/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: t_storg.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:21:52 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_STORE_T_STORG_HXX
#define ARY_STORE_T_STORG_HXX



// USED SERVICES
	// BASE CLASSES
#include "ti_storg.hxx"
	// COMPONENTS
	// PARAMETERS
#include <cosv/template/tpltools.hxx>
#include <manip.hxx>


namespace ary
{
namespace store
{


/** This is the standard structure for all data saved within the
    autodoc repository.
*/
template <class RE>
class StdReStorage : public ReStorage<RE>
{
  public:
    typedef UINT32      KEY;

    // LIFECYCLE
						StdReStorage();
						~StdReStorage();
  private:
    // Interface ReStorage<>
    virtual RE &        do_Add(
                            const KEY &         i_rKey,
                            DYN RE &            let_drElement );
    virtual uintt       do_ForEach(
                            const Manipulator< RE > &
                                                i_rManip );
	virtual RE *  		access_Find(
							const KEY &         i_rKey );

    typedef std::map< KEY, DYN RE * >   DataBase;

	// DATA
    DataBase            aDataBase;
};



// IMPLEMENTATION


template <class RE>
StdReStorage<RE>::StdReStorage()
//  :   aDataBase
{
}

template <class RE>
StdReStorage<RE>::~StdReStorage()
{
    csv::erase_map_of_heap_ptrs(aDataBase);
}


template <class RE>
RE &
StdReStorage<RE>::do_Add( const KEY &         i_rKey,
						  DYN RE &            let_drElement )
{
	std::pair<typename DataBase::iterator, bool> result;
	result = aDataBase.insert(typename DataBase::value_type(i_rKey, &let_drElement));
	if (result.second == false)
		delete &let_drElement;
	return *(*result.first).second;
}

template <class RE>
uintt
StdReStorage<RE>::do_ForEach( const Manipulator< RE > & i_rManip )
{
    for ( typename DataBase::iterator it = aDataBase.begin();
          it != aDataBase.end();
          ++it )
    {
     	i_rManip( *(*it).second );
    }

    return aDataBase.size();
}

template <class RE>
RE *
StdReStorage<RE>::access_Find( const KEY & i_rKey )
{
	return csv::value_from_map( aDataBase, i_rKey );
}


}   // namespace store
}   // namespace ary



#endif

