/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: l_gate.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:15:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <precomp.h>
#include <loc/l_gate.hxx>


// NOT FULLY DEFINED SERVICES
#include <cosv/template/tpltools.hxx>
#include <ary/idg.hxx>
#include <ary/loc/loc_root.hxx>
#include <ary/loc/loc_dir.hxx>
#include <ary/loc/loc_file.hxx>
#include <store/l_stgifc.hxx>


namespace ary
{
namespace loc
{


//********************      CheshireCat        ***********************//

struct Gate::CheshireCat
{
    ary::store::Locations_Ifc *
                        pStorage;
    ary::IdGenerator *  pIds;

                        CheshireCat(
                            ary::store::Locations_Ifc &
                                                i_rStorage,
                            IdGenerator &       i_rIds );
                        ~CheshireCat();

    Directory &         CheckIn_SubDirs(
                            LocationRoot &      io_rRoot,
                            const csv::ploc::DirectoryChain & i_rFileSubPath );
    SourceCodeFile *    Search_FileInDir(
                            const udmstri &     i_sFileName,
                            const Directory &   i_rDir );
};




Gate::
CheshireCat::CheshireCat( ary::store::Locations_Ifc & i_rStorage,
                          IdGenerator &               i_rIds )
    :   pStorage(&i_rStorage),
        pIds(&i_rIds)
{
}

Gate::
CheshireCat::~CheshireCat()
{
}

Directory &
Gate::
CheshireCat::CheckIn_SubDirs( LocationRoot &                    io_rRoot,
                              const csv::ploc::DirectoryChain & i_rFileSubPath )
{
    Directory * ret = &io_rRoot;

    for ( StringVector::const_iterator it = i_rFileSubPath.Begin();
          it != i_rFileSubPath.End();
          ++it )
    {
        Lid nDir = csv::value_from_map( ret->ChildDirs(), *it );
        if (nDir == 0)
        {
            SubDirectory * pNew = new SubDirectory( pIds->NewLid(), *it, ret->Id() );
            pStorage->Add_SubDirectory( *pNew );
            ret->Add_ChildDir( *it, pNew->Id() );
            ret = pNew;
        }
        else
        {
         	ret = pStorage->Find_SubDirectory( nDir );
        }
    }
    return *ret;
}

SourceCodeFile *
Gate::
CheshireCat::Search_FileInDir( const udmstri &      i_sFileName,
                               const Directory &    i_rDir )
{
 	Lid nFileId = csv::value_from_map( i_rDir.Files(), i_sFileName );
    if ( nFileId != 0 )
        return pStorage->Find_File( nFileId );
    return 0;
}


//********************      Gate        ***********************//

Gate::Gate( ary::store::Locations_Ifc & i_rStorage,
            IdGenerator &               i_rIds )
    :   pi( new CheshireCat(i_rStorage, i_rIds) )
{
}

Gate::~Gate()
{
}

LocationRoot &
Gate::do_CheckIn_Root( const csv::ploc::Path & i_rPath )
{
    ary::loc::LocationRoot * ret = pi->pStorage->Search_Root( i_rPath );
    if (ret != 0)
        return *ret;

    ret = new LocationRoot( pi->pIds->NewLid(), i_rPath );
    pi->pStorage->Add_Root( *ret );

    return *ret;
}

SourceCodeFile &
Gate::do_CheckIn_File( const udmstri &                   i_sFileName,
                       const csv::ploc::DirectoryChain & i_rFileSubPath,
                       Lid                               i_nRootDir )
{
    LocationRoot * pRoot = pi->pStorage->Find_Root( i_nRootDir );
    csv_assert( pRoot != 0 );

    Directory & rSub = pi->CheckIn_SubDirs( *pRoot, i_rFileSubPath );
    SourceCodeFile * ret = pi->Search_FileInDir( i_sFileName, rSub );
    if (ret != 0)
        return *ret;

    ret = new SourceCodeFile( pi->pIds->NewLid(), i_nRootDir, rSub.Id(), i_sFileName );
    pi->pStorage->Add_File( *ret );
    rSub.Add_File( i_sFileName, ret->Id() );

    return *ret;
}

LocationRoot *
Gate::inq_Find_Root( Lid i_nRootId ) const
{
    return pi->pStorage->Find_Root( i_nRootId );
}

SourceCodeFile *
Gate::inq_Find_File( Lid i_nFileId ) const
{
    return pi->pStorage->Find_File( i_nFileId );
}



} // namespace loc
} // namespace ary



