/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: project.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:14:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <precomp.h>
#include <ary/project.hxx>


// NOT FULLY DECLARED SERVICES
#include <ary/docu.hxx>
#include <slots.hxx>
#include "gl_rcids.hxx"



namespace ary
{

TopProject::TopProject( Gid i_nProject )
    :   nId( i_nProject )
        // sName,
	    // aCppProjects
{
}

TopProject::~TopProject()
{
}

void
TopProject::Add_Project( Gid i_nProject )
{
    aCppProjects.insert( i_nProject );
}

void
TopProject::do_StoreAt( ary::Display & o_rOut ) const
{
    // Probably not needed.
}

Rid
TopProject::inq_Id() const
{
    return nId;
}

RCid
TopProject::inq_RC() const
{
    return RCID_TOP;
}

const Documentation &
TopProject::inq_Info() const
{
    return Documentation::Null_();
}

void
TopProject::do_Add_Documentation( DYN Documentation & let_drInfo )
{
    // Does nothing.
}

Gid
TopProject::inq_Id_Group() const
{
    return nId;
}

const RepositoryEntity &
TopProject::inq_RE_Group() const
{
    return *this;
}

const group::SlotList &
TopProject::inq_Slots() const
{
    static const SlotAccessId aProjectSlotData[]
            = { SLOT_MetaProjects, SLOT_CppLocationBases };
    static const std::vector< SlotAccessId >
            aSlots( &aProjectSlotData[0],
                      &aProjectSlotData[0]
                        + sizeof aProjectSlotData / sizeof (SlotAccessId) );
    return aSlots;
}

DYN Slot *
TopProject::inq_Create_Slot( SlotAccessId i_nSlot ) const
{
    switch ( i_nSlot )
    {
//     	case SLOT_MetaProjects:     return new Slot_GidSet(aMyNamespaces);
        case SLOT_CppLocationBases: return new Slot_RidSet(aCppProjects);
        default:
                                return new Slot_Null;
    }   // end switch
}

const udmstri &
TopProject::inq_Name() const
{
    return sName;
}


}   // namespace ary


