/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: cdf_gate.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:34:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#include <precomp.h>
#include "cdf_gate.hxx"


// NOT FULLY DEFINED SERVICES
#include <ary/idg.hxx>
#include <ary/cpp/c_define.hxx>
#include <ary/cpp/c_macro.hxx>
#include <ary/cpp/cg_file.hxx>
#include <ary/cpp/inpcontx.hxx>
#include <store/ifcc_df.hxx>
#include <instlist.hxx>
#include "cdf_gate.hxx"


namespace ary
{
namespace cpp
{

Gate_Defines::Gate_Defines( ary::store::cpp::Defs_Ifc & io_rDefs_Ifc,
                            ary::IdGenerator &          io_rIdGenerator )
    :   pDefs_Ifc(&io_rDefs_Ifc),
        pIdGenerator(&io_rIdGenerator)
{
}


Gate_Defines::~Gate_Defines()
{
}

Define &
Gate_Defines::do_Store_Define( const InputContext &         i_rContext,
							   const udmstri &              i_sName,
                               const StringVector & i_rDefinition )
{
    Define & ret = *new Define( pIdGenerator->NewDid(),
                                i_sName,
                                i_rDefinition,
                                i_rContext.CurFileGroup().AssociatedFile() );
    pDefs_Ifc->Add_Define( ret );
    return ret;
}

Macro &
Gate_Defines::do_Store_Macro( const InputContext &          i_rContext,
							  const udmstri &               i_sName,
                              const StringVector &  i_rParams,
                              const StringVector &  i_rDefinition )
{
    Macro & ret = *new Macro( pIdGenerator->NewDid(),
                              i_sName,
                              i_rParams,
                              i_rDefinition,
                              i_rContext.CurFileGroup().AssociatedFile() );
    pDefs_Ifc->Add_Macro( ret );
    return ret;
}

const Define *
Gate_Defines::inq_Find_Define( Did i_nId ) const
{
    return pDefs_Ifc->Find_Define(i_nId);
}

const Macro *
Gate_Defines::inq_Find_Macro( Did i_nId ) const
{
    return pDefs_Ifc->Find_Macro(i_nId);
}

uintt
Gate_Defines::inq_Search_Defines( List_DefIds &       o_rResult,
							      const udmstri &     i_sDefinedName ) const
{
    const InstanceList &
        rResult = pDefs_Ifc->Search_DefineName(i_sDefinedName);
    for ( InstanceList::const_iterator it = rResult.begin();
          it != rResult.end();
          ++it )
    {
        o_rResult.push_back( *it );
    }
    return rResult.size();
}

uintt
Gate_Defines::inq_Search_Macros( List_DefIds &       o_rResult,
							     const udmstri &     i_sDefinedName ) const
{
    const InstanceList &
        rResult = pDefs_Ifc->Search_MacroName(i_sDefinedName);
    for ( InstanceList::const_iterator it = rResult.begin();
          it != rResult.end();
          ++it )
    {
        o_rResult.push_back( *it );
    }
    return rResult.size();
}

uintt
Gate_Defines::inq_Get_AllDefines( List_DefIds & o_rResult ) const
{
    return pDefs_Ifc->Get_AllDefines(o_rResult);
}

uintt
Gate_Defines::inq_Get_AllMacros( List_DefIds & o_rResult ) const
{
    return pDefs_Ifc->Get_AllMacros(o_rResult);
}


}   // namespace cpp
}   // namespace ary





