/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: crog_def.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:04:05 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_CPP_CROG_DEF_HXX
#define ARY_CPP_CROG_DEF_HXX


// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS
#include <ary/ids.hxx>

namespace ary
{
namespace cpp
{
    class Define;
    class Macro;

class RoGate_Defines
{
  public:
    typedef std::vector< Did >      List_DefIds;

    // LIFECYCLE
    virtual             ~RoGate_Defines() {}

	// INQUIRY
	const Define *      Find_Define(
							Did					i_nId ) const;
	const Macro *       Find_Macro(
							Did					i_nId ) const;

	uintt               Search_Defines(
                            List_DefIds &       o_rResult,
							const udmstri &     i_sDefinedName ) const;
	uintt               Search_Macros(
                            List_DefIds &       o_rResult,
							const udmstri &     i_sDefinedName ) const;

    uintt               Get_AllDefines(
                            List_DefIds &       o_rResult ) const;
    uintt               Get_AllMacros(
                            List_DefIds &       o_rResult ) const;


  private:
	virtual const Define *
                        inq_Find_Define(
							Did					i_nId ) const = 0;
	virtual const Macro *
                        inq_Find_Macro(
							Did					i_nId ) const = 0;
	virtual uintt       inq_Search_Defines(
                            List_DefIds &       o_rResult,
							const udmstri &     i_sDefinedName ) const = 0;
	virtual uintt       inq_Search_Macros(
                            List_DefIds &       o_rResult,
							const udmstri &     i_sDefinedName ) const = 0;
    virtual uintt       inq_Get_AllDefines(
                            List_DefIds &       o_rResult ) const = 0;
    virtual uintt       inq_Get_AllMacros(
                            List_DefIds &       o_rResult ) const = 0;
};

inline const Define *
RoGate_Defines::Find_Define( Did i_nId ) const
    { return inq_Find_Define(i_nId); }
inline const Macro *
RoGate_Defines::Find_Macro( Did	i_nId ) const
    { return inq_Find_Macro(i_nId); }
inline uintt
RoGate_Defines::Search_Defines( List_DefIds &       o_rResult,
							    const udmstri &     i_sDefinedName ) const
    { return inq_Search_Defines(o_rResult, i_sDefinedName); }
inline uintt
RoGate_Defines::Search_Macros( List_DefIds &       o_rResult,
							   const udmstri &     i_sDefinedName ) const
    { return inq_Search_Macros(o_rResult, i_sDefinedName); }
inline uintt
RoGate_Defines::Get_AllDefines( List_DefIds & o_rResult ) const
    { return inq_Get_AllDefines(o_rResult ); }
inline uintt
RoGate_Defines::Get_AllMacros( List_DefIds & o_rResult ) const
    { return inq_Get_AllMacros( o_rResult ); }



// IMPLEMENTATION



}   // namespace cpp
}   // namespace ary



#endif

