/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: common_gate.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 15:50:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_COMMON_GATE_HXX
#define ARY_COMMON_GATE_HXX

//	VERSION:		    Autodoc 2.2


// USED SERVICES
    // BASE CLASSES
    // COMPONENTS
    // PARAMETERS
#include <ary/actions.hxx>

namespace ary
{

class PhysicalLocationPilot;
class LogicalLocationPilot;
class InformationPilot;


class CommonGate
{
  public:
    // LIFECYCLE
    virtual             CommonGate::~CommonGate() {}

    // OPERATIONS

    // INQUIRY
    const PhysicalLocationPilot &
                        PhysicalLocations() const;

    const LogicalLocationPilot &
                        LogicalLocations() const;
    const InformationPilot &
                        Informations() const;
    // ACCESS
    PhysicalLocationPilot &
                        PhysicalLocations();

    LogicalLocationPilot &
                        LogicalLocations();
    InformationPilot &  Informations();

  private:
    // Locals
    CommonGate &        MutableMe() const;

    virtual PhysicalLocationPilot &
                        access_PhysicalLocations() = 0;
    virtual LogicalLocationPilot &
                        access_LogicalLocations() = 0;
    virtual InformationPilot &
                        access_Informations() = 0;
};




// IMPLEMENTATION

inline CommonGate &
CommonGate::MutableMe() const
    { return const_cast< CommonGate& >(*this); }

inline const PhysicalLocationPilot &
CommonGate::PhysicalLocations() const
    { return MutableMe().access_PhysicalLocations(); }

inline const LogicalLocationPilot &
CommonGate::LogicalLocations() const
    { return MutableMe().access_LogicalLocations(); }

inline const InformationPilot &
CommonGate::Informations() const
    { return MutableMe().access_Informations(); }

inline PhysicalLocationPilot &
CommonGate::PhysicalLocations()
    { return access_PhysicalLocations(); }

inline LogicalLocationPilot &
CommonGate::LogicalLocations()
    { return access_LogicalLocations(); }

inline InformationPilot &
CommonGate::Informations()
    { return access_Informations(); }





}   // namespace ary



#endif

