/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_isbxobj.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:17:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop



#define ITEMID_TABSTOP 0
#define _SVX_ISBXOBJ_CXX

#ifndef _SFX_SHELL_HXX //autogen
#include <bf_sfx2/shell.hxx>
#endif

#ifndef _SFXMSG_HXX //autogen
#include <bf_sfx2/msg.hxx>
#endif

#ifndef _SBXCLASS_HXX //autogen
#include <basic/sbx.hxx>
#endif
#include "svxids.hrc"
#include "isbxobj.hxx"

//-------------------------------------------------------------------------

#define TabStops
#include "svxslots.hrc"
namespace binfilter {

//-------------------------------------------------------------------------

//STRIP001 TYPEINIT1(SvxTabStopObject_Impl,SvDispatch);
//STRIP001 
//STRIP001 // =======================================================================
//STRIP001 
//STRIP001 SvxTabStopObject_Impl::SvxTabStopObject_Impl()
//STRIP001 :	SvDispatch( "TabStops", SO2_TYPELIB_INFO(TabStops) ),
//STRIP001 	pTabs( new SvxTabStopItem )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 SvxTabStopObject_Impl::SvxTabStopObject_Impl( SbxVariable *pVar,
//STRIP001 											  const SvxTabStopItem &rTabs )
//STRIP001 :	SvDispatch( "TabStops", SO2_TYPELIB_INFO(TabStops) ),
//STRIP001 	pTabs( (SvxTabStopItem*) rTabs.Clone() ),
//STRIP001 	xVar( pVar )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 SvxTabStopObject_Impl::~SvxTabStopObject_Impl()
//STRIP001 {
//STRIP001 	delete pTabs;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 void SvxTabStopObject_Impl::SFX_NOTIFY
//STRIP001 (
//STRIP001 	SfxBroadcaster& rBC, const TypeId& rBCType,
//STRIP001 	const SfxHint& rHint, const TypeId& rHintType
//STRIP001 )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Wenn eine Metode gerufen wird, verschickt das Sbx-System einen Broadcast.
//STRIP001 	Dieser kommt hier an, so da\s hier das Ausf"uhren der Methoden initiiert
//STRIP001 	wird.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	// Hint aufbereiten
//STRIP001 	const SbxHint* pHint = PTR_CAST(SbxHint, &rHint);
//STRIP001 
//STRIP001 	if ( !pHint )
//STRIP001 	{
//STRIP001 		// kein SbxHint => Basisklasse rufen und raus
//STRIP001 		SvDispatch::SFX_NOTIFY( rBC, rBCType, rHint, rHintType );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	ULONG nHint = pHint ? pHint->GetId() : 0;
//STRIP001 	SbxVariable* pVar = pHint->GetVar();
//STRIP001 	USHORT nSID = (USHORT)( pVar->GetUserData() & 0xFFFFL );
//STRIP001 	BOOL bDone = FALSE;
//STRIP001 
//STRIP001 	// Call einer Methode?
//STRIP001 	if ( nHint == SBX_HINT_DATAWANTED && pVar->GetClass() == SbxCLASS_METHOD )
//STRIP001 	{
//STRIP001 		// Parameterarray bereitstellen
//STRIP001 		SbxArrayRef xPar = pVar->GetParameters();
//STRIP001 		if ( !xPar.Is() )
//STRIP001 			xPar = new SbxArray;
//STRIP001 
//STRIP001 		// Insert-Methode?
//STRIP001 		if ( nSID == SID_TAB_INSERT )
//STRIP001 		{
//STRIP001 			// Parameteranzahl pr"ufen
//STRIP001 			if ( xPar->Count() < 2 )
//STRIP001 				SetError( SbxERR_WRONG_ARGS );
//STRIP001 
//STRIP001 			// Parameter auswerten
//STRIP001 			long nPos = xPar->Get(1)->GetLong();
//STRIP001 			SvxTabAdjust eAdjust = SVX_TAB_ADJUST_LEFT;
//STRIP001 			if ( xPar->Count() > 2 )
//STRIP001 			{
//STRIP001 				switch ( xPar->Get(2)->GetString()[ (USHORT) 0] )
//STRIP001 				{
//STRIP001 					case 'L':
//STRIP001 					case 'l':
//STRIP001 						eAdjust = SVX_TAB_ADJUST_LEFT;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case 'R':
//STRIP001 					case 'r':
//STRIP001 						eAdjust = SVX_TAB_ADJUST_RIGHT;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case 'C':
//STRIP001 					case 'c':
//STRIP001 						eAdjust = SVX_TAB_ADJUST_CENTER;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case 'D':
//STRIP001 					case 'd':
//STRIP001 						eAdjust = SVX_TAB_ADJUST_DECIMAL;
//STRIP001 						break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			unsigned char cDec =
//STRIP001 					xPar->Count() > 3 ? xPar->Get(3)->GetString()[(USHORT)0] : ',';
//STRIP001 			unsigned char cFill =
//STRIP001 					xPar->Count() > 4 ? xPar->Get(4)->GetString()[(USHORT)0] : ' ';
//STRIP001 			pTabs->Insert( SvxTabStop( nPos, eAdjust, cDec, cFill ) );
//STRIP001 			bDone = TRUE;
//STRIP001 		}
//STRIP001 		else if ( nSID == SID_TAB_REMOVE )
//STRIP001 		{
//STRIP001 			// Parameteranzahl pr"ufen
//STRIP001 			if ( xPar->Count() < 1 )
//STRIP001 				SetError( SbxERR_WRONG_ARGS );
//STRIP001 
//STRIP001 			long nPos = xPar->Get(1)->GetLong();
//STRIP001 			USHORT nIdxPos = pTabs->GetPos(nPos);
//STRIP001 			if( nIdxPos != SVX_TAB_NOTFOUND)
//STRIP001 			{
//STRIP001 				pTabs->Remove(nIdxPos);
//STRIP001 				bDone = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if ( nSID == SID_TAB_REMOVE_BY_INDEX )
//STRIP001 		{
//STRIP001 			// Parameteranzahl pr"ufen
//STRIP001 			if ( xPar->Count() < 1 )
//STRIP001 				SetError( SbxERR_WRONG_ARGS );
//STRIP001 
//STRIP001 			long nPos = xPar->Get(1)->GetLong();
//STRIP001 
//STRIP001 			if ( nPos < pTabs->Count() )
//STRIP001 			{
//STRIP001 				pTabs->Remove( (USHORT)nPos );
//STRIP001 				bDone = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if ( nSID == SID_TAB_REMOVE_ALL )
//STRIP001 		{
//STRIP001 			USHORT nCount = pTabs->Count();
//STRIP001 			if(nCount)
//STRIP001 				pTabs->Remove(0, nCount);
//STRIP001 			bDone = TRUE;
//STRIP001 		}
//STRIP001 		// alle anderen Methoden haben denselben Aufbau
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Parameter holen und pr"ufen
//STRIP001 			if ( xPar->Count() != 2 )
//STRIP001 				{ SetError( SbxERR_WRONG_ARGS ); return; }
//STRIP001 			short nNo = xPar->Get(1)->GetInteger();
//STRIP001 			if ( nNo > pTabs->Count() )
//STRIP001 				{ SetError( SbxERR_BAD_INDEX ); return; }
//STRIP001 
//STRIP001 			// Tabulatoren indizieren
//STRIP001 			const SvxTabStop &rTab = pTabs->GetObject( nNo );
//STRIP001 
//STRIP001 			// Returnwerte setzen
//STRIP001 			switch ( nSID )
//STRIP001 			{
//STRIP001 				// GetPosition
//STRIP001 				case SID_TAB_POSITION:
//STRIP001 					pVar->PutLong( rTab.GetTabPos() );
//STRIP001 					bDone = TRUE;
//STRIP001 					break;
//STRIP001 
//STRIP001 				// bGetAdjust
//STRIP001 				case SID_TAB_ADJUST:
//STRIP001 					pVar->PutString( GetAdjustChar( rTab.GetAdjustment() ) );
//STRIP001 					bDone = TRUE;
//STRIP001 					break;
//STRIP001 
//STRIP001 				// GetDecimal
//STRIP001 				case SID_TAB_DECIMAL:
//STRIP001 					pVar->PutString( rTab.GetDecimal() );
//STRIP001 					bDone = TRUE;
//STRIP001 					break;
//STRIP001 
//STRIP001 				// GetFillChar
//STRIP001 				case SID_TAB_FILLCHAR:
//STRIP001 					pVar->PutString( rTab.GetFill() );
//STRIP001 					bDone = TRUE;
//STRIP001 					break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// Auto-Writeback f"ur Pseudo-Referenzen
//STRIP001 		if ( bDone && xVar.Is() )
//STRIP001 			xVar->PutObject( this );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Property lesen?
//STRIP001 	else if ( nHint == SBX_HINT_DATAWANTED &&
//STRIP001 			  pVar->GetClass() == SbxCLASS_PROPERTY )
//STRIP001 	{
//STRIP001 		// Count-Property?
//STRIP001 		if ( nSID == SID_TAB_COUNT )
//STRIP001 		{
//STRIP001 			// Returnwert setzen
//STRIP001 			pVar->PutLong( pTabs->Count() );
//STRIP001 			bDone = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// ggf. Basisklasse rufen
//STRIP001 	if ( !bDone )
//STRIP001 		SvDispatch::SFX_NOTIFY( rBC, rBCType, rHint, rHintType );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 String SvxTabStopObject_Impl::GenerateSource
//STRIP001 (
//STRIP001 	const String &rLinePrefix,
//STRIP001 	const SbxObject *pRelativeTo
//STRIP001 )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Mit dieser Methode wird ein String erzeugt, der den Source-Code enth"lt,
//STRIP001 	mit dem das Objekt wiederhergestellt werden kann. Dabei ist das Objekt
//STRIP001 	als aktiver Kontext bereitgestellt (WITH-Statement), auf Methoden und
//STRIP001 	Properties des Objektes kann daher direkt zugegriffen werden.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	// je TabStop ein Insert-Statement erzeugen
//STRIP001 	String aSource;
//STRIP001 	FASTBOOL bLineFeed = FALSE;
//STRIP001 	for ( USHORT nTab = 0; nTab < pTabs->Count(); ++nTab )
//STRIP001 	{
//STRIP001 		// keine Default-Tabs recorden
//STRIP001 		const SvxTabStop &rTabStop = pTabs->GetObject(nTab);
//STRIP001 		if ( SVX_TAB_ADJUST_DEFAULT == rTabStop.GetAdjustment() )
//STRIP001 			continue;
//STRIP001 
//STRIP001 		// ausser vor dem ersten Statement immer einen Umbruch einfuegen
//STRIP001 		if ( bLineFeed )
//STRIP001 			aSource += '\n';
//STRIP001 		else
//STRIP001 			bLineFeed = TRUE;
//STRIP001 
//STRIP001 		// Statement schreiben
//STRIP001 		aSource += rLinePrefix;
//STRIP001 		aSource += ".Insert( ";
//STRIP001 
//STRIP001 		// Parameter schreiben
//STRIP001 		aSource += rTabStop.GetTabPos();
//STRIP001 		aSource += ", \"";
//STRIP001 		aSource += GetAdjustChar( rTabStop.GetAdjustment() );
//STRIP001 		aSource += "\", \"";
//STRIP001 		aSource += (char) rTabStop.GetDecimal();
//STRIP001 		aSource += "\", \"";
//STRIP001 		aSource += (char) rTabStop.GetFill();
//STRIP001 		aSource += "\" )";
//STRIP001 	}
//STRIP001 	return aSource;
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 char SvxTabStopObject_Impl::GetAdjustChar( SvxTabAdjust eAdj )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Hilfsmethode zum umwandeln des Enum-Wertes SvxTabAdjust in
//STRIP001 	ein Character;
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	switch ( eAdj )
//STRIP001 	{
//STRIP001 		case SVX_TAB_ADJUST_LEFT:	return 'L';
//STRIP001 		case SVX_TAB_ADJUST_RIGHT:	return 'R';
//STRIP001 		case SVX_TAB_ADJUST_DECIMAL:return 'D';
//STRIP001 		case SVX_TAB_ADJUST_CENTER: return 'C';
//STRIP001 	}
//STRIP001 
//STRIP001 	return ' ';
//STRIP001 }



}
