/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_dbtoolsclient.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:40:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _COM_SUN_STAR_SDBC_XCONNECTION_HPP_
// auto strip #include <com/sun/star/sdbc/XConnection.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_SDBC_XDATASOURCE_HPP_
// auto strip #include <com/sun/star/sdbc/XDataSource.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_XNUMBERFORMATSSUPPLIER_HPP_
// auto strip #include <com/sun/star/util/XNumberFormatsSupplier.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_SDB_SQLCONTEXT_HPP_ 
// auto strip #include <com/sun/star/sdb/SQLContext.hpp>
// auto strip #endif
#ifndef SVX_DBTOOLSCLIENT_HXX
#include "dbtoolsclient.hxx"
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#include <tools/debug.hxx> //for stripping
namespace binfilter {
//........................................................................
namespace svxform
{
//........................................................................

	using namespace ::connectivity::simple;
	using namespace ::com::sun::star::sdbc;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::util;
	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::beans;
	using namespace ::com::sun::star::sdb;
	using namespace ::com::sun::star::container;

	//====================================================================
	//= ODbtoolsClient
	//====================================================================
	::osl::Mutex	ODbtoolsClient::s_aMutex;
	sal_Int32		ODbtoolsClient::s_nClients = 0;
	oslModule		ODbtoolsClient::s_hDbtoolsModule = NULL;
	createDataAccessToolsFactoryFunction
					ODbtoolsClient::s_pFactoryCreationFunc = NULL;

	//--------------------------------------------------------------------
/*N*/ 	ODbtoolsClient::ODbtoolsClient()
/*N*/ 	{
/*N*/ 		m_bCreateAlready = FALSE;
/*N*/ 	}

	//--------------------------------------------------------------------
	//add by BerryJia for fixing Bug97420 Time:2002-9-12-11:00(PRC time)
//STRIP001 	void ODbtoolsClient::create() const
//STRIP001 	{
//STRIP001 		if(m_bCreateAlready)
//STRIP001 			return;
//STRIP001 		m_bCreateAlready = TRUE;
//STRIP001 		registerClient();
//STRIP001 		if (s_pFactoryCreationFunc)
//STRIP001 		{	// loading the lib succeeded
//STRIP001 			void* pUntypedFactory = (*s_pFactoryCreationFunc)();
//STRIP001 			IDataAccessToolsFactory* pDBTFactory = static_cast<IDataAccessToolsFactory*>(pUntypedFactory);
//STRIP001 			OSL_ENSURE(pDBTFactory, "ODbtoolsClient::ODbtoolsClient: no factory returned!");
//STRIP001 			if (pDBTFactory)
//STRIP001 			{
//STRIP001 				m_xDataAccessFactory = pDBTFactory;
//STRIP001 				// by definition, the factory was aquired once
//STRIP001 				m_xDataAccessFactory->release();
//STRIP001 			}
//STRIP001 			
//STRIP001 		}
//STRIP001 	}

	//--------------------------------------------------------------------
/*N*/ 	ODbtoolsClient::~ODbtoolsClient()
/*N*/ 	{
/*N*/ 		// clear the factory _before_ revoking the client
/*N*/ 		// (the revocation may unload the DBT lib)
/*N*/ 		m_xDataAccessFactory = NULL;
/*N*/ 		// revoke the client
/*N*/ 		if ( m_bCreateAlready )
				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 			revokeClient();
/*N*/ 	}

	//--------------------------------------------------------------------
//STRIP001 	void ODbtoolsClient::registerClient() 
//STRIP001 	{
//STRIP001 		::osl::MutexGuard aGuard(s_aMutex);
//STRIP001 		if (1 == ++s_nClients)
//STRIP001 		{
//STRIP001 			OSL_ENSURE(NULL == s_hDbtoolsModule, "ODbtoolsClient::registerClient: inconsistence: already have a module!");
//STRIP001 			OSL_ENSURE(NULL == s_pFactoryCreationFunc, "ODbtoolsClient::registerClient: inconsistence: already have a factory function!");
//STRIP001 
//STRIP001 			const ::rtl::OUString sModuleName = ::rtl::OUString::createFromAscii(
//STRIP001 				SAL_MODULENAME( "dbtools2" )
//STRIP001 			);
//STRIP001 
//STRIP001 			// load the dbtools library
//STRIP001 			s_hDbtoolsModule = osl_loadModule(sModuleName.pData, 0);
//STRIP001 			OSL_ENSURE(NULL != s_hDbtoolsModule, "ODbtoolsClient::registerClient: could not load the dbtools library!");
//STRIP001 			if (NULL != s_hDbtoolsModule)
//STRIP001 			{
//STRIP001 				// get the symbol for the method creating the factory
//STRIP001 				const ::rtl::OUString sFactoryCreationFunc = ::rtl::OUString::createFromAscii("createDataAccessToolsFactory");
//STRIP001 				s_pFactoryCreationFunc = reinterpret_cast<createDataAccessToolsFactoryFunction>(
//STRIP001 					osl_getSymbol(s_hDbtoolsModule, sFactoryCreationFunc.pData));
//STRIP001 
//STRIP001 				if (NULL == s_pFactoryCreationFunc)
//STRIP001 				{	// did not find the symbol
//STRIP001 					OSL_ENSURE(sal_False, "ODbtoolsClient::registerClient: could not find the symbol for creating the factory!");
//STRIP001 					osl_unloadModule(s_hDbtoolsModule);
//STRIP001 					s_hDbtoolsModule = NULL;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}

	//--------------------------------------------------------------------
//STRIP001 	void ODbtoolsClient::revokeClient()
//STRIP001 	{
//STRIP001 		::osl::MutexGuard aGuard(s_aMutex);
//STRIP001 		if (0 == --s_nClients)
//STRIP001 		{
//STRIP001 			s_pFactoryCreationFunc = NULL;
//STRIP001 			if (s_hDbtoolsModule)
//STRIP001 				osl_unloadModule(s_hDbtoolsModule);
//STRIP001 			s_hDbtoolsModule = NULL;
//STRIP001 		}
//STRIP001 
//STRIP001 		OSL_ENSURE(s_nClients >= 0,"Illegall call of revokeClient()");
//STRIP001 	}

	//====================================================================
	//= OStaticDataAccessTools
	//====================================================================
	//--------------------------------------------------------------------
/*N*/ 	OStaticDataAccessTools::OStaticDataAccessTools()
/*N*/ 	{
/*N*/ 	}

	//--------------------------------------------------------------------
	//add by BerryJia for fixing Bug97420 Time:2002-9-12-11:00(PRC time)
//STRIP001 	void OStaticDataAccessTools::create() const
//STRIP001 	{
//STRIP001 		if (!getFactory().is())
//STRIP001 			ODbtoolsClient::create();
//STRIP001 		if (getFactory().is())
//STRIP001 	 		m_xDataAccessTools = getFactory()->getDataAccessTools();
//STRIP001 	}
	//--------------------------------------------------------------------
//STRIP001 	void OStaticDataAccessTools::checkIfLoaded() const
//STRIP001 	{
//STRIP001 		if (!m_xDataAccessTools.is())
//STRIP001 			create();
//STRIP001 	}

	//--------------------------------------------------------------------
//STRIP001 	Reference< XNumberFormatsSupplier > OStaticDataAccessTools::getNumberFormats(const Reference< XConnection>& _rxConn, sal_Bool _bAllowDefault) const
//STRIP001 	{
//STRIP001 		Reference< XNumberFormatsSupplier > xReturn;
//STRIP001 		checkIfLoaded();
//STRIP001 		if (m_xDataAccessTools.is())
//STRIP001 			xReturn = m_xDataAccessTools->getNumberFormats(_rxConn, _bAllowDefault);
//STRIP001 		return xReturn;
//STRIP001 	}

	//--------------------------------------------------------------------
//STRIP001 	Reference< XConnection> OStaticDataAccessTools::getConnection_withFeedback(const ::rtl::OUString& _rDataSourceName,
//STRIP001 		const ::rtl::OUString& _rUser, const ::rtl::OUString& _rPwd, const Reference< XMultiServiceFactory>& _rxFactory) const
//STRIP001 			SAL_THROW ( (SQLException) )
//STRIP001 	{
//STRIP001 		Reference< XConnection > xReturn;
//STRIP001 		checkIfLoaded();
//STRIP001 		if (m_xDataAccessTools.is())
//STRIP001 			xReturn = m_xDataAccessTools->getConnection_withFeedback(_rDataSourceName, _rUser, _rPwd, _rxFactory);
//STRIP001 		return xReturn;
//STRIP001 	}

	//--------------------------------------------------------------------
//STRIP001 	Reference< XConnection > OStaticDataAccessTools::calcConnection(const Reference< XRowSet >& _rxRowSet, const Reference< XMultiServiceFactory >& _rxFactory) const SAL_THROW ( (SQLException, RuntimeException) )
//STRIP001 	{
//STRIP001 		Reference< XConnection > xReturn;
//STRIP001 		checkIfLoaded();
//STRIP001 		if (m_xDataAccessTools.is())
//STRIP001 			xReturn = m_xDataAccessTools->calcConnection(_rxRowSet, _rxFactory);
//STRIP001 		return xReturn;
//STRIP001 	}

	//--------------------------------------------------------------------
//STRIP001 	Reference< XConnection > OStaticDataAccessTools::getRowSetConnection(const Reference< XRowSet >& _rxRowSet) const SAL_THROW ( (RuntimeException) )
//STRIP001 	{
//STRIP001 		Reference< XConnection > xReturn;
//STRIP001 		checkIfLoaded();
//STRIP001 		if (m_xDataAccessTools.is())
//STRIP001 			xReturn = m_xDataAccessTools->getRowSetConnection(_rxRowSet);
//STRIP001 		return xReturn;
//STRIP001 	}

	//--------------------------------------------------------------------
//STRIP001 	void OStaticDataAccessTools::TransferFormComponentProperties(const Reference< XPropertySet>& _rxOld,
//STRIP001 		const Reference< XPropertySet>& _rxNew, const Locale& _rLocale) const
//STRIP001 	{
//STRIP001 		checkIfLoaded();
//STRIP001 		if (m_xDataAccessTools.is())
//STRIP001 			m_xDataAccessTools->TransferFormComponentProperties(_rxOld, _rxNew, _rLocale);
//STRIP001 	}

	//--------------------------------------------------------------------
//STRIP001 	::rtl::OUString OStaticDataAccessTools::quoteName(const ::rtl::OUString& _rQuote, const ::rtl::OUString& _rName) const
//STRIP001 	{
//STRIP001 		::rtl::OUString sReturn;
//STRIP001 		checkIfLoaded();
//STRIP001 		if (m_xDataAccessTools.is())
//STRIP001 			sReturn = m_xDataAccessTools->quoteName(_rQuote, _rName);
//STRIP001 		return sReturn;
//STRIP001 	}

	//--------------------------------------------------------------------
//STRIP001 	::rtl::OUString OStaticDataAccessTools::quoteTableName(const Reference< XDatabaseMetaData>& _rxMeta, const ::rtl::OUString& _rName) const
//STRIP001 	{
//STRIP001 		::rtl::OUString sReturn;
//STRIP001 		checkIfLoaded();
//STRIP001 		if (m_xDataAccessTools.is())
//STRIP001 			sReturn = m_xDataAccessTools->quoteTableName(_rxMeta, _rName);
//STRIP001 		return sReturn;
//STRIP001 	}

	//--------------------------------------------------------------------
//STRIP001 	SQLContext OStaticDataAccessTools::prependContextInfo(SQLException& _rException, const Reference< XInterface >& _rxContext,
//STRIP001 		const ::rtl::OUString& _rContextDescription, const ::rtl::OUString& _rContextDetails) const
//STRIP001 	{
//STRIP001 		SQLContext aReturn;
//STRIP001 		checkIfLoaded();
//STRIP001 		if (m_xDataAccessTools.is())
//STRIP001 			aReturn = m_xDataAccessTools->prependContextInfo(_rException, _rxContext, _rContextDescription, _rContextDetails);
//STRIP001 		return aReturn;
//STRIP001 	}

	//----------------------------------------------------------------
//STRIP001 	Reference< XDataSource > OStaticDataAccessTools::getDataSource( const ::rtl::OUString& _rsRegisteredName, const Reference< XMultiServiceFactory>& _rxFactory ) const
//STRIP001 	{
//STRIP001 		Reference< XDataSource > xReturn;
//STRIP001 		checkIfLoaded();
//STRIP001 		if (m_xDataAccessTools.is())
//STRIP001 			xReturn = m_xDataAccessTools->getDataSource(_rsRegisteredName,_rxFactory);
//STRIP001 
//STRIP001 		return xReturn;
//STRIP001 	}

	//----------------------------------------------------------------
//STRIP001 	sal_Bool OStaticDataAccessTools::canInsert(const Reference< XPropertySet>& _rxCursorSet) const
//STRIP001 	{
//STRIP001 		sal_Bool bRet = sal_False;
//STRIP001 		checkIfLoaded();
//STRIP001 		if (m_xDataAccessTools.is())
//STRIP001 			bRet = m_xDataAccessTools->canInsert( _rxCursorSet );
//STRIP001 		return bRet;
//STRIP001 	}

	//----------------------------------------------------------------
//STRIP001 	sal_Bool OStaticDataAccessTools::canUpdate(const Reference< XPropertySet>& _rxCursorSet) const
//STRIP001 	{
//STRIP001 		sal_Bool bRet = sal_False;
//STRIP001 		checkIfLoaded();
//STRIP001 		if (m_xDataAccessTools.is())
//STRIP001 			bRet = m_xDataAccessTools->canUpdate( _rxCursorSet );
//STRIP001 		return bRet;
//STRIP001 	}

	//----------------------------------------------------------------
//STRIP001 	sal_Bool OStaticDataAccessTools::canDelete(const Reference< XPropertySet>& _rxCursorSet) const
//STRIP001 	{
//STRIP001 		sal_Bool bRet = sal_False;
//STRIP001 		checkIfLoaded();
//STRIP001 		if (m_xDataAccessTools.is())
//STRIP001 			bRet = m_xDataAccessTools->canDelete( _rxCursorSet );
//STRIP001 		return bRet;
//STRIP001 	}

	//----------------------------------------------------------------
/*?*/ 	Reference< XNameAccess > OStaticDataAccessTools::getFieldsByCommandDescriptor( const Reference< XConnection >& _rxConnection,
/*?*/ 		const sal_Int32 _nCommandType, const ::rtl::OUString& _rCommand,
/*?*/ 			Reference< XComponent >& _rxKeepFieldsAlive, ::dbtools::SQLExceptionInfo* _pErrorInfo ) SAL_THROW( ( ) )
/*?*/ 	{DBG_BF_ASSERT(0, "STRIP");	Reference< XNameAccess > aFields; return aFields;//STRIP001 
//STRIP001 		Reference< XNameAccess > aFields;
//STRIP001 
//STRIP001 		checkIfLoaded();
//STRIP001 		if ( m_xDataAccessTools.is() )
//STRIP001 			aFields = m_xDataAccessTools->getFieldsByCommandDescriptor( _rxConnection, _nCommandType,
//STRIP001 				_rCommand, _rxKeepFieldsAlive, _pErrorInfo );
//STRIP001 
//STRIP001 		return aFields;
/*?*/ }

	//----------------------------------------------------------------
/*?*/ 	Sequence< ::rtl::OUString > OStaticDataAccessTools::getFieldNamesByCommandDescriptor(
/*?*/ 		const Reference< XConnection >& _rxConnection, const sal_Int32 _nCommandType,
/*?*/ 		const ::rtl::OUString& _rCommand, ::dbtools::SQLExceptionInfo* _pErrorInfo ) SAL_THROW( ( ) )
/*?*/ 	{DBG_BF_ASSERT(0, "STRIP"); Sequence< ::rtl::OUString > aNames; return aNames;//STRIP001 
//STRIP001 		Sequence< ::rtl::OUString > aNames;
//STRIP001 
//STRIP001 		checkIfLoaded();
//STRIP001 		if ( m_xDataAccessTools.is() )
//STRIP001 			aNames = m_xDataAccessTools->getFieldNamesByCommandDescriptor( _rxConnection, _nCommandType,
//STRIP001 				_rCommand, _pErrorInfo );
//STRIP001 
//STRIP001 		return aNames;
/*?*/ 	}

//........................................................................
}	// namespace svxform
//........................................................................


}
