/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_objface.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:45:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <stdlib.h>

#ifndef _TOOLS_RCID_H
#include <tools/rcid.h>
#endif
#pragma hdrstop

// auto strip #ifndef _STREAM_HXX //autogen
// auto strip #include <tools/stream.hxx>
// auto strip #endif

#include "module.hxx"
#include "objface.hxx"
// auto strip #include "msg.hxx"
#include "msgpool.hxx"
// auto strip #include "cfgitem.hxx"
// auto strip #include "sfxresid.hxx"
#include "minarray.hxx"
// auto strip #include "cfgmgr.hxx"

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#include "tbxmgr.hxx"
#ifdef _PROXYSHELL_VERWENDEN
// auto strip #include "bindings.hxx" // fuer ProxyInterface
// auto strip #include "dispatch.hxx"	// fuer ProxyInterface
#endif

#ifndef _SFX_SFXUNO_HXX
#include "sfxuno.hxx"
#endif

namespace binfilter {

/*N*/ DBG_NAME(SfxInterface)

static const USHORT nVersion = 5;

//====================================================================

/*N*/ EXTERN_C
/*N*/ #if defined( PM2 ) && (!defined( CSET ) && !defined ( MTW ) && !defined( WTC ))
/*N*/ int _stdcall
/*N*/ #else
/*N*/ #ifdef WNT
/*N*/ int _cdecl
/*N*/ #else
/*N*/ int
/*N*/ #endif
/*N*/ #endif
/*N*/ 
/*N*/ SfxCompareSlots_Impl( const void* pSmaller, const void* pBigger )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	return ( (int) ((SfxSlot*)pSmaller)->GetSlotId() ) -
/*N*/ 		   ( (int) ((SfxSlot*)pBigger)->GetSlotId() );
/*N*/ }

//=========================================================================

/*?*/ struct SfxObjectUI_Impl
/*?*/ {
/*?*/ 	USHORT	nPos;
/*?*/ 	USHORT  nInterfaceId;
/*?*/ 	ResId	aResId;
/*?*/ 	BOOL	bVisible;
/*?*/ 	BOOL	bContext;
/*?*/ 	String* pName;
/*?*/ 	ULONG	nFeature;
/*?*/ 
/*?*/ 	SfxObjectUI_Impl(USHORT n, const ResId& rResId, BOOL bVis, ULONG nFeat,
/*?*/ 				USHORT nClassId=0xFFFF) :
/*?*/ 		nPos(n),
/*?*/ 		aResId(rResId.GetId(), rResId.GetResMgr()),
/*?*/ 		nInterfaceId(nClassId),
/*?*/ 		bVisible(bVis),
/*?*/ 		pName(0),
/*?*/ 		bContext(FALSE),
/*?*/ 		nFeature(nFeat)
/*?*/ 	{
/*?*/ 		aResId.SetRT(rResId.GetRT());
/*?*/ 	}
/*?*/ 
/*?*/ 	~SfxObjectUI_Impl()
/*?*/ 	{
/*?*/ 		delete pName;
/*?*/ 	}
/*?*/ };

/*?*/ DECL_PTRARRAY(SfxObjectUIArr_Impl, SfxObjectUI_Impl*, 2, 2)//STRIP008 ;

/*N*/ struct SfxInterface_Impl
/*N*/ {
/*N*/ 	SfxObjectUIArr_Impl*	pObjectBars;	// registered ObjectBars
/*N*/ 	SfxObjectUIArr_Impl*	pObjectMenues;	// registered ObjectMenues
/*N*/ 	SfxObjectUIArr_Impl*	pChildWindows;	// registered ChildWindows
/*N*/ 	ResId					aPopupRes;		// registered PopupMenu
/*N*/ 	ResId					aStatBarRes;	// registered StatusBar
/*N*/ 	SfxModule*				pModule;
/*N*/ 
/*N*/ 	SfxInterface_Impl() :
/*N*/ 		aPopupRes((USHORT)0),
/*N*/ 		aStatBarRes((USHORT)0)
/*N*/ 	{
/*N*/ 		pObjectBars   = new SfxObjectUIArr_Impl;
/*N*/ 		pObjectMenues = new SfxObjectUIArr_Impl;
/*N*/ 		pChildWindows = new SfxObjectUIArr_Impl;
/*N*/ 	}
/*N*/ 
/*N*/ 	~SfxInterface_Impl()
/*N*/ 	{
/*N*/ 		USHORT n;
/*N*/ 		for (n=0; n<pObjectBars->Count(); n++)
/*N*/ 			delete (*pObjectBars)[n];
/*N*/ 		delete pObjectBars;
/*N*/ 
/*N*/ 		for (n=0; n<pObjectMenues->Count(); n++)
/*N*/ 			delete (*pObjectMenues)[n];
/*N*/ 		delete pObjectMenues;
/*N*/ 
/*N*/ 		for (n=0; n<pChildWindows->Count(); n++)
/*N*/ 			delete (*pChildWindows)[n];
/*N*/ 		delete pChildWindows;
/*N*/ 	}
/*N*/ };

/*?*/ static SfxObjectUI_Impl* CreateObjectBarUI_Impl( USHORT nPos, const ResId& rResId, ULONG nFeature, const String *pStr, USHORT nInterface );

//====================================================================

/*?*/ SfxIFConfig_Impl::SfxIFConfig_Impl() :
/*?*/ 	nCount(0),
/*?*/     pObjectBars(0)
/*?*/ {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	pObjectBars = new SfxObjectUIArr_Impl;
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ SfxIFConfig_Impl::~SfxIFConfig_Impl()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if( pObjectBars )
//STRIP001 	{
//STRIP001 		for (USHORT n=0; n<pObjectBars->Count(); n++)
//STRIP001 			delete (*pObjectBars)[n];
//STRIP001 		delete pObjectBars;
//STRIP001 	}
/*?*/ }

//-------------------------------------------------------------------------
/*?*/ void SfxIFConfig_Impl::RegisterObjectBar( USHORT nPos, const ResId& rResId, ULONG nFeature, const String *pStr )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     SfxObjectUI_Impl* pUI = CreateObjectBarUI_Impl( nPos, rResId, nFeature, pStr, SFX_INTERFACE_OFA_START );
//STRIP001     if ( pUI )
//STRIP001         pObjectBars->Append(pUI);
/*?*/ }

/*?*/ USHORT SfxIFConfig_Impl::GetType()
/*?*/ {
/*?*/     return SFX_ITEMTYPE_INTERFACE_START + SFX_INTERFACE_OFA_START;
/*?*/ }

/*?*/ BOOL SfxIFConfig_Impl::Store(SvStream& rStream)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001     rStream << (USHORT) nVersion;
//STRIP001     rStream << (USHORT) pObjectBars->Count();
//STRIP001     for (USHORT i=0; i<pObjectBars->Count(); i++)
//STRIP001 	{
//STRIP001         rStream << (USHORT) ((*pObjectBars)[i]->nPos)
//STRIP001                 << (USHORT) (*pObjectBars)[i]->aResId.GetId()
//STRIP001                 << (USHORT) (*pObjectBars)[i]->nInterfaceId
//STRIP001                 << (USHORT) (*pObjectBars)[i]->bVisible;
//STRIP001         rStream.WriteByteString(*(*pObjectBars)[i]->pName, RTL_TEXTENCODING_UTF8 );
//STRIP001         rStream << (ULONG) (*pObjectBars)[i]->nFeature;
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
/*?*/ }

//====================================================================
// ctor, registeres a new unit

/*?*/ SfxInterface::SfxInterface( SfxModule *pMod,
/*?*/ 							const char *pClassName,
/*?*/ 							const ResId& rNameResId,
/*?*/ 							USHORT nId,
/*?*/ 							const SfxInterface* pParent,
/*?*/ 							const SfxTypeLibImpl* pLibInfo ):
/*?*/ 	pName(pClassName),
/*?*/ 	nClassId(nId),
/*?*/ 	aNameResId(rNameResId.GetId()),
/*?*/ 	pGenoType(pParent),
/*?*/ 	pTypeLibInfo(pLibInfo),
/*?*/ 	pConfig(NULL),
/*?*/ 	pImpData(0),
/*?*/ 	nCount(0)
/*?*/ {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	aNameResId.SetResMgr(rNameResId.GetResMgr());
//STRIP001 	Init( );
//STRIP001 	pImpData->pModule = pMod;
/*?*/ }

/*N*/ SfxInterface::SfxInterface( SfxModule *pMod,
/*N*/ 							const char *pClassName,
/*N*/ 							const ResId& rNameResId,
/*N*/ 							USHORT nId,
/*N*/ 							const SfxInterface* pParent,
/*N*/ 							const SfxTypeLibImpl* pLibInfo,
/*N*/ 							SfxSlot &rSlotMap, USHORT nSlotCount ):
/*N*/ 	pName(pClassName),
/*N*/ 	nClassId(nId),
/*N*/ 	aNameResId(rNameResId.GetId()),
/*N*/ 	pGenoType(pParent),
/*N*/ 	pTypeLibInfo(pLibInfo),
/*N*/ 	pConfig(NULL),
/*N*/ 	pImpData(0)
/*N*/ {
/*N*/ 	aNameResId.SetResMgr(rNameResId.GetResMgr());
/*N*/ 	Init();
/*N*/ 	pImpData->pModule = pMod;
/*N*/ 	SetSlotMap( rSlotMap, nSlotCount );
/*N*/ 	// register the functions at the SfxMessagePool
/*N*/ 	if ( pMod )
/*N*/ 		pMod->GetSlotPool()->RegisterInterface(*this);
/*N*/ 	else
/*N*/ 		SFX_APP()->GetAppSlotPool_Impl().RegisterInterface(*this);
/*N*/ }

/*N*/ void SfxInterface::Init()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_CTOR(SfxInterface, 0);
/*N*/ //    DBG_ASSERT(nCount, "Anzahl der Slot == NULL");
/*N*/ 	pImpData = new SfxInterface_Impl;
/*N*/ }


/*N*/ void SfxInterface::SetSlotMap( SfxSlot& rSlotMap, USHORT nSlotCount )
/*N*/ {
/*N*/ 	pSlots = &rSlotMap;
/*N*/ 	nCount = nSlotCount;
/*N*/ 	SfxSlot* pIter = pSlots;
/*N*/ 	if ( 1 == nCount && !pIter->pNextSlot )
/*N*/ 		pIter->pNextSlot = pIter;
/*N*/ 
/*N*/ 	if ( !pIter->pNextSlot )
/*N*/ 	{
/*?*/ 		// sort the SfxSlots by id
/*?*/ 		qsort( pSlots, nCount, sizeof(SfxSlot), SfxCompareSlots_Impl );
/*?*/ 
/*?*/ 		// link masters and slaves
/*?*/ 		USHORT nIter = 1;
/*?*/ 		for ( pIter = pSlots; nIter <= nCount; ++pIter, ++nIter )
/*?*/ 		{
/*?*/ 			//! hier bitte sinnvoll pruefen
/*?*/ 			//! DBG_ASSERT(!(pIter->IsMode(SFX_SLOT_CACHABLE) &&
/*?*/ 			//!                 pIter->IsMode(SFX_SLOT_VOLATILE)),
/*?*/ 			//!             "invalid Flags" );
/*?*/ 			DBG_ASSERT( nIter == nCount ||
/*?*/ 						pIter->GetSlotId() != (pIter+1)->GetSlotId(),
/*?*/ 						"doppelte SID" );
/*?*/ 
/*?*/ 			// jeder Master verweist auf seinen ersten Slave (ENUM), alle
/*?*/ 			// Slaves auf ihren Master.
/*?*/ 			// Slaves verweisen im Ring auf die anderen mit gleichem Master
/*?*/ 			if ( pIter->GetKind() == SFX_KIND_ENUM )
/*?*/ 			{
/*?*/ 				pIter->pLinkedSlot = GetSlot( pIter->nMasterSlotId );
/*?*/ 				DBG_ASSERT( pIter->pLinkedSlot, "slave without master" );
/*?*/ 				if ( !pIter->pLinkedSlot->pLinkedSlot )
/*?*/ 					( (SfxSlot*) pIter->pLinkedSlot)->pLinkedSlot = pIter;
/*?*/ 
/*?*/ 				if ( 0 == pIter->GetNextSlot() )
/*?*/ 				{
/*?*/ 					SfxSlot *pLastSlot = pIter;
/*?*/ 					for ( USHORT n = nIter; n < Count(); ++n )
/*?*/ 					{
/*?*/ 						SfxSlot *pCurSlot = (pSlots+n);
/*?*/ 						if ( pCurSlot->nMasterSlotId == pIter->nMasterSlotId )
/*?*/ 						{
/*?*/ 							pLastSlot->pNextSlot = pCurSlot;
/*?*/ 							pLastSlot = pCurSlot;
/*?*/ 						}
/*?*/ 					}
/*?*/ 					pLastSlot->pNextSlot = pIter;
/*?*/ 				}
/*?*/ 			}
/*?*/ 			else if ( 0 == pIter->GetNextSlot() )
/*?*/ 			{
/*?*/ 				// Slots verweisen im Ring auf den n"achten mit derselben Statusmethode
/*?*/ 				SfxSlot *pLastSlot = pIter;
/*?*/ 				for ( USHORT n = nIter; n < Count(); ++n )
/*?*/ 				{
/*?*/ 					SfxSlot *pCurSlot = (pSlots+n);
/*?*/ 					if ( pCurSlot->GetStateFnc() == pIter->GetStateFnc() )
/*?*/ 					{
/*?*/ 						pLastSlot->pNextSlot = pCurSlot;
/*?*/ 						pLastSlot = pCurSlot;
/*?*/ 					}
/*?*/ 				}
/*?*/ 				pLastSlot->pNextSlot = pIter;
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ #ifdef DBG_UTIL
/*N*/ 	else
/*N*/ 	{
/*N*/ 		USHORT nIter = 1;
/*N*/ 		for ( SfxSlot *pNext = pIter+1; nIter < nCount; ++pNext, ++nIter )
/*N*/ 		{
/*N*/ 
/*N*/ 			if ( pNext->GetSlotId() <= pIter->GetSlotId() )
/*N*/ 				DBG_ERROR ("Falsche Reihenfolge!");
/*N*/ 
/*N*/ 			if ( pIter->GetKind() == SFX_KIND_ENUM )
/*N*/ 			{
/*N*/ 				const SfxSlot *pMasterSlot = GetSlot(pIter->nMasterSlotId);
/*N*/ 				const SfxSlot *pFirstSlave = pMasterSlot->pLinkedSlot;
/*N*/ 				const SfxSlot *pSlave = pFirstSlave;
/*N*/ 				do
/*N*/ 				{
/*?*/ 					if ( pSlave->pLinkedSlot != pMasterSlot )
/*?*/ 					{
/*?*/ 						ByteString aStr("Falsche Master/Slave-Verkettung : ");
/*?*/ 						aStr += ByteString::CreateFromInt32(pMasterSlot->GetSlotId());
/*?*/ 						aStr += " , ";
/*?*/ 						aStr += ByteString::CreateFromInt32(pSlave->GetSlotId());
/*?*/ 						DBG_ERROR(aStr.GetBuffer());
/*N*/ 					}
/*N*/ 
/*N*/ 					if ( pSlave->nMasterSlotId != pMasterSlot->GetSlotId() )
/*N*/ 					{
/*?*/ 						ByteString aStr("Falsche Master/Slave-Ids : ");
/*?*/ 						aStr += ByteString::CreateFromInt32(pMasterSlot->GetSlotId());
/*?*/ 						aStr += " , ";
/*?*/ 						aStr += ByteString::CreateFromInt32(pSlave->GetSlotId());
/*?*/ 						DBG_ERROR(aStr.GetBuffer());
/*N*/ 					}
/*N*/ 
/*N*/ 					pSlave = pSlave->pNextSlot;
/*N*/ 				}
/*N*/ 				while ( pSlave != pFirstSlave );
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*N*/ 				if ( pIter->pLinkedSlot )
/*N*/ 				{
/*N*/ 					if ( pIter->pLinkedSlot->GetKind() != SFX_KIND_ENUM )
/*N*/ 					{
/*?*/ 						ByteString aStr("Slave ist kein enum : ");
/*?*/ 						aStr += ByteString::CreateFromInt32(pIter->GetSlotId());
/*?*/ 						aStr += " , ";
/*?*/ 						aStr += ByteString::CreateFromInt32(pIter->pLinkedSlot->GetSlotId());
/*?*/ 						DBG_ERROR(aStr.GetBuffer());
/*N*/ 					}
/*N*/ 				}
/*N*/ 
/*N*/ 				const SfxSlot *pLastSlot = pIter;
/*N*/ 				const SfxSlot *pCurSlot = pIter;
/*N*/ 				do
/*N*/ 				{
/*N*/ 					pCurSlot = pCurSlot->pNextSlot;
/*N*/ 					if ( pCurSlot->GetStateFnc() != pIter->GetStateFnc() )
/*N*/ 					{
/*?*/ 						ByteString aStr("Verkettete Slots mit verschiedenen StateMethods : ");
/*?*/ 						aStr += ByteString::CreateFromInt32(pCurSlot->GetSlotId());
/*?*/ 						aStr += " , ";
/*?*/ 						aStr += ByteString::CreateFromInt32(pIter->GetSlotId());
/*?*/ 						DBG_ERROR(aStr.GetBuffer());
/*N*/ 					}
/*N*/ 				}
/*N*/ 				while ( pCurSlot != pIter );
/*N*/ 			}
/*N*/ 
/*N*/ 			pIter = pNext;
/*N*/ 		}
/*N*/ 	}
/*N*/ #endif
/*N*/ }


//--------------------------------------------------------------------



/*N*/ SfxInterface::~SfxInterface()
/*N*/ {
/*N*/ 	if (pConfig)
/*?*/ 		delete pConfig;
/*N*/ 
/*N*/ 	SfxModule *pMod = pImpData->pModule;
/*N*/ 	delete pImpData;
/*N*/ 	if ( nClassId )
/*N*/ 	{
/*N*/ 		if ( pMod )
/*N*/ 			pMod->GetSlotPool()->ReleaseInterface(*this);
/*N*/ 		else
/*N*/ 			SFX_APP()->GetAppSlotPool_Impl().ReleaseInterface(*this);
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

// searches for the specified func


/*N*/ const SfxSlot* SfxInterface::GetSlot( USHORT nFuncId ) const
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_CHKTHIS(SfxInterface, 0);
/*N*/ 	DBG_ASSERT( this && pSlots && nCount, "" );
/*N*/ 
/*N*/ 	// find the id using binary search
/*N*/ 	void* p = bsearch( &nFuncId, pSlots, nCount, sizeof(SfxSlot),
/*N*/ 					   SfxCompareSlots_Impl );
/*N*/ 	if ( !p && pGenoType )
/*N*/ 		return pGenoType->GetSlot( nFuncId );
/*N*/ 
/*N*/ 	return p ? (const SfxSlot*)p : 0;
/*N*/ }

/*N*/ const SfxSlot* SfxInterface::GetSlot( const String& rCommand ) const
/*N*/ {
/*N*/ 	const char UNO_COMMAND[] = ".uno:";
/*N*/ 
/*N*/ 	String aCommand( rCommand );
/*N*/ 	if ( aCommand.SearchAscii( UNO_COMMAND ) == 0 )
/*N*/ 		aCommand.Erase( 0, sizeof( UNO_COMMAND )-1 );
/*N*/ 
/*N*/ 	SfxSlotPool& rPool = SFX_SLOTPOOL();
/*N*/ 	for ( USHORT n=0; n<nCount; n++ )
/*N*/ 	{
/*N*/         if ( (pSlots+n)->pUnoName && aCommand.CompareIgnoreCaseToAscii( (pSlots+n)->GetUnoName() ) == COMPARE_EQUAL )
/*N*/ 			return pSlots+n;
/*N*/ 	}
/*N*/ 
/*N*/ 	return pGenoType ? pGenoType->GetSlot( aCommand ) : NULL;
/*N*/ }

//--------------------------------------------------------------------


/*?*/ const SfxSlot* SfxInterface::GetRealSlot( const SfxSlot *pSlot ) const
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001 	DBG_MEMTEST();
//STRIP001 	DBG_CHKTHIS(SfxInterface, 0);
//STRIP001 	DBG_ASSERT( this && pSlots && nCount, "" );
//STRIP001 
//STRIP001 	if ( !ContainsSlot_Impl(pSlot) )
//STRIP001 	{
//STRIP001 		if(pGenoType)
//STRIP001 			return pGenoType->GetRealSlot(pSlot);
//STRIP001 		DBG_ERROR("fremder Slot");
//STRIP001 		return 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	return pSlot->pLinkedSlot;
/*?*/ }

//--------------------------------------------------------------------


/*?*/ const SfxSlot* SfxInterface::GetRealSlot( USHORT nSlotId ) const
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001 
//STRIP001 /*?*/ 	DBG_MEMTEST();
//STRIP001 /*?*/ 	DBG_CHKTHIS(SfxInterface, 0);
//STRIP001 /*?*/ 	DBG_ASSERT( this && pSlots && nCount, "" );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	const SfxSlot *pSlot = GetSlot(nSlotId);
//STRIP001 /*?*/ 	if ( !pSlot )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		if(pGenoType)
//STRIP001 /*?*/ 			return pGenoType->GetRealSlot(nSlotId);
//STRIP001 /*?*/ 		DBG_ERROR("fremder Slot");
//STRIP001 /*?*/ 		return 0;
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	return pSlot->pLinkedSlot;
/*?*/ }

//--------------------------------------------------------------------


/*N*/ void SfxInterface::RegisterPopupMenu( const ResId& rResId )
/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxInterface, 0);
/*N*/ 	pImpData->aPopupRes = rResId;
/*N*/ }

//--------------------------------------------------------------------

/*
BOOL SfxInterface::IsDefault()
{
	if (pConfig)
		return pConfig->IsDefault();
	 else
		return TRUE;
}

void SfxInterface::UseDefault()
{
	if ( !pConfig )
	{
		for (USHORT n=0; n<pImpData->pObjectBars->Count(); n++)
			delete (*pImpData->pObjectBars)[n];
		pImpData->pObjectBars->Remove(0, pImpData->pObjectBars->Count());
		return;
	}
	else if ( !pConfig->IsDefault() )
	{
		USHORT n;
		for (n=0; n<pImpData->pObjectBars->Count(); n++)
			delete (*pImpData->pObjectBars)[n];
		pImpData->pObjectBars->Remove(0, pImpData->pObjectBars->Count());

		for (n=0; n<pConfig->nCount; n++)
		{
			SfxObjectUI_Impl* pUI = new SfxObjectUI_Impl(
				(*pConfig->pObjectBars)[n]->nPos,
				(*pConfig->pObjectBars)[n]->aResId,
				(*pConfig->pObjectBars)[n]->bVisible,
				(*pConfig->pObjectBars)[n]->nFeature,
				nClassId);

			pImpData->pObjectBars->Append(pUI);
			pUI->pName = new String(*((*pConfig->pObjectBars)[n]->pName));
		}
	}
}
*/

//--------------------------------------------------------------------


/*?*/ void SfxInterface::SetObjectBarName(const String& rName, USHORT nId)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	// Objectbar im eigenen Array suchen
//STRIP001 	USHORT nCount = pImpData->pObjectBars->Count();
//STRIP001 	USHORT n;
//STRIP001 	for ( n=0; n<nCount; n++ )
//STRIP001 		if ((*pImpData->pObjectBars)[n]->aResId.GetId() == nId) break;
//STRIP001 
//STRIP001 	if ( n >= nCount )
//STRIP001 	{
//STRIP001 		// Nicht gefunden, in der Superklasse versuchen
//STRIP001 		BOOL bGenoType = ( pGenoType != 0 && !pGenoType->HasName() );
//STRIP001 		if (bGenoType)
//STRIP001 			((SfxInterface*)pGenoType)->SetObjectBarName ( rName, nId );
//STRIP001 		else
//STRIP001 			DBG_ERROR("Objectbar ist unbekannt!");
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SfxObjectUI_Impl *pUI = (*pImpData->pObjectBars)[n];
//STRIP001 		delete pUI->pName;
//STRIP001 		pUI->pName = new String( rName );
//STRIP001         DBG_ERROR("Useless configuration!");
//STRIP001 	}
/*?*/ }


/*?*/ void SfxInterface::SetObjectBarPos(USHORT nPos, USHORT nId)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	// Objectbar im eigenen Array suchen
//STRIP001 	USHORT nCount = pImpData->pObjectBars->Count();
//STRIP001 	USHORT n;
//STRIP001 	for ( n=0; n<nCount; n++ )
//STRIP001 		if ((*pImpData->pObjectBars)[n]->aResId.GetId() == nId) break;
//STRIP001 
//STRIP001 	if ( n >= nCount )
//STRIP001 	{
//STRIP001 		// Nicht gefunden, in der Superklasse versuchen
//STRIP001 		BOOL bGenoType = ( pGenoType != 0 && !pGenoType->HasName() );
//STRIP001 		if (bGenoType)
//STRIP001 			((SfxInterface*)pGenoType)->SetObjectBarPos ( nPos, nId );
//STRIP001 		else
//STRIP001 			DBG_ERROR("Objectbar ist unbekannt!");
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		(*pImpData->pObjectBars)[n]->nPos = nPos;
//STRIP001         DBG_ERROR("Useless configuration!");
//STRIP001 	}
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxInterface::RegisterObjectBar( USHORT nPos, const ResId& rResId,
/*N*/ 		const String *pStr )
/*N*/ {
/*N*/ 	RegisterObjectBar( nPos, rResId, 0UL, pStr );
/*N*/ }


/*N*/ void SfxInterface::RegisterObjectBar( USHORT nPos, const ResId& rResId, ULONG nFeature, const String *pStr )
/*N*/ {
/*N*/     SfxObjectUI_Impl* pUI = CreateObjectBarUI_Impl( nPos, rResId, nFeature, pStr, nClassId );
/*N*/     if ( pUI )
/*N*/         pImpData->pObjectBars->Append(pUI);
/*N*/ }

/*N*/ SfxObjectUI_Impl* CreateObjectBarUI_Impl( USHORT nPos, const ResId& rResId, ULONG nFeature, const String *pStr, USHORT nClassId )
/*N*/ {
/*N*/ 	if ((nPos & SFX_VISIBILITY_MASK) == 0)
/*N*/ 	{
/*N*/ 		if ((nPos & SFX_POSITION_MASK) == 0 )
/*N*/ 			nPos |= SFX_VISIBILITY_CLIENT | SFX_VISIBILITY_STANDARD;
/*N*/ 		else
/*N*/ 			nPos |= (SFX_VISIBILITY_STANDARD | SFX_VISIBILITY_SERVER);
/*N*/ 	}
/*N*/ 
/*N*/ 	// App-Leiste?
/*N*/ 	if ( SFX_OBJECTBAR_APPLICATION == ( nPos & SFX_POSITION_MASK ) )
/*N*/ 		// je nach Desktop oder Einzelapp nur die richtige registrieren
/*N*/ 		if ( !( SFX_VISIBILITY_DESKTOP == ( nPos & SFX_VISIBILITY_DESKTOP ) ) )
/*N*/             return NULL;
/*N*/ 
/*N*/ 	nPos &= ~(USHORT)SFX_VISIBILITY_DESKTOP;
/*N*/ 
/*N*/ 	if( nPos & SFX_VISIBILITY_SERVER )
/*N*/ 		nPos |= SFX_VISIBILITY_PLUGSERVER;
/*N*/ 	if( nPos & SFX_VISIBILITY_CLIENT )
/*N*/ 		nPos |= SFX_VISIBILITY_PLUGCLIENT;
/*N*/ 
/*N*/ 	SfxObjectUI_Impl* pUI = new SfxObjectUI_Impl(nPos, rResId, TRUE, nFeature, nClassId);
/*N*/ 
/*N*/ 	if (pStr == 0)
/*N*/ 	{
/*N*/ 		ResId aResId(rResId);
/*N*/ 		aResId.SetRT(RSC_STRING);
/*N*/ 		aResId.SetResMgr(rResId.GetResMgr());
/*N*/ 		if ( !Resource::GetResManager()->IsAvailable(aResId) )
/*N*/ 		{
/*N*/ 			DBG_ERROR("Der Objectbar-Name fehlt in der Resource!");
/*N*/ 			pUI->pName = new String (DEFINE_CONST_UNICODE("NoName"));
/*N*/ 		}
/*N*/ 		else
/*N*/ 			pUI->pName = new String(aResId);
/*N*/ 	}
/*N*/ 	else
/*N*/ 		pUI->pName = new String(*pStr);
/*N*/ 
/*N*/     return pUI;
/*N*/ }

/*?*/ void SfxInterface::TransferObjectBar( USHORT nPos, USHORT nId, SfxInterface *pIFace,
/*?*/ 		const String *pStr)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( !pIFace )
//STRIP001 	{
//STRIP001 		RegisterObjectBar( nPos, nId, pStr );
//STRIP001         DBG_ERROR("Useless configuration!");
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Suche den ObjectBar im Quellen-Interface ( GenoType ?? )
//STRIP001 	USHORT n;
//STRIP001 	for (n=0; n<pIFace->pImpData->pObjectBars->Count(); n++)
//STRIP001 		if ((*pIFace->pImpData->pObjectBars)[n]->aResId.GetId() == nId) break;
//STRIP001 
//STRIP001 	DBG_ASSERT(n<pIFace->pImpData->pObjectBars->Count(),"Objectbar ist unbekannt!");
//STRIP001 
//STRIP001 	// Uebernimm ResId und Interface-Id
//STRIP001 	SfxObjectUI_Impl* pUI = new SfxObjectUI_Impl(nPos,
//STRIP001 							 (*pIFace->pImpData->pObjectBars)[n]->aResId,
//STRIP001 							 (*pIFace->pImpData->pObjectBars)[n]->bVisible,
//STRIP001 							 (*pIFace->pImpData->pObjectBars)[n]->nFeature,
//STRIP001 							 (*pIFace->pImpData->pObjectBars)[n]->nInterfaceId);
//STRIP001 	pImpData->pObjectBars->Append(pUI);
//STRIP001 
//STRIP001 	if (pStr == 0)
//STRIP001 	{
//STRIP001 		pUI->pName = new String( *(pIFace->GetObjectBarName(n)));
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pUI->pName = new String(*pStr);
//STRIP001 
//STRIP001     DBG_ERROR("Useless configuration!");
//STRIP001 	pIFace->ReleaseObjectBar(nId);
/*?*/ }


/*?*/ void SfxInterface::ReleaseObjectBar( USHORT nId )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	// Objectbar im eigenen Array suchen
//STRIP001 	USHORT nCount = pImpData->pObjectBars->Count();
//STRIP001 	USHORT n;
//STRIP001 	for ( n=0; n<nCount; n++ )
//STRIP001 		if ((*pImpData->pObjectBars)[n]->aResId.GetId() == nId) break;
//STRIP001 
//STRIP001 	if ( n >= nCount )
//STRIP001 	{
//STRIP001 		// Nicht gefunden, in der Superklasse versuchen
//STRIP001 		BOOL bGenoType = ( pGenoType != 0 && !pGenoType->HasName() );
//STRIP001 		if (bGenoType)
//STRIP001 			((SfxInterface*)pGenoType)->ReleaseObjectBar( nId );
//STRIP001 		else
//STRIP001 			DBG_ERROR("Objectbar ist unbekannt!");
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		delete (*pImpData->pObjectBars)[n];
//STRIP001 		pImpData->pObjectBars->Remove(n);
//STRIP001         DBG_ERROR("Useless configuration!");
//STRIP001 	}
/*?*/ }

//--------------------------------------------------------------------


/*N*/ const ResId& SfxInterface::GetObjectBarResId( USHORT nNo ) const
/*N*/ {
/*N*/ 	BOOL bGenoType = (pGenoType != 0 && !pGenoType->HasName());
/*N*/ 	if ( bGenoType )
/*N*/ 	{
/*N*/ 		// Gibt es Toolbars in der Superklasse ?
/*N*/ 		USHORT nBaseCount = pGenoType->GetObjectBarCount();
/*N*/ 		if ( nNo < nBaseCount )
/*N*/ 			// Die der Superklasse kommen zuerst
/*N*/ 			return pGenoType->GetObjectBarResId( nNo );
/*N*/ 		else
/*N*/ 			nNo -= nBaseCount;
/*N*/ 	}
/*N*/ 
/*N*/ 	USHORT nCount = pImpData->pObjectBars->Count();
/*N*/ 	DBG_ASSERT( nNo<nCount,"Objectbar ist unbekannt!" );
/*N*/ 	return (*pImpData->pObjectBars)[nNo]->aResId;
/*N*/ }

//--------------------------------------------------------------------


/*N*/ USHORT SfxInterface::GetObjectBarPos( USHORT nNo ) const
/*N*/ {
/*N*/ 	BOOL bGenoType = (pGenoType != 0 && !pGenoType->HasName());
/*N*/ 	if ( bGenoType )
/*N*/ 	{
/*N*/ 		// Gibt es Toolbars in der Superklasse ?
/*N*/ 		USHORT nBaseCount = pGenoType->GetObjectBarCount();
/*N*/ 		if ( nNo < nBaseCount )
/*N*/ 			// Die der Superklasse kommen zuerst
/*N*/ 			return pGenoType->GetObjectBarPos( nNo );
/*N*/ 		else
/*N*/ 			nNo -= nBaseCount;
/*N*/ 	}
/*N*/ 
/*N*/ 	USHORT nCount = pImpData->pObjectBars->Count();
/*N*/ 	DBG_ASSERT( nNo<nCount,"Objectbar ist unbekannt!" );
/*N*/ 	return (*pImpData->pObjectBars)[nNo]->nPos;
/*N*/ }

//--------------------------------------------------------------------


/*N*/ USHORT SfxInterface::GetObjectBarCount() const
/*N*/ {
/*N*/ 	if (pGenoType && ! pGenoType->HasName())
/*N*/ 		return pImpData->pObjectBars->Count() + pGenoType->GetObjectBarCount();
/*N*/ 	else
/*N*/ 		return pImpData->pObjectBars->Count();
/*N*/ }

//--------------------------------------------------------------------


/*N*/ const ResId& SfxInterface::GetObjectMenuResId( USHORT nNo ) const
/*N*/ {
/*N*/ 	DBG_ASSERT(nNo<pImpData->pObjectMenues->Count(),"ObjectMenue ist unbekannt!");
/*N*/ 	return (*pImpData->pObjectMenues)[nNo]->aResId;
/*N*/ }

//--------------------------------------------------------------------


/*N*/ USHORT SfxInterface::GetObjectMenuPos( USHORT nNo ) const
/*N*/ {
/*N*/ 	DBG_ASSERT(nNo<pImpData->pObjectMenues->Count(),"ObjectMenue ist unbekannt!");
/*N*/ 	return (*pImpData->pObjectMenues)[nNo]->nPos;
/*N*/ }

//--------------------------------------------------------------------


/*N*/ USHORT SfxInterface::GetObjectMenuCount() const
/*N*/ {
/*N*/ 	return pImpData->pObjectMenues->Count();
/*N*/ }

/*?*/ void SfxInterface::ClearObjectMenus()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	for (USHORT n = pImpData->pObjectMenues->Count(); n; )
//STRIP001 	{
//STRIP001 		delete pImpData->pObjectMenues->GetObject( --n );
//STRIP001 		pImpData->pObjectMenues->Remove( n );
//STRIP001 	}
/*?*/ }

/*?*/ void SfxInterface::RemoveObjectMenu( USHORT nPos )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	for (USHORT n = pImpData->pObjectMenues->Count(); n; )
//STRIP001 		if( pImpData->pObjectMenues->GetObject(--n)->nPos == nPos )
//STRIP001 		{
//STRIP001 			delete pImpData->pObjectMenues->GetObject( n );
//STRIP001 			pImpData->pObjectMenues->Remove( n );
//STRIP001 		}
/*?*/ }
//--------------------------------------------------------------------


/*N*/ void SfxInterface::RegisterObjectMenu( USHORT nPos, const ResId& rResId )
/*N*/ {
/*N*/ 	SfxObjectUI_Impl* pUI = new SfxObjectUI_Impl(nPos, rResId, TRUE, 0, nClassId);
/*N*/ 	pImpData->pObjectMenues->Append(pUI);
/*N*/ }

//--------------------------------------------------------------------
/*N*/ void SfxInterface::RegisterChildWindow(USHORT nId, BOOL bContext, const String* pName)
/*N*/ {
/*N*/ 	RegisterChildWindow( nId, bContext, 0UL, pName );
/*N*/ }

/*N*/ void SfxInterface::RegisterChildWindow(USHORT nId, BOOL bContext, ULONG nFeature, const String*)
/*N*/ {
/*N*/ 	SfxObjectUI_Impl* pUI = new SfxObjectUI_Impl(0, nId, TRUE, nFeature, 0);
/*N*/ 	pUI->bContext = bContext;
/*N*/ 	pImpData->pChildWindows->Append(pUI);
/*N*/ }

/*N*/ void SfxInterface::ReleaseChildWindow( USHORT nId )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	USHORT nCount = pImpData->pChildWindows->Count();
//STRIP001 	USHORT n;
//STRIP001 	for ( n=0; n<nCount; n++ )
//STRIP001 		if ((*pImpData->pChildWindows)[n]->aResId.GetId() == nId) break;
//STRIP001 
//STRIP001 	if ( n >= nCount )
//STRIP001 	{
//STRIP001 		// Nicht gefunden, in der Superklasse versuchen
//STRIP001 		BOOL bGenoType = ( pGenoType != 0 && !pGenoType->HasName() );
//STRIP001 		if (bGenoType)
//STRIP001 			((SfxInterface*)pGenoType)->ReleaseChildWindow( nId );
//STRIP001 		else
//STRIP001 			DBG_ERROR("ChildWindow ist unbekannt!");
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		delete (*pImpData->pChildWindows)[n];
//STRIP001 		pImpData->pChildWindows->Remove(n);
//STRIP001         DBG_ERROR("Useless configuration!");
//STRIP001 	}
/*N*/ }

/*N*/ void SfxInterface::RegisterStatusBar(const ResId& rResId)
/*N*/ {
/*N*/ 	pImpData->aStatBarRes = rResId;
/*N*/ }


/*N*/ ULONG SfxInterface::GetChildWindowId (USHORT nNo) const
/*N*/ {
/*N*/ 	if ( pGenoType )
/*N*/ 	{
/*N*/ 		// Gibt es ChildWindows in der Superklasse ?
/*N*/ 		USHORT nBaseCount = pGenoType->GetChildWindowCount();
/*N*/ 		if ( nNo < nBaseCount )
/*N*/ 			// Die der Superklasse kommen zuerst
/*N*/ 			return pGenoType->GetChildWindowId( nNo );
/*N*/ 		else
/*N*/ 			nNo -= nBaseCount;
/*N*/ 	}
/*N*/ 
/*N*/ 	USHORT nCount = pImpData->pChildWindows->Count();
/*N*/ 	DBG_ASSERT( nNo<nCount,"ChildWindow ist unbekannt!" );
/*N*/ 	ULONG nRet = (ULONG) (*pImpData->pChildWindows)[nNo]->aResId.GetId();
/*N*/ 	if ( (*pImpData->pChildWindows)[nNo]->bContext )
/*N*/ 		nRet += ( (ULONG) nClassId ) << 16;
/*N*/ 	return nRet;
/*N*/ }

/*N*/ ULONG SfxInterface::GetChildWindowFeature (USHORT nNo) const
/*N*/ {
/*N*/ 	if ( pGenoType )
/*N*/ 	{
/*N*/ 		// Gibt es ChildWindows in der Superklasse ?
/*N*/ 		USHORT nBaseCount = pGenoType->GetChildWindowCount();
/*N*/ 		if ( nNo < nBaseCount )
/*N*/ 			// Die der Superklasse kommen zuerst
/*N*/ 			return pGenoType->GetChildWindowFeature( nNo );
/*N*/ 		else
/*N*/ 			nNo -= nBaseCount;
/*N*/ 	}
/*N*/ 
/*N*/ 	USHORT nCount = pImpData->pChildWindows->Count();
/*N*/ 	DBG_ASSERT( nNo<nCount,"ChildWindow ist unbekannt!" );
/*N*/ 	ULONG nRet = (ULONG) (*pImpData->pChildWindows)[nNo]->nFeature;
/*N*/ 	return nRet;
/*N*/ }

//--------------------------------------------------------------------


/*N*/ USHORT SfxInterface::GetChildWindowCount() const
/*N*/ {
/*N*/ 	if (pGenoType)
/*N*/ 		return pImpData->pChildWindows->Count() + pGenoType->GetChildWindowCount();
/*N*/ 	else
/*N*/ 		return pImpData->pChildWindows->Count();
/*N*/ }


/*?*/ const ResId& SfxInterface::GetPopupMenuResId() const
/*?*/ {
/*?*/ 	return pImpData->aPopupRes;
/*?*/ }


/*N*/ const ResId& SfxInterface::GetStatusBarResId() const
/*N*/ {
/*N*/ 	if (pImpData->aStatBarRes.GetId() == 0 && pGenoType)
/*N*/ 		return pGenoType->GetStatusBarResId();
/*N*/ 	else
/*N*/ 		return pImpData->aStatBarRes;
/*N*/ }



/*N*/ const String* SfxInterface::GetObjectBarName ( USHORT nNo ) const
/*N*/ {
/*N*/ 	BOOL bGenoType = (pGenoType != 0 && !pGenoType->HasName());
/*N*/ 	if ( bGenoType )
/*N*/ 	{
/*N*/ 		// Gibt es Toolbars in der Superklasse ?
/*N*/ 		USHORT nBaseCount = pGenoType->GetObjectBarCount();
/*N*/ 		if ( nNo < nBaseCount )
/*N*/ 			// Die der Superklasse kommen zuerst
/*N*/ 			return pGenoType->GetObjectBarName( nNo );
/*N*/ 		else
/*N*/ 			nNo -= nBaseCount;
/*N*/ 	}
/*N*/ 
/*N*/ 	USHORT nCount = pImpData->pObjectBars->Count();
/*N*/ 	DBG_ASSERT( nNo<nCount,"Objectbar ist unbekannt!" );
/*N*/ 	return (*pImpData->pObjectBars)[nNo]->pName;
/*N*/ }

/*N*/ ULONG SfxInterface::GetObjectBarFeature ( USHORT nNo ) const
/*N*/ {
/*N*/ 	BOOL bGenoType = (pGenoType != 0 && !pGenoType->HasName());
/*N*/ 	if ( bGenoType )
/*N*/ 	{
/*N*/ 		// Gibt es Toolbars in der Superklasse ?
/*N*/ 		USHORT nBaseCount = pGenoType->GetObjectBarCount();
/*N*/ 		if ( nNo < nBaseCount )
/*N*/ 			// Die der Superklasse kommen zuerst
/*N*/ 			return pGenoType->GetObjectBarFeature( nNo );
/*N*/ 		else
/*N*/ 			nNo -= nBaseCount;
/*N*/ 	}
/*N*/ 
/*N*/ 	USHORT nCount = pImpData->pObjectBars->Count();
/*N*/ 	DBG_ASSERT( nNo<nCount,"Objectbar ist unbekannt!" );
/*N*/ 	return (*pImpData->pObjectBars)[nNo]->nFeature;
/*N*/ }


/*N*/ BOOL SfxInterface::IsObjectBarVisible(USHORT nNo) const
/*N*/ {
/*N*/ 	BOOL bGenoType = (pGenoType != 0 && !pGenoType->HasName());
/*N*/ 	if ( bGenoType )
/*N*/ 	{
/*N*/ 		// Gibt es Toolbars in der Superklasse ?
/*N*/ 		USHORT nBaseCount = pGenoType->GetObjectBarCount();
/*N*/ 		if ( nNo < nBaseCount )
/*N*/ 			// Die der Superklasse kommen zuerst
/*N*/ 			return pGenoType->IsObjectBarVisible( nNo );
/*N*/ 		else
/*N*/ 			nNo -= nBaseCount;
/*N*/ 	}
/*N*/ 
/*N*/ 	USHORT nCount = pImpData->pObjectBars->Count();
/*N*/ 	DBG_ASSERT( nNo<nCount,"Objectbar ist unbekannt!" );
/*N*/ 	return (*pImpData->pObjectBars)[nNo]->bVisible;
/*N*/ }


/*?*/ void SfxInterface::SetObjectBarVisible(BOOL bVis, USHORT nId)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	// Objectbar im eigenen Array suchen
//STRIP001 	USHORT nCount = pImpData->pObjectBars->Count();
//STRIP001 	USHORT n;
//STRIP001 	for ( n=0; n<nCount; n++ )
//STRIP001 		if ( (*pImpData->pObjectBars)[n]->aResId.GetId() == nId ) break;
//STRIP001 
//STRIP001 	if ( n >= nCount )
//STRIP001 	{
//STRIP001 		// Nicht gefunden, in der Superklasse versuchen
//STRIP001 		BOOL bGenoType = (pGenoType != 0 && !pGenoType->HasName());
//STRIP001 		if (bGenoType)
//STRIP001 			((SfxInterface*)pGenoType)->SetObjectBarVisible(bVis,nId);
//STRIP001 		else
//STRIP001 			DBG_ERROR("Objectbar ist unbekannt!");
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		(*pImpData->pObjectBars)[n]->bVisible = bVis;
//STRIP001         DBG_ERROR("Useless configuration!");
//STRIP001 	}
/*?*/ }

/*?*/ USHORT SfxInterface::GetConfigId() const
/*?*/ {
/*?*/ 	return SFX_ITEMTYPE_INTERFACE_START + nClassId;
/*?*/ }


/*?*/ SfxObjectUIArr_Impl* SfxInterface::GetObjectBarArr_Impl() const
/*?*/ {
/*?*/ 	return pImpData->pObjectBars;
/*?*/ }


/*?*/ USHORT SfxInterface::RegisterUserDefToolBox(USHORT nId, const String *pName,
/*?*/ 				SfxConfigManager *pCfgMgr)
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001 	// Zuerst "uber den Namen die ToolBox suchen
//STRIP001 	SfxInterface *pIFace;
//STRIP001 	for (pIFace = SFX_SLOTPOOL().FirstInterface(); pIFace != 0;
//STRIP001 			pIFace = SFX_SLOTPOOL().NextInterface())
//STRIP001 	{
//STRIP001 		// Nur Interfaces mit Namen d"urfen welche bekommen
//STRIP001 		if (pIFace->HasName())
//STRIP001 		{
//STRIP001 			// Zugriff auf ObjectBars
//STRIP001 			SfxObjectUIArr_Impl *pArr = pIFace->GetObjectBarArr_Impl();
//STRIP001 			for (USHORT nNo=0; nNo<pArr->Count(); nNo++)
//STRIP001 			{
//STRIP001 				if ( *pName == *(*pArr)[nNo]->pName)
//STRIP001 					return (*pArr)[nNo]->aResId.GetId();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Ansonsten n"achste freie Id besorgen
//STRIP001 	USHORT nFreeId = SfxToolBoxManager::GetUserDefToolBoxId_Impl();
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 
//STRIP001 	// Alle Interfaces durchprobieren, ob sie noch eine UserDefToolBox
//STRIP001 	// aufnehmen k"onnen
//STRIP001 	USHORT nPos;
//STRIP001 	for (pIFace = SFX_SLOTPOOL().FirstInterface(); pIFace != 0;
//STRIP001 			pIFace = SFX_SLOTPOOL().NextInterface())
//STRIP001 	{
//STRIP001 		BOOL bFound = FALSE;
//STRIP001 
//STRIP001 		// Nur Interfaces mit Namen d"urfen welche bekommen
//STRIP001 		if (pIFace->HasName())
//STRIP001 		{
//STRIP001 			// Zugriff auf ObjectBars
//STRIP001 			SfxObjectUIArr_Impl *pArr = pIFace->GetObjectBarArr_Impl();
//STRIP001 
//STRIP001 			for ( nPos=SFX_OBJECTBAR_USERDEF1; nPos<=SFX_OBJECTBAR_USERDEF3; nPos++ )
//STRIP001 			{
//STRIP001 				// Nach freier Position suchen
//STRIP001 				bFound = TRUE;
//STRIP001 				for (USHORT nNo=0; nNo<pArr->Count(); nNo++)
//STRIP001 				{
//STRIP001 					if ( nPos == (*pArr)[nNo]->nPos)
//STRIP001 					{
//STRIP001 						// Diese Position ist schon besetzt, n"achste versuchen
//STRIP001 						bFound = FALSE;
//STRIP001 						break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				// Wurde eine noch freie Position gefunden ?
//STRIP001 				if ( bFound )
//STRIP001 					break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// Wurde am Interface etwas gefunden ?
//STRIP001 		if ( bFound )
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pIFace )
//STRIP001 	{
//STRIP001 		// Am gefundenen Interface mu\s die Konfiguration ver"andert werden
//STRIP001 		SfxConfigItem *pCfgItem = pIFace->GetConfig_Impl();
//STRIP001         SfxConfigManager *pOldCfgMgr = pCfgItem->GetConfigManager();
//STRIP001 /* //!MBA
//STRIP001 		if ( pOldCfgMgr != pCfgMgr )
//STRIP001 		{
//STRIP001 			// Wenn das Interface bisher von einem anderen ConfigManager
//STRIP001 			// bedient wird, wird dessen Config gesichert
//STRIP001 			pCfgItem->StoreConfig();
//STRIP001 
//STRIP001 			// Der Ziel-Configmanager mu\s die Konfiguration aufnehmen k"onnen
//STRIP001 			if ( !pCfgMgr->HasConfigItem(pIFace->GetConfigId()) )
//STRIP001 				pCfgMgr->InsertConfigItem(pIFace->GetConfigId());
//STRIP001 
//STRIP001 			// Verbindung mit dem ConfigItem herstellen und Config "ubernehmen
//STRIP001 			pCfgMgr->AddConfigItem(pCfgItem);
//STRIP001 			pCfgItem->Initialize();
//STRIP001 		}
//STRIP001 */
//STRIP001 		// Jetzt wird das Interface umkonfiguriert
//STRIP001 		pIFace->RegisterObjectBar(nPos, nFreeId, pName);
//STRIP001 		pIFace->SetObjectBarVisible(TRUE, nFreeId);
//STRIP001 
//STRIP001 /* //!MBA
//STRIP001 		// Konfiguration sichern und aktuellen Stand der Config restaurieren
//STRIP001 		if ( pCfgMgr != pOldCfgMgr && pCfgMgr != SFX_CFGMANAGER() )
//STRIP001 		{
//STRIP001 			pCfgItem->StoreConfig();
//STRIP001 			pCfgMgr->RemoveConfigItem(pCfgItem);
//STRIP001 			pCfgItem->Connect(pOldCfgMgr);
//STRIP001 			pCfgItem->Initialize();
//STRIP001 		}
//STRIP001  */
//STRIP001 	}
//STRIP001 
//STRIP001 	return nFreeId;
/*?*/ }


/*?*/ void SfxInterface::ReleaseUserDefToolBox(USHORT nId, SfxConfigManager *pCfgMgr)
/*?*/ 
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	BOOL bDone = FALSE;
//STRIP001 
//STRIP001 	// Alle Interfaces durchprobieren, ob sie diese UserDefToolBox haben
//STRIP001 	for (SfxInterface *pIFace = SFX_SLOTPOOL().FirstInterface(); pIFace != 0;
//STRIP001 			pIFace = SFX_SLOTPOOL().NextInterface())
//STRIP001 	{
//STRIP001 		// Nur Interfaces mit Namen k"onnen welche haben
//STRIP001 		if (pIFace->HasName())
//STRIP001 		{
//STRIP001 			// Die Konfiguration vom "ubergebenen Manager interessiert
//STRIP001 			SfxConfigItem *pCfgItem = pIFace->GetConfig_Impl();
//STRIP001             SfxConfigManager *pOldCfgMgr = pCfgItem->GetConfigManager();
//STRIP001 /* //!MBA
//STRIP001 			if ( pOldCfgMgr != pCfgMgr )
//STRIP001 			{
//STRIP001 				// Wenn das Interface bisher von einem anderen ConfigManager
//STRIP001 				// bedient wird, wird dessen Config gesichert
//STRIP001 				pCfgItem->StoreConfig();
//STRIP001 
//STRIP001 				// Verbindung mit dem ConfigItem herstellen und Config "ubernehmen
//STRIP001 				pCfgMgr->AddConfigItem(pCfgItem);
//STRIP001 				pCfgItem->Initialize();
//STRIP001 			}
//STRIP001 */
//STRIP001 			if ( pIFace->HasObjectBar(nId) )
//STRIP001 			{
//STRIP001 				pIFace->ReleaseObjectBar(nId);
//STRIP001 				BOOL bDone = TRUE;
//STRIP001 			}
//STRIP001 
//STRIP001 /* //!MBA
//STRIP001 			// Konfiguration sichern und aktuellen Stand der Config restaurieren
//STRIP001 			if ( pCfgMgr != pOldCfgMgr )
//STRIP001 			{
//STRIP001 				pCfgItem->StoreConfig();
//STRIP001 				pCfgMgr->RemoveConfigItem(pCfgItem);
//STRIP001 				pCfgItem->Connect(pOldCfgMgr);
//STRIP001 				pCfgItem->Initialize();
//STRIP001 			}
//STRIP001  */
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bDone )
//STRIP001 		{
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
/*?*/ }


/*N*/ BOOL SfxInterface::HasObjectBar( USHORT nId ) const
/*N*/ {
/*N*/ 	for (USHORT n=0; n<pImpData->pObjectBars->Count(); n++)
/*N*/ 		if ((*pImpData->pObjectBars)[n]->aResId.GetId() == nId) return TRUE;
/*N*/ 	return FALSE;
/*N*/ }

/*N*/ SfxModule* SfxInterface::GetModule() const
/*N*/ {
/*N*/ 	return pImpData->pModule;
/*N*/ }

/*N*/ const SfxInterface* SfxInterface::GetRealInterfaceForSlot( const SfxSlot *pRealSlot ) const
/*N*/ {
/*N*/ 	const SfxInterface* pInterface = this;
/*N*/ 
/*N*/ 	// Der Slot k"onnte auch aus dem Interface einer Shell-Basisklasse stammen
/*N*/ 	do
/*N*/ 	{
/*N*/ 		const SfxSlot *pLastSlot  = (*pInterface)[pInterface->Count()-1];
/*N*/ 		const SfxSlot *pFirstSlot = (*pInterface)[0];
/*N*/ 
/*N*/ 		// Ist pInterface der Owner von pRealSlot ?
/*N*/ 		if ( pFirstSlot <= pRealSlot && pRealSlot <= pLastSlot )
/*N*/ 			break;
/*N*/ 
/*N*/ 		// Sonst Interface der Superklasse probieren
/*N*/ 		pInterface = pInterface->pGenoType;
/*N*/ 	}
/*N*/ 	while ( pInterface );
/*N*/ 
/*N*/ 	return pInterface;
/*N*/ }



/*N*/ void SfxInterface::LoadConfig()
/*N*/ {
/*N*/ }

}
