/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_drwtrans.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:45:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// INCLUDE ---------------------------------------------------------------

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// auto strip #include <com/sun/star/beans/XPropertySet.hpp>
// auto strip #include <com/sun/star/beans/XPropertySetInfo.hpp>
// auto strip #include <com/sun/star/form/FormButtonType.hpp>

// auto strip #ifndef _UTL_STREAM_WRAPPER_HXX_
// auto strip #include <unotools/streamwrap.hxx>
// auto strip #endif

// auto strip #include <bf_svx/unomodel.hxx>

// auto strip #include <so3/svstor.hxx>
// auto strip #include <vcl/virdev.hxx>
// auto strip #include <bf_svx/fmglob.hxx>
// auto strip #include <bf_svx/svditer.hxx>
// auto strip #include <bf_svx/svdograf.hxx>
// auto strip #include <bf_svx/svdoole2.hxx>
// auto strip #include <bf_svx/svdouno.hxx>
// auto strip #include <bf_svx/svdpage.hxx>
// auto strip #include <bf_svx/svdxcgv.hxx>
// auto strip #include <bf_sfx2/docfile.hxx>
#include <svtools/itempool.hxx>
// auto strip #include <svtools/urlbmk.hxx>
// auto strip #include <tools/urlobj.hxx>
// auto strip #include <vos/mutex.hxx>

#include "drwtrans.hxx"
// auto strip #include "docsh.hxx"
// auto strip #include "drwlayer.hxx"
// auto strip #include "drawview.hxx"
// auto strip #include "viewdata.hxx"
#include "scmod.hxx"

// #108584#
#include "scitems.hxx"

// #108584#
// auto strip #ifndef _EEITEM_HXX
// auto strip #include <bf_svx/eeitem.hxx>
// auto strip #endif

// #108584#
// auto strip #ifndef _SVX_FHGTITEM_HXX
// auto strip #include <bf_svx/fhgtitem.hxx>
// auto strip #endif
namespace binfilter {

using namespace ::com::sun::star;

// -----------------------------------------------------------------------

#define SCDRAWTRANS_TYPE_EMBOBJ         1
#define SCDRAWTRANS_TYPE_DRAWMODEL      2

// -----------------------------------------------------------------------

// -----------------------------------------------------------------------

//STRIP001 ScDrawTransferObj::ScDrawTransferObj( SdrModel* pClipModel, ScDocShell* pContainerShell,
//STRIP001                                         const TransferableObjectDescriptor& rDesc ) :
//STRIP001     aObjDesc( rDesc ),
//STRIP001     pModel( pClipModel ),
//STRIP001     pBookmark( NULL ),
//STRIP001     bGraphic( FALSE ),
//STRIP001     bGrIsBit( FALSE ),
//STRIP001     bOleObj( FALSE ),
//STRIP001     pDragSourceView( NULL ),
//STRIP001     nDragSourceFlags( 0 ),
//STRIP001     bDragWasInternal( FALSE ),
//STRIP001     nSourceDocID( 0 )
//STRIP001 {
//STRIP001     //
//STRIP001     //  check what kind of objects are contained
//STRIP001     //
//STRIP001 
//STRIP001     SdrPage* pPage = pModel->GetPage(0);
//STRIP001     if (pPage)
//STRIP001     {
//STRIP001         SdrObjListIter aIter( *pPage, IM_FLAT );
//STRIP001         SdrObject* pObject = aIter.Next();
//STRIP001         if (pObject && !aIter.Next())               // exactly one object?
//STRIP001         {
//STRIP001             //
//STRIP001             //  OLE object
//STRIP001             //
//STRIP001 
//STRIP001             UINT16 nSdrObjKind = pObject->GetObjIdentifier();
//STRIP001             if (nSdrObjKind == OBJ_OLE2)
//STRIP001             {
//STRIP001                 bOleObj = TRUE;
//STRIP001                 // aOleData is initialized later
//STRIP001             }
//STRIP001 
//STRIP001             //
//STRIP001             //  Graphic object
//STRIP001             //
//STRIP001 
//STRIP001             if (nSdrObjKind == OBJ_GRAF)
//STRIP001             {
//STRIP001                 bGraphic = TRUE;
//STRIP001                 if ( ((SdrGrafObj*)pObject)->GetGraphic().GetType() == GRAPHIC_BITMAP )
//STRIP001                     bGrIsBit = TRUE;
//STRIP001             }
//STRIP001 
//STRIP001             //
//STRIP001             //  URL button
//STRIP001             //
//STRIP001 
//STRIP001             SdrUnoObj* pUnoCtrl = PTR_CAST(SdrUnoObj, pObject);
//STRIP001             if (pUnoCtrl && FmFormInventor == pUnoCtrl->GetObjInventor())
//STRIP001             {
//STRIP001                 uno::Reference<awt::XControlModel> xControlModel = pUnoCtrl->GetUnoControlModel();
//STRIP001                 DBG_ASSERT( xControlModel.is(), "uno control without model" );
//STRIP001                 if ( xControlModel.is() )
//STRIP001                 {
//STRIP001                     uno::Reference< beans::XPropertySet > xPropSet( xControlModel, uno::UNO_QUERY );
//STRIP001                     uno::Reference< beans::XPropertySetInfo > xInfo = xPropSet->getPropertySetInfo();
//STRIP001 
//STRIP001                     ::rtl::OUString sPropButtonType = ::rtl::OUString::createFromAscii( "ButtonType" );
//STRIP001                     ::rtl::OUString sPropTargetURL  = ::rtl::OUString::createFromAscii( "TargetURL" );
//STRIP001                     ::rtl::OUString sPropLabel      = ::rtl::OUString::createFromAscii( "Label" );
//STRIP001 
//STRIP001                     if(xInfo->hasPropertyByName( sPropButtonType ))
//STRIP001                     {
//STRIP001                         uno::Any aAny = xPropSet->getPropertyValue( sPropButtonType );
//STRIP001                         form::FormButtonType eTmp;
//STRIP001                         if ( (aAny >>= eTmp) && eTmp == form::FormButtonType_URL )
//STRIP001                         {
//STRIP001                             // URL
//STRIP001                             if(xInfo->hasPropertyByName( sPropTargetURL ))
//STRIP001                             {
//STRIP001                                 aAny = xPropSet->getPropertyValue( sPropTargetURL );
//STRIP001                                 ::rtl::OUString sTmp;
//STRIP001                                 if ( (aAny >>= sTmp) && sTmp.getLength() )
//STRIP001                                 {
//STRIP001                                     String aUrl = sTmp;
//STRIP001                                     String aAbs;
//STRIP001                                     const SfxMedium* pMedium;
//STRIP001                                     if (pContainerShell && (pMedium = pContainerShell->GetMedium()))
//STRIP001                                     {
//STRIP001                                         bool bWasAbs = true;
//STRIP001                                         aAbs = pMedium->GetURLObject().smartRel2Abs( aUrl, bWasAbs ).
//STRIP001                                         			GetMainURL(INetURLObject::NO_DECODE);
//STRIP001 										// full path as stored INetBookmark must be encoded
//STRIP001                                     }
//STRIP001                                     else
//STRIP001                                         aAbs = aUrl;
//STRIP001 
//STRIP001                                     // Label
//STRIP001                                     String aLabel;
//STRIP001                                     if(xInfo->hasPropertyByName( sPropLabel ))
//STRIP001                                     {
//STRIP001                                         aAny = xPropSet->getPropertyValue( sPropLabel );
//STRIP001                                         if ( (aAny >>= sTmp) && sTmp.getLength() )
//STRIP001                                         {
//STRIP001                                             aLabel = String(sTmp);
//STRIP001                                         }
//STRIP001                                     }
//STRIP001                                     pBookmark = new INetBookmark( aAbs, aLabel );
//STRIP001                                 }
//STRIP001                             }
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     //
//STRIP001     //  get size for object descriptor
//STRIP001     //
//STRIP001 
//STRIP001     SdrExchangeView aView(pModel);
//STRIP001     Point aPos;
//STRIP001     SdrPageView* pPv = aView.ShowPagePgNum(0,aPos);
//STRIP001     aView.MarkAll(pPv);
//STRIP001     aSrcSize = aView.GetAllMarkedRect().GetSize();
//STRIP001     aObjDesc.maSize = aSrcSize;
//STRIP001 
//STRIP001     //
//STRIP001     // remember a unique ID of the source document
//STRIP001     //
//STRIP001     if ( pContainerShell )
//STRIP001     {
//STRIP001         const ScDocument* pDoc = pContainerShell->GetDocument();
//STRIP001         if ( pDoc )
//STRIP001             nSourceDocID = pDoc->GetDocumentID();
//STRIP001     }
//STRIP001 }

//STRIP001 ScDrawTransferObj::~ScDrawTransferObj()
//STRIP001 {
//STRIP001     Application::GetSolarMutex().acquire();     //! ???
//STRIP001 
//STRIP001     ScModule* pScMod = SC_MOD();
//STRIP001     if ( pScMod->GetClipData().pDrawClipboard == this )
//STRIP001     {
//STRIP001         DBG_ERROR("ScDrawTransferObj wasn't released");
//STRIP001         pScMod->SetClipObject( NULL, NULL );
//STRIP001     }
//STRIP001     if ( pScMod->GetDragData().pDrawTransfer == this )
//STRIP001     {
//STRIP001         DBG_ERROR("ScDrawTransferObj wasn't released");
//STRIP001         pScMod->ResetDragObject();
//STRIP001     }
//STRIP001 
//STRIP001     aOleData = TransferableDataHelper();        // clear before releasing the mutex
//STRIP001     aDocShellRef.Clear();
//STRIP001 
//STRIP001     delete pModel;
//STRIP001     aDrawPersistRef.Clear();                    // after the model
//STRIP001 
//STRIP001     delete pBookmark;
//STRIP001     delete pDragSourceView;
//STRIP001 
//STRIP001     Application::GetSolarMutex().release();     //! ???
//STRIP001 }

// static
/*N*/ ScDrawTransferObj* ScDrawTransferObj::GetOwnClipboard( Window* )
/*N*/ {
/*N*/     ScDrawTransferObj* pObj = SC_MOD()->GetClipData().pDrawClipboard;
/*N*/     return pObj;
/*N*/ }

//STRIP001 BOOL lcl_HasOnlyControls( SdrModel* pModel )
//STRIP001 {
//STRIP001     BOOL bOnlyControls = FALSE;         // default if there are no objects
//STRIP001 
//STRIP001     if ( pModel )
//STRIP001     {
//STRIP001         SdrPage* pPage = pModel->GetPage(0);
//STRIP001         if (pPage)
//STRIP001         {
//STRIP001             SdrObjListIter aIter( *pPage, IM_DEEPNOGROUPS );
//STRIP001             SdrObject* pObj = aIter.Next();
//STRIP001             if ( pObj )
//STRIP001             {
//STRIP001                 bOnlyControls = TRUE;   // only set if there are any objects at all
//STRIP001                 while ( pObj )
//STRIP001                 {
//STRIP001                     if (!pObj->ISA(SdrUnoObj))
//STRIP001                     {
//STRIP001                         bOnlyControls = FALSE;
//STRIP001                         break;
//STRIP001                     }
//STRIP001                     pObj = aIter.Next();
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return bOnlyControls;
//STRIP001 }

//STRIP001 void ScDrawTransferObj::AddSupportedFormats()
//STRIP001 {
//STRIP001     if ( bGrIsBit )             // single bitmap graphic
//STRIP001     {
//STRIP001 		AddFormat( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR );
//STRIP001         AddFormat( SOT_FORMATSTR_ID_SVXB );
//STRIP001         AddFormat( SOT_FORMAT_BITMAP );
//STRIP001         AddFormat( SOT_FORMAT_GDIMETAFILE );
//STRIP001     }
//STRIP001     else if ( bGraphic )        // other graphic
//STRIP001     {
//STRIP001 		AddFormat( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR );
//STRIP001         AddFormat( SOT_FORMATSTR_ID_SVXB );
//STRIP001         AddFormat( SOT_FORMAT_GDIMETAFILE );
//STRIP001         AddFormat( SOT_FORMAT_BITMAP );
//STRIP001     }
//STRIP001     else if ( pBookmark )       // url button
//STRIP001     {
//STRIP001 //      AddFormat( SOT_FORMATSTR_ID_EMBED_SOURCE );
//STRIP001         AddFormat( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR );
//STRIP001         AddFormat( SOT_FORMATSTR_ID_SOLK );
//STRIP001         AddFormat( SOT_FORMAT_STRING );
//STRIP001         AddFormat( SOT_FORMATSTR_ID_UNIFORMRESOURCELOCATOR );
//STRIP001         AddFormat( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK );
//STRIP001         AddFormat( SOT_FORMATSTR_ID_DRAWING );
//STRIP001     }
//STRIP001     else if ( bOleObj )         // single OLE object
//STRIP001     {
//STRIP001         AddFormat( SOT_FORMATSTR_ID_EMBED_SOURCE );
//STRIP001         AddFormat( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR );
//STRIP001         AddFormat( SOT_FORMAT_GDIMETAFILE );
//STRIP001 
//STRIP001         if ( !aOleData.GetTransferable().is() )
//STRIP001         {
//STRIP001             SvInPlaceObjectRef xIPObj = GetSingleObject();
//STRIP001             if ( xIPObj.Is() )
//STRIP001                 aOleData = TransferableDataHelper( xIPObj->CreateTransferableSnapshot() );
//STRIP001         }
//STRIP001         if ( aOleData.GetTransferable().is() )
//STRIP001         {
//STRIP001             //  get format list from object snapshot
//STRIP001             //  (this must be after inserting the default formats!)
//STRIP001 
//STRIP001             DataFlavorExVector              aVector( aOleData.GetDataFlavorExVector() );
//STRIP001             DataFlavorExVector::iterator    aIter( aVector.begin() ), aEnd( aVector.end() );
//STRIP001 
//STRIP001             while( aIter != aEnd )
//STRIP001                 AddFormat( *aIter++ );
//STRIP001         }
//STRIP001     }
//STRIP001     else                        // any drawing objects
//STRIP001     {
//STRIP001         AddFormat( SOT_FORMATSTR_ID_EMBED_SOURCE );
//STRIP001         AddFormat( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR );
//STRIP001         AddFormat( SOT_FORMATSTR_ID_DRAWING );
//STRIP001 
//STRIP001         // #103556# leave out bitmap and metafile if there are only controls
//STRIP001         if ( !lcl_HasOnlyControls( pModel ) )
//STRIP001         {
//STRIP001             AddFormat( SOT_FORMAT_BITMAP );
//STRIP001             AddFormat( SOT_FORMAT_GDIMETAFILE );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001 //  if( pImageMap )
//STRIP001 //      AddFormat( SOT_FORMATSTR_ID_SVIM );
//STRIP001 }

//STRIP001 sal_Bool ScDrawTransferObj::GetData( const ::com::sun::star::datatransfer::DataFlavor& rFlavor )
//STRIP001 {
//STRIP001     sal_Bool bOK = sal_False;
//STRIP001 
//STRIP001     if ( bOleObj )
//STRIP001     {
//STRIP001         if ( !aOleData.GetTransferable().is() )
//STRIP001         {
//STRIP001             SvInPlaceObjectRef xIPObj = GetSingleObject();
//STRIP001             if ( xIPObj.Is() )
//STRIP001                 aOleData = TransferableDataHelper( xIPObj->CreateTransferableSnapshot() );
//STRIP001         }
//STRIP001 
//STRIP001         if( aOleData.GetTransferable().is() && aOleData.HasFormat( rFlavor ) )
//STRIP001         {
//STRIP001             ULONG nOldSwapMode;
//STRIP001 
//STRIP001             if( pModel )
//STRIP001             {
//STRIP001                 nOldSwapMode = pModel->GetSwapGraphicsMode();
//STRIP001                 pModel->SetSwapGraphicsMode( SDR_SWAPGRAPHICSMODE_PURGE );
//STRIP001             }
//STRIP001 
//STRIP001             bOK = SetAny( aOleData.GetAny( rFlavor ), rFlavor );
//STRIP001 
//STRIP001             if( pModel )
//STRIP001                 pModel->SetSwapGraphicsMode( nOldSwapMode );
//STRIP001 
//STRIP001             return bOK;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     sal_uInt32 nFormat = SotExchange::GetFormat( rFlavor );
//STRIP001     if( HasFormat( nFormat ) )
//STRIP001     {
//STRIP001         if ( nFormat == SOT_FORMATSTR_ID_LINKSRCDESCRIPTOR || nFormat == SOT_FORMATSTR_ID_OBJECTDESCRIPTOR )
//STRIP001         {
//STRIP001             if ( bOleObj )              // single OLE object
//STRIP001             {
//STRIP001                 SvInPlaceObjectRef xIPObj = GetSingleObject();
//STRIP001                 if ( xIPObj.Is() )
//STRIP001                     xIPObj->FillTransferableObjectDescriptor( aObjDesc );
//STRIP001             }
//STRIP001 
//STRIP001             bOK = SetTransferableObjectDescriptor( aObjDesc, rFlavor );
//STRIP001         }
//STRIP001         else if ( nFormat == SOT_FORMATSTR_ID_DRAWING )
//STRIP001         {
//STRIP001             bOK = SetObject( pModel, SCDRAWTRANS_TYPE_DRAWMODEL, rFlavor );
//STRIP001         }
//STRIP001         else if ( nFormat == SOT_FORMAT_BITMAP || nFormat == SOT_FORMAT_GDIMETAFILE )
//STRIP001         {
//STRIP001             SdrExchangeView aView( pModel );
//STRIP001             Point aPos;
//STRIP001             SdrPageView* pPv = aView.ShowPagePgNum( 0, aPos );
//STRIP001             DBG_ASSERT( pPv, "pPv not there..." );
//STRIP001             aView.MarkAll( pPv );
//STRIP001             if ( nFormat == SOT_FORMAT_GDIMETAFILE )
//STRIP001                 bOK = SetGDIMetaFile( aView.GetAllMarkedMetaFile( TRUE ), rFlavor );
//STRIP001             else
//STRIP001                 bOK = SetBitmap( aView.GetAllMarkedBitmap( TRUE ), rFlavor );
//STRIP001         }
//STRIP001         else if ( nFormat == SOT_FORMATSTR_ID_SVXB )
//STRIP001         {
//STRIP001             // only enabled for single graphics object
//STRIP001 
//STRIP001             SdrPage* pPage = pModel->GetPage(0);
//STRIP001             if (pPage)
//STRIP001             {
//STRIP001                 SdrObjListIter aIter( *pPage, IM_FLAT );
//STRIP001                 SdrObject* pObject = aIter.Next();
//STRIP001                 if (pObject && pObject->GetObjIdentifier() == OBJ_GRAF)
//STRIP001                 {
//STRIP001                     SdrGrafObj* pGraphObj = (SdrGrafObj*) pObject;
//STRIP001                     bOK = SetGraphic( pGraphObj->GetGraphic(), rFlavor );
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001         else if ( nFormat == SOT_FORMATSTR_ID_EMBED_SOURCE )
//STRIP001         {
//STRIP001             if ( bOleObj )              // single OLE object
//STRIP001             {
//STRIP001                 SvInPlaceObjectRef xIPObj = GetSingleObject();
//STRIP001                 if ( xIPObj.Is() )
//STRIP001                 {
//STRIP001                     SvEmbeddedObject* pEmbObj = xIPObj;
//STRIP001                     bOK = SetObject( pEmbObj, SCDRAWTRANS_TYPE_EMBOBJ, rFlavor );
//STRIP001                 }
//STRIP001             }
//STRIP001             else                        // create object from contents
//STRIP001             {
//STRIP001                 InitDocShell();         // set aDocShellRef
//STRIP001 
//STRIP001                 SvEmbeddedObject* pEmbObj = aDocShellRef;
//STRIP001                 bOK = SetObject( pEmbObj, SCDRAWTRANS_TYPE_EMBOBJ, rFlavor );
//STRIP001             }
//STRIP001         }
//STRIP001         else if( pBookmark )
//STRIP001         {
//STRIP001             bOK = SetINetBookmark( *pBookmark, rFlavor );
//STRIP001         }
//STRIP001     }
//STRIP001     return bOK;
//STRIP001 }

//STRIP001 sal_Bool ScDrawTransferObj::WriteObject( SotStorageStreamRef& rxOStm, void* pUserObject, sal_uInt32 nUserObjectId,
//STRIP001                                         const ::com::sun::star::datatransfer::DataFlavor& rFlavor )
//STRIP001 {
//STRIP001     // called from SetObject, put data into stream
//STRIP001 
//STRIP001     sal_Bool bRet = sal_False;
//STRIP001     switch (nUserObjectId)
//STRIP001     {
//STRIP001         case SCDRAWTRANS_TYPE_DRAWMODEL:
//STRIP001             {
//STRIP001                 SdrModel* pDrawModel = (SdrModel*)pUserObject;
//STRIP001                 pDrawModel->SetStreamingSdrModel(TRUE);
//STRIP001                 rxOStm->SetBufferSize( 0xff00 );
//STRIP001 
//STRIP001 				// #108584#
//STRIP001 				// for the changed pool defaults from drawing layer pool set those
//STRIP001 				// attributes as hard attributes to preserve them for saving
//STRIP001 				const SfxItemPool& rItemPool = pModel->GetItemPool();
//STRIP001 				const SvxFontHeightItem& rDefaultFontHeight = (const SvxFontHeightItem&)rItemPool.GetDefaultItem(EE_CHAR_FONTHEIGHT);
//STRIP001 				
//STRIP001 				// SW should have no MasterPages
//STRIP001 				DBG_ASSERT(0L == pModel->GetMasterPageCount(), "SW with MasterPages (!)");
//STRIP001 
//STRIP001 				for(sal_uInt16 a(0); a < pModel->GetPageCount(); a++) 
//STRIP001 				{
//STRIP001 					const SdrPage* pPage = pModel->GetPage(a);
//STRIP001 					SdrObjListIter aIter(*pPage, IM_DEEPNOGROUPS);
//STRIP001 					
//STRIP001 					while(aIter.IsMore())
//STRIP001 					{
//STRIP001 						SdrObject* pObj = aIter.Next();
//STRIP001 						const SvxFontHeightItem& rItem = (const SvxFontHeightItem&)pObj->GetItem(EE_CHAR_FONTHEIGHT);
//STRIP001 
//STRIP001 						if(rItem.GetHeight() == rDefaultFontHeight.GetHeight())
//STRIP001 						{
//STRIP001 							pObj->SetItem(rDefaultFontHeight);
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 				
//STRIP001 				{
//STRIP001 					::com::sun::star::uno::Reference< ::com::sun::star::io::XOutputStream> xDocOut( new utl::OOutputStreamWrapper( *rxOStm ) );
//STRIP001 					if( SvxDrawingLayerExport( pDrawModel, xDocOut ) )
//STRIP001 						rxOStm->Commit();
//STRIP001 				}
//STRIP001 				pDrawModel->SetStreamingSdrModel(FALSE);
//STRIP001                 bRet = ( rxOStm->GetError() == ERRCODE_NONE );
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001         case SCDRAWTRANS_TYPE_EMBOBJ:
//STRIP001             {
//STRIP001                 SvEmbeddedObject* pEmbObj = (SvEmbeddedObject*)pUserObject;
//STRIP001 
//STRIP001                 SvStorageRef xWorkStore( new SvStorage( TRUE, *rxOStm ) );
//STRIP001                 rxOStm->SetBufferSize( 0xff00 );
//STRIP001 
//STRIP001                 // write document storage
//STRIP001                 pEmbObj->SetupStorage( xWorkStore );
//STRIP001                 bRet = pEmbObj->DoSaveAs( xWorkStore );
//STRIP001                 pEmbObj->DoSaveCompleted();
//STRIP001                 xWorkStore->Commit();
//STRIP001                 rxOStm->Commit();
//STRIP001 
//STRIP001                 bRet = ( rxOStm->GetError() == ERRCODE_NONE );
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001         default:
//STRIP001             DBG_ERROR("unknown object id");
//STRIP001     }
//STRIP001     return bRet;
//STRIP001 }

//STRIP001 void ScDrawTransferObj::ObjectReleased()
//STRIP001 {
//STRIP001     ScModule* pScMod = SC_MOD();
//STRIP001     if ( pScMod->GetClipData().pDrawClipboard == this )
//STRIP001         pScMod->SetClipObject( NULL, NULL );
//STRIP001 
//STRIP001     TransferableHelper::ObjectReleased();
//STRIP001 }

//STRIP001 void ScDrawTransferObj::DragFinished( sal_Int8 nDropAction )
//STRIP001 {
//STRIP001     if ( nDropAction == DND_ACTION_MOVE && !bDragWasInternal && !(nDragSourceFlags & SC_DROP_NAVIGATOR) )
//STRIP001     {
//STRIP001         //  move: delete source objects
//STRIP001 
//STRIP001         if ( pDragSourceView )
//STRIP001             pDragSourceView->DeleteMarked();
//STRIP001     }
//STRIP001 
//STRIP001     ScModule* pScMod = SC_MOD();
//STRIP001     if ( pScMod->GetDragData().pDrawTransfer == this )
//STRIP001         pScMod->ResetDragObject();
//STRIP001 
//STRIP001     DELETEZ( pDragSourceView );
//STRIP001 
//STRIP001     TransferableHelper::DragFinished( nDropAction );
//STRIP001 }

//STRIP001 void ScDrawTransferObj::SetDrawPersist( const SvEmbeddedObjectRef& rRef )
//STRIP001 {
//STRIP001     aDrawPersistRef = rRef;
//STRIP001 }

//STRIP001 void lcl_InitMarks( SdrMarkView& rDest, const SdrMarkView& rSource, USHORT nTab )
//STRIP001 {
//STRIP001     rDest.ShowPagePgNum( nTab, Point() );
//STRIP001     SdrPageView* pDestPV = rDest.GetPageViewPvNum(0);
//STRIP001     DBG_ASSERT(pDestPV,"PageView ??!?!");
//STRIP001 
//STRIP001     const SdrMarkList& rMarkList = rSource.GetMarkList();
//STRIP001     ULONG nCount = rMarkList.GetMarkCount();
//STRIP001     for (ULONG i=0; i<nCount; i++)
//STRIP001     {
//STRIP001         SdrMark* pMark = rMarkList.GetMark(i);
//STRIP001         SdrObject* pObj = pMark->GetObj();
//STRIP001 
//STRIP001         rDest.MarkObj(pObj, pDestPV);
//STRIP001     }
//STRIP001 }

//STRIP001 void ScDrawTransferObj::SetDragSource( ScDrawView* pView )
//STRIP001 {
//STRIP001     DELETEZ( pDragSourceView );
//STRIP001     pDragSourceView = new SdrView( pView->GetModel() );
//STRIP001     lcl_InitMarks( *pDragSourceView, *pView, pView->GetTab() );
//STRIP001 
//STRIP001     //! add as listener with document, delete pDragSourceView if document gone
//STRIP001 }

//STRIP001 void ScDrawTransferObj::SetDragSourceObj( SdrObject* pObj, USHORT nTab )
//STRIP001 {
//STRIP001     DELETEZ( pDragSourceView );
//STRIP001     pDragSourceView = new SdrView( pObj->GetModel() );
//STRIP001     pDragSourceView->ShowPagePgNum( nTab, Point() );
//STRIP001     SdrPageView* pPV = pDragSourceView->GetPageViewPvNum(0);
//STRIP001     pDragSourceView->MarkObj(pObj, pPV);
//STRIP001 
//STRIP001     //! add as listener with document, delete pDragSourceView if document gone
//STRIP001 }

//STRIP001 void ScDrawTransferObj::SetDragSourceFlags( USHORT nFlags )
//STRIP001 {
//STRIP001     nDragSourceFlags = nFlags;
//STRIP001 }

//STRIP001 void ScDrawTransferObj::SetDragWasInternal()
//STRIP001 {
//STRIP001     bDragWasInternal = TRUE;
//STRIP001 }

//STRIP001 SvInPlaceObjectRef ScDrawTransferObj::GetSingleObject()
//STRIP001 {
//STRIP001     //  if single OLE object was copied, get its object
//STRIP001 
//STRIP001     SdrPage* pPage = pModel->GetPage(0);
//STRIP001     if (pPage)
//STRIP001     {
//STRIP001         SdrObjListIter aIter( *pPage, IM_FLAT );
//STRIP001         SdrObject* pObject = aIter.Next();
//STRIP001         if (pObject && pObject->GetObjIdentifier() == OBJ_OLE2)
//STRIP001         {
//STRIP001             SdrOle2Obj* pOleObj = (SdrOle2Obj*) pObject;
//STRIP001             return pOleObj->GetObjRef();
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return SvInPlaceObjectRef();
//STRIP001 }

//
//  initialize aDocShellRef with a live document from the ClipDoc
//

//STRIP001 void ScDrawTransferObj::InitDocShell()
//STRIP001 {
//STRIP001     if ( !aDocShellRef.Is() )
//STRIP001     {
//STRIP001         ScDocShell* pDocSh = new ScDocShell;
//STRIP001         aDocShellRef = pDocSh;      // ref must be there before InitNew
//STRIP001 
//STRIP001         pDocSh->DoInitNew(NULL);
//STRIP001 
//STRIP001         ScDocument* pDestDoc = pDocSh->GetDocument();
//STRIP001         pDestDoc->InitDrawLayer( pDocSh );
//STRIP001 
//STRIP001         SdrModel* pDestModel = pDestDoc->GetDrawLayer();
//STRIP001         SdrExchangeView aDestView( pDestModel );
//STRIP001         Point aPos;
//STRIP001         aDestView.ShowPagePgNum( 0, aPos );
//STRIP001         aDestView.Paste( *pModel, Point( aSrcSize.Width()/2, aSrcSize.Height()/2 ) );
//STRIP001 
//STRIP001         // put objects to right layer (see ScViewFunc::PasteDataFormat for SOT_FORMATSTR_ID_DRAWING)
//STRIP001 
//STRIP001         SdrPage* pPage = pDestModel->GetPage(0);
//STRIP001         if (pPage)
//STRIP001         {
//STRIP001             SdrObjListIter aIter( *pPage, IM_DEEPWITHGROUPS );
//STRIP001             SdrObject* pObject = aIter.Next();
//STRIP001             while (pObject)
//STRIP001             {
//STRIP001                 if ( pObject->ISA(SdrUnoObj) )
//STRIP001                     pObject->NbcSetLayer(SC_LAYER_CONTROLS);
//STRIP001                 else
//STRIP001                     pObject->NbcSetLayer(SC_LAYER_FRONT);
//STRIP001                 pObject = aIter.Next();
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001         Point aTmpPoint;
//STRIP001         Rectangle aDestArea( aTmpPoint, aSrcSize );
//STRIP001         pDocSh->SetVisArea( aDestArea );
//STRIP001 
//STRIP001         ScViewOptions aViewOpt( pDestDoc->GetViewOptions() );
//STRIP001         aViewOpt.SetOption( VOPT_GRID, FALSE );
//STRIP001         pDestDoc->SetViewOptions( aViewOpt );
//STRIP001 
//STRIP001         ScViewData aViewData( pDocSh, NULL );
//STRIP001         aViewData.SetTabNo( 0 );
//STRIP001         aViewData.SetScreen( aDestArea );
//STRIP001         aViewData.SetCurX( 0 );
//STRIP001         aViewData.SetCurY( 0 );
//STRIP001         pDocSh->UpdateOle(&aViewData, TRUE);
//STRIP001     }
//STRIP001 }


}
