/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: VCLWindow.h,v $
 *
 *  $Revision: 1.26 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:31:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SV_VCLWINDOW_H
#define _SV_VCLWINDOW_H

typedef void *VCLWINDOW;

#ifndef _SV_SALFRAME_HXX
#include <salframe.hxx>
#endif

#ifndef _SV_VCLVIEW_H
#include <VCLView.h>
#endif

#ifndef __cplusplus

#include <premac.h>
#import <AppKit/AppKit.h>
#include <postmac.h>

// -------------
// - VCLWindow -
// -------------

@interface VCLWindow : NSWindow
{   
@public
	// Important: these data members must be explicitly set before using this
	// class. Otherwise, none of the rest of the methods in this class will
	// work properly.
	SalFrame				*mpSalFrame;
	struct SalFrameData		*mpSalFrameData;
}
- (void)setContentSize: (NSSize)aSize;
- (void)windowDidBecomeKey: (NSNotification *)aNotification;
- (void)windowDidResignKey: (NSNotification *)aNotification;
- (MacOSBOOL)windowShouldClose: (id)sender;
- (NSSize)windowWillResize: (NSWindow *)sender toSize: (NSSize)proposedFrameSize;
@end

#endif // ! __cplusplus

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

// -----------------------
// - C wrapper functions -
// -----------------------

// Instantiate a native VCLWindow.
VCLWINDOW VCLWindow_New( ULONG nSalFrameStyle, VCLWINDOW hParentWindow,
	SalFrame *pFrame, struct SalFrameData *pFrameData );
  
// Get VCLWindow contentView
VCLVIEW VCLWindow_ContentView( VCLWINDOW hWindow );
 
// Display VCLWindow
void VCLWindow_Show( VCLWINDOW hWindow );
 
// Hide VCLWindow
void VCLWindow_Close( VCLWINDOW hWindow );
 
// Release a native VCLWindow
void VCLWindow_Release( VCLWINDOW hWindow );

// Set the title for VCLWindow
void VCLWindow_SetTitle( VCLWINDOW hWindow, const char *pTitle );

// Set the size of a VCLWindow
void VCLWindow_SetSize( VCLWINDOW hWindow, long nWidth, long nHeight );

// Post an NSApplicationDefined event to the event queue
BOOL VCLWindow_PostEvent( VCLWINDOW hWindow, void *pData );

// Sound a beep
void VCLWindow_Beep();

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // _SV_VCLWINDOW_H
