
package org.netbeans.modules.openoffice;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;

import org.openide.compiler.*;
import org.openide.compiler.Compiler;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.NbProcessDescriptor;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 *
 * @author  Michael Bohn
 *
 */

public class OOREGCompilerType extends ExternalCompilerType {
    
    /* No special error expressions for now, probably not needed.
    static final ExternalCompiler.ErrorExpression[] ERROR_EXPRS = {
      new ExternalCompiler.ErrorExpression (NbBundle.getBundle (OOREGCompilerType.class).getString ("LBL_error_exp_1"),
                                            "(some|reg|exp|here)",
                                            1, 2, 3, 4),
};
     */
    
    /** Default process template.
     */
    private static final NbProcessDescriptor DEFAULT = new NbProcessDescriptor(
    // PROCESS NAME:
    "{" + OOREGCompilerGroup.Format.TAG_UDKINSTALL_DIRECTORY + "}" 
    + System.getProperty( "file.separator" ) + "bin" 
    + System.getProperty( "file.separator" ) + "regmerge",
    // LIST OF ARGUMENTS INCLUDING OPTIONS:
    "{" + OOREGCompilerGroup.Format.TAG_PROJECT_DIR + "}"
    + System.getProperty( "file.separator" )
    + "types.rdb /UCR " +
    "{" + OOREGCompilerGroup.Format.TAG_URD_FILE_PATH + "}" 
    + System.getProperty( "file.separator" )
    + "{" + OOREGCompilerGroup.Format.TAG_URD_FILE + "}",
    // DESCRIPTION FOR USER OF HOW TO MODIFY THE ARGUMENTS:
    NbBundle.getBundle( OOREGCompilerType.class ).getString(
    "MSG_format_hint_MCT" )
    );
    
    
    
    /** Create a new compiler type.
     */
    public OOREGCompilerType() {
        setExternalCompiler(DEFAULT);
        // setErrorExpression (ERROR_EXPRS[0]);
    }
    
    /** Get the display name.
     * Workaround for 1.0 core bug; not needed in 1.1 core.
     * @return the name
     */
    protected String displayName() {
        try {
            return java.beans.Introspector.getBeanInfo(getClass()).getBeanDescriptor().getDisplayName();
        } catch (Exception e) {
            if (Boolean.getBoolean("netbeans.debug.exceptions"))
                e.printStackTrace();
            return getClass().getName();
        }
    }
    
    /** Get the help context.
     * @return help for the compiler
     */
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
    
    /** Add a proper compiler to the job.
     * @param job the job
     * @param type the style of compilation, controlling the target
     * @param obj the makefile
     */
    public void prepareJob(CompilerJob job, Class type, DataObject obj) {
        
        
        OOREGCompiler bCompiler = new OOREGCompiler(obj.getPrimaryFile(), getExternalCompiler(), getErrorExpression() );
        
        
        
    }
    
    
}
