/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Columns.cxx,v $
 *
 *  $Revision: 1.23 $
 *
 *  last change: $Author: hr $ $Date: 2006/06/19 12:45:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _FRM_COLUMNS_HXX
#include "Columns.hxx"
#endif
#ifndef _FRM_PROPERTY_HRC_
#include "property.hrc"
#endif
#ifndef _FRM_PROPERTY_HXX_
#include "property.hxx"
#endif
#ifndef _FRM_IDS_HXX_
#include "ids.hxx"
#endif
#include "findpos.hxx"

#ifndef _COM_SUN_STAR_IO_XPERSISTOBJECT_HPP_
#include <com/sun/star/io/XPersistObject.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOBJECTOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XObjectOutputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOBJECTINPUTSTREAM_HPP_
#include <com/sun/star/io/XObjectInputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XMARKABLESTREAM_HPP_
#include <com/sun/star/io/XMarkableStream.hpp>
#endif
#ifndef _COM_SUN_STAR_FORM_XFORMCOMPONENT_HPP_
#include <com/sun/star/form/XFormComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_FORM_BINDING_XBINDABLEVALUE_HPP_
#include <com/sun/star/form/binding/XBindableValue.hpp>
#endif
#ifndef _COMPHELPER_SEQUENCE_HXX_
#include <comphelper/sequence.hxx>
#endif
#ifndef _COMPHELPER_PROPERTY_HXX_
#include <comphelper/property.hxx>
#endif
#ifndef _COMPHELPER_BASIC_IO_HXX_
#include <comphelper/basicio.hxx>
#endif

#ifndef _FRM_SERVICES_HXX_
#include "services.hxx"
#endif
#ifndef _FRM_RESOURCE_HRC_
#include "frm_resource.hrc"
#endif
#ifndef _TOOLS_DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif
#ifndef _RTL_UUID_H_
#include <rtl/uuid.h>
#endif
#ifndef _RTL_MEMORY_H_
#include <rtl/memory.h>
#endif

//.........................................................................
namespace frm
{
//.........................................................................
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::form;
using namespace ::com::sun::star::awt;
using namespace ::com::sun::star::io;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::form::binding;

const sal_uInt16 WIDTH              = 0x0001;
const sal_uInt16 ALIGN              = 0x0002;
const sal_uInt16 OLD_HIDDEN         = 0x0004;
const sal_uInt16 COMPATIBLE_HIDDEN  = 0x0008;

//------------------------------------------------------------------------------
const StringSequence& getColumnTypes()
{
    static StringSequence aColumnTypes(10);
    if (!aColumnTypes.getConstArray()[0].getLength())
    {
        ::rtl::OUString* pNames = aColumnTypes.getArray();
        pNames[TYPE_CHECKBOX]       = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "CheckBox" ) );
        pNames[TYPE_COMBOBOX]       = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "ComboBox" ) );
        pNames[TYPE_CURRENCYFIELD]  = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "CurrencyField" ) );
        pNames[TYPE_DATEFIELD]      = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "DateField" ) );
        pNames[TYPE_FORMATTEDFIELD] = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "FormattedField" ) );
        pNames[TYPE_LISTBOX]        = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "ListBox" ) );
        pNames[TYPE_NUMERICFIELD]   = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "NumericField" ) );
        pNames[TYPE_PATTERNFIELD]   = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "PatternField" ) );
        pNames[TYPE_TEXTFIELD]      = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "TextField" ) );
        pNames[TYPE_TIMEFIELD]      = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "TimeField" ) );
    }
    return aColumnTypes;
}

//------------------------------------------------------------------------------
sal_Int32 getColumnTypeByModelName(const ::rtl::OUString& aModelName)
{
    const ::rtl::OUString aModelPrefix = ::rtl::OUString::createFromAscii("com.sun.star.form.component.");
    const ::rtl::OUString aCompatibleModelPrefix = ::rtl::OUString::createFromAscii("stardiv.one.form.component.");

    sal_Int32 nTypeId = -1;
    if (aModelName == FRM_COMPONENT_EDIT)
        nTypeId = TYPE_TEXTFIELD;
    else
    {
        sal_Int32 nPrefixPos = aModelName.indexOf(aModelPrefix);
#ifdef DBG_UTIL
        sal_Int32 nCompatiblePrefixPos = aModelName.indexOf(aCompatibleModelPrefix);
#endif
        DBG_ASSERT( (nPrefixPos != -1) ||   (nCompatiblePrefixPos != -1),
                "::getColumnTypeByModelName() : wrong servivce !");

        ::rtl::OUString aColumnType = (nPrefixPos != -1)
            ? aModelName.copy(aModelPrefix.getLength())
            : aModelName.copy(aCompatibleModelPrefix.getLength());

        const StringSequence& rColumnTypes = getColumnTypes();
        nTypeId = ::detail::findPos(aColumnType, rColumnTypes);
    }
    return nTypeId;
}

/*************************************************************************/

//------------------------------------------------------------------
InterfaceRef SAL_CALL OGridColumn_CreateInstance(const Reference<XMultiServiceFactory>& _rxFactory)
{
    return *(new OGridColumn(_rxFactory));
}

//------------------------------------------------------------------
const Sequence<sal_Int8>& OGridColumn::getUnoTunnelImplementationId()
{
    static Sequence< sal_Int8 > * pSeq = 0;
    if( !pSeq )
    {
        ::osl::MutexGuard aGuard( ::osl::Mutex::getGlobalMutex() );
        if( !pSeq )
        {
            static Sequence< sal_Int8 > aSeq( 16 );
            rtl_createUuid( (sal_uInt8*)aSeq.getArray(), 0, sal_True );
            pSeq = &aSeq;
        }
    }
    return *pSeq;
}

//------------------------------------------------------------------
sal_Int64 SAL_CALL OGridColumn::getSomething( const Sequence<sal_Int8>& _rIdentifier) throw(RuntimeException)
{
    sal_Int64 nReturn(0);

    if  (   (_rIdentifier.getLength() == 16)
        &&  (0 == rtl_compareMemory( getUnoTunnelImplementationId().getConstArray(), _rIdentifier.getConstArray(), 16 ))
        )
    {
        nReturn = reinterpret_cast<sal_Int64>(this);
    }
    else
    {
        Reference< XUnoTunnel > xAggTunnel;
        if ( query_aggregation( m_xAggregate, xAggTunnel ) )
            return xAggTunnel->getSomething( _rIdentifier );
    }
    return nReturn;
}

//------------------------------------------------------------------
Sequence<sal_Int8> SAL_CALL OGridColumn::getImplementationId() throw(RuntimeException)
{
    return OImplementationIds::getImplementationId(getTypes());
}

//------------------------------------------------------------------
Sequence<Type> SAL_CALL OGridColumn::getTypes() throw(RuntimeException)
{
    Reference<XTypeProvider> xProv;

    if (query_aggregation(m_xAggregate, xProv))
        return concatSequences(OGridColumn_BASE::getTypes(), xProv->getTypes());
    return OGridColumn_BASE::getTypes();
}

//------------------------------------------------------------------
Any SAL_CALL OGridColumn::queryAggregation( const Type& _rType ) throw (RuntimeException)
{
    Any aReturn;
    // though our aggregate may be an XFormComponent or an XServiceInfo, we aren't anymore
    if  (   _rType.equals(::getCppuType(static_cast< Reference< XFormComponent >* >(NULL)))
        ||  _rType.equals(::getCppuType(static_cast< Reference< XServiceInfo >* >(NULL)))
        ||  _rType.equals(::getCppuType(static_cast< Reference< XBindableValue >* >(NULL)))
        )
        return aReturn;

    aReturn = OGridColumn_BASE::queryAggregation(_rType);
    if (!aReturn.hasValue())
    {
        aReturn = OPropertySetAggregationHelper::queryInterface(_rType);
        if (!aReturn.hasValue() && m_xAggregate.is())
            aReturn = m_xAggregate->queryAggregation(_rType);
    }

    return aReturn;
}

DBG_NAME(OGridColumn);
//------------------------------------------------------------------------------
OGridColumn::OGridColumn(const Reference<XMultiServiceFactory>& _rxFactory, const ::rtl::OUString& _sModelName)
	:OGridColumn_BASE(m_aMutex)
	,OPropertySetAggregationHelper(OGridColumn_BASE::rBHelper)
	,m_aHidden( makeAny( sal_False ) )
    ,m_xORB( _rxFactory )
	,m_aModelName(_sModelName)
{
    DBG_CTOR(OGridColumn,NULL);

    // Anlegen des UnoControlModels
    if ( m_aModelName.getLength() )    // is there a to-be-aggregated model?
    {
        increment( m_refCount );

        // Muss im eigenen Block,
        // da xAgg vor dem delegator setzen wieder freigesetzt sein muss!
        {
            m_xAggregate = Reference< XAggregation >( _rxFactory->createInstance( m_aModelName ), UNO_QUERY );
            setAggregation( m_xAggregate );
        }

        if (m_xAggregate.is())
        {   // don't omit this brackets - they ensure that the following temporary is properly deleted
            m_xAggregate->setDelegator( static_cast< ::cppu::OWeakObject* >( this ) );
        }

        // Refcount wieder bei NULL
        decrement( m_refCount );
    }

    if ( m_xAggregateSet.is() )
    {
        Reference< XPropertySetInfo > xPropInfo = m_xAggregateSet->getPropertySetInfo();
        if ( xPropInfo.is() && xPropInfo->hasPropertyByName( PROPERTY_TRISTATE ) )
            m_xAggregateSet->setPropertyValue( PROPERTY_TRISTATE, makeAny( sal_True ) );
    }
}

//------------------------------------------------------------------------------
OGridColumn::OGridColumn( const OGridColumn* _pOriginal )
	:OGridColumn_BASE( m_aMutex )
	,OPropertySetAggregationHelper( OGridColumn_BASE::rBHelper )
    ,m_xORB( _pOriginal->m_xORB )
{
    DBG_CTOR(OGridColumn,NULL);

	m_aWidth = _pOriginal->m_aWidth;
	m_aAlign = _pOriginal->m_aAlign;
	m_aHidden = _pOriginal->m_aHidden;
	m_aModelName = _pOriginal->m_aModelName;
	m_aLabel = _pOriginal->m_aLabel;

	increment( m_refCount );
	{
		{
			m_xAggregate = createAggregateClone( _pOriginal );
			setAggregation( m_xAggregate );
		}

		if ( m_xAggregate.is() )
		{	// don't omit this brackets - they ensure that the following temporary is properly deleted
			m_xAggregate->setDelegator( static_cast< ::cppu::OWeakObject* >( this ) );
		}
	}
	decrement( m_refCount );
}

//------------------------------------------------------------------------------
OGridColumn::~OGridColumn()
{
    if (!OGridColumn_BASE::rBHelper.bDisposed)
    {
        acquire();
        dispose();
    }

    // freigeben der Agg
    if (m_xAggregate.is())
    {
        InterfaceRef  xIface;
        m_xAggregate->setDelegator(xIface);
    }

    DBG_DTOR(OGridColumn,NULL);
}

// XChild
//------------------------------------------------------------------------------
void SAL_CALL OGridColumn::setParent(const InterfaceRef& Parent) throw(NoSupportException, RuntimeException)
{
    m_xParent = Parent;
}

// XEventListener
//------------------------------------------------------------------------------
void SAL_CALL OGridColumn::disposing(const EventObject& _rSource) throw(RuntimeException)
{
    OPropertySetAggregationHelper::disposing(_rSource);

    Reference<XEventListener>  xEvtLstner;
    if (query_aggregation(m_xAggregate, xEvtLstner))
        xEvtLstner->disposing(_rSource);
}

// OGridColumn_BASE
//-----------------------------------------------------------------------------
void OGridColumn::disposing()
{
    OGridColumn_BASE::disposing();
    OPropertySetAggregationHelper::disposing();

    Reference<XComponent>  xComp;
    if (query_aggregation(m_xAggregate, xComp))
        xComp->dispose();

    setParent(InterfaceRef ());
}

//------------------------------------------------------------------------------
void OGridColumn::clearAggregateProperties( Sequence< Property >& _rProps, sal_Bool bAllowDropDown )
{
    // some properties are not to be exposed to the outer world
    ::std::set< ::rtl::OUString > aForbiddenProperties;
    aForbiddenProperties.insert( PROPERTY_ALIGN );
    aForbiddenProperties.insert( PROPERTY_AUTOCOMPLETE );
    aForbiddenProperties.insert( PROPERTY_BACKGROUNDCOLOR );
    aForbiddenProperties.insert( PROPERTY_BORDER );
    aForbiddenProperties.insert( PROPERTY_ECHO_CHAR );
    aForbiddenProperties.insert( PROPERTY_FILLCOLOR );
    aForbiddenProperties.insert( PROPERTY_FONT );
    aForbiddenProperties.insert( PROPERTY_FONT_NAME );
    aForbiddenProperties.insert( PROPERTY_FONT_STYLENAME );
    aForbiddenProperties.insert( PROPERTY_FONT_FAMILY );
    aForbiddenProperties.insert( PROPERTY_FONT_CHARSET );
    aForbiddenProperties.insert( PROPERTY_FONT_HEIGHT );
    aForbiddenProperties.insert( PROPERTY_FONT_WEIGHT );
    aForbiddenProperties.insert( PROPERTY_FONT_SLANT );
    aForbiddenProperties.insert( PROPERTY_FONT_UNDERLINE );
    aForbiddenProperties.insert( PROPERTY_FONT_STRIKEOUT );
    aForbiddenProperties.insert( PROPERTY_FONT_WORDLINEMODE );
    aForbiddenProperties.insert( PROPERTY_TEXTLINECOLOR );
    aForbiddenProperties.insert( PROPERTY_FONTEMPHASISMARK );
    aForbiddenProperties.insert( PROPERTY_FONTRELIEF );
    aForbiddenProperties.insert( PROPERTY_HARDLINEBREAKS );
    aForbiddenProperties.insert( PROPERTY_HSCROLL );
    aForbiddenProperties.insert( PROPERTY_LABEL );
    aForbiddenProperties.insert( PROPERTY_LINECOLOR );
    aForbiddenProperties.insert( PROPERTY_MULTISELECTION );
    aForbiddenProperties.insert( PROPERTY_PRINTABLE );
    aForbiddenProperties.insert( PROPERTY_TABINDEX );
    aForbiddenProperties.insert( PROPERTY_TABSTOP );
    aForbiddenProperties.insert( PROPERTY_TEXTCOLOR );
    aForbiddenProperties.insert( PROPERTY_TRISTATE );
    aForbiddenProperties.insert( PROPERTY_VSCROLL );
    aForbiddenProperties.insert( PROPERTY_CONTROLLABEL );
    aForbiddenProperties.insert( PROPERTY_RICH_TEXT );
    aForbiddenProperties.insert( PROPERTY_VERTICALALIGN );
    if ( !bAllowDropDown )
        aForbiddenProperties.insert( PROPERTY_DROPDOWN );

    Sequence< Property > aNewProps( _rProps.getLength() );
    Property* pNewProps = aNewProps.getArray();

    const Property* pProps = _rProps.getConstArray();
    const Property* pPropsEnd = pProps + _rProps.getLength();
    for ( ; pProps != pPropsEnd; ++pProps )
    {
        if ( aForbiddenProperties.find( pProps->Name ) == aForbiddenProperties.end() )
            *pNewProps++ = *pProps;
    }

    aNewProps.realloc( pNewProps - aNewProps.getArray() );
    _rProps = aNewProps;
}

//------------------------------------------------------------------------------
void OGridColumn::setOwnProperties(Sequence<Property>& aDescriptor)
{
    aDescriptor.realloc(5);
    Property* pProperties = aDescriptor.getArray();
    DECL_PROP1(LABEL,               ::rtl::OUString,    BOUND);
    DECL_PROP3(WIDTH,               sal_Int32,          BOUND, MAYBEVOID, MAYBEDEFAULT);
    DECL_PROP3(ALIGN,               sal_Int16,          BOUND, MAYBEVOID, MAYBEDEFAULT);
    DECL_BOOL_PROP2(HIDDEN,                             BOUND, MAYBEDEFAULT);
    DECL_PROP1(COLUMNSERVICENAME,   ::rtl::OUString,    READONLY);
}

// Reference<XPropertySet>
//------------------------------------------------------------------------------
Reference<XPropertySetInfo> SAL_CALL OGridColumn::getPropertySetInfo() throw(RuntimeException)
{
    DBG_ERROR("OGridColumn::getPropertySetInfo() : Dummy Called");
    return Reference<XPropertySetInfo> ();
}

//------------------------------------------------------------------------------
::cppu::IPropertyArrayHelper& OGridColumn::getInfoHelper()
{
    DBG_ERROR("OGridColumn::getInfoHelper() : Dummy Called");

    Sequence<Property> aDescriptor, aAggProperties;
    static OPropertyArrayAggregationHelper aDescAry(aDescriptor, aAggProperties);
    return aDescAry;
}

//------------------------------------------------------------------------------
void OGridColumn::getFastPropertyValue(Any& rValue, sal_Int32 nHandle ) const
{
    switch (nHandle)
    {
        case PROPERTY_ID_COLUMNSERVICENAME:
            rValue <<= m_aModelName;
            break;
        case PROPERTY_ID_LABEL:
            rValue <<= m_aLabel;
            break;
        case PROPERTY_ID_WIDTH:
            rValue = m_aWidth;
            break;
        case PROPERTY_ID_ALIGN:
            rValue = m_aAlign;
            break;
        case PROPERTY_ID_HIDDEN:
            rValue = m_aHidden;
            break;
        default:
            OPropertySetAggregationHelper::getFastPropertyValue(rValue, nHandle);
    }
}

//------------------------------------------------------------------------------
sal_Bool OGridColumn::convertFastPropertyValue( Any& rConvertedValue, Any& rOldValue,
                                            sal_Int32 nHandle, const Any& rValue )throw( IllegalArgumentException )
{
    sal_Bool bModified(sal_False);
    switch (nHandle)
    {
        case PROPERTY_ID_LABEL:
            bModified = tryPropertyValue(rConvertedValue, rOldValue, rValue, m_aLabel);
            break;
        case PROPERTY_ID_WIDTH:
            bModified = tryPropertyValue(rConvertedValue, rOldValue, rValue, m_aWidth, ::getCppuType((const sal_Int32*)NULL));
            break;
        case PROPERTY_ID_ALIGN:
            try
            {
                bModified = tryPropertyValue(rConvertedValue, rOldValue, rValue, m_aAlign, ::getCppuType((const sal_Int16*)NULL));
            }
            catch(starlang::IllegalArgumentException&)
            {
                OSL_ENSURE(0,"OGridColumn::convertFastPropertyValue: TextAlign must be casted to sal_Int16!");
                throw;
            }
            break;
        case PROPERTY_ID_HIDDEN:
            bModified = tryPropertyValue(rConvertedValue, rOldValue, rValue, getBOOL(m_aHidden));
            break;
    }
    return bModified;
}

//------------------------------------------------------------------------------
void OGridColumn::setFastPropertyValue_NoBroadcast( sal_Int32 nHandle, const Any& rValue ) throw (::com::sun::star::uno::Exception)
{
    switch (nHandle)
    {
        case PROPERTY_ID_LABEL:
            DBG_ASSERT(rValue.getValueType().getTypeClass() == TypeClass_STRING, "invalid type" );
            rValue >>= m_aLabel;
            break;
        case PROPERTY_ID_WIDTH:
            m_aWidth = rValue;
            break;
        case PROPERTY_ID_ALIGN:
            m_aAlign = rValue;
            break;
        case PROPERTY_ID_HIDDEN:
            m_aHidden = rValue;
            break;
    }
}


// XPropertyState
//------------------------------------------------------------------------------
PropertyState OGridColumn::getPropertyStateByHandle(sal_Int32 nHandle)
{
    PropertyState eState = PropertyState_DIRECT_VALUE;

    switch (nHandle)
    {
        case PROPERTY_ID_WIDTH:
            if (!m_aWidth.hasValue())
                eState = PropertyState_DEFAULT_VALUE;
            break;

        case PROPERTY_ID_ALIGN:
            if (!m_aAlign.hasValue())
                eState = PropertyState_DEFAULT_VALUE;
            break;

		case PROPERTY_ID_HIDDEN:
		{
			sal_Bool bHidden = sal_True;
			if ( ( m_aHidden >>= bHidden ) && !bHidden )
				eState = PropertyState_DEFAULT_VALUE;
		}
		break;

        default:
            eState = OPropertySetAggregationHelper::getPropertyStateByHandle(nHandle);
    }
    return eState;
}

//------------------------------------------------------------------------------
void OGridColumn::setPropertyToDefaultByHandle(sal_Int32 nHandle)
{
    switch (nHandle)
    {
        case PROPERTY_ID_WIDTH:
        case PROPERTY_ID_ALIGN:
            setFastPropertyValue(nHandle, Any());
            break;
        case PROPERTY_ID_HIDDEN:
            setFastPropertyValue( nHandle, makeAny( (sal_Bool)sal_False ) );
            break;
        default:
            OPropertySetAggregationHelper::setPropertyToDefaultByHandle(nHandle);
    }
}

//------------------------------------------------------------------------------
Any OGridColumn::getPropertyDefaultByHandle( sal_Int32 nHandle ) const
{
    switch (nHandle)
    {
        case PROPERTY_ID_WIDTH:
        case PROPERTY_ID_ALIGN:
            return Any();
        case PROPERTY_ID_HIDDEN:
            return makeAny((sal_Bool)sal_False);
        default:
            return OPropertySetAggregationHelper::getPropertyDefaultByHandle(nHandle);
    }
}

// XCloneable
//------------------------------------------------------------------------------
Reference< XCloneable > SAL_CALL OGridColumn::createClone(  ) throw (RuntimeException)
{
    OGridColumn* pNewColumn = createCloneColumn();
    return pNewColumn;
}

//------------------------------------------------------------------------------
OGridColumn* OGridColumn::createCloneColumn() const
{
    return new OGridColumn( this );
}

//XPersistObject
//------------------------------------------------------------------------------
void SAL_CALL OGridColumn::write(const Reference<XObjectOutputStream>& _rxOutStream)
{
    // 1. Schreiben des UnoControls
    Reference<XMarkableStream>  xMark(_rxOutStream, UNO_QUERY);
    sal_Int32 nMark = xMark->createMark();

    sal_Int32 nLen = 0;
    _rxOutStream->writeLong(nLen);

    Reference<XPersistObject>  xPersist;
    if (query_aggregation(m_xAggregate, xPersist))
        xPersist->write(_rxOutStream);

    // feststellen der Laenge
    nLen = xMark->offsetToMark(nMark) - 4;
    xMark->jumpToMark(nMark);
    _rxOutStream->writeLong(nLen);
    xMark->jumpToFurthest();
    xMark->deleteMark(nMark);

    // 2. Schreiben einer VersionsNummer
    _rxOutStream->writeShort(0x0002);

    sal_uInt16 nAnyMask = 0;
    if (m_aWidth.getValueType().getTypeClass() == TypeClass_LONG)
        nAnyMask |= WIDTH;

    if (m_aAlign.getValueTypeClass() == TypeClass_SHORT)
        nAnyMask |= ALIGN;

    nAnyMask |= COMPATIBLE_HIDDEN;

    _rxOutStream->writeShort(nAnyMask);

    if (nAnyMask & WIDTH)
        _rxOutStream->writeLong(getINT32(m_aWidth));
    if (nAnyMask & ALIGN)
        _rxOutStream->writeShort(getINT16(m_aAlign));

    // Name
    _rxOutStream << m_aLabel;

    // the new place for the hidden flag : after m_aLabel, so older office version read the correct label, too
    if (nAnyMask & COMPATIBLE_HIDDEN)
        _rxOutStream->writeBoolean(getBOOL(m_aHidden));
}

//------------------------------------------------------------------------------
void SAL_CALL OGridColumn::read(const Reference<XObjectInputStream>& _rxInStream)
{
    // 1. Lesen des UnoControls
    sal_Int32 nLen = _rxInStream->readLong();
    if (nLen)
    {
        Reference<XMarkableStream>  xMark(_rxInStream, UNO_QUERY);
        sal_Int32 nMark = xMark->createMark();
        Reference<XPersistObject>  xPersist;
        if (query_aggregation(m_xAggregate, xPersist))
            xPersist->read(_rxInStream);

        xMark->jumpToMark(nMark);
        _rxInStream->skipBytes(nLen);
        xMark->deleteMark(nMark);
    }

    // 2. Lesen des Versionsnummer
    sal_uInt16 nVersion = _rxInStream->readShort(); (void)nVersion;
    sal_uInt16 nAnyMask = _rxInStream->readShort();

    if (nAnyMask & WIDTH)
    {
        sal_Int32 nValue = _rxInStream->readLong();
        m_aWidth <<= (sal_Int32)nValue;
    }

    if (nAnyMask & ALIGN)
    {
        sal_Int16 nValue = _rxInStream->readShort();
        m_aAlign <<= nValue;
    }
    if (nAnyMask & OLD_HIDDEN)
    {
        sal_Bool bValue = _rxInStream->readBoolean();
        m_aHidden <<= (sal_Bool)bValue;
    }

    // Name
    _rxInStream >> m_aLabel;

    if (nAnyMask & COMPATIBLE_HIDDEN)
    {
        sal_Bool bValue = _rxInStream->readBoolean();
        m_aHidden <<= (sal_Bool)bValue;
    }
}

//------------------------------------------------------------------------------
IMPL_COLUMN(TextFieldColumn,        FRM_SUN_COMPONENT_TEXTFIELD,        sal_False);
IMPL_COLUMN(PatternFieldColumn,     FRM_SUN_COMPONENT_PATTERNFIELD,     sal_False);
IMPL_COLUMN(DateFieldColumn,        FRM_SUN_COMPONENT_DATEFIELD,        sal_True);
IMPL_COLUMN(TimeFieldColumn,        FRM_SUN_COMPONENT_TIMEFIELD,        sal_False);
IMPL_COLUMN(NumericFieldColumn,     FRM_SUN_COMPONENT_NUMERICFIELD,     sal_False);
IMPL_COLUMN(CurrencyFieldColumn,    FRM_SUN_COMPONENT_CURRENCYFIELD,    sal_False);
IMPL_COLUMN(CheckBoxColumn,         FRM_SUN_COMPONENT_CHECKBOX,         sal_False);
IMPL_COLUMN(ComboBoxColumn,         FRM_SUN_COMPONENT_COMBOBOX,         sal_False);
IMPL_COLUMN(ListBoxColumn,          FRM_SUN_COMPONENT_LISTBOX,          sal_False);
IMPL_COLUMN(FormattedFieldColumn,   FRM_SUN_COMPONENT_FORMATTEDFIELD,   sal_False);

//.........................................................................
}   // namespace frm
//.........................................................................

