/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dialogcontrolling.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 16:13:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef DBACCESS_SOURCE_UI_INC_DIALOGCONTROLLING_HXX
#include "dialogcontrolling.hxx"
#endif

#ifndef _SV_WINDOW_HXX
#include <vcl/window.hxx>
#endif

//........................................................................
namespace dbaui
{
//........................................................................

    //=====================================================================
    //= DialogController
    //=====================================================================
	//---------------------------------------------------------------------
    DialogController::DialogController( Window& _rInstigator,
        const PWindowEventFilter _pEventFilter, const PWindowOperator _pOperator )
        :m_rInstigator( _rInstigator )
        ,m_pEventFilter( _pEventFilter )
        ,m_pOperator( _pOperator )
    {
        DBG_ASSERT( m_pEventFilter.get() && m_pOperator.get(),
            "DialogController::DialogController: invalid filter and/or operator!" );

        m_rInstigator.AddEventListener( LINK( this, DialogController, OnWindowEvent ) );
    }

    //---------------------------------------------------------------------
    DialogController::~DialogController()
    {
        m_rInstigator.RemoveEventListener( LINK( this, DialogController, OnWindowEvent ) );
    }

    //---------------------------------------------------------------------
    void DialogController::addDependentWindow( Window& _rWindow )
    {
        m_aConcernedWindows.push_back( &_rWindow );
        impl_update( _rWindow );
    }

    //---------------------------------------------------------------------
    IMPL_LINK( DialogController, OnWindowEvent, const VclSimpleEvent*, _pEvent )
    {
        if ( m_pEventFilter->payAttentionTo( *_pEvent ) )
            impl_updateAll();
        return 0L;
    }

    //---------------------------------------------------------------------
    void DialogController::impl_updateAll()
    {
        for ( ::std::vector< Window* >::iterator loop = m_aConcernedWindows.begin();
                loop != m_aConcernedWindows.end();
                ++loop
            )
            impl_update( *(*loop) );
    }

    //---------------------------------------------------------------------
    void DialogController::impl_update( Window& _rWindow )
    {
        m_pOperator->operateOn( _rWindow );
    }

//........................................................................
} // namespace dbaui
//........................................................................

