#include "TransformationHelper.hxx"
#include "CommonConverters.hxx"


//.............................................................................
namespace chart
{
//.............................................................................
using namespace ::com::sun::star;
using namespace ::com::sun::star::chart2;

drawing::Direction3D TransformationHelper::transformSize( const drawing::Direction3D& rSize, const drawing::Position3D& rPos
                 , uno::Reference< XTransformation > xTransformation )
{
    drawing::Position3D aLogicPos1( rPos - rSize/2 );
    drawing::Position3D aLogicPos2( rPos + rSize/2 );

    drawing::Position3D aTransformedPos1( SequenceToPosition3D( xTransformation->transform( Position3DToSequence(aLogicPos1) ) ) );
    drawing::Position3D aTransformedPos2( SequenceToPosition3D( xTransformation->transform( Position3DToSequence(aLogicPos2) ) ) );

    drawing::Direction3D aSize = aTransformedPos2 - aTransformedPos1;
    return aSize;
}

DataPointGeometry TransformationHelper::transformLogicGeom(
    const DataPointGeometry& rGeom
    , uno::Reference< XTransformation > xTransformation )
{
    //@transform logic coordinates to target coordinates
    return DataPointGeometry(
          SequenceToPosition3D( xTransformation->transform( Position3DToSequence(rGeom.m_aPosition) ) )
        , transformSize(rGeom.m_aSize,rGeom.m_aPosition,xTransformation)
        , transformSize(rGeom.m_aSize2,rGeom.m_aPosition,xTransformation)
        );
}
//.............................................................................
} //namespace chart
//.............................................................................
