/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: HitStore.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:58:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

import java.util.Arrays;

final class HitStore {
    private final int        _limit;
    private double           _standard;
    private final QueryHit[] _heap;
    private int              _free;
    private int              _index;	// for enumerating results
    private final int        _nColumns;	// cached here
  
    public HitStore(double initialStandard, int limit, int nColumns) {
	_standard = initialStandard;
	_heap = new QueryHit[_limit = limit];
	_nColumns = nColumns;
    }
  
    public final boolean goodEnough(double penalty, int begin, int end) {
	return _free == _limit
	    ? _heap[0].worseThan(penalty, begin, end)
	    : true;
    }

    /** if the proposed hit is good enough, ie. is one of few found
	or is better than current worst -- it will be built
	and added to store */
    public QueryHit createQueryHit(double penalty, int doc, int begin, int end) {
	QueryHit hit = new QueryHit(_nColumns, penalty, doc, begin, end);
	if (_free == _limit) {	// goodEnough'ness checked already
	    _heap[0] = hit;
	    heapify(0);
	    _standard = _heap[0].getPenalty();
	}
	else if (_free < _limit) {
	    _heap[_free++] = hit;
	    if (_free == _limit) {	// we have the needed number
		for (int i = _free/2; i >= 0; i--)// build heap
		    heapify(i);
		_standard = _heap[0].getPenalty();
	    }
	}
	return hit;
    }

    private final void heapify(int i) {
	for (int r, l, worst;;) {
	    r = (i + 1) << 1; l = r - 1;
	    worst = l < _free && _heap[i].betterThan(_heap[l]) ? l : i;
	    if (r < _free && _heap[worst].betterThan(_heap[r]))
		worst = r;
	    if (worst != i) {
		QueryHit temp = _heap[worst];
		_heap[worst] = _heap[i];
		_heap[i] = temp;
		i = worst;		// continue
	    }
	    else
		break;
	}
    }
  
    public QueryHit firstBestQueryHit() {
	if (_free > 0) {
	    Arrays.sort(_heap, 0, _free);
	    _index = 0;
	    return nextBestQueryHit();
	}
	else
	    return null;
    }
  
    public final QueryHit nextBestQueryHit() {
	return _index < _free ? _heap[_index++] : null;
    }
  
    public final double getCurrentStandard() {
	return _standard;
    }
}
