/*************************************************************************
 *
 *  $RCSfile: Copy_of_SxgChildTransformer.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/04 10:22:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2002 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if
 t, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

/**
 * Description: This class is used for the transformation of Global documents.
 * For each child document referenced by a URL of the text:section a transformation will
 * be started.
 * This is necessary as global document children don't 'know' of each other nor of the global
 * document.
 * Due to that no consequence numbering of the chapter would be possible nor a HTML linking between
 * child documents an to the content-table (global document).
 * The class collects all necessary parameters and starts the transformation of each child document.
 *
 * This class works only with the XT processor of James Clark. This was the easiest way to go and should be
 * expanded/splitt later.
 * <p>
 */
package com.sun.star.xslt.helper;

import java.io.*;
import java.util.*;
import java.net.*;

import org.xml.sax.*;
import org.apache.xerces.parsers.SAXParser;
import com.jclark.xsl.sax.*;
import com.jclark.xsl.om.NodeIterator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.helpers.XMLReaderFactory;
import org.xml.sax.helpers.XMLReaderAdapter;
import com.jclark.xsl.expr.*;
import com.jclark.xsl.om.*;



public class SxgChildTransformer
{

    private static boolean isInitialized = false;
    static final byte ELEMENT = 0;
    static final byte TEXT = 1;
    static final byte ATTRIBUTE = 2;
    static final byte ROOT = 3;
    static final byte PROCESSING_INSTRUCTION = 4;
    static final byte COMMENT = 5;
    static final int  N_TYPES = 6;
    static final byte ALLTYPES = 6;  // useful for the "node()" node type test

    static final String STOP_ELEMENT = "allstyles";

    /** The XSLT processor instance with parsed style-sheet, to be cloned for performance gain*/
    static XSLProcessor clonableXSLProcessor;
    static XMLReaderAdapter xmlReaderAdapter;
    static EntityResolver entityResolver;


    static String jaredRootURL;
    static String optionalURLSuffix;
    static String absoluteSourceDirRef; //in XSLT -> absoluteSourceDirRef
    static String globalDocumentDir;
    static String contentTableURL;
    static String tableOfContentDocumentDir;
    static String tableOfContentDocument;
    static String dpi;
    static String stylesFileURL;
    static String metaFileURL;
    static String outputType = "CSS_HEADER";
    static String globalDocumentRefToCurrentFile;
    static NodeIterator contentTableHeadings;
    static double headingNo;
    static double currentChildNo;
    static String currentChildUrl;


    private static InputSource inputSource;
    private static String destinationDirURL;
    private static String xslStylesheet;
    private static int[] initialHeaderLevel;

    // helper for calcChapterNumbers()
    private static int[] childHeaderLevel;

    // helper for getCurrentChildHeadingNo()
    private static String fileBefore;
    private static double headingCounter;
    private static HashMap fileHeadingNos;

    static final int LEVELMAX = 10; // maximum number of header levels
    static boolean debug = false;


    private static Vector  externalDocumentVector;
    // gives the number of preceding header for an external document via path
    private static HashMap precedingHeaderCounterMap;
    private static HashMap chapterNames;

    // bug workaround members
    static double allHeadings;
    static double previousHeading;



    /**
     * Initializes a converter before usage.
     */
    public static void initialize(){

        try {
            if(outputType.equals("WML"))
                xslStylesheet   = "main_wml.xsl";
            else
                xslStylesheet   = "main_html.xsl";

            // create the XSLT processor (to be cloned later)
            if(clonableXSLProcessor == null){
                initXSLProcessor();
            }
            isInitialized = true;

            // helper for getCurrentChildHeadingNo()
            fileHeadingNos = new HashMap();
            fileBefore = "dummyFileName";

        }catch(Exception e) {
            System.out.println(e.getMessage());
            java.io.StringWriter sw = new java.io.StringWriter();
            e.printStackTrace(new java.io.PrintWriter(sw));
            System.out.println(sw.toString());
        }
    }


    public static void main(String args[]){

        try{



globalDocumentDir = "a/b/c";
System.out.println("scenario 1"+ getRelativeFileRef("d/e", "d/E/f/g"));
System.out.println("");
System.out.println("");
System.out.println("scenario 2"+ getRelativeFileRef("d/E/f/g", "d/e"));
System.out.println("");
System.out.println("We have a global document in the direcotry a/b/c/ \n A child (C1) in directory a/b/c/d/e \n Another child (C2) in directory a/B");
System.out.println("scenario 3 with d/e to ../../B -> ../../../../B/C2 == " + getRelativeFileRef("d/e", "../../B"));
System.out.println("FINISH");
System.out.println("");
System.out.println("scenario 4 with ../../B to d/e -> ../b/c/d/e/C1  == "+ getRelativeFileRef("../../B", "d/e"));

/*
            int nArgs = 0;
            Properties cmdlineProps = new Properties();
            for (int i = 0; i < args.length; i++) {
                int k = args[i].indexOf('=');
                if (k > 0) {
                    cmdlineProps.setProperty(args[i].substring(0, k),
                                     args[i].substring(k + 1));
                } else {
                    args[nArgs] = args[i];
                    nArgs++;
                }
            }

            if (nArgs < 3) {
                System.err.println("usage: java com.sun.star.xslt.helper.SxgChildTransformer source stylesheet result absoluteSourceDirRef=value [param=value]...\n\n");
                System.err.println("\tAn absolute destination path is necessary, if the source is a SXG (global document) containing links to child documents.");
                System.err.println("\tSuch a child document will be implizit transformed via a java call to SxgChildTransformer.");
                System.err.println("\tFor Usability reasons the child output gonna get HTML links to the ContentTable.");
                System.err.println("\tIn case it the child resists in a different directory as the global document, that link won't work.");

                System.exit(1);
            }
            if(System.getProperty("com.jclark.xsl.sax.parser") == null)
                System.setProperty("com.jclark.xsl.sax.parser", "org.xml.sax.helpers.XMLReaderAdapter");

            if(System.getProperty("org.xml.sax.driver") == null)
                System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");

            String debugParameter = cmdlineProps.getProperty("debug");

            if(debugParameter != null){
                if(debugParameter.equalsIgnoreCase("true")){
                    SxgChildTransformer.debug = true;
                    System.out.println("debug activated!");
                }
            }
            initialize();

            SxgChildTransformer.absoluteSourceDirRef = cmdlineProps.getProperty("absoluteSourceDirRef");
            if(absoluteSourceDirRef == null){
                System.err.println("Usage: The parameter 'absoluteSourceDirRef' giving the absolute path to the source file is not set.");
                System.exit(1);
            }
            SxgChildTransformer.setContentTableURL(cmdlineProps.getProperty("contentTableURL").replace('\\','/'));
System.out.println("contentTableURL: " + contentTableURL);
            SxgChildTransformer.jaredRootURL = cmdlineProps.getProperty("jaredRootURL").replace('\\','/');

            String inputFile = args[0].replace('\\','/');
            String outputFile = args[2].replace('\\','/');

System.out.println("jaredRootURL: " + jaredRootURL);


            globalDocumentDir = file2URL(new File(inputFile)).toString();
            // removing the file name
            globalDocumentDir = globalDocumentDir.substring(0, globalDocumentDir.lastIndexOf('/') + 1 );
            // removing the file protocol
            globalDocumentDir = globalDocumentDir.substring(globalDocumentDir.lastIndexOf(':') + 1);
            if(debug)System.out.println("globalDocumentDir: " + globalDocumentDir);
System.out.println("globalDocumentDir: " + globalDocumentDir);
            tableOfContentDocument = contentTableURL.substring(contentTableURL.lastIndexOf('/') + 1);
            tableOfContentDocumentDir = contentTableURL.substring(0, contentTableURL.lastIndexOf('/') + 1 );

            if(debug)System.out.println("tableOfContentDocumentDir: " + tableOfContentDocumentDir);

System.out.println("tableOfContentDocument: " + tableOfContentDocument);
            System.out.println("\nGoing to transfrom "+inputFile +" to "+ outputFile);
            transformDocument(inputFile, outputFile);
  */
        }catch(Exception e){
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }


    /** To be called from the stylesheet (e.g. common.xsl) */
    public static String transformChildren( NodeIterator iter,
                                            String jaredRootURL,
                                            String absoluteSourceDirRef,
                                            String optionalURLSuffix,
                                            String dpi,
                                            String outputType,
                                            boolean debug){

        try{
            if(!isInitialized){
                if(debug)System.err.println("transformChildren() - Initializing application!");
                initialize();
            }else
                if(debug)System.err.println("transformChildren() - Initializing already done!");

            SxgChildTransformer.jaredRootURL = jaredRootURL;
            SxgChildTransformer.optionalURLSuffix = optionalURLSuffix;
            SxgChildTransformer.setAbsoluteSourceDirRef(absoluteSourceDirRef);
            SxgChildTransformer.dpi = dpi;
            SxgChildTransformer.outputType = outputType;
            SxgChildTransformer.debug = debug;

            Node root = null;
            root = iter.next();
            NodeIterator descIter = new DescendantsOrSelfNodeIterator(root);
            CloneableNodeIterator cloneIter= new CloneableNodeIteratorImpl(descIter);




            SxgChildTransformer.contentTableHeadings = (NodeIterator) cloneIter.clone();
            //giving out all nodes of the node-set(NodeIterator) upto a certain element
            if(debug) printAllNodes((NodeIterator)cloneIter.clone(), STOP_ELEMENT);

            collectData(cloneIter, STOP_ELEMENT);

            for (Enumeration e = externalDocumentVector.elements(); e.hasMoreElements();) {
                String newSourceRef = (String) e.nextElement();
                if(!newSourceRef.equals(".")){
                    globalDocumentRefToCurrentFile = newSourceRef;
                    transformDocument(newSourceRef);
                }
            }

            return "Finished transformation of children documents, started from the global document transformation ";

        }catch(Exception e){
            if(debug) System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return null;
    }



    public static boolean transformDocument(String newSourceRef){

        try{
            // getting the new destination document for the ongoing transformation
            int sourceURLLength = newSourceRef.length();
            String targetURL = null;


			// if it is not an absolute URL nor an absolute DOS path nor absolute Unix path -> it is most probably a relative URL
			// the target URL will be changed
            if(newSourceRef.indexOf("//") < 0 && !newSourceRef.regionMatches(true, 1, ":", 0, 1) && !newSourceRef.startsWith("/")){
                targetURL = destinationDirURL + newSourceRef.substring(0, sourceURLLength-4)+".htm";
            }else
                targetURL = newSourceRef.substring(0, sourceURLLength-4)+".htm";

            transformDocument(newSourceRef, targetURL);

        }catch(Exception e){
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return false;
    }


    public static boolean transformDocument(String newSourceRef, String targetURL){

        try{
            System.out.println("\n\n*** New transformation ***");
            System.out.println("The output will be written to " + targetURL);

            // getting the inputSource and setting the destinationDirURL, which is the one of the source
            InputSource inputSource = createInputSource(newSourceRef);
            convert(inputSource, new FileDestination(targetURL), newSourceRef);
            return true;
        }catch(Exception e){
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return false;
    }




    /** Getting the inputSource for the transformation and setting the path for the dependent partial source
        files styles.xml and meta.xml (setting metaFileURL and stylesFileURL variables), which can be
        the same as the input file in case of a flat XML file  */
    public static InputSource createInputSource(String newSourceRef){
        try{


            // The output should be in the same dir as the source document.
            // The path of a linked document from the global document (newSourceRef)
            // might be relative URL to the global document, we need the absolute to be able to transform
            String sourceDocumentURL = null;

            // check if it's a relative URL or an absolute path
            int pathEnd = newSourceRef.lastIndexOf('/');
            if(newSourceRef.indexOf("//") < 0 && !newSourceRef.regionMatches(true, 1, ":", 0, 1) && !newSourceRef.startsWith("/")){
                // it is a relative URL, the absolute URL have to be concatenated
                sourceDocumentURL = absoluteSourceDirRef + newSourceRef;
                setDestinationDirURL(absoluteSourceDirRef);
            }else{
                // it is an absolute path, no concatenation needed
                sourceDocumentURL = newSourceRef;
                setDestinationDirURL(newSourceRef.substring(0, pathEnd));
            }
            System.out.print("The source "+ sourceDocumentURL);
            int sourceURLLength = sourceDocumentURL.length();
            // Is the input source from a Jar URL or a SX? OpenOffice jared/compressed document
            boolean isOpenOfficeDocument = sourceDocumentURL.regionMatches(true,(sourceURLLength - 4),".sx",0,3);
            URL sourceURL = null;
            if(sourceDocumentURL.startsWith("jar:") || isOpenOfficeDocument) {
                if(sourceDocumentURL.startsWith("jar:")) {
                    System.out.println("It is a jar URL");
                    sourceURL = new URL(sourceDocumentURL); // already JAR URL
                }else {
                    System.out.println(" is a compressed OpenOffice document");
                   	//if file URL or absolute Path
		            if(newSourceRef.startsWith("file:") || newSourceRef.regionMatches(true, 1, ":", 0, 1) || newSourceRef.startsWith("/")){
	                    sourceDocumentURL = (file2URL(new File(sourceDocumentURL))).toString();
					}
//this works        sourceURL = new URL("file://h:/xsltTest/testfiles/testfile/wd-so-xml-intro.xml");
//                  sourceURL = new URL("jar", "", "file:/h:/xsltTest/testfiles/testfile/wd-so-xml.jar!/content.xml");
                    sourceURL = new URL("jar", "", sourceDocumentURL + "!/content.xml");

                }
                JarURLConnection jarConn = (JarURLConnection) sourceURL.openConnection();
                //test stream
                //copyStream(new BufferedInputStream(jarConn.getInputStream()),System.out);
                inputSource = new InputSource(new BufferedInputStream(jarConn.getInputStream()));

                //useable with JarResolver overwriting resolveEntity()
                metaFileURL   = "JAR:" + sourceDocumentURL + "!/meta.xml";
                stylesFileURL = "JAR:" + sourceDocumentURL + "!/styles.xml";

            }// flatfilter XML inputfile
            else if(sourceDocumentURL.regionMatches(true,(sourceURLLength - 4),".xml",0,4)) {
                System.out.println(" is a XML flatfile");
                try{
                    // optimistically handling destinationDirURL as FILE or relative URL
                    File sourceFile = new File(sourceDocumentURL);
                    inputSource = new InputSource(new BufferedInputStream(new FileInputStream(sourceFile)));
                    sourceURL = file2URL(sourceFile);
                }catch(Exception e){
                    if(debug){
                        System.out.println(e.getMessage());
                        e.printStackTrace();
                    }
                    // otherwise if sourceDocumentURL wasn't a relative URL nor a file URL, we use it as different URL
                    sourceURL = new URL(sourceDocumentURL);
                    inputSource = new InputSource(new BufferedInputStream(sourceURL.openStream()));
                }
                // in the flat xml file both files are integrated in the content.xml
                metaFileURL   = sourceDocumentURL;
                stylesFileURL = sourceDocumentURL;
            }else{
                System.err.println("No InputSource for "+ sourceDocumentURL +" was able to be set!");
            }
            if(debug)System.out.println("The OpenOffice styles can be found under: " + stylesFileURL);

            if(inputSource == null)
                throw new Exception("The inputsource is null");
            else
                inputSource.setSystemId(sourceURL.toString());

            // setting the adequate headerlevel for this source
            if(precedingHeaderCounterMap != null)
                initialHeaderLevel = (int[]) precedingHeaderCounterMap.get(newSourceRef);
            return inputSource;

        }catch(Exception e){
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public static void convert(InputSource inputSource, GenericDestination outDest, String newSourceRef){
        convert(inputSource, outDest);
        System.out.println("...document " + newSourceRef + " has been transformed!\n");
    }


    public static void convert(InputSource inputSource, GenericDestination outDest){
        try{

            // setting up the XSL processor
            XSLProcessor aXSLProcessor = (XSLProcessor) clonableXSLProcessor.clone();

            OutputMethodHandlerImpl outputMethodHandler = new OutputMethodHandlerImpl(aXSLProcessor);
            outputMethodHandler.setDestination(outDest);
            aXSLProcessor.setOutputMethodHandler(outputMethodHandler);

            setStyleSheetParameters(aXSLProcessor);

            aXSLProcessor.setParser(xmlReaderAdapter);
            aXSLProcessor.setErrorHandler(new ErrorHandlerImpl());
            if(inputSource != null){
                System.out.println("\nStart transformation...");
                aXSLProcessor.parse(inputSource);
            }else
                throw new Exception("Empty InputSource!");

        }catch(Exception e){
            System.out.println(e.getMessage());
            if(debug){
                java.io.StringWriter sw = new java.io.StringWriter();
                e.printStackTrace(new java.io.PrintWriter(sw));
                if(debug) System.out.println(sw.toString());
            }
        }
    }




    /**
    * Initilizes a clonable XSL Processor instance of the XT processor from James Clark.
    * Depends on the initialized variables xslStylesheet.
    *
    */
    private static void initXSLProcessor(){

        try{
            XMLReader xmlReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            try {
                // the StarOffice XML documents shall not be validated, no dtd has been included
                xmlReader.setFeature("http://xml.org/sax/features/validation",                          false);
                xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd",  false);
                xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes",                  true);
            } catch (SAXException e) {
                System.out.println("Error in setting up xmlReader feature: 'load-external-dtd' equal false");
                if(debug){
                    System.out.println("Error in setting up parser feature");
                    System.out.println(e.getMessage());
                    java.io.StringWriter sw = new java.io.StringWriter();
                    e.printStackTrace(new java.io.PrintWriter(sw));
                    System.out.println(sw.toString());
                }
            }
            xmlReaderAdapter = new XMLReaderAdapter(xmlReader);
            // preparing the original of the clone the XSL Processor (4 seconds gain)
            clonableXSLProcessor = new XSLProcessorImpl();
            clonableXSLProcessor.setParser(xmlReaderAdapter);

            entityResolver = new JarResolver();
            xmlReaderAdapter.setEntityResolver(entityResolver);
            Class aClass = java.lang.String.class;
            if(debug) System.out.println("The xslStylesheet is: " + xslStylesheet);
            InputSource inputSource = new InputSource(new BufferedInputStream(aClass.getResourceAsStream("/" + xslStylesheet)));
            String styleSheetURL = aClass.getResource("/" + xslStylesheet).toString();
            String systemID = null;
            systemID = styleSheetURL.substring(0, styleSheetURL.lastIndexOf('/') + 1);
            if(debug) System.out.println("The stylesheet can be found under: " + systemID);
            inputSource.setSystemId(systemID);
            if(debug) System.out.println("The stylesheet can be found under: " + systemID);
            clonableXSLProcessor.loadStylesheet(inputSource);
        }
        catch(Exception e){
            System.out.println(e.getMessage());
            if(debug){
                java.io.StringWriter sw = new java.io.StringWriter();
                e.printStackTrace(new java.io.PrintWriter(sw));
                System.out.println(sw.toString());
            }
        }
    }

    static private void setStyleSheetParameters(XSLProcessor aXSLProcessor){

        try{
            // for tunneling through session based WebApplications with the optionalURLSuffix as URL suffix
            // (neccessary in case of URLREWRITING and single sign on)
            if(optionalURLSuffix != null)
                aXSLProcessor.setParameter("optionalURLSuffix", optionalURLSuffix);
            // tunneling through Presentation Server using PackageURLs to access content of the jar
            if(jaredRootURL != null)
                aXSLProcessor.setParameter("jaredRootURL", jaredRootURL);
            if(stylesFileURL != null)
                aXSLProcessor.setParameter("stylesFileURL", stylesFileURL);
            if(metaFileURL != null)
                aXSLProcessor.setParameter("metaFileURL", metaFileURL);
            if(destinationDirURL != null)
                aXSLProcessor.setParameter("absoluteSourceDirRef", destinationDirURL);
            if(dpi != null)
                aXSLProcessor.setParameter("dpi", dpi);
            if(contentTableURL != null)
                aXSLProcessor.setParameter("contentTableURL", contentTableURL);
            if(debug)
                aXSLProcessor.setParameter("debug", "true");
            if(globalDocumentRefToCurrentFile != null)
                aXSLProcessor.setParameter("globalDocumentRefToCurrentFile", globalDocumentRefToCurrentFile);

            if(contentTableHeadings != null){
                aXSLProcessor.setParameter("contentTableHeadings", (NodeIterator) contentTableHeadings);
            }
            if(initialHeaderLevel != null){
                if (debug)System.out.print("Parameter precedingChapterLevel: ");
                for(int i=1; i<=LEVELMAX; i++){
                    aXSLProcessor.setParameter("precedingChapterLevel" + Integer.toString(i), Integer.toString(initialHeaderLevel[i]));
                    if (debug)System.out.print("L:"+i+"V:"+Integer.toString(initialHeaderLevel[i])+" ");
                }   if (debug)System.out.println("");
            }
        }catch(Exception e){
            if(debug) System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }




    /**
        This function has two purposes.
        1) Adding all URLs of linked files of the global document into a vector (externalDocumentVector variable)
        2) To enable the consecutive numbering of chapters along the linked documents, the preceding open headers of a each level
           have to be counted and used as a chapter start value.

     * @param   iter                        Traverses all nodes of the given iterator upto a certain element (stop_element)
     *
     * @param   stopElement                 Name of the element, where the traversing of the tree stops.
     *
    */
    static void collectData(NodeIterator iter, String stopElement){
        try{

            Node node        = null;
            Name name        = null;
            Node aNode       = null;
            Name aName       = null;
            NodeIterator aIter  = null;
            String localPart    = null;
            byte nodeType       = 0;
            int level           = 0;
            int childDocumentNo      = 0;
            int oldChildDocumentNo   = 0;
            String currentDocumentURL   = null;
            //for easy usage, we use field and level equalent and ignore the fist field
            initialHeaderLevel   = new int[LEVELMAX + 1];

            externalDocumentVector = new Vector();
            precedingHeaderCounterMap = new HashMap();

            if(debug) System.out.println("Iterating the node-set from the stylesheet:");
            while((node = iter.next()) != null){
                nodeType = node.getType();
                if(nodeType == ELEMENT){
                    localPart = node.getName().getLocalPart();
                    if(localPart.equals("heading")){

                        level = new Integer(getAttributeValueFrom(node, "level")).intValue();
                        if(level > LEVELMAX)
                            throw new Exception("HeaderLevel exceeds the possible maximum level of headers: "+ LEVELMAX);

                        // the incremention of a header results in the restart of all higher levels with zero
                        for(int i=level+1; i <= LEVELMAX; i++)
                            initialHeaderLevel[i] = 0;


                        childDocumentNo = new Integer(getAttributeValueFrom(node, "child-document-no")).intValue();
                        if(childDocumentNo > oldChildDocumentNo){
                            oldChildDocumentNo = childDocumentNo;

                            currentDocumentURL  = getAttributeValueFrom(node, "file-url");
                            if(!currentDocumentURL.endsWith(".htm") && !currentDocumentURL.endsWith(".html")){
                                externalDocumentVector.add(currentDocumentURL);
                                if(debug) System.out.println("\nNew global document child:"+currentDocumentURL);
                            }else
                                if(debug) System.out.println("\nUnvalid global document child :"+currentDocumentURL);

                            // after the first header in the new document the initial values are determined
                            // (e.g. when the new document starts with a chapter level 3,
                            // the preceding chapters of level 1,2 and 3 are used)

                            precedingHeaderCounterMap.put(currentDocumentURL, cloneArray(initialHeaderLevel));
                        }
                        // the header incremention is updated after the cloning of the initialHeaderLevel,
                        // otherwise it would be counted double, as the first header is no preceding header
                        initialHeaderLevel[level]++;
                        if (debug){
                            for(int i=1; i<=LEVELMAX; i++){
                                System.out.print("L:"+i+"V:"+Integer.toString(initialHeaderLevel[i])+" ");
                            }
                            System.out.println("");
                        }
                    }else if(localPart.equals("content-table-headings")){
                        setContentTableURL(getAttributeValueFrom(node, "content-table-url"));

                    }else if(localPart.equals(stopElement)){
                        if(debug) System.out.println("**** Reached the output stop element: " + stopElement);
                        break;
                    }
                }
            }
        }catch(Exception e){
            if(debug) System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }


    static int[] cloneArray(int[] source){
        int[] clone = new int[source.length];
        for(int i=0; i<source.length; i++)
            clone[i] = source[i];
        return clone;
    }

    static String getAttributeValueFrom(Node ElementNode, String aName){
        try{
            NodeIterator aIter = ElementNode.getAttributes();
            Node aNode = null;
            do{
                aNode = aIter.next();
            }while(!(aNode.getName().getLocalPart().equals(aName)));
            return aNode.getData();
        }catch(Exception e){
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return null;
    }



    static public URL file2URL(File file)
    {
        String path = file.getAbsolutePath();
        String fSep = System.getProperty("file.separator");
        if (fSep != null && fSep.length() == 1) {
            path = path.replace(fSep.charAt(0), '/');
        }
        if (path.length() > 0 && path.charAt(0) != '/') {
            path = '/' + path;
        }
        try {
                return new URL("file", "", path);
        }
        catch (java.net.MalformedURLException e) {
            /* According to the spec this could only happen if the file
               protocol were not recognized. */
            throw new Error("unexpected MalformedURLException");
        }
    }




    /**
     * Debugging method:
     * Print outs all following node, dependent of the type of the iterator, until a certain named element (stopElement) is reached
     *
     * @param   iter                        Traverses all nodes of the given iterator upto a certain element (stopElement)
     *                                      and prints the content of the nodes to System.out
     * @param   stopElement                 Name of the element, where the traversing of the tree stops.
     *                                      The element of the provided name is not included.
     *
     */
    public static void printAllNodes(NodeIterator iter, String stopElement){
        try{

            Node node = null;
            Name name = null;
            byte nodeType = 0;
            String localPart = null;

            while((node = iter.next()) != null){

                nodeType = node.getType();
                if(nodeType == ELEMENT){
                        localPart = node.getName().getLocalPart();
                        if(localPart.equals(stopElement)){
                            if(debug) System.out.println("**** Reached the output stop element: " + stopElement);
                            break;
                        }
                        System.out.print("ELEMENT: ");
                        System.out.print(localPart);
                        printValueOfAttributes(node);

                }else if(nodeType == TEXT){
                        System.out.print("TEXT: ");
                        System.out.println(node.getData());

                }else if(nodeType == ATTRIBUTE){
                        System.out.print("ATTRIBUTE: ");
                        System.out.println(node.getName().getLocalPart());

                }else if(nodeType == ROOT){
                        System.out.println("ROOT");

                }else if(nodeType == PROCESSING_INSTRUCTION){
                        System.out.print("PROCESSING_INSTRUCTION: ");
                        System.out.println(node.getData());

                }else if(nodeType == COMMENT){
                        System.out.print("COMMENT: ");
                        System.out.println(node.getData());
                }
            }
        }catch(Exception e){
            if(debug) System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }


    /**
     * Debugging method:
     *  This method gives out the Attribute of an given element to System.out with a '@' prefix before the name
     *  and '=' between name and value, a '; ' is the delimiter of the attibutes.
     *  Example: '@title='Categories'; @level='4';
     *
     * @param   element   Parent element of the attributes to be given out
     */
    public static void printValueOfAttributes(Node element){
        try{
            NodeIterator iter = element.getAttributes();
            Node an = null;
            Name aName = null;
            String prefix = null;
            System.out.print("  ");
            while((an = iter.next()) != null){
                aName = an.getName();
                System.out.print((((prefix = aName.getPrefix()) != null) ? "@" + prefix : "@") + aName.getLocalPart() + "='" + element.getAttributeValue(aName) + "'; ");
            }
            System.out.println("");
        }catch(Exception e){
            if(debug) System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }


    /**
     * Debugging method:
	 * Copies the the whole inputstream to the outputstream. Flushing output, but not closing the streams after usage.
	 *
	 * @param   in       The inputstream to be copied to the outputstream
	 * @param   out      The outputstream as desired destination of the inputstream
	 *
	 * @return  the absolute path of a file with choosen pre- and suffix in the tempory directory of the webservices/WebDAV server.
	 */
    static public void copyStream(InputStream in, OutputStream out){
        try{
            final int BYTEARRAYLENGTH  = 16384;
            byte[] b = new byte[BYTEARRAYLENGTH];

            int len = in.read(b);
            while (len != -1)
            {
                out.write(b, 0, len);
                len = in.read(b);
            }
            out.flush();
        }catch (Exception e){
            System.out.println(e.getMessage());
            if(debug){
                java.io.StringWriter sw = new java.io.StringWriter();
                e.printStackTrace(new java.io.PrintWriter(sw));
                System.out.println(sw.toString());
            }
        }
    }



    static class ErrorHandlerImpl implements ErrorHandler
    {
        public void warning(SAXParseException e)
        {
            printSAXParseException(e);
        }

        public void error(SAXParseException e)
        {
            printSAXParseException(e);
        }

        public void fatalError(SAXParseException e) throws SAXException
        {
            throw e;
        }
    }

    static void printSAXParseException(SAXParseException e)
    {
        String systemId = e.getSystemId();
        int lineNumber = e.getLineNumber();
        if (systemId != null) {
            System.err.print(systemId + ":");
        }
        if (lineNumber >= 0) {
            System.err.print(lineNumber + ":");
        }
        if (systemId != null || lineNumber >= 0) {
            System.err.print(" ");
        }
        System.err.println(e.getMessage());
    }

    static void setAbsoluteSourceDirRef(String path){
        absoluteSourceDirRef = path.endsWith("/") ? path : path + '/';
    }

    static void setDestinationDirURL(String path){
        destinationDirURL = path.endsWith("/") ? path : path + '/';
    }

    static void setContentTableURL(String ref){
        if(ref.indexOf(':') < 0)
            contentTableURL = file2URL(new File(ref)).toString();
        else
            contentTableURL = ref;
    }


    /* A Chapter name will be provided as String. And the current number of recurrence will be returned.
       Our application only got one thread accessing this method at time, so no sync necessary
    public static int getCurrentChapterRepeating(String chapterName){
        boolean debug = true;
        int repeats;

        if(chapterNames == null)
            chapterNames = new HashMap();

        if(chapterNames.containsKey(chapterName)){
            Integer aInt = (Integer) chapterNames.get(chapterName);
            repeats = aInt.intValue();
            chapterNames.put(chapterName, new Integer(++repeats));
            if(debug)
                System.out.println("getCurrentChapterRepeating -- chapter '"+chapterName+"' number was incremented to "+repeats);
        }
        else{
            repeats = 1;
            chapterNames.put(chapterName, new Integer(repeats));
            if(debug)
                System.out.println("getCurrentChapterRepeating -- a new chapter: "+chapterName+" has been created!");
        }
        return repeats;
    }

    public static com.jclark.xsl.om.NodeIterator getcontentTableHeadings(){
        return contentTableHeadings;
    }

*/
    // OOo Bug Workaround: XSLT memory helper for previous headings of child documents
    public static double getPreviousChildDocumentsHeadingCount(double childHeadingCount){

        double previous = previousHeading;

        allHeadings     += childHeadingCount;
        previousHeading += childHeadingCount;

        return previous;

    }


    // OOo Bug Workaround: XSLT memory helper for previous headings of child documents
    public static double getAllChildDocumentsHeadingCount(){
        return allHeadings;
    }

    public static String getGlobalDocumentDir(){
        return globalDocumentDir;
    }

    public static double getHeadingNo(){
        return headingNo;
    }

    public static double getCurrentChildNo(){
        return currentChildNo;
    }

    public static String getCurrentChildUrl(){
        return currentChildUrl;
    }


    public static void setHeadingNo(double newHeadingNo){
        headingNo = newHeadingNo;
    }

    public static void setCurrentChildNo(double newCurrentChildNo){
        currentChildNo = newCurrentChildNo;
    }

    public static void setCurrentChildUrl(String newCurrentChildUrl){
        currentChildUrl = newCurrentChildUrl;
    }


    // this method receives the actual heading level and returns the actual absolute heading level
    // if the level is set to 0 the array will be resetted
    public static String calcChapterNumbers(double d_Level){
        int level = (int) d_Level;

        if(childHeaderLevel == null)
            childHeaderLevel   = new int[LEVELMAX + 1];

        // if the level is set to 0 the array will be resetted
        if(level == 0){
            for(int i=0; i <= LEVELMAX; i++)
                childHeaderLevel[i] = 0;
            return "A new file is being used!";
        }else if(level > LEVELMAX){
            System.out.println("HeaderLevel exceeds the possible maximum level of headers: "+ LEVELMAX);
            return "HeaderLevel exceeds the possible maximum level of headers: "+ LEVELMAX;
        }else{
            // the incremention of a header results in the restart of all higher levels with zero
            for(int i=level+1; i <= LEVELMAX; i++)
                childHeaderLevel[i] = 0;
            childHeaderLevel[level]++;

            int j = LEVELMAX;
            // start giving out heading levels from the first numbers not '0'
            for(; j >= 1; j--)
                if(childHeaderLevel[j] != 0)
                    break;

            StringBuffer sb = new StringBuffer("1");
            // starts with '1' as level 0 is not existing
            for(int i=2; i <= j; i++){
                sb.append('+');
                sb.append(childHeaderLevel[i]);
            }
            return sb.toString();
        }
    }

    // gives back the last used heading of the specified file
    // (double is used as number for the interface to XT)
    public static double getNextCurrentChildHeadingNo(String file){

        // a new child will be worked on
        if(file.compareToIgnoreCase(fileBefore) != 0)
        {
            fileHeadingNos.put(fileBefore, new Double(headingCounter));
            Double oldHeadingCounter;
            // if on the file has been worked before
            if((oldHeadingCounter = (Double) fileHeadingNos.get(file)) != null){
                headingCounter = oldHeadingCounter.doubleValue();
            }else{
              headingCounter = 1.0;
            }
            fileBefore = file;

        }else
            headingCounter++;
        return headingCounter;
    }


    // gives back the last used heading of the specified file
    // (double is used as number for the interface to XT)
    public static double getCurrentChildHeadingNo(){
        return headingCounter;
    }

    // gives back the last used heading of the specified file
    // (double is used as number for the interface to XT)
    public static String getGlobalHeadingNo(String currentHeadingNo, double precedingChapterLevel1){

        int precedingNo = (int)precedingChapterLevel1 + 1;

        StringBuffer output = new StringBuffer();
        output.append(precedingNo);

        if(currentHeadingNo.indexOf('.') != -1)
            output.append(currentHeadingNo.substring(currentHeadingNo.indexOf('.')));

        return output.toString();
    }



    /**
    The global document contains relative links to all child.
    This method has two of these relative child links as parameter
    and the global path as a class member and creates a relative link
    from the source to the target child.

    Example II:
    We have a global document in the direcotry a/b/c/
    A child (C1) in directory a/b/c/d/e
    Another child (C2) in directory a/B

    Both child are relative linked from the global document:
    C1 = d/e/C1
    C2 = ../../B/C2


    Scenario Ia:
    A reference from C2 -> C1 would be ../b/c/d/e/C1
    This can be split up to:

    ../b/c + d/e/C1
    The latter part is simply the reference to C1
    The first is a somehow inverted C2 link (../../B)
    The B is .. and the ../.. are taken from the global dir path


    Scenario Ib:
    A reference from C1 -> C2 would be ../../../../B/C2
    This can be split up to:

    ../.. + ../../B/C2
    The latter part is simply the reference to C2
    The first is a somehow inverted C1 link (d/e)
    The d/e are written as ../..
    -----------------
    Example II:

    We have a global document in the direcotry a/b/c/
    A child (C1) in directory a/b/c/d/e
    A child (C3) in directory a/b/c/d/e/f/g

    C1 = d/e/C1
    C3 = d/e/f/g/C3

    Scenario IIa:
    A reference from C1 -> C3 would be f/g/C3

    Scenario IIa:
    A reference from C3 -> C1 would be ../../C3

    ----------
    Example III:

    We have a global document in the direcotry a/b/c/
    A child (C1) in directory a/b/c/d/e
    A child (C3) in directory a/b/c/d/E/f/g

    C1 = d/e/C1
    C3 = d/E/f/g/C3

    Scenario IIa:
    A reference from C1 -> C3 would be ../E/f/g/C3

    Here is again a split up, but the common directories are
    taken earlier away..
    C1     C3
    .. + E/f/g/C3

    Scenario IIa:
    A reference from C3 -> C1 would be ../../../e/C1

    C3          C1
    ../../.. + e/C3


    */
    public static String getRelativeFileRef(String sourcePath, String targetPath){

System.out.println("Entered sourcePath:  "+ sourcePath +"targetPath: " + targetPath);

        // removing potential DOS separators
        sourcePath = sourcePath.replace('\\','/');
        targetPath = targetPath.replace('\\','/');

        //removing 'file:' protocol and DOS drive letter
        if(sourcePath.lastIndexOf(':') != -1)
            sourcePath = sourcePath.substring(sourcePath.lastIndexOf(':')+ 1);

        // removing the file name from the source
        if(sourcePath.lastIndexOf('/') != -1)
            sourcePath = sourcePath.substring(0, sourcePath.lastIndexOf('/') + 1);
        // sourcefile name only will be removed as well
        else
            sourcePath = "./";

System.out.println("Entered sourcePath2:  "+ sourcePath);

        //removing 'file:' protocol and DOS drive letter
        while(targetPath.indexOf(':') != -1)
            targetPath = targetPath.substring(targetPath.indexOf(':')+ 1);
/*
        // for the usage of tokenizer the string have to end with a token otherwise
        // the last path won't be taken
        if(!targetPath.endsWith("/"))
            targetPath = targetPath + "/";*/

        StringTokenizer inTkn  = new StringTokenizer(sourcePath);
        StringTokenizer outTkn = new StringTokenizer(targetPath);
        StringTokenizer globalTkn = new StringTokenizer(globalDocumentDir);
        String inToken = null;
        String outToken = null;
        String globalToken = null;
        StringBuffer outStringBuffer = new StringBuffer();

        // a beginning './' or '/' will be removed
        if(sourcePath.startsWith("/") || sourcePath.startsWith("./")){
            inToken = inTkn.nextToken("/");
            System.out.println("inToken./:  "+ inToken);
        }

        // a beginning './' or '/' will be removed
        if(targetPath.startsWith("/") || targetPath.startsWith("./")){
            outToken = outTkn.nextToken("/");
            System.out.println("outToken./: "+ outToken);
        }

        // a beginning './' or '/' will be removed
        if(targetPath.startsWith("/") || targetPath.startsWith("./")){
            globalToken = globalTkn.nextToken("/");
            System.out.println("globalToken file:  "+ globalToken);
        }

        // removing of similar preceding directories
        boolean isUnequal = false;
        while (inTkn.hasMoreTokens() && outTkn.hasMoreTokens()) {

            inToken  = inTkn.nextToken("/");
            outToken = outTkn.nextToken("/");
            System.out.println("inToken3:  "+ inToken);
            System.out.println("outToken3: "+ outToken);

            if(inToken.equals(outToken)){

                System.out.println("inToken4:  "+ inToken);
                System.out.println("outToken4: "+ outToken);
                continue;
            }else
                isUnequal = true;

            System.out.println("inTokenx:  "+ inToken+ "  -  countToken " + inTkn.countTokens());
            System.out.println("outTokenx: "+ outToken + "  -  countToken " + outTkn.countTokens());

            break;
        }


        StringBuffer part2 = new StringBuffer();
        if(inToken.equals("..")){
            do{
    System.out.println("inToken is '..' = "+ inToken);
                globalToken = globalTkn.nextToken("/");
    System.out.println("globalToken is "+ globalToken);
                part2.append(globalToken);
                part2.append("/");
                inToken = inTkn.nextToken("/");
            }while(inToken.equals("..") && inTkn.hasMoreTokens());
        }
        if(isUnequal)
            outStringBuffer.append("../");

System.out.println("S1" + outStringBuffer.toString());
        for (int i = 0; i < inTkn.countTokens();i++){
            outStringBuffer.append("../");
        }

System.out.println("S2" + outStringBuffer.toString());
        // inverse adding (cp. example)
        outStringBuffer.append(part2);


System.out.println("S3" + outStringBuffer.toString());
        // adding the rest (not equal) output path
        outStringBuffer.append(outToken);
        while (outTkn.hasMoreTokens()){
            outStringBuffer.append("/");
            outToken = outTkn.nextToken();
            outStringBuffer.append(outToken);
        }
System.out.println("S4" + outStringBuffer.toString());
        return outStringBuffer.toString();
    }

    public static String getNameOfTableOfContentDocument(){
        return tableOfContentDocument;
    }

}
