/*************************************************************************
 *
 *  $RCSfile: outputter.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: lla $ $Date: 2003/01/20 11:11:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//
#include <string>
#include "cppunit/result/outputter.hxx"

// -----------------------------------------------------------------------------

Outputter::~Outputter()
{
    // delete m_pLog;
}

void Outputter::writeToAll(const sal_Char* _sCharStr)
{
    // std::cout << _sCharStr;
    if (m_pStream)
    {
        *m_pStream << _sCharStr;
    }
    if (m_pLog.get())
    {
        m_pLog->write(_sCharStr);
    }
}

void Outputter::write(const sal_Char* _sCharStr)
{
    writeToAll(_sCharStr);
}

void Outputter::write(std::string const& _sStr)
{
    writeToAll(_sStr.c_str());
}

void Outputter::write(sal_Int32 _nValue)
{
    sal_Char cBuf[20];
    sal_Char* pBuf = cBuf;
    sprintf(pBuf, "%d", _nValue);
    writeToAll(pBuf);
}

// -----------------------------------------------------------------------------

Outputter& operator <<( Outputter &_aStreamWrapper, const sal_Char* _sValue)
{
    _aStreamWrapper.write(_sValue);
    return _aStreamWrapper;
}

Outputter& operator <<( Outputter &_aStreamWrapper, std::string const& _sValue)
{
    _aStreamWrapper.write(_sValue);
    return _aStreamWrapper;
}

Outputter& operator <<( Outputter &_aStreamWrapper, sal_Int32 _nValue)
{
    _aStreamWrapper.write(_nValue);
    return _aStreamWrapper;
}

//# Outputter& operator <<( Outputter &_aStreamWrapper, double )
//# {
//#     return _aStreamWrapper;
//# }

Outputter& operator <<( Outputter &_aStreamWrapper, Outputter::endl const& _aValue)
{
    _aStreamWrapper.write("\n");
    return _aStreamWrapper;
}
