/*************************************************************************
 *
 *  $RCSfile: slidechg.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: cl $ $Date: 2002/05/21 14:03:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _SD_SLIDECHG_HXX
#define _SD_SLIDECHG_HXX

#ifndef _COM_SUN_STAR_PRESENTATION_FADEEFFECT_HPP_
#include <com/sun/star/presentation/FadeEffect.hpp>
#endif

#ifndef _SV_GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif
#ifndef _SFXCTRLITEM_HXX //autogen
#include <sfx2/ctrlitem.hxx>
#endif
#ifndef _SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif
#ifndef _VALUESET_HXX //autogen
#include <svtools/valueset.hxx>
#endif
#ifndef _LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif
#ifndef _IMAGEBTN_HXX //autogen
#include <vcl/imagebtn.hxx>
#endif
#ifndef _SFXDOCKWIN_HXX //autogen
#include <sfx2/dockwin.hxx>
#endif

#ifndef _SD_SDRESID_HXX
#include "sdresid.hxx"
#endif

#include "diactrl.hxx"	// DiaTimeControl
#include "slidchld.hxx"
#include "fadedef.h"

class SdDrawDocument;
class SdView;

enum ViewTypeSlCh
{
	VIEWTYPE_SC_EFFECT = 1,
	VIEWTYPE_SC_EXTRAS
};


class SdEffectPrevCtrlItem;

//------------------------------------------------------------------------

class SdSlideChangeWin : public SfxDockingWindow
{
 friend class SdSlideChangeChildWindow;
 friend class SdSlideChangePrevCtrlItem;

private:
	//ImageButton			aBtnViewType;
	ImageButton			aBtnVTEffect;
	ImageButton			aBtnVTExtras;
	ImageButton 		aBtnPreview;
	ImageButton 		aBtnUpdate;
	ImageButton 		aBtnAssign;

	ListBox				aLbEffect;
	ValueSet			aCtlEffect;
	ListBox				aLbSpeed;

	ImageButton			aBtnAuto;
	ImageButton			aBtnSemi;
	ImageButton			aBtnManual;
	DiaTimeControl		aFldTime;
	ImageButton			aBtnSound;
	ImageButton			aBtnSearch;
	//Edit				aEdtSound;
	ListBox 			aLbSound;

	FixedLine			aGrpEffect;

	Size				aSize;
	USHORT				aValueSetHeight;
	USHORT				aExtrasHeight;
	USHORT				aBreakEvenHeight;
	BOOL				bBreakEven;

	USHORT				aBtnAutoPosY;
	USHORT				aBtnSemiPosY;
	USHORT				aBtnManualPosY;
	USHORT				aFldTimePosY;
	USHORT				aBtnSoundPosY;
	USHORT				aBtnSearchPosY;
	USHORT				aLbSoundPosY;

	BOOL				bUpdate;
	ViewTypeSlCh		eViewType;

	List*				ppStringIdList;
	List*				ppBitmapIdList;
	List*				ppHCBitmapIdList;
	List*				pSoundList;

	SfxBindings*				pBindings;
	SdSlideChangePrevCtrlItem*	pSlideChangePrevCtrlItem;

	//------------------------------------

	DECL_LINK( ClickViewTypeHdl, ImageButton * );
	DECL_LINK( ClickPreviewHdl, void * );
	DECL_LINK( ClickUpdateHdl, void * );
	DECL_LINK( ClickAssignHdl, void * );

	DECL_LINK( SelectEffectHdl, void * );
	DECL_LINK( SelectSoundHdl, void * );

	DECL_LINK( ClickAutoHdl, ImageButton * );
	DECL_LINK( ClickSemiHdl, ImageButton * );
	DECL_LINK( ClickManualHdl, ImageButton * );
	DECL_LINK( ClickSoundHdl, ImageButton * );
	DECL_LINK( ClickSearchHdl, ImageButton * );

	void 			OpenFileDialog();

	void			Construct();
	void			Reset();
	void			FillValueSet();
	USHORT			GetBitmapId( USHORT i, USHORT nPos );
	USHORT			GetStringId( USHORT i, USHORT nPos );
	void			SetFadeEffect( ::com::sun::star::presentation::FadeEffect eFE );
	::com::sun::star::presentation::FadeEffect 		GetFadeEffect();
	USHORT 			GetViewTypeResId( ViewTypeSlCh eVT, BOOL bImage = FALSE );

	void			FillSoundListAndBox();
	void			ClearSoundList();
	long			GetSoundObject( const String& rStr );
	String			GetSoundById( USHORT nId );
	USHORT			GetIdBySound( const String& rStr );

	void			DataChanged( const DataChangedEvent& rDCEvt );

protected:
	virtual BOOL	Close();
	virtual void	Resize();

public:
			SdSlideChangeWin( SfxBindings* pBindings, SfxChildWindow *pCW,
						Window* pParent, const SdResId& rSdResId );
			~SdSlideChangeWin();

	BOOL	IsUpdateMode() const { return bUpdate; }

	void	Update( SfxItemSet& rSet );
	void	GetAttr( SfxItemSet& rSet );

	void	EnableAssignButton( BOOL bEnable = TRUE ) { aBtnAssign.Enable( bEnable ); }
};

/*************************************************************************
|*
|* ControllerItem fuer Preview-Button
|*
\************************************************************************/

class SdSlideChangePrevCtrlItem : public SfxControllerItem
{
	SdSlideChangeWin*	pWin;

 protected:
	virtual void StateChanged( USHORT nSId, SfxItemState eState,
								const SfxPoolItem* pState );

 public:
	SdSlideChangePrevCtrlItem( USHORT, SdSlideChangeWin*, SfxBindings* );
};

#endif		// _SD_SLIDECHG_HXX

