/*************************************************************************
 *
 *  $RCSfile: process.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 17:44:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __SCHEDULE_HXX
#include "schedule.hxx"
#endif

#include "socket.hxx"

#include <dir.h>
#include <string.h>

#include "system.h"
#include <toolhelp.h>
#include <shellapi.h>

#include <osl/process.h>

extern "C" {

/*--------------------------------------------------------------------------*/
/*  	osl_executeProcess													*/
/*--------------------------------------------------------------------------*/

oslProcessError SAL_CALL osl_executeProcess(const sal_Char *pszImageName,
								   const sal_Char *pszArguments[],
								   oslProcessOption Options,
								   oslSecurity,
								   const sal_Char *pszDirectory,
								   const sal_Char *[],
								   oslIOResource*,
								   oslProcess *pProcess)
{
	sal_Char		szCmdLine[256] = "";
	int			i;
	UINT		nShow;
	HINSTANCE	hInst;
	TASKENTRY	*pTaskEntry;

	pTaskEntry = new TASKENTRY;
	if (pTaskEntry == NULL)
		return osl_Process_E_None;

	for (i = 0; pszArguments[i]; i++)
	{
		if (i)
			strcat(szCmdLine, " ");
		strcat(szCmdLine, pszArguments[i]);
	}

	switch (Options & (osl_Process_NORMAL | osl_Process_HIDDEN |
	               osl_Process_MINIMIZED | osl_Process_MAXIMIZED |
				   osl_Process_FULLSCREEN))
	{
		case osl_Process_HIDDEN:
			nShow = SW_HIDE;
			break;

		case osl_Process_MINIMIZED:
			nShow = SW_MINIMIZE;
			break;

		case osl_Process_MAXIMIZED:
		case osl_Process_FULLSCREEN:
			nShow = SW_MAXIMIZE;
			break;

		default:
			nShow = SW_NORMAL;
	}


	hInst = ShellExecute(NULL, NULL, pszImageName, szCmdLine, pszDirectory, nShow);

	if (hInst >= HINSTANCE_ERROR)
	{
		TASKENTRY	te;
		BOOL		bTask;

		te.dwSize = sizeof(TASKENTRY);

		bTask = TaskFirst(&te);
		while (bTask && te.hInst != hInst)
			bTask = TaskNext(&te);

		if (bTask)
		{
			*pTaskEntry = te;
			*pProcess = (oslProcess)pTaskEntry;
			return osl_Process_E_None;
		}
		else
			free(pTaskEntry);
	}
	else
		free(pTaskEntry);

	return osl_Process_E_Unknown;
}

/*--------------------------------------------------------------------------*/
/*  	osl_terminateProcess												*/
/*--------------------------------------------------------------------------*/

oslProcessError SAL_CALL osl_terminateProcess(oslProcess Process)
{
	TASKENTRY	*pTaskEntry = (TASKENTRY *)Process;

	if (pTaskEntry)
	{
		if (IsTask(pTaskEntry->hTask))
		{
			TerminateApp(pTaskEntry->hTask, NO_UAE_BOX);
   			return osl_Process_E_None;
		}
		else
			return osl_Process_E_Unknown;
	}
	else
		return osl_Process_E_Unknown;
}


/*--------------------------------------------------------------------------*/
/*  	osl_getProcess														*/
/*--------------------------------------------------------------------------*/

oslProcess SAL_CALL osl_getProcess(oslProcessIdentifier Ident)
{
	TASKENTRY	*pTaskEntry = new TASKENTRY;

	pTaskEntry->dwSize = sizeof(TASKENTRY);
	if (!TaskFindHandle(pTaskEntry, (HTASK)Ident))
	{
		free(pTaskEntry);
		pTaskEntry = NULL;
	}

	return (oslProcess)pTaskEntry;
}

/*--------------------------------------------------------------------------*/
/*  	osl_freeProcessHandle												*/
/*--------------------------------------------------------------------------*/

void SAL_CALL osl_freeProcessHandle(oslProcess Process)
{
	if (Process)
		free((TASKENTRY *)Process);
}

/*--------------------------------------------------------------------------*/
/*  	osl_getProcessInfo													*/
/*--------------------------------------------------------------------------*/

oslProcessError SAL_CALL osl_getProcessInfo(oslProcess Process, oslProcessData Fields,
                                   oslProcessInfo* pInfo)
{
	if (Process && pInfo)
	{
		TASKENTRY	*pTaskEntry = (TASKENTRY *)Process;

		pInfo->Size = sizeof(oslProcessInfo);
		pInfo->Fields = 0;

		if (Fields & osl_Process_IDENTIFIER)
		{
			pInfo->Fields |= osl_Process_IDENTIFIER;
			pInfo->Ident = (oslProcessIdentifier)pTaskEntry->hTask;
		}

		return osl_Process_E_None;
	}

	return osl_Process_E_Unknown;
}

/*--------------------------------------------------------------------------*/
/*  	osl_joinProcess														*/
/*--------------------------------------------------------------------------*/

BOOL FAR PASCAL __loadds __export NotifyRegisterCallback(WORD wID, DWORD)
{
	HTASK		hTask;
	TASKENTRY	te;

	switch (wID)
	{
		case NFY_EXITTASK:
			hTask = GetCurrentTask();
			te.dwSize = sizeof(TASKENTRY);
			if (TaskFindHandle(&te, hTask) && SCHEDULER)
			{
				SALThread *pThread = SCHEDULER->findCallbackThread(SALThread::ProcessTaskType, hTask);

				if (pThread)
					pThread->unregisterCallback();
			}
			break;
		default:
			break;
	}

	return FALSE;
}

oslProcessError SAL_CALL osl_joinProcess(oslProcess Process)
{
	TASKENTRY	*pTaskEntry = (TASKENTRY *)Process;

	if (pTaskEntry)
	{
		static FARPROC lpfnCallback = NULL;

		if (lpfnCallback == NULL)
		{
			lpfnCallback = MakeProcInstance((FARPROC)NotifyRegisterCallback, GetThreadInstance());
			if (!NotifyRegister(GetCurrentTask(), (LPFNNOTIFYCALLBACK)lpfnCallback, NF_NORMAL))
			{
				FreeProcInstance(lpfnCallback);
				lpfnCallback = NULL;
				return osl_Process_E_Unknown;
			}
		}

		SCHEDULER->activeThread()->registerCallback(SALThread::ProcessTaskType, pTaskEntry->hTask);
		SCHEDULER->dispatch();

  		return osl_Process_E_None;
	}

	return osl_Process_E_Unknown;
}

/*--------------------------------------------------------------------------*/
/*  	osl_getExecutableFile												*/
/*--------------------------------------------------------------------------*/

oslProcessError SAL_CALL osl_getExecutableFile(sal_Char* pszBuffer, sal_uInt32 Max)
{
	return ((GetModuleFileName(NULL, pszBuffer, Max) == 0) ? osl_Process_E_Unknown : osl_Process_E_None);
}

/*--------------------------------------------------------------------------*/
/*  	osl_getCommandArgs													*/
/*--------------------------------------------------------------------------*/

oslProcessError SAL_CALL osl_getCommandArgs(sal_Char*, sal_uInt32)
{
	return osl_Process_E_Unknown;
}

/*--------------------------------------------------------------------------*/
/*  	osl_getEnvironment													*/
/*--------------------------------------------------------------------------*/

oslProcessError SAL_CALL osl_getEnvironment(const sal_Char* pszName, sal_Char *pszBuffer, sal_uInt32 Max)
{
	sal_Char *pszValue = getenv(pszName);

	if (pszValue && pszBuffer)
	{
		strnzcpy(pszBuffer, pszValue, Max);
		return osl_Process_E_None;
	}
	else
		return osl_Process_E_Unknown;
}

/*--------------------------------------------------------------------------*/
/*  	osl_searchPath														*/
/*--------------------------------------------------------------------------*/

oslProcessError SAL_CALL osl_searchPath(const sal_Char* pszName, const sal_Char* pszPath,
                               sal_Char Separator, sal_Char *pszBuffer, sal_uInt32 Max)
{
	sal_Char		szPath[_MAX_PATH + 1];
	const sal_Char	*pszSeparator;

	do {
		size_t len;
		struct ffblk fileinfo;

		pszSeparator = strchr(pszPath, Separator);
		if (pszSeparator)
		{
			len = pszSeparator - pszPath;
			memcpy(szPath, pszPath, len);
			szPath[len] = '\0';
			pszPath += len + 1;
		}
		else
			strcpy(szPath, pszPath);

		len = strlen(szPath);
		if (len > 0 && szPath[len-1] != '\\')
			strcat(szPath, "\\");

		strcat(szPath, pszName);

		if (findfirst((sal_Char *)szPath, &fileinfo, 0x3F) == 0)
		{
			strnzcpy(pszBuffer, szPath, Max);
			return osl_Process_E_None;
		}
	} while (pszSeparator);

	return osl_Process_E_NotFound;
}

/*--------------------------------------------------------------------------*/
/*  	osl_getIOResources													*/
/*--------------------------------------------------------------------------*/

oslProcessError SAL_CALL osl_getIOResources(oslIOResource[], sal_uInt32)
{
	return osl_Process_E_NotFound;
}


} // extern "C"



