/*************************************************************************
 *
 *  $RCSfile: sdb.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "sdb.hxx"

#ifndef __STARDIV_ONE_DATA_DBWORKSP_HXX__
#include <stardiv/one/data/dbworksp.hxx>
#endif

#ifndef __STARDIV_ONE_DATA_DBCONN_HXX__
#include <stardiv/one/data/dbconn.hxx>
#endif


#ifndef __STARDIV_UNO_IO_STREAM_HXX__
#include <stardiv/uno/io/stream.hxx>
#endif

#ifndef __STARDIV_ONE_DATA_DBTABLE_HXX__
#include <stardiv/one/data/dbtable.hxx>
#endif

#ifdef _USE_NAMESPACE
using namespace std;
#endif

inline BOOL isLessParameteredValue( 
	const AddressBookParameteredValue& rFirst, const AddressBookParameteredValue& rSecond )
{
	return isLessSequenceUString( rFirst.Parameters, rSecond.Parameters );
}

inline BOOL isEqual(
	const PropertyValue& r1, const PropertyValue& r2 )
{
 	return r1.Name == r2.Name && isEqual( r1.Value, r2.Value );
}


DECLARE_SEQEQUAL( PropertyValue )


UString mapToDBFieldName( 
	const AddressBookSourceSimpleDatabaseSchemaDefinition& rSchema,
	const UString& rField )
{
	const AddressBookSourceSimpleDatabaseFieldMapping* pFirst = 
		rSchema.FieldMappings.getConstArray();
	const AddressBookSourceSimpleDatabaseFieldMapping* pLast = 
		pFirst + rSchema.FieldMappings.getLen();
	for(; pFirst != pLast; pFirst++ )
		if( pFirst->Name == rField ) return pFirst->DatabaseName;
	THROW( NoSuchElementException() );
	return UString();
}


inline BOOL isLessFieldMapping( 
	const AddressBookSourceSimpleDatabaseFieldMapping& r1, 
	const AddressBookSourceSimpleDatabaseFieldMapping& r2 )
{
	return r1.Name < r2.Name || r1.Name == r2.Name && 
		isLessSequenceUString( r1.Parameters, r2.Parameters );
}

OAddressBookSourceSimpleDatabase::OAddressBookSourceSimpleDatabase(
	const XMultiServiceFactoryRef& xMgr ) :
	OPropertySet( 			
		m_aMutex, this,	
		OObjectClass<OAddressBookSourceSimpleDatabaseData>::getInstance(), false ),
	m_xMgr( xMgr )
{
	m_ServiceName = L"stardiv.one.address.AddressBookSourceSimpleDatabase";

	AddressBookSourceSimpleDatabaseSchemaDefinition aDefinition;
	aDefinition.Name = L"Person";
	AddressBookSourceSimpleDatabaseFieldMapping aMapping[ 11 ];
	for( INT32 nPos = ARRSIZE( aMapping ); nPos--; )
		aMapping[ nPos ].Type = OUString_getReflection()->getIdlClass();
	
	INT32 i = 0;
	aMapping[ i ].DatabaseName = L"VORNAME";
	aMapping[ i ].Name = L"Givenname";
	aMapping[ ++i ].DatabaseName = L"NAME";
	aMapping[ i ].Name = L"Surname";
	aMapping[ ++i ].DatabaseName = L"FIRMA";
	aMapping[ i ].Name = L"Company";
	aMapping[ ++i ].DatabaseName = L"ABTEILUNG";
	aMapping[ i ].Name = L"Department";
	aMapping[ ++i ].DatabaseName = L"STRASSE";
	aMapping[ i ].Name = L"Address";
	aMapping[ ++i ].DatabaseName = L"ORT";
	aMapping[ i ].Name = L"City";
	aMapping[ ++i ].DatabaseName = L"BUNDLAND";
	aMapping[ i ].Name = L"State";
	aMapping[ ++i ].DatabaseName = L"PLZ";
	aMapping[ i ].Name = L"ZIP";
	aMapping[ ++i ].DatabaseName = L"LAND";
	aMapping[ i ].Name = L"Country";
	aMapping[ ++i ].DatabaseName = L"POSITION";
	aMapping[ i ].Name = L"Jobtitle";
	aMapping[ ++i ].DatabaseName = L"ID";
	aMapping[ i ].Name = L"Uid";
	aDefinition.FieldMappings = 
		Sequence<AddressBookSourceSimpleDatabaseFieldMapping>( 
			aMapping, ARRSIZE( aMapping ) );
	m_Schemata = Sequence<AddressBookSourceSimpleDatabaseSchemaDefinition>( 
		&aDefinition, 1 );
	Sequence<PropertyValue> aParams( 3 );
	PropertyValue* pParams = aParams.getArray();
	pParams[ 0 ].Name = L"TYPE";
	pParams[ 0 ].Value <<= UString( L"DBF" );
	pParams[ 1 ].Name = L"DSN";
	pParams[ 1 ].Value <<= UString( L"g:\\547b.49\\user\\database" );
	pParams[ 2 ].Name = L"CHARSET";
	pParams[ 2 ].Value <<= UString( L"CHARSET" );
	m_ConnectionParameters = aParams;
}


inline BOOL isEqual( const AddressBookSourceSimpleDatabaseFieldMapping& r1, 
					 const AddressBookSourceSimpleDatabaseFieldMapping& r2 )
{
	return r1.Name == r2.Name && isEqual( r1.Parameters, r2.Parameters ) &&
		r1.DatabaseName == r2.DatabaseName && r1.Type->equals( r2.Type );
}

DECLARE_SEQEQUAL( AddressBookSourceSimpleDatabaseFieldMapping )

inline BOOL isEqual( const AddressBookSourceSimpleDatabaseSchemaDefinition& r1, 
					 const AddressBookSourceSimpleDatabaseSchemaDefinition& r2 )
{
	return r1.Name == r2.Name && isEqual( r1.FieldMappings, r2.FieldMappings );
}

DECLARE_SEQEQUAL( AddressBookSourceSimpleDatabaseSchemaDefinition )

void OAddressBookSourceSimpleDatabaseData::fillClassInfo(
	OObjectClassBase*& rpParentClass, 
	Sequence<OPropertyAccessor>& rProps )
{
	static OPropertyAccessor aProps[] = 
	{
		ADR_PROPERTY( 
			OAddressBookSourceSimpleDatabaseData, Name, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSourceSimpleDatabaseData, Table, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSourceSimpleDatabaseData, ServiceName, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSourceSimpleDatabaseData, ConnectionParameters, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSourceSimpleDatabaseData, Schemata, PropertyAttribute_BOUND )
	};
	rProps = Sequence<OPropertyAccessor>( 
		aProps, sizeof( aProps )/ sizeof( OPropertyAccessor ) );
}

const AddressBookSourceSimpleDatabaseSchemaDefinition* OAddressBookSourceSimpleDatabaseData::getSchemaDefinition( 
	const UString& rName )
{
	const AddressBookSourceSimpleDatabaseSchemaDefinition* pBegin = 
		m_Schemata.getConstArray();
	const AddressBookSourceSimpleDatabaseSchemaDefinition* pEnd = 
		pBegin + m_Schemata.getLen();
	while( pBegin != pEnd )
	{
		if( pBegin->Name == rName ) return pBegin;
		pBegin++;
	}
	return 0;
}

static const AddressBookSourceSimpleDatabaseFieldMapping* findField( 
	const AddressBookSourceSimpleDatabaseSchemaDefinition& rSchema,
	const UString& rABName )
{
	const AddressBookSourceSimpleDatabaseFieldMapping* pFirst = 
		rSchema.FieldMappings.getConstArray();
	const AddressBookSourceSimpleDatabaseFieldMapping* pLast = 
		pFirst + rSchema.FieldMappings.getLen();
	for( ;pFirst != pLast; pFirst++ )
		if( pFirst->Name == rABName ) return pFirst;
	return 0;
}

static Sequence<UString> getDatabaseNames( 
	const AddressBookSourceSimpleDatabaseSchemaDefinition& rSchema )
{
	vector<UString> aResult;
	const AddressBookSourceSimpleDatabaseFieldMapping* pFirst = 
		rSchema.FieldMappings.getConstArray();
	const AddressBookSourceSimpleDatabaseFieldMapping* pLast = 
		pFirst + rSchema.FieldMappings.getLen();
	for( ;pFirst != pLast; pFirst++ )
		aResult.push_back(  pFirst->DatabaseName );
	sort( aResult.begin(), aResult.end(), isLess );
	aResult.erase( 
		unique( aResult.begin(), aResult.end(), UStringEqual() ), 
		aResult.end() );
	Sequence<UString> aSeq;
	copyContainerToSequence( aResult, aSeq );
	return aSeq;
}



XIdlClassRef OAddressBookSourceSimpleDatabase::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"stardiv.one.address.OAddressBookSourceSimpleDatabase", 
		OPropertySet::getStaticIdlClass(), 2,
		XAddressBookJobFactorySupplier_getReflection(),
		XJobFactory_getReflection()
		);
	return xClass;
}

BOOL OAddressBookSourceSimpleDatabase::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XAddressBookJobFactorySupplier );
	QUERYIFACE( XJobFactory );
	return OPropertySet::queryInterface( aUik, rOut );
}

Sequence<XIdlClassRef>	OAddressBookSourceSimpleDatabase::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

XJobFactoryRef OAddressBookSourceSimpleDatabase::getJobFactory()
{
	if( !m_xJobFactory.is() )
	{
		UsrAny aAny;
		aAny <<= XJobFactoryRef( this );
		m_xJobFactory = XJobFactoryRef(
			m_xMgr->createInstanceWithArguments( 
				L"stardiv.one.address.SynchronAndAsynchronJobFactory",
				Sequence<UsrAny>( &aAny, 1 ) ), USR_QUERY );
	}
	return m_xJobFactory;
}

XInterfaceRef OAddressBookSourceSimpleDatabase::createJob( 
	const UString& rType, const Sequence<UsrAny>& rArgs )
{
	if( rType == L"query" )
		return *new OAddressBookSourceSimpleDatabaseQueryJob(
			m_xMgr, this, rType, rArgs );
	else
		return *new OAddressBookSourceSimpleDatabaseSynchronJob(
			m_xMgr, this, rType, rArgs );
}

void OAddressBookSourceSimpleDatabase::setFastPropertyValue_NoBroadcast( 
	INT32 nHandle, const UsrAny& rValue ) THROWS( (Exception) )
{
	OPropertySet::setFastPropertyValue_NoBroadcast( nHandle, rValue );
	m_aConnection = XInterfaceRef();
}

const XDatabaseConnectionRef OAddressBookSourceSimpleDatabase::getConnection()
{
	XDatabaseConnectionRef xConn;
	if( !m_aConnection.queryHardRef( 
		XDatabaseConnection::getSmartUik(), xConn ) )
	{
		OAddressBookSourceSimpleDatabaseData aData;
		{
			OGuard aGuard( m_aMutex );
			aData = *this;
		}
		XDatabaseEngineRef xEngine(
			m_xMgr->createInstance(L"stardiv.one.data.DatabaseEngine"), USR_QUERY );
		if( !xEngine.Is() ) THROW( RuntimeException() );
		TRY
		{
			xConn = XDatabaseConnectionRef( xEngine->createConnection( 
				aData.m_ConnectionParameters ), USR_QUERY );
			m_aConnection = xConn;
		}
		CATCH( DatabaseException, e )
		{
		}
		END_CATCH;
	}
	return xConn;
}


const XAddressBookRecordContainerRef& OAddressBookSourceSimpleDatabase::getRecordContainer()
{
	if( !m_xRecordContainer.is() )
	{
		UsrAny aAny;
		aAny <<= XAddressBookJobFactorySupplierRef( this );
		m_xRecordContainer = XAddressBookRecordContainerRef(
			m_xMgr->createInstanceWithArguments( 
				L"stardiv.one.address.AddressBookSourceAccess",
				Sequence<UsrAny>( &aAny, 1 ) ), USR_QUERY );
	}
	return m_xRecordContainer;
}

UsrAny OAddressBookSourceSimpleDatabase::getAnyFromProperty( 
	const UString& rSchemaName,
	const AddressBookSourceSimpleDatabaseFieldMapping& rMap,
	const AddressBookParameteredValue& rValue )
{
	if( rMap.Name == L"Uid" )
	{
		UString aUid;
		if( rValue.Value >>= aUid )
			return UsrAny( UString( aUid + rSchemaName.len() + 1 ));
	}
	return rValue.Value;
}

UsrAny OAddressBookSourceSimpleDatabase::getPropertyFromAny( 
	const UString& rSchemaName,
	const AddressBookSourceSimpleDatabaseFieldMapping& rMap,
	const UsrAny& rValue )
{
	UsrAny aRet = rValue;
	if( aRet.getReflection() == XInputStream_getReflection() )
	{
		XDataInputStreamRef xStream( 
			*(const XInputStreamRef*)aRet.get(), USR_QUERY );
		aRet.setString(  xStream->readUTF() );
	}
	if( rMap.Name == L"Uid" )
	{
		UString aUid;
		if( aRet >>= aUid )	aRet.setString(
			OAddressBookSources::schemaAndBasisUidToUid(
				rSchemaName, aUid ) );
	}
	return aRet;
}


//////////////////////////////////////////////////////////

OAddressBookSourceSimpleDatabaseSynchronJob::OAddressBookSourceSimpleDatabaseSynchronJob( 
	const XMultiServiceFactoryRef& xMgr, 
	const OAddressBookSourceSimpleDatabaseRef& xSource, 
	const UString& rType, const Sequence<UsrAny>& rArgs )
	: m_xMgr( xMgr ), m_xSource( xSource ), m_aArgs( rArgs ), m_aType( rType )
{
}

XIdlClassRef OAddressBookSourceSimpleDatabaseSynchronJob::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"stardiv.one.address.OAddressBookSourceSimpleDatabaseSynchronJob", 
		UsrObject::getUsrObjectIdlClass(), 2,
		XCancellable_getReflection(),
		XSynchronJob_getReflection() );
	return xClass;
}

Sequence<XIdlClassRef>	OAddressBookSourceSimpleDatabaseSynchronJob::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OAddressBookSourceSimpleDatabaseSynchronJob::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XJob );
	QUERYIFACE( XSynchronJob );
	QUERYIFACE( XCancellable );
	return UsrObject::queryInterface( aUik, rOut );
}

void OAddressBookSourceSimpleDatabaseSynchronJob::updateRecord( 
	const XDatabaseCursorRef& xCursor, 
	const AddressBookSourceSimpleDatabaseSchemaDefinition& rSchema, 
	const Sequence<AddressBookParameteredPropertyValue>& rValues )
{
	XPropertySetRef xProp = xCursor->getRecord();
	vector<AddressBookSourceSimpleDatabaseFieldMapping> aProperties;
	copySequenceToContainer( rSchema.FieldMappings, aProperties );
	stable_sort( 
		aProperties.begin(), aProperties.end(), isLessFieldMapping );
	
	// now distribute the values on the record of the cursor
	AddressBookSourceSimpleDatabaseFieldMapping aSearchMap;
	UsrAny aAny;
	const AddressBookParameteredPropertyValue* pFirstValue = 
		rValues.getConstArray();
	const AddressBookParameteredPropertyValue* pLastValue = 
		pFirstValue + rValues.getLen();
	const AddressBookParameteredPropertyValue* pCur;
	for( pCur = pFirstValue; pCur != pLastValue; pCur++ )
	{
		Sequence<AddressBookParameteredValue> aSeq =
			pCur->Values;
		const AddressBookParameteredValue* pFirstSubValue = 
			aSeq.getConstArray();
		const AddressBookParameteredValue* pLastSubValue = 
			pFirstSubValue + aSeq.getLen();
		aSearchMap.Name = pCur->Name;
		for( ; pFirstSubValue != pLastSubValue; pFirstSubValue++ )
		{
			aSearchMap.Parameters = pFirstSubValue->Parameters;
			pair<vector<AddressBookSourceSimpleDatabaseFieldMapping>::iterator,
				vector<AddressBookSourceSimpleDatabaseFieldMapping>::iterator >
				aPair = equal_range( 
					aProperties.begin(), aProperties.end(), aSearchMap,
					isLessFieldMapping );
			if( aPair.first == aPair.second )
				THROW( IllegalArgumentException() );
			aAny = OAddressBookSourceSimpleDatabase::getAnyFromProperty( 
				rSchema.Name, *aPair.first, *pFirstSubValue );
			xProp->setPropertyValue( 
				(*aPair.first).DatabaseName, aAny );
			aProperties.erase( aPair.first );
		}
	}
}


UsrAny OAddressBookSourceSimpleDatabaseSynchronJob::executeSynchron( )
{
	TRY
	{
		const UsrAny* pArr = m_aArgs.getConstArray();
		if( m_aType == L"getSchemata" )
		{
			Sequence<AddressBookSourceSimpleDatabaseSchemaDefinition> aSchemata = 
				m_xSource->getData().m_Schemata;
			UString aTable = m_xSource->getData().m_Table;
			
			OAddressBookSchemaData aSchema;
			AddressBookParameteredProperty aProperty;
			aProperty.Type = OUString_getReflection()->getIdlClass();
		
			// iterate over all schemata
			vector<Sequence<PropertyValue> > aRet;
		
			AddressBookSourceSimpleDatabaseSchemaDefinition* pDefinitions = 
				aSchemata.getArray();
			UString aName;
			INT32 nPos;
			for( nPos = aSchemata.getLen(); nPos--; )
			{
				XDatabaseConnectionRef xConnection = m_xSource->getConnection();
				aSchema.m_IsInsertable = FALSE;
				if( !xConnection.is() ) continue;
				XNameContainerRef xTables = xConnection->getTables();
				XPropertySetRef xTable;
				TRY
				{
					extractInterface( 
						xTables->getByName( aTable ), xTable );
				}
				CATCH( NoSuchElementException, e )
				{
				}
				END_CATCH;
				
				if( !xTable.is() ) continue;
				short nPrivs = 0;
				xTable->getPropertyValue( L"Priviliges" ) >>= nPrivs;
				BOOL bUpdatable = !!(nPrivs & DatabasePrivilige_UPDATE_DATA );
				BOOL bRemovable = !!(nPrivs & DatabasePrivilige_DELETE_DATA );
				if( nPrivs & DatabasePrivilige_INSERT_DATA )
					aSchema.m_IsInsertable = TRUE;
				
				XDatabaseFieldsSupplierRef xFieldSup( xTable, USR_QUERY );
				XNameAccessRef xFields = xFieldSup->getFields();

				aSchema.m_Name = pDefinitions[ nPos ].Name;
				Sequence<AddressBookSourceSimpleDatabaseFieldMapping>& rMapping = 
					pDefinitions[ nPos ].FieldMappings;
			
				// sort Mapping so that parameter combinations belonging
				// to the same property can be done sequencially 
				sort( rMapping.getArray(), rMapping.getArray() + rMapping.getLen(), 
					  isLessFieldMapping );
				aName = L"";
				Sequence<UString> aParameters;
			
				const AddressBookSourceSimpleDatabaseFieldMapping* pMap = 
					rMapping.getConstArray();
				vector<AddressBookParameteredProperty>   aProps;
				vector<AddressBookPropertyParameterInfo> aInfos;
				AddressBookPropertyParameterInfo aInfo;
			
				for( INT32 nPropPos = 0; nPropPos <= rMapping.getLen(); 
					 nPropPos++ )
				{
					const AddressBookSourceSimpleDatabaseFieldMapping& rMap = 
						pMap[ nPropPos ];
					XPropertySetRef xField;
					BOOL bRealProp = nPropPos != rMapping.getLen();
					if( bRealProp )
					{
						TRY
							{
								extractInterface( xFields->getByName( 
									rMap.DatabaseName ), xField );
							}
						CATCH( NoSuchElementException, e )
							{
							continue;
							}
						END_CATCH;
					}
					

					Sequence<UString> aNewParameters;
					if( bRealProp )
					{
						aNewParameters = rMap.Parameters;
						sort( aNewParameters.getArray(), 
								 aNewParameters.getArray() + aNewParameters.getLen(), isLess );
					}
					
					if( !bRealProp || aName != rMap.Name ||
						!isEqual( aParameters, aNewParameters ) )
					{
						// parameters or name changes -> next PropertyInfo
						if( aInfo.MaxCount != 0 ) 
						{
							aInfo.IsWritable = bUpdatable;
							
							if( aInfo.IsWritable ) aProperty.IsWritable = TRUE;
							
							INT32 nOldParCount = aProperty.Parameters.getLen();
							aProperty.Parameters.realloc( nOldParCount + aInfo.Parameters.getLen() );
							copy( aInfo.Parameters.getConstArray(), 
								  aInfo.Parameters.getConstArray() + aInfo.Parameters.getLen(),
								  aProperty.Parameters.getArray() + nOldParCount );
							inplace_merge( 
								aProperty.Parameters.getArray(),
								aProperty.Parameters.getArray() + nOldParCount,
								aProperty.Parameters.getArray() + 
								aProperty.Parameters.getLen(), isLess );
							aProperty.Parameters.realloc(
								unique(
									aProperty.Parameters.getArray(),
									aProperty.Parameters.getArray() +
									aProperty.Parameters.getLen(), 
									UStringEqual() ) -
								aProperty.Parameters.getArray() );
							
							aProperty.MaxCount += aInfo.MaxCount;
							aProperty.MinCount += aInfo.MinCount;
							aInfos.push_back( aInfo );
						}
						
						aInfo.MinCount = 0;
						aInfo.MaxCount = 0;
						aInfo.Parameters = aNewParameters;
						
						// property changes -> next property
						if( !bRealProp || aName != rMap.Name )
						{
							if( aName.len() )
							{
								// Name has changed so we have to append aProperty
								aProperty.Name = aName;
								copyContainerToSequence( 
									aInfos, aProperty.AllowedParameterCombinations );
								aProps.push_back( aProperty );
								aProperty.MinCount = 0;
								aProperty.MaxCount = 0;
								aProperty.IsWritable = FALSE;
								aInfos = vector<AddressBookPropertyParameterInfo>();
							}
							if( bRealProp ) aName = rMap.Name;
						}
					}
					
					if( !bRealProp ) continue;
					aInfo.MaxCount++;
					if( xField->getPropertyValue( L"IsRequired" ).getBOOL() )
						aInfo.MinCount++;
				}
				copyContainerToSequence( aProps, aSchema.m_Properties );
				aRet.push_back( 
					OObjectClass<OAddressBookSchemaData>::getInstance().
					getPropertyValues( &aSchema ) );
			}
			Sequence< Sequence< PropertyValue> > aRetSeq;
			copyContainerToSequence( aRet, aRetSeq );
			UsrAny aRetAny;
			aRetAny <<= aRetSeq;
			return aRetAny;
		}
		else if( m_aType == L"removeRecord" )
		{
			UString aUid;
			if( m_aArgs.getLen() != 1 || 
				!( m_aArgs.getConstArray()[ 0 ] >>= aUid ) )
				THROW( IllegalArgumentException() );

			OAddressBookSourceSimpleDatabaseData aData = m_xSource->getData();
			XDatabaseConnectionRef xCon = m_xSource->getConnection();
			if( !xCon.is() ) THROW( CantConnectException() );
			UniString aSql = L"delete from ";
			UString aSchema;
			UString aUBaseUid;
			OAddressBookSources::uidToSchemaAndBasisUid(
				aUid, aSchema, aUBaseUid );
			UniString aBaseUid( aUBaseUid );
			aBaseUid.SearchAndReplaceAll( L"\'", L"\\\'" );
			( aSql += aData.m_Table ) += L" where ";
			const AddressBookSourceSimpleDatabaseSchemaDefinition* pSchema = 
				aData.getSchemaDefinition( aSchema );
			if( !pSchema ) THROW( IllegalArgumentException() );
			const AddressBookSourceSimpleDatabaseFieldMapping* pField = 
				findField( *pSchema, L"Uid" );
			if( ! pField ) THROW( IllegalArgumentException() );
			(( aSql += pField->DatabaseName ) += L"=\'" ) += 
				aBaseUid;
			aSql += L"\'";
		
			m_xStatement = m_xSource->getConnection()->createStatement(
				UString( aSql ),FALSE );
			m_xStatement->execute();
			return UsrAny();
		}
		else if( m_aType == L"insertRecord" )
		{
			UString aSchema;
			Sequence<AddressBookParameteredPropertyValue> aValues;
			if( m_aArgs.getLen() != 2 || 
				!( pArr[ 0 ] >>= aSchema ) || !( pArr[ 1 ] >>= aValues ) )
				THROW( IllegalArgumentException() );

			OAddressBookSourceSimpleDatabaseData aData = m_xSource->getData();
			XDatabaseConnectionRef xCon = m_xSource->getConnection();
			if( !xCon.is() ) THROW( CantConnectException() );
		
			const AddressBookSourceSimpleDatabaseSchemaDefinition* pSchema = 
				aData.getSchemaDefinition( aSchema );
			Sequence<UString> aFields = getDatabaseNames( *pSchema );

			UniString aFieldsStr;
			const UString* pFields = aFields.getConstArray();
			const UString* pLast = pFields + aFields.getLen();
			INT32 nLen = aFields.getLen();
			if( nLen-- ) aFieldsStr = *pFields++;
			while( nLen-- ) ( aFieldsStr += L',' ) += *pFields++;
		
			UniString aSql = L"select ";
			( aSql += aFieldsStr ) += " from ";
			( aSql += aData.m_Table ) += L" where 1=0";

			m_xStatement = 
				m_xSource->getConnection()->createStatement(
					UString( aSql ), FALSE );
			XDatabaseCursorRef xCursor = m_xStatement->executeQuery( 
				DatabaseCursorType_KEYSET, DatabaseCursorOption_INSERTONLY );
			XDatabaseUpdateCursorRef xUpdate( xCursor, USR_QUERY );
			if( !xUpdate.is() ) THROW( IllegalArgumentException() );
			xUpdate->addRecord();
		
			AddressBookParameteredPropertyValue* pFirstValue = 
				aValues.getArray();
			AddressBookParameteredPropertyValue* pLastValue = 
				pFirstValue + aValues.getLen();
			AddressBookParameteredPropertyValue* pCur;
			for( pCur = pFirstValue; pCur != pLastValue; pCur++ )
				if( pCur->Name == L"Uid" ) break;
		
			// if we don't get a uid we have to generate one ourselves
			if( pCur == pLastValue || !pCur->Values.getLen())
			{
				Sequence<UString> aUids = m_xSource->getRecordContainer()->
					createUids( aSchema, 1 );
				aValues.realloc( aValues.getLen() + 1 );
				AddressBookParameteredPropertyValue& rValue = 
					aValues.getArray()[ aValues.getLen() - 1 ];
				rValue.Name = L"Uid";
				rValue.Values.realloc( 1 );
				rValue.Values.getArray()[ 0 ].Value <<= aUids.getConstArray()[ 0 ];
				pFirstValue = aValues.getArray();
				pLastValue = pFirstValue + aValues.getLen();
			}
			// if we do get one, wwe have to adjust it
			else
			{
				UsrAny& rAny = pCur->Values.getArray()[ 0 ].Value;
				UString aUid;
				if( rAny >>= aUid )
				{
					UString aSchema;
					UString aBasis;
					if( OAddressBookSources::uidToSchemaAndBasisUid( aUid, aSchema, aBasis ) )
						rAny <<= aBasis;
				}
			}
		
			updateRecord( xCursor, *pSchema, aValues );
			xUpdate->updateRecord();
			XComponentRef xComp( xCursor, USR_QUERY );
			xComp->dispose();
			return UsrAny();
		}
		else if( m_aType == L"updateRecord" )
		{
			UString aUid;
			Sequence<AddressBookParameteredPropertyValue> aValues;
			if( m_aArgs.getLen() != 2 || 
				!( pArr[ 0 ] >>= aUid ) || !( pArr[ 1 ] >>= aValues ) )
				THROW( IllegalArgumentException() );

			OAddressBookSourceSimpleDatabaseData aData = m_xSource->getData();
			XDatabaseConnectionRef xCon = m_xSource->getConnection();
			if( !xCon.is() ) THROW( CantConnectException() );
		
			UString aSchema;
			UString aUBaseUid;
			if( !OAddressBookSources::uidToSchemaAndBasisUid( aUid, aSchema, aUBaseUid ) )
				THROW( IllegalArgumentException() );
		
			const AddressBookSourceSimpleDatabaseSchemaDefinition* pSchema = 
				aData.getSchemaDefinition( aSchema );

			Sequence<UString> aFields = getDatabaseNames( *pSchema );

			UniString aFieldsStr;
			const UString* pFields = aFields.getConstArray();
			const UString* pLast = pFields + aFields.getLen();
			INT32 nLen = aFields.getLen();
			if( nLen-- ) aFieldsStr = *pFields++;
			while( nLen-- ) ( aFieldsStr += L',' ) += *pFields++;
		
			UniString aSql = L"select ";
			( aSql += aFieldsStr ) += " from ";
			( aSql += aData.m_Table ) += L" where ";
			aSql += findField( *pSchema, L"Uid" )->DatabaseName;
			aSql += L"=\'";
			UniString aBaseUid( aUBaseUid );
			aBaseUid.SearchAndReplaceAll( L"\'", L"\\\'" );
			( aSql += aBaseUid ) += L'\'';
		
			m_xStatement =
				m_xSource->getConnection()->createStatement(
					UString( aSql ), FALSE );
			XDatabaseCursorRef xCursor = m_xStatement->executeQuery( 
				DatabaseCursorType_KEYSET, DatabaseCursorOption_UPDATABLE );
			XDatabaseUpdateCursorRef xUpdate( xCursor, USR_QUERY );
			if( !xUpdate.is() ) THROW( IllegalArgumentException() );
			if( !xCursor->isValid() )
				THROW( IllegalArgumentException() );
			xUpdate->editRecord();

			UString aOldUid;
			const AddressBookSourceSimpleDatabaseFieldMapping* pField = 
				findField( *pSchema, L"Uid" );
			xCursor->getRecord()->getPropertyValue( 
				pField->DatabaseName ) >>= aOldUid;

			updateRecord( xCursor, *pSchema, aValues );
		
			if( aOldUid != UString( aBaseUid ) ) THROW( IllegalArgumentException() );
			xUpdate->updateRecord();
			XComponentRef xComp( xCursor, USR_QUERY );
			xComp->dispose();
			return UsrAny();
		}
		else if( m_aType == L"createUids" )
		{
			UString aSchema;
			INT32   nCount;
			if( m_aArgs.getLen() != 2 || !( pArr[ 0 ] >>= aSchema  ) )
				THROW( IllegalArgumentException() );
			nCount = OPropertyTypeConversion::toINT32( pArr[ 1 ] );

			Sequence<UString> aRet( nCount );
			UString* pRet = aRet.getArray();
			UniString aUid;
			while( nCount-- )
			{
				static long nNr = 0;
				String aSubUid = Time::GetSystemTicks();
				((( aSubUid += '/' ) += rand() ) += '/' ) += nNr++;
				aUid += SHOULDBEUNICODE( aSubUid );
				pRet[ nCount ] = OAddressBookSources::schemaAndBasisUidToUid( 
					aSchema, UString( aUid ) );
			}
			UsrAny aAny;
			aAny <<= aRet;
			return aAny;
		}
		else if( m_aType == L"getProperties" )
		{
			UsrAny aAny;
			aAny <<= Sequence<PropertyValue>();
			return aAny;
		}
		THROW( IllegalArgumentException() );
	}
	CATCH( DatabaseDetailedException, e )
	{
		if( e.ExceptionContext == DatabaseExceptionContext_SYNTAX )
		{
			THROW( IllegalArgumentException() );
		}
		else THROW( CantConnectException() );
	}
	AND_CATCH( DatabaseException, e )
	{
		THROW( CantConnectException() );
	}
	END_CATCH;
	return UsrAny();
}

void OAddressBookSourceSimpleDatabaseSynchronJob::cancel()
{
	XCancellableRef xCancel( m_xStatement, USR_QUERY );
	if( xCancel.is() ) xCancel->cancel();
}

//////////////////////////////////////////////////////////

OAddressBookSourceSimpleDatabaseQueryJob::OAddressBookSourceSimpleDatabaseQueryJob( 
	const XMultiServiceFactoryRef& xMgr, 
	const OAddressBookSourceSimpleDatabaseRef& xSource, 
	const UString& rType, const Sequence<UsrAny>& rArgs )
	: m_xMgr( xMgr ), m_xSource( xSource ), m_aArgs( rArgs ), m_aType( rType ), m_bCanceled( FALSE )
{
}

XIdlClassRef OAddressBookSourceSimpleDatabaseQueryJob::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"stardiv.one.address.OAddressBookSourceSimpleDatabaseQueryJob", 
		UsrObject::getUsrObjectIdlClass(), 2,
		XCancellable_getReflection(),
		XAsynchronJob_getReflection() );
	return xClass;
}

Sequence<XIdlClassRef>	OAddressBookSourceSimpleDatabaseQueryJob::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OAddressBookSourceSimpleDatabaseQueryJob::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XJob );
	QUERYIFACE( XAsynchronJob );
	QUERYIFACE( XCancellable );
	return UsrObject::queryInterface( aUik, rOut );
}

void OAddressBookSourceSimpleDatabaseQueryJob::buildQueries( 
	const AddressBookSourceSimpleDatabaseSchemaDefinition& rDef,
	UniString& rQuery, const AddressBookQueryTerm& rTerm )
{
	switch( rTerm.Function )
	{
		// all functions that operate on a field have to be replicated into
		// n filters corresponding to the db fields the property is mapped onto
		case AddressBookQueryFunction_PRESENT:
		case AddressBookQueryFunction_EQUALITYMATCH:
		case AddressBookQueryFunction_SUBSTRINGS:
		case AddressBookQueryFunction_APPROXMATCH:
		case AddressBookQueryFunction_LESSOREQUAL:
		case AddressBookQueryFunction_GREATEROREQUAL:
		{
			AddressBookQueryTerm aTerm( rTerm );
			UsrAny* pArgs = aTerm.Arguments.getArray();
			UString aField;
			if( !(*pArgs >>= aField ) ) THROW( IllegalArgumentException() );
			
			if( rTerm.Function == AddressBookQueryFunction_EQUALITYMATCH &&
				aField == L"Uid" )
			{
				UString aValue;
				pArgs[ 1 ] >>= aValue;
				UString aSchema, aBasisUid;
				OAddressBookSources::uidToSchemaAndBasisUid( aValue, aSchema, aBasisUid );
				pArgs[ 1 ] <<= aBasisUid;
			}
			
			vector<UString> aMappings;
			const AddressBookSourceSimpleDatabaseFieldMapping* pBegin = rDef.FieldMappings.getConstArray();
			const AddressBookSourceSimpleDatabaseFieldMapping* pEnd = pBegin + rDef.FieldMappings.getLen();

			for( ;pBegin != pEnd; pBegin++ )
				if( pBegin->Name == aField ) aMappings.push_back( pBegin->DatabaseName );
			// if the addressbook property maps to only one ldap field, create one filter
			// if it does not map, this term is always false
			if( !aMappings.size() )
				rQuery += L"( 1 = 0 )";
			else if( aMappings.size() == 1 )
			{
				buildQuery( 
					rDef, rQuery, aMappings.size() == 0 ? 
					aField : aMappings[ 0 ], aTerm );
			}
			else
			{
				UniString aTerms;
				for( vector<UString>::const_iterator aIter = aMappings.begin();
					 aIter != aMappings.end(); aIter++ )
				{
					if( aTerms.Len() ) aTerms += L" OR ";
					buildQuery( rDef, aTerms, *aIter, rTerm );
					((rQuery += L'(' ) += aTerms ) += L") ";
				}
			}
			break;
		}
		default:
			buildQuery( rDef, rQuery, L"", rTerm );
	}

}

UString OAddressBookSourceSimpleDatabaseQueryJob::getQueryStringFromAny( 
	const UsrAny& rAny )
{
	UString aRet;
	if( rAny >>= aRet )
	{
		UniString aTmp( aRet );
		aTmp.SearchAndReplaceAll( L"\'", L"\\\'" );
		UniString aResult = L'\'';
		( aResult += aTmp ) += L'\'';
		aRet = aResult;
	}
	return aRet;
}


//Marker
void OAddressBookSourceSimpleDatabaseQueryJob::buildQuery( 
	const AddressBookSourceSimpleDatabaseSchemaDefinition& rDef,
	UniString& rQuery, const UString& rField, const AddressBookQueryTerm& aTerm )
{
	const UsrAny* pArgs = aTerm.Arguments.getConstArray();
	switch(aTerm.Function)
	{
		case AddressBookQueryFunction_AND:
		{
			AddressBookQueryTerm aTerm;
			UniString aQuery;
			for(INT32 i=0;i<aTerm.Arguments.getLen();++i)
			{
				if( pArgs[ i ] >>= aTerm )
				{
					if( aQuery.Len() ) aQuery += L" AND ";
					buildQueries( rDef, rQuery, aTerm );
				}
			}
			(( rQuery += L" ( " ) += aQuery ) += L" ) ";
			break;
		}
		case AddressBookQueryFunction_OR:
		{
			AddressBookQueryTerm aTerm;
			UniString aQuery;
			for(INT32 i=0;i<aTerm.Arguments.getLen();++i)
			{
				if( pArgs[ i ] >>= aTerm )
				{
					if( aQuery.Len() ) aQuery += L" OR ";
					buildQueries( rDef, rQuery, aTerm );
				}
			}
			(( rQuery += L" ( " ) += aQuery ) += L" ) ";
			break;
		}
		case AddressBookQueryFunction_NOT:
		{
			rQuery += L" not ( ";
			buildQueries( rDef, rQuery, aTerm );
			rQuery += ") ";
			break;
		}
		case AddressBookQueryFunction_SUBSTRINGS:
		{
			INT32 nLen = aTerm.Arguments.getLen();
			UniString aValue;
			UString aStr;
			for( INT32 i = 1; i<aTerm.Arguments.getLen() - 1; i++ )
			{
				pArgs[ i ] >>= aStr;
				( aValue += aStr ) += L'%';
			}
			pArgs[ i ] >>= aStr;
			aValue += aStr;
			aStr = getQueryStringFromAny( UsrAny( UString( aValue ) ) );
			(( rQuery += rField ) += L" like " ) += aStr;
			break;
		}
		case AddressBookQueryFunction_APPROXMATCH:
		case AddressBookQueryFunction_EQUALITYMATCH:
		{
			UString aValue = getQueryStringFromAny( pArgs[ 1 ] );
			(( rQuery += rField ) += L'=' ) += aValue;
			break;
		}
		case AddressBookQueryFunction_GREATEROREQUAL:
		{
			UString aValue = getQueryStringFromAny( pArgs[ 1 ] );
			(( rQuery += rField ) += L">=" ) += aValue;
			break;
		}
		case AddressBookQueryFunction_LESSOREQUAL:
		{
			UString aValue = getQueryStringFromAny( pArgs[ 1 ] );
			(( rQuery += rField ) += L"<=" ) += aValue;
			break;
		}
		case AddressBookQueryFunction_PRESENT:
		{
			(( rQuery += rField ) += L"=\'%\'" ) += L' ';
			break;
		}
	}
}

void OAddressBookSourceSimpleDatabaseQueryJob::cancel()
{
	m_bCanceled = TRUE;
	XCancellableRef xCancel( m_xStatement, USR_QUERY );
	if( xCancel.is() ) xCancel->cancel();
}

void OAddressBookSourceSimpleDatabaseQueryJob::executeAsynchron( 
	const XJobListenerRef& xCallback )
{
	TRY
	{
		if( m_aType == L"query" )
		{
			Sequence<UString> aProperties;
			UString aQuery;
			Sequence<AddressBookSortInfo> aSortInfo;
			Sequence<UString> aSchemata;
			const UsrAny* pArgs = m_aArgs.getConstArray();
			if( !(pArgs[ 0 ] >>= aProperties ) ||
				!(pArgs[ 1 ] >>= aQuery ) ||
				!(pArgs[ 2 ] >>= aSortInfo ) ||
				!(pArgs[ 3 ] >>= aSchemata ) )
				THROW( IllegalArgumentException() );

			// no schemata is all schemata
			OAddressBookSourceSimpleDatabaseData aData = m_xSource->getData();
			if( !aSchemata.getLen() ) 
			{
				aSchemata.realloc( aData.m_Schemata.getLen() );
				UString* pSchemata = aSchemata.getArray();
				const AddressBookSourceSimpleDatabaseSchemaDefinition* pFirst = 
					aData.m_Schemata.getConstArray();
				const AddressBookSourceSimpleDatabaseSchemaDefinition* pLast = 
					pFirst + aData.m_Schemata.getLen();
				for( ;pFirst!= pLast; pFirst++ )
					*pSchemata++ = pFirst->Name;
			}
			VOS_ENSHURE( 
				aSchemata.getLen() == 1, "more than one schema not yet supported" );

			// sorting can be done by the db if and only if every sorting field
			// touches only one db field
			BOOL bSortOnServer = TRUE;
			const AddressBookSortInfo* pFirstInfo = aSortInfo.getConstArray();
			const AddressBookSortInfo* pLastInfo = pFirstInfo + aSortInfo.getLen();
			for( ;pFirstInfo != pLastInfo && bSortOnServer; pFirstInfo++ )
			{
				const AddressBookSourceSimpleDatabaseSchemaDefinition* pFirst = 
					aData.m_Schemata.getConstArray();
				const AddressBookSourceSimpleDatabaseSchemaDefinition* pLast = 
					pFirst + aData.m_Schemata.getLen();
				for( ;pFirst!= pLast; pFirst++ )
				{
					const AddressBookSourceSimpleDatabaseFieldMapping* pFirstMap = 
						pFirst->FieldMappings.getConstArray();
					const AddressBookSourceSimpleDatabaseFieldMapping* pLastMap = 
						pFirstMap + pFirst->FieldMappings.getLen();
					vector<UString> aFields;
					for(;pLastMap!= pFirstMap; pFirstMap++ )
						aFields.push_back( pFirstMap->Name );
					sort( aFields.begin(), aFields.end(), isLess );
					pair<vector<UString>::iterator,vector<UString>::iterator> aPair = 
						equal_range( aFields.begin(), aFields.end(), pFirstInfo->Property,
									 isLess );
					if( aPair.first != aPair.second && 
						++aPair.first != aPair.second )
					{
						bSortOnServer = FALSE;
						break;
					}
				}
			}
		
			OResultSet* pResultSet = 0;
			if( !bSortOnServer )
				pResultSet = new OResultSet( aSortInfo );
		
			const AddressBookSourceSimpleDatabaseSchemaDefinition* pCur = 
				aData.m_Schemata.getConstArray();
			UniString aSql(L"SELECT ");
		
			// select columns
			// collect all requested props
			const AddressBookSourceSimpleDatabaseFieldMapping* pBegin = 
				pCur->FieldMappings.getConstArray();
			const AddressBookSourceSimpleDatabaseFieldMapping* pEnd = 
				pBegin + pCur->FieldMappings.getLen();
			UString* pFirstProp = aProperties.getArray();
			UString* pLastProp = pFirstProp + aProperties.getLen();
			sort( pFirstProp, pLastProp, isLess );
			UniString aCols;
			for( ;pBegin != pEnd; pBegin++ ) 
			{
				pair< UString*, UString*> aPair;
				aPair = equal_range( 
					pFirstProp, pLastProp, pBegin->Name, isLess );
				if( aPair.first != aPair.second )
				{
					if( aCols.Len() ) aCols+=L',';
					aCols += pBegin->DatabaseName;
				}
			}
		
			aSql += aCols;
		
			// from clause
			( aSql += L" FROM " ) += aData.m_Table;
		
			if( aQuery.len() )
			{
				XAddressBookQueryParserRef xParser( 
					m_xMgr->createInstance(L"stardiv.one.address.AddressBookQueryParser"),
					USR_QUERY);
				AddressBookQueryTerm aTerm = xParser->parseTerm( aQuery );
				// where condition
				UniString aQuery;
				buildQueries( *pCur, aQuery, aTerm );
				if( aQuery.Len() )
					( aSql += L" WHERE " ) += aQuery;
			}
		
			if( bSortOnServer )
			{
				INT32 nLen = aSortInfo.getLen() ;
				UniString aSorting;
				if( nLen )
				{
					const AddressBookSortInfo* pSort = aSortInfo.getConstArray();
					for( INT32 i=0; i<nLen; i++)
					{
						UString aFieldName;
						TRY
							{
								aFieldName = mapToDBFieldName( *pCur, pSort[i].Property );
								if( aSorting.Len() ) aSorting += L',';
								( aSorting += aFieldName ) +=
									pSort[i].Ascending ? L" ASC " : L" DESC ";
							}
						CATCH( NoSuchElementException, e )
							{
							}
						END_CATCH;
					}
				}
				if( aSorting.Len() ) ( aSql += L" ORDER BY " ) += aSorting;
			}
		
			XDatabaseCursorRef xCursor;

			XDatabaseConnectionRef xCon = m_xSource->getConnection();
			if( !xCon.is() ) THROW( CantConnectException() );
			m_xStatement = m_xSource->getConnection()->createStatement(
				UString( aSql ),FALSE ) ;
			xCursor =  m_xStatement->executeQuery( 
				DatabaseCursorType_FORWARD, DatabaseCursorOption_READONLY );
			// extract data
			XPropertySetRef xRecord = xCursor->getRecord();
			Sequence<Property> aFields = xRecord->getPropertySetInfo()->getProperties();
			INT32 nCount = aFields.getLen();
			const Property* pFields = aFields.getConstArray();


			XNameContainerRef xTables = xCon->getTables();
			XPropertySetRef xTable;
			TRY
			{
				extractInterface( 
					xTables->getByName( aData.m_Table ), xTable );
			}
			CATCH( NoSuchElementException, e )
			{
			}
			END_CATCH;
				
			if( !xTable.is() ) THROW( IllegalArgumentException() );
			
			short nPrivs = 0;
			xTable->getPropertyValue( L"Priviliges" ) >>= nPrivs;
			BOOL bUpdatable = !!(nPrivs & DatabasePrivilige_UPDATE_DATA );
			BOOL bRemovable = !!(nPrivs & DatabasePrivilige_DELETE_DATA );
			
			XNameAccessRef xFields( xCursor->getRecord(), USR_QUERY );
			while( !m_bCanceled && xCursor->isValid() )
			{
				ORecord aRecord;
				UString aUid;
				aRecord.m_SchemaName = pCur->Name;
				aRecord.m_IsRemovable = bRemovable;
			
				vector<AddressBookParameteredPropertyValue>  aValues;
				AddressBookParameteredPropertyValue  aValue;
				Sequence<AddressBookParameteredValue>* pSequence;
			
				aValue.Type = OUString_getReflection()->getIdlClass();
				aValue.IsWritable = bUpdatable;
				
				XAddressBookSchemataSupplierRef xSup(
					m_xSource->getRecordContainer(), USR_QUERY );
				UsrAny aProps = xSup->getSchemata()->getByName(
					pCur->Name );
				XPropertySetRef xProp;
				if( !(aProps >>= xProp ) ) THROW( RuntimeException() );
				aProps = xProp->getPropertyValue( L"Properties" );
				if( aProps.getReflection() != 
					Sequence<AddressBookParameteredProperty>::getReflection() )
					THROW( IllegalArgumentException() );
				const Sequence<AddressBookParameteredProperty>& aSchemaFields = 
					*(const Sequence<AddressBookParameteredProperty>*)
					aProps.get();
			
				AddressBookParameteredValue aPMValue;
				INT32 i;
				UsrAny aAny;
				// consider all db properties
				for ( i = 0; i < nCount; ++i )
				{
					aAny = xRecord->getPropertyValue( pFields[ i ].Name );
				
					const AddressBookSourceSimpleDatabaseSchemaDefinition* pSchemaDefinition = 
						aData.getSchemaDefinition( pCur->Name );
					INT32 nLen = pCur->FieldMappings.getLen();
					const AddressBookSourceSimpleDatabaseFieldMapping* pSchemaFields = 
						pCur->FieldMappings.getConstArray();
				
					// find corresponding addressbook field
					for( INT32 nPos = 0; nPos < nLen; nPos++ )
					{
						if( pSchemaFields[ nPos ].DatabaseName == pFields[ i ].Name )
						{
							aValue.Name = pSchemaFields[ nPos ].Name;
							// if we already have a property with this name, use it
							pSequence = 0;
							for( vector<AddressBookParameteredPropertyValue>::iterator 
									 aIter = aValues.begin();
								 aIter != aValues.end(); aIter++ )
								if( (*aIter).Name == aValue.Name )
								{
									pSequence = &(*aIter).Values;
									break;
								}
							if( !pSequence )
							{
								// copy property definition to property
								const AddressBookParameteredProperty* pParProp = 
									aSchemaFields.getConstArray();
								for( INT32 nPos = aSchemaFields.getLen(); nPos--; )
									if( pParProp[ nPos ].Name == aValue.Name )
									{
										aValue.AddressBookParameteredProperty::operator=(
											pParProp[ nPos ] );
										break;
									}
							
								aValues.push_back( aValue );
								pSequence = &aValues.back().Values;
							}
							aPMValue.Parameters = pSchemaFields[ nPos ].Parameters;
							// append value to the sequence in the propertyvalue
							INT32 nLen = pSequence->getLen();
							pSequence->realloc( nLen + 1 );
							//! Type conversion
							aPMValue.Value = 
								OAddressBookSourceSimpleDatabase::
								getPropertyFromAny(
									pSchemaDefinition->Name,
									pSchemaFields[ nPos ], aAny );
							pSequence->getArray()[ nLen ] = aPMValue;
						}
					}
				}
				// copy values to sequence
				sort( aValues.begin(), aValues.end(), isLessProperty );
				copyContainerToSequence( aValues, aRecord.m_Values );
			
				if( pResultSet ) pResultSet->appendRecord( aRecord);
				else
				{
					JobEvent aEvent;
					aEvent.Source = *this;
					aEvent.Type = JobEventType_DATA;
					aEvent.Data <<= 
						OObjectClass<ORecord>::getInstance().getPropertyValues(
							&aRecord );
					xCallback->updateJobState( aEvent );
				}
				xCursor->moveRelative( 1 );
			}
			if( pResultSet )
			{
				pResultSet->getRecords().sort();
				JobEvent aEvent;
				aEvent.Source = *this;
				aEvent.Type = JobEventType_DATA;
				for( list<ORecord>::iterator aIter = pResultSet->getRecords().begin();
					 aIter != pResultSet->getRecords().end(); aIter++ )
				{
					aEvent.Data <<= OObjectClass<ORecord>::getInstance().getPropertyValues(
						&*aIter );
					xCallback->updateJobState( aEvent );
				}
				delete pResultSet;
			}
			JobEvent aEvent;
			aEvent.Source = *this;
			aEvent.Type = JobEventType_DONE;
			xCallback->updateJobState( aEvent );
			XComponentRef xComp( xCursor, USR_QUERY );
			xComp->dispose();
		}
	}
	CATCH( DatabaseDetailedException, e )
	{
		if( e.ExceptionContext == DatabaseExceptionContext_SYNTAX )
		{
			THROW( IllegalArgumentException() );
		}
		else THROW( CantConnectException() );
	}
	AND_CATCH( DatabaseException, e )
	{
		THROW( CantConnectException() );
	}
	END_CATCH;
	if( m_bCanceled ) 
	{
		JobEvent aEvent;
		aEvent.Source = *this;
		aEvent.Type = JobEventType_ERROR;
		aEvent.Data <<= CancelledException();
		xCallback->updateJobState( aEvent );
	}
}
	

