/*************************************************************************
 *
 *  $RCSfile: adrview.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "adr.hrc"
#include "adrcont.hxx"
#include "adrbeam.hxx"
#include "adrmod.hxx"
#include "general.hxx"
#include "busiaddr.hxx"
#include "privaddr.hxx"
#include "busiphon.hxx"
#include "privdata.hxx"
#include "adrview.hxx"
#include "datman.hxx"
#include "adrresid.hxx"
#include "adrmod.hxx"
#include "sections.hrc"
#include "viewsect.hxx"
#include "adrsect.hxx"

#ifndef _TOOLS_DEBUG_HXX //autogen wg. DBG_ASSERT
#include <tools/debug.hxx>
#endif

UString	gSectionSizes(L"TheSectionSizes");
UString	gSectionNames(L"TheSectionNames");
UString	gSectionExpander(L"TheSectionExpander");
UString	gSectionPos(L"TheSectionPosition");

#define LSTR_PRIVAT  L"Private"
#define LSTR_BUSINESS  L"Business"
#define LSTR_COMPANY L"Company"
#define LSTR_ADDRESS L"Address"
#define LSTR_PHONE   L"Telephone"
#define LSTR_PHONE   L"Telephone"

#define DEFAULT_SIZE 200

// -----------------------------------------------------------------------
AdrView::AdrView(Window* pParent, AdrDataManagerHdl ppDM, WinBits nStyle):
		SvSectionControl(pParent,nStyle),
		ppDatMan(ppDM),
		nSectionCount(1),
		nDefNameCount(0)
{
		String aDefName(AdrResId(RID_ADR_STR_SECTION));
		aDefaultName=S2U(aDefName);
		if(ppDatMan!=NULL)
		{
			AdrDataManagerPtr pDatMan = *ppDatMan;
			if(pDatMan)
			{
				pDatMan->SetUpdateHdl(LINK( this, AdrView, UpdateHdl) );
				pDatMan->SetAdrSourceChangedHdl( LINK( this, AdrView, SourceChangedHdl) );
				pDatMan->SetAdrSourceRefreshHdl( LINK( this, AdrView, SourceRefreshHdl) );
				pDatMan->SetAdrSourceSaveHdl( LINK( this, AdrView, SourceSaveHdl) );
			}
		}
//		SetPaintTransparent(TRUE);
//		SetBackground();
		InitPages();
		ConfigPages();
}

AdrView::~AdrView()
{
	nSectionCount=GetSectionCount();
	
	for(long i=nSectionCount-1; i >=0 ;i--)
	{
		USHORT nId = GetSectionId(i);
		SvSection* pSection=GetSection(nId );
		if(pSection!=NULL)
		{
			Window*	pChildWin=(Window *)pSection->GetChildWin();
			pSection->SetChildWin(NULL);
			delete pChildWin;
			RemoveSection(nId);
			delete pSection;
		}
	}
}

void AdrView::InitPages()
{
	TRY
	{
		ULONG nId = 1;
		UString aStrPrivat(LSTR_PRIVAT);
		UString aStrBusiness(LSTR_BUSINESS);
		UString aStrEmpty;
		
		
		NewSection(nId++,CreateGeneralPage( this, ppDatMan)             );
		NewSection(nId++,CreateBusinessAddress( this, ppDatMan)         );
		NewSection(nId++,CreatePhonePage( this, ppDatMan,aStrBusiness)  );
		NewSection(nId++,CreatePrivatAddress( this, ppDatMan,aStrPrivat));
		NewSection(nId++,CreatePhonePage( this, ppDatMan,aStrPrivat)    );
		NewSection(nId++,CreatePrivatAddress( this, ppDatMan,aStrEmpty) );
		NewSection(nId++,CreatePhonePage( this, ppDatMan,aStrEmpty)     );
		NewSection(nId++,CreatePrivatData( this, ppDatMan)              );

		USHORT	nCount = GetSectionCount();			
		
		long nMaxWidth = 0;
		USHORT nPos;
		for(nPos = 0; nPos < nCount; nPos++)
		{
			USHORT nId=GetSectionId(nPos );
			SvSection* pSection = GetSection(nId);
			AdrBasePage* pPage = (AdrBasePage*) pSection->GetChildWin();
			if(pPage)
			{
				long nWidth = pPage->GetMaxFixTextWidth();
				if(nWidth > nMaxWidth)
					nMaxWidth = nWidth;
			}
		}

		for(nPos = 0; nPos < nCount; nPos++)
		{
			USHORT nId=GetSectionId(nPos );
			SvSection* pSection = GetSection(nId);
			pSection->SetMinWidth(6 * nMaxWidth);

			AdrBasePage* pPage = (AdrBasePage*) pSection->GetChildWin();
			if(pPage)
			{
				pPage->InitPage();
				pPage->SetFixTextWidth(nMaxWidth);
				((Window*)pSection)->Resize();
			}
		}
		Resize();
	}
	CATCH_ALL()
	{
		DBG_ERROR("::InitPages: something went wrong !");
	}
	END_CATCH
}

void AdrView::SavePageInfo()
{
	TRY
	{
		UsrAny aNameAny;
		UsrAny aSizeAny;
		UsrAny aExpandedAny;
		UsrAny aPosAny;

		nSectionCount=GetSectionCount();
		Sequence<UString> aNameSeq(nSectionCount);
		Sequence<INT32> aSizeSeq(nSectionCount);
		Sequence<INT32> aExpandedSeq(nSectionCount);
		Sequence<INT32> aPosSeq(nSectionCount);
		
		UString* pName = aNameSeq.getArray();
		INT32* pSize = aSizeSeq.getArray();
		INT32* pExpanded = aExpandedSeq.getArray();
		INT32* pPos = aPosSeq.getArray();



		for(USHORT i=0; i < nSectionCount;i++)
		{
			USHORT nId = GetSectionId(i);
			SvSection*	pSection=GetSection(nId);
			pName[i]=S2U(GetSectionText(nId));
			pExpanded[i]=pSection->IsExpanded();

			if(!pExpanded[i])
			{
				pSection->ExpandSection();
			}
			pSize[i]=GetSectionSize(nId);
			pPos[i]=GetSectionPos(nId);
		}

		aNameAny.set(&aNameSeq, Sequence<UString>::getReflection());
		aSizeAny.set(&aSizeSeq, Sequence<INT32>::getReflection());
		aExpandedAny.set(&aExpandedSeq, Sequence<INT32>::getReflection());
		aPosAny.set(&aPosSeq, Sequence<INT32>::getReflection());
		xViewSet->setPropertyValue(gSectionNames, aNameAny);
		xViewSet->setPropertyValue(gSectionSizes, aSizeAny);
		xViewSet->setPropertyValue(gSectionExpander, aExpandedAny);
		xViewSet->setPropertyValue(gSectionPos, aPosAny);

	}
	CATCH_ALL()
	{
		DBG_ERROR("::SavePageInfo: something went wrong !");
	}
	END_CATCH
}

long AdrView::PreNotify( NotifyEvent& rNEvt )
{	
/*
	if(rNEvt.GetType() == EVENT_COMMAND)
	{
		const CommandEvent* pCEvt = rNEvt.GetCommandEvent();
		if(pCEvt->GetCommand() == COMMAND_CONTEXTMENU && pCEvt->IsMouseEvent())
		{
			PopupMenu aPopup(AdrResId(RID_POPUP_ME_VIEW));

			Point aPos=GetPointerPosPixel();
			//Point aPos=pCEvt->GetMousePosPixel();
			USHORT nId=GetSectionId(aPos);
			if(nId==0)
			{
				aPopup.EnableItem(PU_REMOVE,FALSE);
				aPopup.EnableItem(PU_CHG_NAME,FALSE);
			}
			
			USHORT nCommand=aPopup.Execute(
						OutputToScreenPixel(aPos));

			if(nCommand==PU_REMOVE) 
			{
				DelSection(nId);
			}
			else if(nCommand==PU_INSERT) 
			{
				USHORT nPos(SECTION_APPEND);
				if(nId!=0)
					nPos = GetSectionPos(nId);

				NewSection(nPos);
			}
			
			return TRUE;
		}
	}
 */
	return SvSectionControl::PreNotify(rNEvt );
}

void AdrView::ConfigPages()
{
	TRY
	{	
		if(ppDatMan!=NULL && *ppDatMan!=NULL)
		{
			AdrDataManagerPtr pDatMan = *ppDatMan;

			xViewSet=pDatMan->getViewProperties();

			nSectionCount = GetSectionCount();
			INT32 nNameCount = 0;
			Sequence<UString>	aNameSeq;
			Sequence<INT32>		aSizeSeq;
			Sequence<INT32>		aExpandedSeq;
			Sequence<INT32>		aPosSeq;
			
			UsrAny aNameAny		= xViewSet->getPropertyValue(gSectionNames);
			UsrAny aSizeAny		= xViewSet->getPropertyValue(gSectionSizes);
			UsrAny aExpandedAny	= xViewSet->getPropertyValue(gSectionExpander);
			UsrAny aPosAny		= xViewSet->getPropertyValue(gSectionPos);
			
			if(aNameAny.getReflection()->equals(*Sequence<UString>::getReflection()))
			{
				aNameSeq=*(Sequence<UString>*)aNameAny.get();
				nNameCount=aNameSeq.getLen();
			}
			else
			{
				nNameCount=1;
				Sequence<UString> a2NameSeq(1);
				aNameSeq=a2NameSeq;
				UString* pNameSeq = aNameSeq.getArray();
				
				for(INT32 i=0; i < nNameCount; i++)
				{
					nDefNameCount++;
					pNameSeq[i]=aDefaultName + S2U(String(nDefNameCount));
				}
			}		
			
			if(aSizeAny.getReflection()->equals(*Sequence<INT32>::getReflection()))
			{
				aSizeSeq=*(Sequence<INT32>*)aSizeAny.get();
			}
			else
			{
				Sequence<INT32> a2SizeSeq(nNameCount);
				aSizeSeq=a2SizeSeq;
				INT32* pSize = aSizeSeq.getArray();
				for(INT32 i=0; i < nNameCount; i++)
					pSize[i]=400;
			}		
			
			if(aExpandedAny.getReflection()->equals(*Sequence<INT32>::getReflection()))
			{
				aExpandedSeq=*(Sequence<INT32>*)aExpandedAny.get();
			}
			else
			{
				Sequence<INT32> a2Seq(nNameCount);
				aExpandedSeq=a2Seq;
				INT32* pExpanded = aExpandedSeq.getArray();
				for(INT32 i=0; i < nNameCount; i++)
					pExpanded[i]=TRUE;
			}		

			if(aPosAny.getReflection()->equals(*Sequence<INT32>::getReflection()))
			{
				aPosSeq=*(Sequence<INT32>*)aPosAny.get();
			}
			else
			{
				Sequence<INT32> a2Seq(nNameCount);
				aPosSeq=a2Seq;
				INT32* pPos = aPosSeq.getArray();
				for(INT32 i=0; i < nNameCount; i++)
					pPos[i]=0;
			}

			const UString* pName = aNameSeq.getConstArray();
			const INT32* pSize = aSizeSeq.getConstArray();
			const INT32* pExpanded = aExpandedSeq.getConstArray();
			const INT32* pPos = aPosSeq.getConstArray();
			
			for(INT32 i=0; i< nNameCount;i++)
			{
				WSString aSectName=U2S(pName[i]);

				for(INT32 j=0; j< nSectionCount;j++)
				{
					USHORT nId = GetSectionId(j);
					if(aSectName == GetSectionText(nId))
					{
	 					SvSection*	pSection=GetSection(nId);

						long nMinWidth=0;

						const Window* pWin=pSection->GetChildWin();
						nMinWidth=pWin->GetSizePixel().Width();
						
						//pSection->SetMinWidth(nMinWidth);

						SetSectionSize(nId,pSize[i]);

						if(pExpanded[i])
						{
							pSection->ExpandSection();
						}
						else
						{
							pSection->ShrinkSection();
						}
						break;
					}
				}
			}
		}
	}
	CATCH_ALL()
	{
		DBG_ERROR("::ConfigPages: something went wrong !");
	}
	END_CATCH

	Resize();
	
}


void AdrView::NewSection(ULONG nId,AdrBasePage* pPage )
{
	if(pPage != NULL)
	{
		AdrSection*	pSection=new AdrSection(pPage->GetText() , this);
		pSection->SetChildWin(pPage);
		Size aSize=pPage->GetSizePixel();
		InsertSection( nId,pSection,aSize.Height(), SECTION_APPEND);
	}
}

void AdrView::DelSection(USHORT nID)
{
	SvSection* pSection=GetSection(nID);
	if(pSection!=NULL)
	{
		Window*	pChildWin=(Window *)pSection->GetChildWin();
		pSection->SetChildWin(NULL);
		delete pChildWin;
		RemoveSection(nID);
		delete pSection;
	}
}

IMPL_LINK( AdrView, SourceSaveHdl, AdrDataManager*, pPtr )
{
	if(ppDatMan !=NULL && pPtr==*ppDatMan)
	{
		INT32 nCount=GetSectionCount();

		USHORT i;
		for(i=0; i < nCount;i++)
		{
			USHORT nId = GetSectionId(i);
			SvSection*	pSection=GetSection(nId);
			AdrBasePage* pChild = (AdrBasePage* ) pSection->GetChildWin();
			pChild -> SaveFields();
		}
	}

	return 0;
}


IMPL_LINK( AdrView, UpdateHdl, AdrDataManager*, pPtr )
{
	if(ppDatMan !=NULL && pPtr==*ppDatMan)
	{
		INT32 nCount=GetSectionCount();

		USHORT i;
		for(i=0; i < nCount;i++)
		{
			USHORT nId = GetSectionId(i);
			SvSection*	pSection=GetSection(nId);
			AdrBasePage* pChild = (AdrBasePage* ) pSection->GetChildWin();
			pChild -> UpdateData();
		}

		for(i=0; i < nCount;i++)
		{
			USHORT nId = GetSectionId(i);
			SvSection*	pSection=GetSection(nId);
			AdrBasePage* pChild = (AdrBasePage* ) pSection->GetChildWin();
			pChild -> GenerateFields();
		}

		for(i=0; i < nCount;i++)
		{
			USHORT nId = GetSectionId(i);
			SvSection*	pSection=GetSection(nId);
			AdrBasePage* pChild = (AdrBasePage* ) pSection->GetChildWin();
			pChild -> RefreshFields();
		}
	}
	return 0;
}

IMPL_LINK( AdrView, SourceChangedHdl, AdrDataManager*, pPtr )
{
	if(ppDatMan !=NULL && pPtr==*ppDatMan)
	{
		nSectionCount=GetSectionCount();

		SavePageInfo();
	}
	return 0;
}

IMPL_LINK( AdrView, SourceRefreshHdl,AdrDataManager*, pPtr )
{
	if(ppDatMan !=NULL && pPtr==*ppDatMan)
	{
		nSectionCount=GetSectionCount();
		
		for(long i=nSectionCount-1; i >=0 ;i--)
		{
			USHORT nId = GetSectionId(i);
			SvSection* pSection=GetSection(nId );
			if(pSection!=NULL)
			{
				Window*	pChildWin=(Window *)pSection->GetChildWin();
				pSection->SetChildWin(NULL);
				delete pChildWin;
				RemoveSection(nId);
				delete pSection;
			}
		}

		InitPages();
		ConfigPages();
	}
	return 0;
}






