/*
  cpp2uno.cxx - IRIX N32 gcc UNO bridge

  Ralph Thomas - <ralpht@sgi.com>


  ISSUES...
   x This code needs to be tested for out-of-process connections
   x This code needs to be tested for out-of-process connections where
     byte-order differs (e.g.: have connection coming from Linux-x86)
*/

#include <stdio.h>

#define LEAK_STATIC_DATA //Don't know why.

#define TRACE(x)
#define STATUSMSG	false

#include <malloc.h>
#if STLPORT_VERSION < 321
#include <list.h>
#include <map.h>
#else
#include <list>
#include <map>
#endif
#include <typeinfo>
#ifndef _RTL_ALLOC_H_
#include <rtl/alloc.h>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _TYPELIB_TYPEDESCRIPTION_HXX_
#include <typelib/typedescription.hxx>
#endif
#ifndef _UNO_DATA_H_
#include <uno/data.h>
#endif
#ifndef _BRIDGES_CPP_UNO_BRIDGE_HXX_
#include <bridges/cpp_uno/bridge.hxx>
#endif
#ifndef _BRIDGES_CPP_UNO_TYPE_MISC_HXX_
#include <bridges/cpp_uno/type_misc.hxx>
#endif

//IRIX cacheflush function:
#include <sys/cachectl.h>
//bzero
#include <strings.h>
#include "gcc2_irix_mips.hxx"

using namespace com::sun::star::uno;
using namespace std;
using namespace osl;
using namespace rtl;

namespace CPPU_CURRENT_NAMESPACE
{
  rtl_StandardModuleCount g_moduleCount = MODULE_COUNT_INIT;

  static typelib_TypeClass cpp2uno_call (cppu_cppInterfaceProxy* pThis, const typelib_TypeDescription* pMemberTypeDescr,
					 typelib_TypeDescriptionReference* pReturnTypeRef, sal_Int32 nParams,
					 typelib_MethodParameter* pParams, long long* gpreg, long long* fpreg, long long* stack,
					 sal_Int64* pRegisterReturn) //sal_Int32 ??
  {
    /*
      In gpreg, the first parameter might be a pointer to a place to put the return value, although it might not
      be there (if it's a simple return type that could go in registers).

      So:
       gpreg = [ret*], this, [integer args]

      (Just like PPC).
    */

    if( STATUSMSG ) printf ("cpp2uno_call\n");
    int regNum;
    void* pUnoReturn; //complex case
    void* pCppReturn;
    bool complexCall = false;
    bool interfaceRelated = false;
    typelib_TypeDescription* pReturnTypeDescr;
    sal_Int32 paramListSize;
 
    regNum = 0;
    pUnoReturn = 0;
    pCppReturn = 0;
    pReturnTypeDescr = 0;

    if (pReturnTypeRef)
      TYPELIB_DANGER_GET (&pReturnTypeDescr, pReturnTypeRef);

    complexCall = false;
    if (pReturnTypeDescr)
      {
	interfaceRelated = cppu_relatesToInterface (pReturnTypeDescr);
	if (cppu_isSimpleType (pReturnTypeDescr) || pReturnTypeDescr->eTypeClass == typelib_TypeClass_HYPER || pReturnTypeDescr->eTypeClass == typelib_TypeClass_UNSIGNED_HYPER)
	  {
	    pUnoReturn = pRegisterReturn;
	    pCppReturn = pRegisterReturn;
	  }
	else
	  {
	    complexCall = true;
	  }
	if (pReturnTypeDescr->eTypeClass == typelib_TypeClass_STRUCT || pReturnTypeDescr->eTypeClass == typelib_TypeClass_UNION)
	  {
	    if (pReturnTypeDescr->nSize <= 16)
	      {
		complexCall = false;
		if (interfaceRelated)
		  { //reconversion required for these
		    pUnoReturn = alloca (pReturnTypeDescr->nSize);
		    pCppReturn = pRegisterReturn;
		  }
		else
		  { //reconversion not required
		    pUnoReturn = pRegisterReturn;
		    pCppReturn = pRegisterReturn;
		  }
	      }
	  }
	if (complexCall)
	  {
	    pCppReturn = (long long*) gpreg [regNum];
	    regNum++;
	    if (interfaceRelated)
	      pUnoReturn = alloca (pReturnTypeDescr->nSize);
	    else
	      pUnoReturn = pRegisterReturn;
	  }
      }


    //pop this...
    regNum++;
    //ABI Check
    OSL_ENSURE (sizeof (void*) == sizeof (sal_Int32), "### unexpected size!");
    void** pUnoArgs = (void**) alloca (4* (nParams+100));
    long long* pCppArgs = (long long*) alloca (8* (nParams+100));
    //indices of values to be converted
    sal_Int32* pTempIndizes = (sal_Int32*) alloca (4* (nParams+100));
    //type descriptions for conversions...
    typelib_TypeDescription** ppTempParamTypeDescr = (typelib_TypeDescription **) alloca (4* (nParams+100));
    sal_Int32 nTempIndizes = 0;
    
    if( STATUSMSG ) printf ("  Converting %d Parameters\n", nParams);
    
    for (sal_Int32 nPos = 0; nPos < nParams; ++nPos)
      {
	const typelib_MethodParameter& rParam = pParams [nPos];
	typelib_TypeDescription* pParamTypeDescr = 0;
	TYPELIB_DANGER_GET (&pParamTypeDescr, rParam.pTypeRef);

	if (!rParam.bOut && cppu_isSimpleType (pParamTypeDescr))
	  {
	    if ((pParamTypeDescr->eTypeClass == typelib_TypeClass_DOUBLE || pParamTypeDescr->eTypeClass == typelib_TypeClass_FLOAT) && regNum < 8)
	      {
		fpreg [regNum] = fixAlignmentForUNO (fpreg [regNum], pParamTypeDescr);
		long long tmpLongLong = fpreg [regNum];
		((char*) &tmpLongLong) [0] = ((char*) &fpreg [regNum]) [4];
    	((char*) &tmpLongLong) [1] = ((char*) &fpreg [regNum]) [5];
    	((char*) &tmpLongLong) [2] = ((char*) &fpreg [regNum]) [6];
    	((char*) &tmpLongLong) [3] = ((char*) &fpreg [regNum]) [7];
    	if (pParamTypeDescr->eTypeClass == typelib_TypeClass_FLOAT)
			fpreg [regNum] = tmpLongLong;
		pCppArgs [nPos] = &(fpreg [regNum]);
		pUnoArgs [nPos] = &(fpreg [regNum]);
		regNum++;
	      }
	    else
	      {
		if (regNum < 8)
		  {
		    gpreg [regNum] = fixAlignmentForUNO (gpreg [regNum], pParamTypeDescr);
		    pCppArgs [nPos] = &(gpreg [regNum]);
		    pUnoArgs [nPos] = &(gpreg [regNum]);
		    regNum++;
		  }
		else
		  {
		    *stack = fixAlignmentForUNO (*stack, pParamTypeDescr);
		    pCppArgs [nPos] = stack;
		    pUnoArgs [nPos] = stack;
		    stack++;
		  }
	      }
	    TYPELIB_DANGER_RELEASE (pParamTypeDescr);
	  }
	else
	  {
	    //complex type, or an in or an in/out
	    /*
	     * GCC doesn't follow the N32 ABI regarding structs and unions.
	     * When I port this code to MIPSpro, there will be much work in
	     * taking structures to pieces here.
	     *
	     */
	    long long *tmpPtr;

	    if (regNum < 8)
	      {
		pCppArgs [nPos] = gpreg [regNum];
		tmpPtr = & (gpreg [regNum]);
		regNum++;
	      }
	    else
	      {
		pCppArgs [nPos] = *stack;
		tmpPtr = stack;
		stack++;
	      }
	    
	    if (! rParam.bIn)
	      {
		//Pure out - pass a reference
		pUnoArgs [nPos] = alloca (pParamTypeDescr->nSize);
		pTempIndizes [nTempIndizes] = nPos;
		ppTempParamTypeDescr [nTempIndizes] = pParamTypeDescr; //release at reconversion
		nTempIndizes++;
	      }
	    else if (cppu_relatesToInterface (pParamTypeDescr))
	      {
		//Complex (Interface Related) In or In/Out
		pUnoArgs [nPos] = alloca (pParamTypeDescr->nSize);
		uno_copyAndConvertData (pUnoArgs [nPos], *tmpPtr, pParamTypeDescr,
					&pThis->pBridge->aCpp2Uno);
		pTempIndizes [nTempIndizes] = nPos;
		ppTempParamTypeDescr [nTempIndizes] = pParamTypeDescr; //release at reconversion
		nTempIndizes++;
	      }
	    else
	      {
		//Simple In
		pUnoArgs [nPos] = *tmpPtr;//fixAlignmentForUNO (*tmpPtr, pParamTypeDescr);
		TYPELIB_DANGER_RELEASE (pParamTypeDescr); //don't need to reconvert: don't need paramTypeDescr.
	      }
	    
	  }
      }
    if( STATUSMSG ) printf ("  Converted Types\n");
    //Now invoke the function over the network.
    uno_Any aUnoExc; //will be constructed by callee
    uno_Any *pUnoExc = &aUnoExc;
    if( STATUSMSG ) printf ("  Invoking pDispatcher = 0x%x\n", pThis->pUnoI->pDispatcher);
    (*pThis->pUnoI->pDispatcher) (pThis->pUnoI, pMemberTypeDescr, pUnoReturn, (void**) pUnoArgs, &pUnoExc);
    if( STATUSMSG ) printf ("  Invoked\n");
    //in case an exception occured...
    if (pUnoExc)
      {
	if( STATUSMSG ) printf ("  Caught Exception\n");
	for (;nTempIndizes--;)
	  {
	    sal_Int32 nIndex;

	    nIndex = pTempIndizes [nTempIndizes];
	    typelib_TypeDescription* pParamTypeDescr = ppTempParamTypeDescr [nTempIndizes];
	    if (pParams [nIndex].bIn) //is in/inout therefore data was constructed
	      uno_destructData (pUnoArgs [nIndex], pParamTypeDescr, 0);

	    TYPELIB_DANGER_RELEASE (pParamTypeDescr);
	  }
	if (pReturnTypeDescr)
	  TYPELIB_DANGER_RELEASE (pReturnTypeDescr);

	gcc291_irix_mips_raiseException (&aUnoExc, &pThis->pBridge->aUno2Cpp); //destroys the uno_Any
	return typelib_TypeClass_VOID; //never get here.
      }
    else
      {
	if( STATUSMSG ) printf ("  No Exception: reconverting %d out-values\n", nTempIndizes);

	for (;nTempIndizes--;)
	  {
	    sal_Int32 nIndex;

	    nIndex = pTempIndizes [nTempIndizes];
	    typelib_TypeDescription * pParamTypeDescr = ppTempParamTypeDescr[nTempIndizes];
	    
	    if (pParams [nIndex].bOut) // inout/out ... requires reconversion
	      {
		uno_destructData (pCppArgs [nIndex], pParamTypeDescr, cpp_release);
		uno_copyAndConvertData (pCppArgs [nIndex], pUnoArgs [nIndex], pParamTypeDescr,
					&pThis->pBridge->aUno2Cpp);
			if (pParamTypeDescr->eTypeClass == typelib_TypeClass_FLOAT)
			{
				int* a;
				float* b;
				if( STATUSMSG ) printf ("Address of FLOAT out space: CPP: 0x%x UNO: 0x%x\n", pCppArgs [nIndex], pUnoArgs [nIndex]);
				a = (int*) pCppArgs [nIndex];
				if( STATUSMSG )
				{
				  printf ("CPP: Value [0] = 0x%x\n", a [0]);
				  printf ("CPP: Value [1] = 0x%x\n", a [1]);
				}
				b = (float*) a [1];
				if( STATUSMSG ) printf ("b [0] = 0x%x\nb[1] = 0x%x\n", b[0], b[1]);
				a = (int*) pUnoArgs [nIndex];
				if( STATUSMSG )
				{
				  printf ("UNO: Value [0] = 0x%x\n", a [0]);
				  printf ("UNO: Value [1] = 0x%x\n", a [1]);
				}
			}
	      }
	    //destroy temp uno param.
	    uno_destructData (pUnoArgs [nIndex], pParamTypeDescr, 0);
	    TYPELIB_DANGER_RELEASE (pParamTypeDescr);
	  }
	//return

	if (interfaceRelated)
	  {
	    uno_copyAndConvertData (pCppReturn, pUnoReturn, pReturnTypeDescr, &pThis->pBridge->aUno2Cpp);
	    uno_destructData (pUnoReturn, pReturnTypeDescr, 0);
	  }
	else
	  {
	    if (pReturnTypeDescr)
	      {
		if (!complexCall)
		  {
		    pRegisterReturn [0] = fixAlignmentForN32 (pRegisterReturn [0], pReturnTypeDescr);
		    pRegisterReturn [2] = fixAlignmentForN32 (pRegisterReturn [2], pReturnTypeDescr);
		    if( STATUSMSG ) printf ("pRegisterReturn [2] = 0x%x\n", ((int*) & (pRegisterReturn[2])) [0]);
		  }
		else
		  {
		    memcpy (pCppReturn, pRegisterReturn, pReturnTypeDescr->nSize);
		  }
	      }
	  }
	if (pReturnTypeDescr)
	  {
	    typelib_TypeClass eRet;
	    eRet = (typelib_TypeClass) pReturnTypeDescr->eTypeClass;
	    TYPELIB_DANGER_RELEASE (pReturnTypeDescr);
	    return eRet;
	  }
	return typelib_TypeClass_VOID;
      }

  }

  //=====================

  static typelib_TypeClass cpp_mediate (sal_Int32 nVtableCall, void* gpreg, void* fpreg, void* stack,
					sal_Int64* pRegisterReturn)
  {
    //gpreg: [ret*], this, [params...]
    //fpreg: [fp params...]
    //stack: [params...]

    cppu_cppInterfaceProxy* pCppI;
    typelib_InterfaceTypeDescription* pTypeDescr;
    sal_Int32 nMemberPos;
    typelib_TypeClass eRet;

    pCppI = NULL;
    if (nVtableCall & 0x80000000)
    {
    	if( STATUSMSG ) printf ("  Complex Call!\n");
    	nVtableCall &= 0x7fffffff;
    	pCppI = (cppu_cppInterfaceProxy*) (XInterface*) *((long long*) gpreg + 1);
    }
    else
    	pCppI = (cppu_cppInterfaceProxy*) (XInterface*) *((long long*) gpreg);

    pTypeDescr = pCppI->pTypeDescr;
    OSL_ENSURE (pTypeDescr != NULL, "### null cppu_cppInterfaceProxy!");
    OSL_ENSURE (nVtableCall < pTypeDescr->nMapFunctionIndexToMemberIndex, "### illegal vtable index!");
    if (nVtableCall >= pTypeDescr->nMapFunctionIndexToMemberIndex)
    {
    	if( STATUSMSG ) printf ("  Throwing exception\n");
    	throw RuntimeException (OUString::createFromAscii ("illegal vtable index!"), (XInterface*) pCppI);
    }
    //determine called method
    OSL_ENSURE (nVtableCall < pTypeDescr->nMapFunctionIndexToMemberIndex, "### illegal vtable index!");
    nMemberPos = pTypeDescr->pMapFunctionIndexToMemberIndex [nVtableCall];
    OSL_ENSURE (nMemberPos < pTypeDescr->nAllMembers, "### illegal member index!");
    TypeDescription aMemberDescr (pTypeDescr->ppAllMembers [nMemberPos]);

    switch (aMemberDescr.get ()->eTypeClass)
      {
      case typelib_TypeClass_INTERFACE_ATTRIBUTE:
	{
	  if (pTypeDescr->pMapMemberIndexToFunctionIndex [nMemberPos] == nVtableCall)
	    {
	      //is GET method
	      if( STATUSMSG ) printf ("  GET METHOD: nVtableCall == %d\n", nVtableCall);
	      eRet = cpp2uno_call (pCppI, aMemberDescr.get (),
				   ((typelib_InterfaceAttributeTypeDescription*) aMemberDescr.get ())->pAttributeTypeRef,
				   0, 0, (void*)gpreg, (void*)fpreg, (void*)stack, pRegisterReturn);
	    }
	  else
	    {
	      //is SET method
	      if( STATUSMSG ) printf ("  SET METHOD: nVtableCall == %d\n", nVtableCall);
	      typelib_MethodParameter aParam;

	      aParam.pTypeRef = ((typelib_InterfaceAttributeTypeDescription*) aMemberDescr.get ())->pAttributeTypeRef;
	      aParam.bIn = sal_True;
	      aParam.bOut = sal_False;

	      eRet = cpp2uno_call (pCppI, aMemberDescr.get (), 0, //void return
				   1, &aParam, (void*)gpreg, (void*)fpreg, (void*)stack, pRegisterReturn);
	      if( STATUSMSG ) printf (" SET METHOD DONE\n");
	    }
	  break;
	}
      case typelib_TypeClass_INTERFACE_METHOD:
	{
	  //is METHOD
	  //deal with non virtual functions (queryInterface...)
	  switch (nVtableCall)
	    {
	    case 1: // acquire ()
	      {
		pCppI->acquireProxy (); //non virtual call.
		eRet = typelib_TypeClass_VOID;
		break;
	      }
	    case 2: // release ()
	      {
		pCppI->releaseProxy (); //non virtual call.
		eRet = typelib_TypeClass_VOID;
		break;
	      }
	    case 0: //queryInterface (type) [implies] gpreg = ret*, this, type.
	      {
		if( STATUSMSG ) printf ("  queryInterface\n");
		typelib_TypeDescription* pTD;
		Type* tmpType;

		tmpType = (Type*) ((long long*)gpreg) [2];
		if( STATUSMSG ) printf ("tmpType = 0x%x\n", tmpType);
		pTD = 0;
		//XXX: Check gpreg pointer usage
		TYPELIB_DANGER_GET (&pTD, tmpType->getTypeLibType ());

		if (pTD)
		  {
		    XInterface* pInterface;

		    pInterface = 0;
		    if( STATUSMSG ) printf ("  Getting Interface\n");
		    (*pCppI->pBridge->pCppEnv->getRegisteredInterface) (pCppI->pBridge->pCppEnv, (void**) &pInterface,
									pCppI->oid.pData, (typelib_InterfaceTypeDescription*) pTD);

		    if (pInterface)
		      {
			if( STATUSMSG ) printf ("  Doing recast\n");
			::uno_any_construct (reinterpret_cast <uno_Any*> (((void**)gpreg) [0]), &pInterface, pTD, cpp_acquire);
			pInterface->release ();
			TYPELIB_DANGER_RELEASE (pTD);
			if( STATUSMSG ) printf ("  Returning\n");
			pRegisterReturn = *(void**) gpreg;
			eRet = typelib_TypeClass_ANY;
			break;
		      }
		    TYPELIB_DANGER_RELEASE (pTD);
		  }
	      }
	    default:
	      {
	      	if( STATUSMSG ) printf ("GENERIC METHOD: nVtableCall = %d\n", nVtableCall);
		eRet = cpp2uno_call (pCppI, aMemberDescr.get (),
				     ((typelib_InterfaceMethodTypeDescription*) aMemberDescr.get ())->pReturnTypeRef,
				     ((typelib_InterfaceMethodTypeDescription*) aMemberDescr.get ())->nParams,
				     ((typelib_InterfaceMethodTypeDescription*) aMemberDescr.get ())->pParams,
				     (void*)gpreg, (void*)fpreg, (void*)stack, pRegisterReturn);
	      }
	    }
	  break;
	  
	}
      default:
	{
	  if( STATUSMSG ) printf ("  Throwing member description exception\n");
	  throw RuntimeException (OUString::createFromAscii ("no member description found!"), (XInterface*) pCppI);
	  eRet = typelib_TypeClass_VOID;
	}
      }

    return eRet;
  }

  //========

  class MediateClassData
  {
  public:
    struct ClassDataBuffer
    {
      void* m_pVTable;
      ~ClassDataBuffer ();
    };
  private:
    std::map <OUString, ClassDataBuffer*> m_aClassData;
    Mutex m_aMutex;
    void createVTable (ClassDataBuffer*, typelib_InterfaceTypeDescription*);
  public:
    const ClassDataBuffer* getClassData (typelib_InterfaceTypeDescription*);
    MediateClassData () {}
    ~MediateClassData ();
  };

  //========

  MediateClassData::ClassDataBuffer::~ClassDataBuffer ()
  {
    delete m_pVTable;
  }

  MediateClassData::~MediateClassData ()
  {
    TRACE ("> calling ~MediateClassData (): freeing mediate vtables... <\n");

    //this MUST be the absolute last one which is called!
    for (map<OUString, ClassDataBuffer*>::iterator iPos (m_aClassData.begin ()); iPos != m_aClassData.end (); ++iPos)
      {
	//Tra la la.
	//delete (*iPos).second;
      }
  }

  const MediateClassData::ClassDataBuffer* MediateClassData::getClassData (typelib_InterfaceTypeDescription* pType)
  {
    MutexGuard aGuard (m_aMutex);

    map<OUString, ClassDataBuffer*>::iterator element = m_aClassData.find (pType->aBase.pTypeName);

    if (element != m_aClassData.end ())
      return (*element).second;

    ClassDataBuffer* pBuffer = new ClassDataBuffer ();
    createVTable (pBuffer, pType);
    m_aClassData [pType->aBase.pTypeName] = pBuffer;

    return pBuffer;
  }

  /* This is called by assembler snippets */
  static void cpp_vtable_call (long long nTableEntry, void** dataPtr, void** stackPtr)
  {
    int gpreg [32];
    int* fpreg = gpreg + 16;
    long long pRegReturn [4];

    memcpy (gpreg, dataPtr, 128);
    //memcpy (fpreg, (char*)dataPtr + 64, 64);
    free (dataPtr);
    cpp_mediate (nTableEntry, gpreg, fpreg, stackPtr, pRegReturn);
    
    __asm__ (
	     "ld $2, %0\n\t"
	     "ld $3, %1\n\t"
	     "l.d $f0, %2\n\t"
	     "l.d $f2, %3\n\t"
	     : : "m" (pRegReturn [0]), "m" (pRegReturn [1]), "m" (pRegReturn [2]), "m" (pRegReturn [3])
	     );
  }

  //==========

  void MediateClassData::createVTable (ClassDataBuffer* pBuffer, typelib_InterfaceTypeDescription* pType)
  {
    list <sal_Bool> aComplexReturn;

    for (int n = 0; n < pType->nAllMembers; n++)
      {
	typelib_TypeDescription* pMember;

	pMember = NULL;
	TYPELIB_DANGER_GET (&pMember, pType->ppAllMembers [n]);
	if (pMember->eTypeClass == typelib_TypeClass_INTERFACE_ATTRIBUTE)
	  {
	    typelib_TypeDescription* pRetTD;

	    pRetTD = 0;
	    TYPELIB_DANGER_GET (&pRetTD, ((typelib_InterfaceAttributeTypeDescription*) pMember)->pAttributeTypeRef);
	    //get method
	    if (cppu_isSimpleType (pRetTD))
	      aComplexReturn.push_back (sal_False);
	    else
	      {
		if (pRetTD->eTypeClass == typelib_TypeClass_STRUCT || pRetTD->eTypeClass == typelib_TypeClass_UNION)
		  {
		    if (pRetTD->nSize <= 16)
		      {
			aComplexReturn.push_back (sal_False);
		      }
		    else
		      {
			aComplexReturn.push_back (sal_True);
		      }
		  }
		else
		  aComplexReturn.push_back (sal_True);
	      }
	    //set method
	    if (! ((typelib_InterfaceAttributeTypeDescription*) pMember)->bReadOnly)
	      aComplexReturn.push_back (sal_False);
	    TYPELIB_DANGER_RELEASE (pRetTD);
	  }
	else
	  {
	    typelib_TypeDescription* pRetTD;

	    pRetTD = 0;
	    TYPELIB_DANGER_GET (&pRetTD, ((typelib_InterfaceMethodTypeDescription*)pMember)->pReturnTypeRef);
	    if (cppu_isSimpleType (pRetTD))
	      aComplexReturn.push_back (sal_False);
	    else
	      {
		if (cppu_relatesToInterface (pRetTD))
		  aComplexReturn.push_back (sal_True);
		else
		  if (pRetTD->nSize > 16)
		    aComplexReturn.push_back (sal_True);
		  else
		    aComplexReturn.push_back (sal_False);
	      }
	    TYPELIB_DANGER_RELEASE (pRetTD);
	  }
	TYPELIB_DANGER_RELEASE (pMember)
      }
    
    int nSize;
    const int nSnippetSize = 500;
    char* pSpace;
    char* pCode;
    void** pvft;

    nSize = aComplexReturn.size ();
    pSpace = (char*) rtl_allocateMemory ((nSize + 4) * sizeof (long long) + (nSize * nSnippetSize));
    pBuffer->m_pVTable = (void*) pSpace;
    pCode = pSpace + ((nSize + 4) * sizeof (long long));
    pvft = (void**) pSpace;

    pvft [0] = NULL;
    pvft [1] = NULL;

    if( STATUSMSG ) printf ("  Patching VTable with %d entries\n", nSize);
    for (sal_Int32 nPos = 0; nPos < nSize; ++nPos)
      {
	int* codeSnip;
	unsigned long nTablePos;
	int* origSnipPos;
	sal_Bool bComplex;
	int ptrPos;

	ptrPos = (nPos * 2) + 3;

	codeSnip = (int*) (pCode + (nPos * nSnippetSize));
	origSnipPos = codeSnip;
	//pvft [nPos + 2] = codeSnip;
	pvft [ptrPos] = codeSnip;
	pvft [ptrPos - 1] = NULL;
	nTablePos = nPos;
	bComplex = aComplexReturn.front ();
	aComplexReturn.pop_front ();

	if (bComplex)
	  nTablePos = 0x80000000 | nPos;
	
	//machine code... Ugh!
	*codeSnip++ = 0x27bdff70; // subu $sp, 144 (grow the stack)
	*codeSnip++ = 0xffa40000; // sd $4, 0($sp) (save arg register 1 to stack)
	*codeSnip++ = 0xffa50008; // sd $5, 8($sp) (... register 2...)
	*codeSnip++ = 0xffa60010; // sd $6, 16($sp) (... 3...)
	*codeSnip++ = 0xffa70018; // sd $7, 24($sp) (... 4...)
	*codeSnip++ = 0xffa80020; // sd $8, 32($sp) (... 5...)
	*codeSnip++ = 0xffa90028; // sd $9, 40($sp) (... 6...)
	*codeSnip++ = 0xffaa0030; // sd $10, 48($sp) (... 7...)
	*codeSnip++ = 0xffab0038; // sd $11, 56($sp) (... 8...)
	*codeSnip++ = 0xf7ac0040; // sdc1 $f12, 64($sp) (save fp arg register 1 to stack)
	*codeSnip++ = 0xf7ad0048; // sdc1 $f13, 72($sp) (... 2...)
	*codeSnip++ = 0xf7ae0050; // sdc1 $f14, 80($sp) (... 3...)
	*codeSnip++ = 0xf7af0058; // sdc1 $f15, 88($sp) (... 4...)
	*codeSnip++ = 0xf7b00060; // sdc1 $f16, 96($sp) (... 5...)
	*codeSnip++ = 0xf7b10068; // sdc1 $f17, 104($sp) (... 6...)
	*codeSnip++ = 0xf7b20070; // sdc1 $f18, 112($sp) (... 7...)
	*codeSnip++ = 0xf7b30078; // sdc1 $f19, 120($sp) (... 8...)
	*codeSnip++ = 0xffbf0080; // sd $31, 128($sp) (save the return address to stack)
	*codeSnip++ = 0x3c040090; // lui $4, 144 (we want to move what we put on stack into free store)
	*codeSnip++ = 0x34840090; // ori $4, $4, 144 (as above)
	*codeSnip++ = 0x3c190000 | ((((int) malloc) >> 16) & 0x0000FFFF); //lui $4, malloc (load address of malloc)
	*codeSnip++ = 0x37390000 | (((int) malloc) & 0x0000FFFF); //ori $4, $4, malloc (load the other half)
	*codeSnip++ = 0x0320f809; // jal $25 (do the malloc)
	*codeSnip++ = 0x00000000; // nop (delay slot)
	//This is where it gets really fun. We unload the stack into the malloc'd memory.
	*codeSnip++ = 0xdfa40000;
	*codeSnip++ = 0xfc440000;
	*codeSnip++ = 0xdfa40008;
	*codeSnip++ = 0xfc440008;
	*codeSnip++ = 0xdfa40010;
	*codeSnip++ = 0xfc440010;
	*codeSnip++ = 0xdfa40018;
	*codeSnip++ = 0xfc440018;
	*codeSnip++ = 0xdfa40020;
	*codeSnip++ = 0xfc440020;
	*codeSnip++ = 0xdfa40028;
	*codeSnip++ = 0xfc440028;
	*codeSnip++ = 0xdfa40030;
	*codeSnip++ = 0xfc440030;
	*codeSnip++ = 0xdfa40038;
	*codeSnip++ = 0xfc440038;
	*codeSnip++ = 0xdfa40040;
	*codeSnip++ = 0xfc440040;
	*codeSnip++ = 0xdfa40048;
	*codeSnip++ = 0xfc440048;
	*codeSnip++ = 0xdfa40050;
	*codeSnip++ = 0xfc440050;
	*codeSnip++ = 0xdfa40058;
	*codeSnip++ = 0xfc440058;
	*codeSnip++ = 0xdfa40060;
	*codeSnip++ = 0xfc440060;
	*codeSnip++ = 0xdfa40068;
	*codeSnip++ = 0xfc440068;
	*codeSnip++ = 0xdfa40070;
	*codeSnip++ = 0xfc440070;
	*codeSnip++ = 0xdfbf0080; // ld $31, 128($sp) (restore the return address)
	*codeSnip++ = 0x27bd0090; // addiu $sp, $sp, 144 (restore the stack)
	*codeSnip++ = 0x3c040000 | ((((int) nTablePos) >> 16) & 0x0000FFFF); // lui $4, nVtableNumber (store half of nVtableNumber in arg 1)
	*codeSnip++ = 0x34840000 | (((int) nTablePos) & 0x0000FFFF); // ori $4, $4, nVtableNumber (store the other half)
	*codeSnip++ = 0x00002825; // move a1, zero (blank out $5)
	*codeSnip++ = 0x00a22821; // addu a1, a1, v0 (move $2 to $5)
	*codeSnip++ = 0x00003025; // move a2, zero (blank out $6)
	*codeSnip++ = 0x00dd3021; // addu a2, a2, sp (move $sp to $6)
	*codeSnip++ = 0x3c190000 | ((((int) cpp_vtable_call) >> 16) & 0x0000FFFF); // lui $25, cpp_vtable_call (load half the address of cpp_vtable_call)
	*codeSnip++ = 0x37390000 | (((int) cpp_vtable_call) & 0x0000FFFF); // ori $25, $25, cpp_vtable_call (and the other half)
	*codeSnip++ = 0x03200008; // jr $25 (go to cpp_vtable_call -- very cunning: rely on it to return to the code that called me!).
	*codeSnip++ = 0x00000000; // nop (delay slot)
	*codeSnip++ = 0x00000000; // nop (padding)

	cacheflush (origSnipPos, sizeof (int) * 66, ICACHE);
      }

  }

  //=======
  
  void SAL_CALL cppu_cppInterfaceProxy_patchVtable (XInterface* pCppI, typelib_InterfaceTypeDescription* pTypeDescr)
  {
    static MediateClassData* s_pMediateClassData = 0;

    if (!s_pMediateClassData)
      {
	MutexGuard aGuard (Mutex::getGlobalMutex ());
	if (!s_pMediateClassData)
	  {
#ifdef LEAK_STATIC_DATA
	    s_pMediateClassData = new MediateClassData ();
#else
	    static MediateClassData s_aMediateClassData;
	    s_pMediateClassData = &s_aMediateClassData;
#endif
	  }
      }
    *(const void**) pCppI = s_pMediateClassData->getClassData (pTypeDescr)->m_pVTable;
  }
}

//##########

extern "C" SAL_DLLEXPORT sal_Bool SAL_CALL component_CanUnload (TimeValue* pTime)
  SAL_THROW_EXTERN_C ()
{
  return CPPU_CURRENT_NAMESPACE::g_moduleCount.canUnload (&CPPU_CURRENT_NAMESPACE::g_moduleCount, pTime);
}

//##########

extern "C" SAL_DLLEXPORT void SAL_CALL uno_initEnvironment (uno_Environment* pCppEnv)
  SAL_THROW_EXTERN_C ()
{
  CPPU_CURRENT_NAMESPACE::cppu_cppenv_initEnvironment (pCppEnv);
}

//##########

extern "C" SAL_DLLEXPORT void SAL_CALL uno_ext_getMapping (uno_Mapping** ppMapping, uno_Environment* pFrom,
							   uno_Environment* pTo)
  SAL_THROW_EXTERN_C ()
{
  CPPU_CURRENT_NAMESPACE::cppu_ext_getMapping (ppMapping, pFrom, pTo);
}
