/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalBarRenderer;
import com.jrefinery.chart.VerticalNumberAxis3D;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.entity.ChartEntity;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardCategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Range;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;

public class VerticalBarRenderer3D
extends VerticalBarRenderer {
    private static final double DEFAULT_EFFECT3D = 10.0;
    private double effect3d;

    public VerticalBarRenderer3D() {
        this((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator(), 10.0);
    }

    public VerticalBarRenderer3D(CategoryToolTipGenerator categoryToolTipGenerator, double d) {
        super(categoryToolTipGenerator);
        this.effect3d = d;
    }

    public boolean hasItemGaps() {
        return true;
    }

    public int barWidthsPerCategory(CategoryDataset categoryDataset) {
        return categoryDataset.getSeriesCount();
    }

    public Rectangle2D getAxisArea(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.effect3d, rectangle2D.getWidth() - this.effect3d, rectangle2D.getHeight() - this.effect3d);
    }

    public Shape getDataClipRegion(Rectangle2D rectangle2D) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)rectangle2D.getX(), (float)(rectangle2D.getMinY() + this.effect3d));
        generalPath.lineTo((float)(rectangle2D.getX() + this.effect3d), (float)rectangle2D.getMinY());
        generalPath.lineTo((float)rectangle2D.getMaxX(), (float)rectangle2D.getMinY());
        generalPath.lineTo((float)rectangle2D.getMaxX(), (float)(rectangle2D.getMaxY() - this.effect3d));
        generalPath.lineTo((float)(rectangle2D.getMaxX() - this.effect3d), (float)rectangle2D.getMaxY());
        generalPath.lineTo((float)rectangle2D.getX(), (float)rectangle2D.getMaxY());
        generalPath.closePath();
        return generalPath;
    }

    public void drawPlotBackground(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, Shape shape) {
        super.drawPlotBackground(graphics2D, categoryPlot, rectangle2D, shape);
        double d = rectangle2D.getX();
        double d2 = d + this.effect3d;
        double d3 = rectangle2D.getMaxX() + this.effect3d;
        double d4 = rectangle2D.getMaxY();
        double d5 = d4 - this.effect3d;
        double d6 = rectangle2D.getMinY() - this.effect3d;
        graphics2D.setPaint(categoryPlot.getOutlinePaint());
        Line2D.Double double_ = new Line2D.Double(d, d4, d2, d5);
        graphics2D.draw(double_);
        ((Line2D)double_).setLine(d2, d5, d2, d6);
        graphics2D.draw(double_);
        ((Line2D)double_).setLine(d2, d5, d3, d5);
        graphics2D.draw(double_);
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D, Shape shape) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        float f = (float)valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        float f2 = (float)rectangle2D.getX();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f2, f);
        generalPath.lineTo(f2 + (float)this.effect3d, f - (float)this.effect3d);
        generalPath.lineTo((float)(rectangle2D.getMaxX() + this.effect3d), f - (float)this.effect3d);
        generalPath.lineTo((float)rectangle2D.getMaxX(), f);
        generalPath.closePath();
        graphics2D.setPaint(marker.getPaint());
        graphics2D.fill(generalPath);
        graphics2D.setPaint(marker.getOutlinePaint());
        graphics2D.draw(generalPath);
    }

    public void drawCategoryItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, Object object, int n2, Object object2) {
        Number number = categoryDataset.getValue(n, object);
        if (number != null) {
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            double d = rectangle2D.getX() + rectangle2D.getWidth() * categoryPlot.getIntroGapPercent();
            int n3 = categoryDataset.getCategoryCount();
            int n4 = categoryDataset.getSeriesCount();
            if (n3 > 1) {
                d = d + (double)n2 * (this.categorySpan / (double)n3) + ((double)n2 * (this.categoryGapSpan / (double)(n3 - 1)) + (double)n * this.itemSpan / (double)(n3 * n4));
                if (n4 > 1) {
                    d += (double)n * this.itemGapSpan / (double)(n3 * (n4 - 1));
                }
            } else {
                d += (double)n * this.itemSpan / (double)(n3 * n4);
                if (n4 > 1) {
                    d += (double)n * this.itemGapSpan / (double)(n3 * (n4 - 1));
                }
            }
            double d2 = number.doubleValue();
            double d3 = 0.0;
            if (this.upperClip <= 0.0) {
                if (d2 >= this.upperClip) {
                    return;
                }
                d3 = this.upperClip;
                if (d2 <= this.lowerClip) {
                    d2 = this.lowerClip;
                }
            } else if (this.lowerClip <= 0.0) {
                if (d2 >= this.upperClip) {
                    d2 = this.upperClip;
                } else if (d2 <= this.lowerClip) {
                    d2 = this.lowerClip;
                }
            } else {
                if (d2 <= this.lowerClip) {
                    return;
                }
                d3 = this.lowerClip;
                if (d2 >= this.upperClip) {
                    d2 = this.upperClip;
                }
            }
            double d4 = valueAxis.translateValueToJava2D(d3, rectangle2D);
            double d5 = valueAxis.translateValueToJava2D(d2, rectangle2D);
            double d6 = Math.min(d4, d5);
            double d7 = this.itemWidth;
            double d8 = Math.abs(d4 - d5);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d, d6, d7, d8);
            Paint paint = null;
            paint = !this.getUseCategoriesPaint() ? categoryPlot.getSeriesPaint(n) : this.getCategoryPaint(n2);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            GeneralPath generalPath = null;
            GeneralPath generalPath2 = null;
            double d9 = 0.0;
            VerticalAxis verticalAxis = (VerticalAxis)((Object)categoryPlot.getRangeAxis());
            if (d8 != 0.0 && verticalAxis instanceof VerticalNumberAxis3D) {
                d9 = ((VerticalNumberAxis3D)verticalAxis).getEffect3d();
                generalPath = new GeneralPath();
                generalPath.moveTo((float)(d + d7), (float)d6);
                generalPath.lineTo((float)(d + d7), (float)(d6 + d8));
                generalPath.lineTo((float)(d + d7 + d9), (float)(d6 + d8 - d9));
                generalPath.lineTo((float)(d + d7 + d9), (float)(d6 - d9));
                if (paint instanceof Color) {
                    graphics2D.setPaint(((Color)paint).darker());
                }
                graphics2D.fill(generalPath);
                generalPath2 = new GeneralPath();
                generalPath2.moveTo((float)d, (float)d6);
                generalPath2.lineTo((float)(d + d9), (float)(d6 - d9));
                generalPath2.lineTo((float)(d + d7 + d9), (float)(d6 - d9));
                generalPath2.lineTo((float)(d + d7), (float)d6);
                graphics2D.fill(generalPath2);
            }
            if (this.itemWidth > 3.0) {
                graphics2D.setStroke(categoryPlot.getSeriesOutlineStroke(n));
                graphics2D.setPaint(categoryPlot.getSeriesOutlinePaint(n));
                graphics2D.draw(double_);
                if (generalPath != null) {
                    graphics2D.draw(generalPath);
                }
                if (generalPath2 != null) {
                    graphics2D.draw(generalPath2);
                }
                if (categoryPlot.getLabelsVisible()) {
                    object6 = categoryPlot.getLabelFont();
                    graphics2D.setFont((Font)object6);
                    object5 = categoryPlot.getLabelPaint();
                    graphics2D.setPaint((Paint)object5);
                    object4 = categoryPlot.getLabelFormatter();
                    object3 = ((Format)object4).format(number);
                    FontMetrics fontMetrics = graphics2D.getFontMetrics();
                    int n5 = (int)((this.itemWidth - (double)fontMetrics.stringWidth((String)object3)) / 2.0);
                    graphics2D.drawString((String)object3, (int)(d + d9 + (double)n5), (int)(d6 - d9 - 5.0));
                }
            }
            if (this.getInfo() != null && (object6 = this.getInfo().getEntityCollection()) != null) {
                object5 = "";
                if (this.getToolTipGenerator() != null) {
                    object5 = this.getToolTipGenerator().generateToolTip(categoryDataset, n, object);
                }
                object4 = null;
                if (this.getURLGenerator() != null) {
                    object4 = this.getURLGenerator().generateURL(categoryDataset, n, object);
                }
                object3 = new CategoryItemEntity(double_, (String)object5, (String)object4, n, object, n2);
                object6.addEntity((ChartEntity)object3);
            }
        }
    }
}

