/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openide.cookies.ConnectionCookie;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;

public class ConnectionSupport
implements ConnectionCookie {
    private static final String EA_LISTENERS = "EA-OpenIDE-Connection";
    private MultiDataObject.Entry entry;
    private ConnectionCookie.Type[] types;
    private Set typesSet;
    private LinkedList listeners;
    static /* synthetic */ Class class$org$openide$cookies$ConnectionCookie$Listener;

    public ConnectionSupport(MultiDataObject.Entry entry, ConnectionCookie.Type[] typeArray) {
        this.entry = entry;
        this.types = typeArray;
    }

    public synchronized void register(ConnectionCookie.Type type, Node node) throws IOException {
        this.testSupported(type);
        boolean bl = type.isPersistent();
        LinkedList<Pair> linkedList = bl ? (LinkedList)this.entry.getFile().getAttribute(EA_LISTENERS) : this.listeners;
        if (linkedList == null) {
            linkedList = new LinkedList<Pair>();
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Node node2;
            Pair pair = (Pair)iterator.next();
            if (!type.equals(pair.getType())) continue;
            try {
                node2 = pair.getNode();
            }
            catch (IOException iOException) {
                if (System.getProperty("netbeans.debug.exceptions") != null) {
                    iOException.printStackTrace();
                }
                iterator.remove();
                continue;
            }
            if (!node2.equals(node)) continue;
            iterator.remove();
        }
        linkedList.add(bl ? new Pair(type, node.getHandle()) : new Pair(type, node));
        if (bl) {
            this.entry.getFile().setAttribute(EA_LISTENERS, linkedList);
        }
    }

    public synchronized void unregister(ConnectionCookie.Type type, Node node) throws IOException {
        this.testSupported(type);
        boolean bl = type.isPersistent();
        LinkedList linkedList = bl ? (LinkedList)this.entry.getFile().getAttribute(EA_LISTENERS) : this.listeners;
        if (linkedList == null) {
            return;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Node node2;
            Pair pair = (Pair)iterator.next();
            if (!type.equals(pair.getType())) continue;
            try {
                node2 = pair.getNode();
            }
            catch (IOException iOException) {
                iterator.remove();
                continue;
            }
            if (!node2.equals(node)) continue;
            iterator.remove();
        }
        if (bl) {
            this.entry.getFile().setAttribute(EA_LISTENERS, linkedList);
        }
    }

    public Set getTypes() {
        if (this.typesSet == null) {
            this.typesSet = Collections.unmodifiableSet(new HashSet<ConnectionCookie.Type>(Arrays.asList(this.types)));
        }
        return this.typesSet;
    }

    public List getRegisteredTypes() {
        LinkedList<ConnectionCookie.Type> linkedList = new LinkedList<ConnectionCookie.Type>();
        LinkedList linkedList2 = this.listeners;
        int n = 0;
        while (n <= 1) {
            if (n == 1) {
                linkedList2 = (LinkedList)this.entry.getFile().getAttribute(EA_LISTENERS);
            }
            if (linkedList2 != null) {
                Iterator iterator = linkedList2.iterator();
                while (iterator.hasNext()) {
                    linkedList.add(((Pair)iterator.next()).getType());
                }
            }
            ++n;
        }
        return linkedList;
    }

    public synchronized void fireEvent(ConnectionCookie.Event event) {
        ConnectionCookie.Type type = event.getType();
        boolean bl = type.isPersistent();
        LinkedList linkedList = bl ? (LinkedList)this.entry.getFile().getAttribute(EA_LISTENERS) : this.listeners;
        if (linkedList == null) {
            return;
        }
        int n = linkedList.size();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (!pair.getType().overlaps(event.getType())) continue;
            try {
                ConnectionCookie.Listener listener = (ConnectionCookie.Listener)pair.getNode().getCookie(class$org$openide$cookies$ConnectionCookie$Listener == null ? ConnectionSupport.class$("org.openide.cookies.ConnectionCookie$Listener") : class$org$openide$cookies$ConnectionCookie$Listener);
                if (listener == null) continue;
                try {
                    listener.notify(event);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    iterator.remove();
                }
                catch (ClassCastException classCastException) {
                    iterator.remove();
                }
            }
            catch (IOException iOException) {
                iterator.remove();
            }
        }
        if (bl && linkedList.size() != n) {
            try {
                this.entry.getFile().setAttribute(EA_LISTENERS, linkedList);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized Set listenersFor(ConnectionCookie.Type type) {
        LinkedList linkedList = type.isPersistent() ? (LinkedList)this.entry.getFile().getAttribute(EA_LISTENERS) : this.listeners;
        if (linkedList == null) {
            return Collections.EMPTY_SET;
        }
        Iterator iterator = linkedList.iterator();
        HashSet<Node> hashSet = new HashSet<Node>(7);
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (!type.overlaps(pair.getType())) continue;
            try {
                hashSet.add(pair.getNode());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return hashSet;
    }

    private void testSupported(ConnectionCookie.Type type) throws InvalidObjectException {
        int n = 0;
        while (n < this.types.length) {
            if (type.overlaps(this.types[n])) {
                return;
            }
            ++n;
        }
        throw new InvalidObjectException(type.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class Pair
    implements Serializable {
        private ConnectionCookie.Type type;
        private Object value;
        static final long serialVersionUID = 387180886175136728L;

        public Pair(ConnectionCookie.Type type, Node node) {
            this.type = type;
            this.value = node;
        }

        public Pair(ConnectionCookie.Type type, Node.Handle handle) throws IOException {
            if (handle == null) {
                throw new IOException();
            }
            this.type = type;
            this.value = handle;
        }

        public ConnectionCookie.Type getType() {
            return this.type;
        }

        public Node getNode() throws IOException {
            return this.value instanceof Node ? (Node)this.value : ((Node.Handle)this.value).getNode();
        }
    }
}

