/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: BasicViewFactory.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2007/04/03 15:50:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SD_FRAMEWORK_VIEW_FACTORY_HXX
#define SD_FRAMEWORK_VIEW_FACTORY_HXX

#include "MutexOwner.hxx"

#ifndef _COM_SUN_STAR_DRAWING_FRAMEWORK_XVIEWFACTORY_HPP_
#include <com/sun/star/drawing/framework/XViewFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FRAMEWORK_XPANECONTROLLER_HPP_
#include <com/sun/star/drawing/framework/XPaneController.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FRAMEWORK_XVIEWCONTROLLER_HPP_
#include <com/sun/star/drawing/framework/XViewController.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_XCOMPONENTCONTEXT_HPP_
#include <com/sun/star/uno/XComponentContext.hpp>
#endif

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _CPPUHELPER_COMPBASE2_HXX_
#include <cppuhelper/compbase2.hxx>
#endif

#include <boost/shared_ptr.hpp>
#include <boost/scoped_ptr.hpp>

namespace sd {
class ViewShell;
class ViewShellBase;
class FrameView;
}
class SfxViewFrame;
class Window;

namespace {

typedef ::cppu::WeakComponentImplHelper2 <
    ::com::sun::star::drawing::framework::XViewFactory,
    ::com::sun::star::lang::XInitialization
    > BasicViewFactoryInterfaceBase;

} // end of anonymous namespace.




namespace sd { namespace framework {

/** Factory for the frequently used standard views of the drawing framework:
        private:resource/view/
        private:resource/view/ImpressView
        private:resource/view/GraphicView
        private:resource/view/OutlineView
        private:resource/view/NotesView
        private:resource/view/HandoutView
        private:resource/view/SlideSorter
        private:resource/view/PresentationView
        private:resource/view/TaskPane
    For some views in some panes this class also acts as a cache.
*/
class BasicViewFactory
    : private sd::MutexOwner,
      public BasicViewFactoryInterfaceBase      
{
public:
    BasicViewFactory (
        const ::com::sun::star::uno::Reference<com::sun::star::uno::XComponentContext>& rxContext);
    virtual ~BasicViewFactory (void);
    
    virtual void SAL_CALL disposing (void);

    
    // XViewFactory

    virtual com::sun::star::uno::Reference<com::sun::star::drawing::framework::XView>
        SAL_CALL createView (
            const ::com::sun::star::uno::Reference<
                com::sun::star::drawing::framework::XResourceId>& rxViewId,
            const ::com::sun::star::uno::Reference<
                com::sun::star::frame::XController>& xController)
        throw(com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL releaseView (
        const com::sun::star::uno::Reference<com::sun::star::drawing::framework::XView>& xView)
        throw(com::sun::star::uno::RuntimeException);

    
    // XInitialization
    
    virtual void SAL_CALL initialize(
        const ::com::sun::star::uno::Sequence<com::sun::star::uno::Any>& aArguments)
        throw (::com::sun::star::uno::Exception, ::com::sun::star::uno::RuntimeException);

private:
    ::com::sun::star::uno::Reference<com::sun::star::drawing::framework::XPaneController>
        mxPaneController;
    ::com::sun::star::uno::Reference<com::sun::star::drawing::framework::XViewController>
        mxViewController;
    class ViewDescriptor;
    class ViewShellContainer;
    ::boost::scoped_ptr<ViewShellContainer> mpViewShellContainer;
    ViewShellBase* mpBase;
    FrameView* mpFrameView;

    class ViewCache;
    ::boost::shared_ptr<ViewCache> mpViewCache;

    ::com::sun::star::uno::Reference<com::sun::star::drawing::framework::XPane> mxLocalPane;

    ::boost::shared_ptr<ViewDescriptor> CreateView (
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XResourceId>& rxViewId,
        SfxViewFrame& rFrame,
        ::Window& rWindow,
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XPane>& rxPane,
        FrameView* pFrameView);
    
    ::boost::shared_ptr<ViewShell> CreateViewShell (
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XResourceId>& rxViewId,
        SfxViewFrame& rFrame,
        ::Window& rWindow,
        FrameView* pFrameView);

    void ActivateCenterView (
        const ::boost::shared_ptr<ViewDescriptor>& rpDescriptor);

    void ReleaseView (
        const ::boost::shared_ptr<ViewDescriptor>& rpDescriptor,
        bool bDoNotCache = false);

    bool IsCacheable (
        const ::boost::shared_ptr<ViewDescriptor>& rpDescriptor);

    ::boost::shared_ptr<ViewDescriptor> GetViewFromCache (
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XResourceId>& rxViewId,
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XPane>& rxPane);
};

} } // end of namespace sd::framework

#endif
