#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.3 $
#
#   last change: $Author: hr $ $Date: 2007/08/02 14:28:35 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software  you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY  without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library  if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************

PRJ	= ..$/..$/..$/..$/..$/..
PRJNAME = reportdesign
TARGET  = sun-report-builder
PACKAGE = com$/sun$/star$/report$/pentaho
# we have circular dependencies
nodep=true
# --- Settings -----------------------------------------------------
.INCLUDE: settings.mk

#----- compile .java files -----------------------------------------

JARFILES        = ridl.jar unoil.jar jurt.jar juh.jar jut.jar java_uno.jar jcommon-1.0.10.jar libxml-0.9.5.jar jfreereport-0.9.0-05.jar libloader-0.3.4.jar sac.jar liblayout-0.2.6.jar jcommon-serializer-0.1.0.jar libfonts-0.2.6.jar libformula-0.1.8.jar
JAVAFILES       := $(shell $(FIND) . -name "*.java")
# JAVACLASSFILES	= $(foreach,i,$(JAVAFILES) $(CLASSDIR)$/$(PACKAGE)$/$(i:s/.java/.class/))

#----- copy .properties and .css files -----------------------------------------
# external find gives / for 4nt too...
# PROPERTYFILES := $(subst,/,$/ $(subst,./,$(CLASSDIR)$/$(PACKAGE)$/ $(shell $(FIND) . -name "*.properties")))
PROPERTYFILES := $(CLASSDIR)$/$(PACKAGE)$/configuration.properties \
				 $(CLASSDIR)$/$(PACKAGE)$/module.properties \
				 $(CLASSDIR)$/$(PACKAGE)$/parser$/selectors.properties
				 
# CSSFILES := $(subst,./,$(CLASSDIR)$/$(PACKAGE)$/ $(shell $(FIND) . -name "*.css"))
CSSFILES := $(CLASSDIR)$/$(PACKAGE)$/oasis-datastyle.css\
			$(CLASSDIR)$/$(PACKAGE)$/oasis-draw.css\
			$(CLASSDIR)$/$(PACKAGE)$/oasis-form.css\
			$(CLASSDIR)$/$(PACKAGE)$/oasis-style.css\
			$(CLASSDIR)$/$(PACKAGE)$/oasis-table.css\
			$(CLASSDIR)$/$(PACKAGE)$/oasis-text.css\
			$(CLASSDIR)$/$(PACKAGE)$/smil.css\
			$(CLASSDIR)$/$(PACKAGE)$/star-office.css\
			$(CLASSDIR)$/$(PACKAGE)$/star-report.css\
			$(CLASSDIR)$/$(PACKAGE)$/star-rpt.css\
			$(CLASSDIR)$/$(PACKAGE)$/svg.css\
			$(CLASSDIR)$/$(PACKAGE)$/xsl-fo.css

XSDFILES := $(CLASSDIR)$/$(PACKAGE)$/parser$/rpt-schema-v1.0-os.xsd \
			$(CLASSDIR)$/$(PACKAGE)$/styles$/stylemapper.xsd
			
XMLFILES := $(CLASSDIR)$/$(PACKAGE)$/styles$/stylemapper.xml
			
TXTFILES := $(CLASSDIR)$/$(PACKAGE)$/parser$/style-mapping.txt

			
#----- make a jar from compiled files ------------------------------

JARCLASSDIRS    = .
JARTARGET       = $(TARGET).jar
JARCOMPRESS 	= TRUE
CUSTOMMANIFESTFILE = Manifest.mf


# --- Targets ------------------------------------------------------
.INCLUDE :  target.mk

.IF "$(JARTARGETN)"!=""
$(JARTARGETN) : $(PROPERTYFILES) $(CSSFILES) $(XSDFILES) $(TXTFILES) $(XMLFILES)
.ENDIF          # "$(JARTARGETN)"!=""

$(CLASSDIR)$/$(PACKAGE)$/%.properties : %.properties
	@@-$(MKDIRHIER) $(@:d)
    $(COPY) $< $@

$(CLASSDIR)$/$(PACKAGE)$/%.css : %.css
	@@-$(MKDIRHIER) $(@:d)
    $(COPY) $< $@

$(CLASSDIR)$/$(PACKAGE)$/%.xsd : %.xsd
	@@-$(MKDIRHIER) $(@:d)
    $(COPY) $< $@
    
$(CLASSDIR)$/$(PACKAGE)$/%.xml : %.xml
	@@-$(MKDIRHIER) $(@:d)
    $(COPY) $< $@    

$(CLASSDIR)$/$(PACKAGE)$/%.txt : %.txt
	@@-$(MKDIRHIER) $(@:d)
    $(COPY) $< $@
    
