/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: cg_gate.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:35:52 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_CPP_CG_GATE_HXX
#define ARY_CPP_CG_GATE_HXX


// USED SERVICES
	// BASE CLASSES
#include <ary/cpp/crwg_grp.hxx>
#include <ary/cpp/crog_grp.hxx>
	// COMPONENTS
	// PARAMETERS


namespace ary
{
    namespace store
    {
        class Groups_Ifc;
    }

    class IdGenerator;

namespace cpp
{


class Gate_Groups : public ary::cpp::RwGate_Groups,
                    public ary::cpp::RoGate_Groups
{
  public:
	// LIFECYCLE
                        Gate_Groups(
                            ary::store::Groups_Ifc &
                                                io_rGroupStorage_Ifc,
                            ary::IdGenerator &  io_rIdGenerator );
    virtual             ~Gate_Groups();

  private:
    // Interface ary::cpp::RwGate_Groups:
	virtual ProjectGroup &
                        do_CheckIn_ProjectGroup(
							const udmstri &     i_sName,
                            Lid                 i_nSourceCodeRootDirectory );
	virtual FileGroup & do_CheckIn_FileGroup(
                            Lid                 i_nSourceCodeFile,
                            Gid                 i_nProjectGroup,
                            const udmstri &     i_sFileName );

    // Interface ary::cpp::RoGate_Groups:
    virtual const TopProject &
                        inq_Get_TopProject() const;
    virtual const ary::AryGroup *
                        inq_Find_Group(
                            Gid                 i_nId ) const;
    virtual const ProjectGroup *
                        inq_Find_ProjectGroup(
                            Gid                 i_nId ) const;
    virtual const ProjectGroup *
                        inq_Search_ProjectGroup(
                            const udmstri &     i_sProjectName ) const;
    virtual const FileGroup *
                        inq_Search_FileGroup(
                            Lid                 i_nAssociatedFileId ) const;
    // DATA
    ary::store::Groups_Ifc *
                        pGroupStorage_Ifc;
    ary::IdGenerator *  pIdGenerator;
};

// IMPLEMENTATION


} // namespace cpp
} // namespace ary



#endif

