/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ConceptLocation.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:44:54 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.util;

public final class ConceptLocation {
  /*BROKEN GCJ private*/ public int _concept;
  /*BROKEN GCJ private*/ public int _begin;
  /*BROKEN GCJ private*/ public int _end;
  
  private abstract class ConceptLocationSorter {
    abstract public boolean smallerThan(ConceptLocation a, ConceptLocation b);
    // part of quicksearch
    private int partition(ConceptLocation[] array, int p, int r) {
      ConceptLocation x = array[(p + r)/2];
      int i = p - 1, j = r + 1;
      while (true) {
	while (smallerThan(x, array[--j]))
	  ;
	while (smallerThan(array[++i], x))
	  ;
	if (i < j) {
	  ConceptLocation t = array[i];
	  array[i] = array[j];
	  array[j] = t;
	}
	else
	  return j;
      }
    }

    public void quicksort(ConceptLocation[] array, int p, int r) {
      while (p < r) {
	int q = partition(array, p, r);
	quicksort(array, p, q);
	p = q + 1;
      }
    }
  }

  private class ConceptSorter extends ConceptLocationSorter {
    public boolean smallerThan(ConceptLocation a, ConceptLocation b) {
      return a._concept < b._concept;
    }
  }
  
  private class PositionSorter extends ConceptLocationSorter {
    public boolean smallerThan(ConceptLocation a, ConceptLocation b) {
      return a._begin < b._begin || a._begin == b._begin && a._end < b._end;
    }
  }
  // sorter by concept ID
  private static ConceptLocationSorter _cComp;
  // sorter by position
  private static ConceptLocationSorter _pComp;

  private ConceptLocation() {
    _cComp = new ConceptSorter();
    _pComp = new PositionSorter();
  }

  static { new ConceptLocation(); }

  public ConceptLocation(int conceptID, int begin, int end) {
    _concept = conceptID;
    _begin = begin;
    _end = end;
  }
  
  public boolean equals(ConceptLocation other) {
    return _concept==other._concept&&_begin==other._begin&&_end==other._end;
  }

  public void setConcept(int concept) {
    _concept = concept;
  }
  
  public int getConcept() {
    return _concept;
  }
  
  public int getBegin() {
    return _begin;
  }
  
  public int getEnd() {
    return _end;
  }
  
  public int getLength() {
    return _end - _begin;
  }
  
  public static void sortByConcept(ConceptLocation[] array, int i1, int i2) {
    _cComp.quicksort(array, i1, i2 - 1);
  }
  
  public static void sortByPosition(ConceptLocation[] array, int i1, int i2) {
    _pComp.quicksort(array, i1, i2 - 1);
  }
  
  public void print() {
    System.out.println(_concept+"\t"+_begin+"\t"+_end);
  }

  public static void main(String[] args) {
    int limit = 30, b;
    ConceptLocation[] array = new ConceptLocation[limit];
    for (int i = 0; i < limit; i++)
      array[i] = new ConceptLocation((int)(Math.random()*1000),
				     b = (int)(Math.random()*1000),
				     b + (int)(Math.random()*10));
    for (int i = 0; i < limit; i++)
      array[i].print();
    ConceptLocation.sortByConcept(array, 0, limit);
    System.out.println("----------------------------------");
    for (int i = 0; i < limit; i++)
      array[i].print();
    ConceptLocation.sortByPosition(array, 0, limit);
    System.out.println("----------------------------------");
    for (int i = 0; i < limit; i++)
      array[i].print();
  }
}

