/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: QueryEngine.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:32:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.qe;

import java.util.StringTokenizer;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.File;
import java.net.URL;
import com.sun.xmlsearch.util.*;

public class QueryEngine {
  private static double INFLpenalty = 0.5;
  private SearchEnvironment _env;
  private LiteMorph _morph = LiteMorph_en.getMorph();

  public QueryEngine(String indexDir) throws Exception {
    _env = new SearchEnvironment(indexDir);
  }

  public void close() throws java.io.IOException {
    _env.close();
  }

  public void processQuery(String query)
    throws Exception {
      StringTokenizer terms = new StringTokenizer(query);
      int nTerms = terms.countTokens();
      IntegerArray[] columns = new IntegerArray[nTerms];
      int[] primary = new int[nTerms];
      int nValidTerms = 0;
      while (terms.hasMoreTokens()) {
	String term = terms.nextToken().toLowerCase();
	String[] variants = _morph.variantsOf(term);
	int id = _env.fetch(term);
	IntegerArray ids = new IntegerArray();
	StringTokenizer forms = new StringTokenizer(term);
	for (int i = 0; i < variants.length; i++) {
	  int formID = _env.fetch(variants[i]);
	  if (formID > 0 && formID != id)
	    ids.add(formID);
	}
	if (ids.cardinality() > 0 || id > 0) {
	  columns[nValidTerms] = ids;
	  primary[nValidTerms] = id;
	  nValidTerms++;
	}
      }
      Search search = new Search(_env);
      search.addQuery(nValidTerms);
      for (int i = 0; i < nValidTerms; i++) {
	if (primary[i] > 0)
	  search.addTerm(i, primary[i], 0.0, 0);
	for (int j = 0; j < columns[i].cardinality(); j++)
	  search.addTerm(i, columns[i].at(j), INFLpenalty, 0);
      }
      search.startSearch();
      search.printResults(25);
  }

  public static void main(String[] args) {
    try {
      // BufferedReader is needed for readLine() method
      BufferedReader in =
	// but we'll make it a degenerate buffer of 1
	// to workaround a problem with some PC implementation
	// which wouldn't start to read before a lot of chars
	// were typed
	new BufferedReader(new InputStreamReader(System.in), 1);
      QueryEngine qe = new QueryEngine(args[0]);
      System.out.println("initialized; enter query");
      while (true) {
	String line = in.readLine();
	if (line.equals("."))
	  break;
	else {
	  long start = System.currentTimeMillis();
	  qe.processQuery(line);
	  System.out.println((System.currentTimeMillis()-start)
			     +" msec search");
	}
	System.out.println("enter next query or . to quit");
      }
      qe.close();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
}
