/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: viewcontactpainthelper.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 13:31:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#ifndef _SDR_CONTACT_VIEWCONTACTPAINTHELPER_HXX
#include <svx/sdr/contact/viewcontactpainthelper.hxx>
#endif

#ifndef _SDR_CONTACT_VIEWOBJECTCONTACTREDIRECTOR_HXX
#include <svx/sdr/contact/viewobjectcontactredirector.hxx>
#endif

#ifndef _SDR_CONTACT_VIEWOBJECTCONTACT_HXX
#include <svx/sdr/contact/viewobjectcontact.hxx>
#endif

#ifndef _SDR_CONTACT_VIEWCONTACT_HXX
#include <svx/sdr/contact/viewcontact.hxx>
#endif

#ifndef _SVDOBJ_HXX
#include <svdobj.hxx>
#endif

#ifndef _SDR_PROPERTIES_PROPERTIES_HXX
#include <svx/sdr/properties/properties.hxx>
#endif

#ifndef SVX_XFILLIT0_HXX
#include <xfillit0.hxx>
#endif

#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif

#ifndef _SVX_XLINEIT0_HXX
#include <xlineit0.hxx>
#endif

#ifndef _XOUTX_HXX
#include <xoutx.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////
// ViewContact Paint helpers

namespace sdr
{
	namespace contact
	{
		// process the BackgroundObject painting
		sal_Bool PaintBackgroundObject(
			ViewContact& rPainter,
			SdrObject& rBackgroundObject,
			DisplayInfo& rDisplayInfo, 
			Rectangle& rPaintRectangle, 
			const ViewObjectContact& rAssociatedVOC)
		{
			sal_Bool bRetval(sal_False);

			// get the correct redirector
			ViewObjectContactRedirector* pRedirector = rAssociatedVOC.GetRedirector();

			if(pRedirector)
			{
				// for historical reasons if the pPaintProc is set we need
				// to call the old paint mechanism here to get created the output
				// into the metafile(s).
				rBackgroundObject.DoPaintObject(
					*rDisplayInfo.GetExtendedOutputDevice(), 
					*rDisplayInfo.GetPaintInfoRec());

				rPaintRectangle = rPainter.GetPaintRectangle();
				bRetval = sal_True;
			}
			else
			{
				// use pFillProperties to paint a object in the size of the page
				const SfxItemSet& rFillProperties = rBackgroundObject.GetProperties().GetObjectItemSet();

				Rectangle a2ndPaintRect;
				bRetval = PaintBackgroundObjectWithItemSet(
					rPainter, rDisplayInfo, rPaintRectangle, rFillProperties);
			}

			return bRetval;
		}

		// Paint a PageBackgroundObject with the size of the page and the attributes
		// of the given FillProperties
		sal_Bool PaintBackgroundObjectWithItemSet(
			ViewContact& rPainter,
			DisplayInfo& rDisplayInfo, Rectangle& rPaintRectangle,
			const SfxItemSet& rFillProperties)
		{
			sal_Bool bRetval(sal_False);
			XOutputDevice* pXOut = rDisplayInfo.GetExtendedOutputDevice();

			if(pXOut)
			{
				XFillStyle eFillStyle = ((XFillStyleItem&)(rFillProperties.Get(XATTR_FILLSTYLE))).GetValue();

				if(XFILL_NONE != eFillStyle)
				{
					Rectangle aPaintRectangle = rPainter.GetPaintRectangle();
					SfxItemSet aEmptySet(*rFillProperties.GetPool());
					aEmptySet.Put(XLineStyleItem(XLINE_NONE));

					pXOut->SetLineAttr(aEmptySet);
					pXOut->SetFillAttr(rFillProperties);
					pXOut->DrawRect(aPaintRectangle);

					rPaintRectangle = aPaintRectangle;
					bRetval = sal_True;
				}
			}

			return bRetval;
		}
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
