/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fuinsleg.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:12:52 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

#include <svx/flstitem.hxx>
#ifndef _CTRLTOOL_HXX //autogen
#include <svtools/ctrltool.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif
#ifndef _SFX_OBJSH_HXX //autogen
#include <sfx2/objsh.hxx>
#endif

#include "schattr.hxx"
#define ITEMID_CHARTLEGENDPOS	SCHATTR_LEGEND_POS
#include <svx/chrtitem.hxx>

#include "app.hrc"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "viewshel.hxx"
#include "schresid.hxx"
#include "strings.hrc"
#include "legend.hxx"
#include "uninsleg.hxx"
#include "fuinsleg.hxx"

TYPEINIT1(SchFuInsertLegend, SchFuPoor);


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuInsertLegend::SchFuInsertLegend(SchViewShell* pViewSh, SchWindow* pWin,
									 SchView* pView, ChartModel* pDoc,
									 SfxRequest& rReq) :
	SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	nMarkedID           = 0;

	const SfxItemSet* pArgs = rReq.GetArgs();
	SfxItemSet aAttr(pDoc->GetFullLegendAttr());
	
	//	Determine current position of the legend.
	const SfxPoolItem * pLegendPosItem = aAttr.GetItem (SCHATTR_LEGEND_POS);
	SvxChartLegendPos eOldPos = pLegendPosItem!=NULL 
		? static_cast<const SvxChartLegendPosItem*>(pLegendPosItem)->GetValue()
		: CHLEGEND_NONE;
	if (!pDoc->GetShowLegend ())
		eOldPos = CHLEGEND_NONE;

	if (!pArgs)
	{
//      FG: Mit dieser Zeile erhaelt man keinen modalen Dialog => Absturz falls ein Resize im Chart
//      stattfindet waehrend dieser Dialog geoeffnet ist.
//  		SchLegendDlg* pDlg = new SchLegendDlg(&pViewSh->GetViewFrame()->GetWindow(), aAttr);
		SchLegendDlg* pDlg = new SchLegendDlg(NULL, aAttr);

		if (pDlg->Execute() == RET_OK)
		{
			pDlg->GetAttr(aAttr);
			rReq.Done(aAttr);
			pArgs = rReq.GetArgs();
			delete pDlg;
		}
		else
		{
			delete pDlg;
			return;
		}

		pChDoc->CanRebuild (TRUE);
	}
	else pChDoc->CanRebuild (FALSE);

	pViewSh->GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

	SvxChartLegendPos eNewPos = ((const SvxChartLegendPosItem&)pArgs->Get(SCHATTR_LEGEND_POS)).GetValue();

	if (eOldPos != eNewPos)
	{
		pDoc->SetLegendHasBeenMoved(FALSE);//#50913#
		pDoc->SetShowLegend (eNewPos != CHLEGEND_NONE);
		pDoc->ChangeLegendAttr(*pArgs);//, FALSE);
		SchUndoInsertLegend* pUndo = new SchUndoInsertLegend(*pDoc, eOldPos, eNewPos, eOldPos != CHLEGEND_NONE,
															 eNewPos != CHLEGEND_NONE);//#36258# != statt ==
		pUndo->SetComment(String(SchResId(STR_UNDO_INSERT_LEGEND)));
		pViewSh->GetViewFrame()->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);
	}

	RemarkObject ();
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuInsertLegend::Activate()
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuInsertLegend::Deactivate()
{
}



