/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: edit.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/28 03:13:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef EDIT_HXX
#define EDIT_HXX

#ifndef _SV_WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif
#ifndef _SV_TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _TRANSFER_HXX
#include <svtools/transfer.hxx>
#endif
#ifndef _MyEDITDATA_HXX //autogen
#include <bf_svx/editdata.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
#include <svtools/colorcfg.hxx>
#endif

#ifndef _ACCESSIBILITY_HXX_
#include "accessibility.hxx"
#endif
class ScrollBar; 
class ScrollBarBox; 
class Menu; 
namespace binfilter {

class SmDocShell;
class SmViewShell;
class EditView;
class EditEngine;
class EditStatus;
class DataChangedEvent;

class SmCmdBoxWindow;

/**************************************************************************/

	void SmGetLeftSelectionPart(const ESelection aSelection,
								USHORT &nPara, USHORT &nPos);

/**************************************************************************/

class SmEditWindow : public Window, public DropTargetHelper
{

    SmCmdBoxWindow &rCmdBox;
	EditView	   *pEditView;
	ScrollBar	   *pHScrollBar,
				   *pVScrollBar;
	ScrollBarBox   *pScrollBox;
	Timer			aModifyTimer,
					aCursorMoveTimer;
	ESelection		aOldSelection;

	virtual void KeyInput(const KeyEvent& rKEvt);
	DECL_LINK(ModifyTimerHdl, Timer *);
	DECL_LINK(CursorMoveTimerHdl, Timer *);

	virtual void Resize();


	DECL_LINK(EditStatusHdl ,EditStatus *);
	DECL_LINK(ScrollHdl, ScrollBar *);

	void 		CreateEditView();

	Rectangle 	AdjustScrollBars();
	void 		SetScrollBarRanges();
	void 		InitScrollBars();

public:
    SmEditWindow( SmCmdBoxWindow &rMyCmdBoxWin );
	~SmEditWindow();

    SmDocShell *    GetDoc();
    EditView *      GetEditView()   { return pEditView; }
    EditEngine *    GetEditEngine();

	// Window
	virtual void		SetText(const XubString &rText);
	virtual XubString	GetText();
	virtual void		GetFocus();

	ESelection			GetSelection() const;

	BOOL 				IsEmpty() const;
	BOOL 				IsSelected() const;

	void 				Flush();

    void ApplyColorConfigValues( const svtools::ColorConfig &rColorCfg );

    // for Accessibility

};


} //namespace binfilter
#endif

