/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_pszctrl.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 21:33:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#include <limits.h>

#ifndef _STATUS_HXX //autogen
#include <vcl/status.hxx>
#endif
#ifndef _SV_IMAGE_HXX
#include <vcl/image.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXPTITEM_HXX //autogen
#include <svtools/ptitem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _SFX_OBJSH_HXX //autogen
#include <bf_sfx2/objsh.hxx>
#endif
#pragma hdrstop

#define _SVX_PSZCTRL_CXX

#include "pszctrl.hxx"

#define PAINT_OFFSET	5

#define ITEMID_SIZE		SID_ATTR_SIZE
#include "sizeitem.hxx"
#include "dialmgr.hxx"
#include "dlgutil.hxx"
#include "stbctrls.h"

#include "dialogs.hrc"

namespace binfilter {

// -----------------------------------------------------------------------

/*	[Beschreibung]

	Funktion, mit der ein metrischer Wert in textueller Darstellung
	umgewandelt wird.

	nVal ist hier der metrische Wert in der Einheit eUnit.

	[Querverweise]

	<SvxPosSizeStatusBarControl::Paint(const UserDrawEvent&)>
*/


// -----------------------------------------------------------------------

/*N*/ SFX_IMPL_STATUSBAR_CONTROL(SvxPosSizeStatusBarControl, SvxSizeItem);

// class FunctionPopup_Impl ----------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// struct SvxPosSizeStatusBarControl_Impl --------------------------------

struct SvxPosSizeStatusBarControl_Impl

/*	[Beschreibung]

	Diese Implementations-Struktur der Klasse SvxPosSizeStatusBarControl
	dient der Entkopplung von "Anderungen vom exportierten Interface sowie
	der Verringerung von extern sichtbaren Symbolen.

	Eine Instanz exisitiert pro SvxPosSizeStatusBarControl-Instanz
	f"ur deren Laufzeit.
*/

{
	Point   aPos;		// g"ultig, wenn eine Position angezeigt wird
	Size    aSize;		// g"ultig, wenn eine Gr"o/se angezeigt wird
	String	aStr;		// g"ultig, wenn ein Text angezeigt wird
	BOOL    bTime;		// Zeit und Datum anzeigen? (nichts anzeigen (#65302#))
	BOOL	bSize;		// Gr"o/se anzeigen?
	BOOL	bTable;		// Tabellenindex anzeigen?
	BOOL	bHasMenu;	// StarCalc Popup-Menue anzeigen?
	USHORT	nFunction;	// selektierte StarCalc Funktion
	Image	aPosImage; 	// Image f"ur die Positionsanzeige
	Image	aSizeImage;	// Image f"ur die Gr"o/senanzeige
};

// class SvxPosSizeStatusBarControl ------------------------------------------

/*	[Beschreibung]

	Ctor():
	Anlegen einer Impl-Klassen-Instanz, Default die Zeitanzeige enablen,
	Images fu"r die Position und Gro"sse laden.
*/

/*N*/ SvxPosSizeStatusBarControl::SvxPosSizeStatusBarControl( USHORT nId,
/*N*/ 														StatusBar& rStb,
/*N*/ 														SfxBindings& rBind ) :
/*N*/ 	SfxStatusBarControl( nId, rStb, rBind ),
/*N*/ 
/*N*/ 	aPosForwarder( SID_ATTR_POSITION, *this ),
/*N*/ 	aTableForwarder( SID_TABLE_CELL, *this ),
/*N*/ 	aFuncForwarder( SID_PSZ_FUNCTION, *this ),
/*N*/ 	pImp( new SvxPosSizeStatusBarControl_Impl )
/*N*/ 
/*N*/ {
/*N*/ 	pImp->bTime = TRUE;
/*N*/ 	pImp->bSize = FALSE;
/*N*/ 	pImp->bTable = FALSE;
/*N*/ 	pImp->bHasMenu = FALSE;
/*N*/ 	pImp->nFunction = 0;
/*N*/ 	pImp->aPosImage = Image( ResId( RID_SVXBMP_POSITION, DIALOG_MGR() ) );
/*N*/ 	pImp->aSizeImage = Image( ResId( RID_SVXBMP_SIZE, DIALOG_MGR() ) );
/*N*/ }

// -----------------------------------------------------------------------

/*	[Beschreibung]

	Dtor():
	Pointer auf die Impl-Klasse lo"schen, damit der Timer gestoppt wird.
*/

/*N*/ SvxPosSizeStatusBarControl::~SvxPosSizeStatusBarControl()
/*N*/ {
/*N*/ 	delete pImp;
/*N*/ }

// -----------------------------------------------------------------------

/*	[Beschreibung]

	SID_PSZ_FUNCTION aktiviert das Popup-Menue fuer Calc, ansonsten:

	Statusbenachrichtigung;
	Je nach Item-Typ wird eine bestimmte Anzeige enabled, die anderen disabled.

				NULL/Void	SfxPointItem	SvxSizeItem		SfxStringItem
	------------------------------------------------------------------------
	Zeit		TRUE		FALSE			FALSE			FALSE
	Position	FALSE										FALSE
	Gro"sse		FALSE						TRUE			FALSE
	Text		FALSE						FALSE			TRUE

	Ein anderes Item bewirkt einen Assert, die Zeitanzeige wird enabled.
*/

/*N*/ void SvxPosSizeStatusBarControl::StateChanged( USHORT nSID, SfxItemState eState,
/*N*/ 											   const SfxPoolItem* pState )
/*N*/ {
/*N*/ 	// da Kombi-Controller, immer die aktuelle Id als HelpId setzen
/*N*/ 	// gecachten HelpText vorher l"oschen
/*N*/ 	GetStatusBar().SetHelpText( GetId(), String() );
/*N*/ 	GetStatusBar().SetHelpId( GetId(), nSID );
/*N*/ 
/*N*/ 	if ( nSID == SID_PSZ_FUNCTION )
/*N*/ 	{
/*N*/ 		if ( eState == SFX_ITEM_AVAILABLE )
/*N*/ 		{
/*N*/ 			pImp->bHasMenu = TRUE;
/*N*/ 			if ( pState && pState->ISA(SfxUInt16Item) )
/*N*/ 				pImp->nFunction = ((const SfxUInt16Item*)pState)->GetValue();
/*N*/ 		}
/*N*/ 		else
/*N*/ 			pImp->bHasMenu = FALSE;
/*N*/ 	}
/*N*/ 	else if ( SFX_ITEM_AVAILABLE != eState )
/*N*/ 	{
/*N*/ 		// Datum und Zeit anzeigen
/*N*/ 		pImp->bTime = TRUE;
/*N*/ 		pImp->bSize = FALSE;
/*N*/ 		pImp->bTable = FALSE;
/*N*/ 	}
/*N*/ 	else if ( pState->ISA( SfxPointItem ) )
/*N*/ 	{
/*N*/ 		// Position anzeigen
/*N*/ 		pImp->aPos = ( (SfxPointItem*)pState )->GetValue();
/*N*/ 		pImp->bTime = FALSE;
/*N*/ 		pImp->bTable = FALSE;
/*N*/ 	}
/*N*/ 	else if ( pState->ISA( SvxSizeItem ) )
/*N*/ 	{
/*N*/ 		// Groesse anzeigen
/*N*/ 		pImp->aSize = ( (SvxSizeItem*)pState )->GetSize();
/*N*/ 		pImp->bSize = TRUE;
/*N*/ 		pImp->bTime = FALSE;
/*N*/ 		pImp->bTable = FALSE;
/*N*/ 	}
/*N*/ 	else if ( pState->ISA( SfxStringItem ) )
/*N*/ 	{
/*N*/ 		// String anzeigen (Tabellen-Zelle oder anderes)
/*N*/ 		pImp->aStr = ( (SfxStringItem*)pState )->GetValue();
/*N*/ 		pImp->bTable = TRUE;
/*N*/ 		pImp->bTime = FALSE;
/*N*/ 		pImp->bSize = FALSE;
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*?*/ 		DBG_ERRORFILE( "invalid item type" );
/*?*/ 		// trotzdem Datum und Zeit anzeigen
/*?*/ 		pImp->bTime = TRUE;
/*?*/ 		pImp->bSize = FALSE;
/*?*/ 		pImp->bTable = FALSE;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( GetStatusBar().AreItemsVisible() )
/*N*/ 		GetStatusBar().SetItemData( GetId(), 0 );
/*N*/ 
/*N*/ 	//	nur Strings auch als Text an der StatusBar setzen, damit Tip-Hilfe
/*N*/ 	//	funktioniert, wenn der Text zu lang ist.
/*N*/ 	String aText;
/*N*/ 	if ( pImp->bTable )
/*N*/ 		aText = pImp->aStr;
/*N*/ 	GetStatusBar().SetItemText( GetId(), aText );
/*N*/ }

// -----------------------------------------------------------------------

/*	[Beschreibung]

	Popup-Menue ausfuehren, wenn per Status enabled
*/


// -----------------------------------------------------------------------

/*	[Beschreibung]

	Je nach enableden Anzeigentyp, wird der Wert angezeigt. Vorher wird
	das Rectangle u"bermalt (gelo"scht).
*/

/*N*/ void SvxPosSizeStatusBarControl::Paint( const UserDrawEvent& rUsrEvt )
/*N*/ {
/*N*/ 	OutputDevice* pDev = rUsrEvt.GetDevice();
/*N*/ 	DBG_ASSERT( pDev, "no OutputDevice on UserDrawEvent" );
/*N*/ 	const Rectangle& rRect = rUsrEvt.GetRect();
/*N*/ 	StatusBar& rBar = GetStatusBar();
/*N*/ 	Point aItemPos = rBar.GetItemTextPos( GetId() );
/*N*/ 	Color aOldLineColor = pDev->GetLineColor();
/*N*/ 	Color aOldFillColor = pDev->GetFillColor();
/*N*/ 	pDev->SetLineColor();
/*N*/ 	pDev->SetFillColor( pDev->GetBackground().GetColor() );
/*N*/ 
/*N*/ 	if ( pImp->bTime )
/*N*/ 	{
/*N*/ 		// PB: Datum und Uhrzeit nicht mehr ausgeben (#65302#)
/*N*/ 		pDev->DrawRect( rRect );
/*N*/ 	}
/*N*/ 	else if ( !pImp->bTable )
/*N*/ 	{
/*N*/ 		// Position fuer Size-Anzeige berechnen
/*?*/	 DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		long nSizePosX =
/*?*/ 	}
/*?*/ 	else if ( pImp->bTable )
/*?*/ 	{
/*?*/ 		pDev->DrawRect( rRect );
/*?*/ 		pDev->DrawText( Point(
/*?*/ 			rRect.Left() + rRect.GetWidth() / 2 - pDev->GetTextWidth( pImp->aStr ) / 2,
/*?*/ 			aItemPos.Y() ),	pImp->aStr );
/*N*/ 	}
/*N*/ 
/*N*/ 	pDev->SetLineColor( aOldLineColor );
/*N*/ 	pDev->SetFillColor( aOldFillColor );
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ ULONG SvxPosSizeStatusBarControl::GetDefItemWidth(const StatusBar& rStb)
/*N*/ {
/*N*/ 	Image aTmpPosImage( ResId( RID_SVXBMP_POSITION, DIALOG_MGR() ) );
/*N*/ 	Image aTmpSizeImage( ResId( RID_SVXBMP_SIZE, DIALOG_MGR() ) );
/*N*/ 
/*N*/ 	ULONG nWidth=PAINT_OFFSET+aTmpPosImage.GetSizePixel().Width();
/*N*/ 	nWidth+=PAINT_OFFSET+aTmpSizeImage.GetSizePixel().Width();
/*N*/ 	nWidth+=2*(PAINT_OFFSET+rStb.GetTextWidth(String::CreateFromAscii("XXXX,XX / XXXX,XX")));
/*N*/ 
/*N*/ 	return nWidth;
/*N*/ }


}
