/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_fmctrler.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 20:54:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#pragma hdrstop

#define USE_PROPERTY_HELPER

#ifndef _COM_SUN_STAR_AWT_XFOCUSLISTENER_HPP_
#include <com/sun/star/awt/XFocusListener.hpp>
#endif

#ifndef _COM_SUN_STAR_SDBC_XROWSETLISTENER_HPP_
#include <com/sun/star/sdbc/XRowSetListener.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_SDB_XSQLQUERYCOMPOSERFACTORY_HPP_
#include <com/sun/star/sdb/XSQLQueryComposerFactory.hpp>
#endif

#ifndef _SVX_FMCTRLER_HXX
#include "fmctrler.hxx"
#endif
#ifndef _SVX_FMPROP_HRC
#include "fmprop.hrc"
#endif

#ifndef _COM_SUN_STAR_FORM_XLOADABLE_HPP_
#include <com/sun/star/form/XLoadable.hpp>
#endif



#ifndef _COM_SUN_STAR_FORM_XRESET_HPP_
#include <com/sun/star/form/XReset.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif
#ifndef _COM_SUN_STAR_SDB_XINTERACTIONSUPPLYPARAMETERS_HPP_
#include <com/sun/star/sdb/XInteractionSupplyParameters.hpp>
#endif




#ifndef _SVX_FMSHIMP_HXX
#include <fmshimp.hxx>
#endif



#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif

#ifndef _SFX_BINDINGS_HXX
#include <bf_sfx2/bindings.hxx>
#endif




#ifndef _COMPHELPER_INTERACTION_HXX_
#include <comphelper/interaction.hxx>
#endif
#ifndef _TOOLKIT_CONTROLS_UNOCONTROL_HXX_
#include <toolkit/controls/unocontrol.hxx>
#endif

#ifndef _COMPHELPER_CONTAINER_HXX_
#include <comphelper/container.hxx>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XCONTAINER_HPP_
#include <com/sun/star/container/XContainer.hpp>
#endif

namespace binfilter {

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::awt;
using namespace ::com::sun::star::sdb;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::task;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::form;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::beans;
using namespace ::comphelper;
using namespace ::connectivity;
using namespace ::binfilter::svxform;//STRIP008 using namespace ::svxform;
using namespace ::connectivity::simple;

extern sal_uInt16 AutoSlotMap[];

//==================================================================
// FmXAutoControl
//==================================================================
class OParameterContinuation : public OInteraction< XInteractionSupplyParameters >
{
    Sequence< PropertyValue >       m_aValues;

public:
    OParameterContinuation() { }


// XInteractionSupplyParameters
};

//------------------------------------------------------------------

//==================================================================
// FmXAutoControl
//==================================================================
struct FmFieldInfo
{
    ::rtl::OUString       aFieldName;
    Reference< XPropertySet >   xField;
    Reference< ::com::sun::star::awt::XTextComponent >  xText;

    FmFieldInfo(const Reference< XPropertySet >& _xField, const Reference< ::com::sun::star::awt::XTextComponent >& _xText)
        :xField(_xField)
        ,xText(_xText)
    {xField->getPropertyValue(FM_PROP_NAME) >>= aFieldName;}
};

//==================================================================
// FmXAutoControl
//==================================================================
class FmXAutoControl: public UnoControl

{
    friend Reference< XInterface > SAL_CALL FmXAutoControl_NewInstance_Impl();

public:
    FmXAutoControl(){}


protected:
};

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
/*N*/ IMPL_LINK(FmXFormController, OnTimeout, void*, EMPTYTAG)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
/*N*/ }

/*************************************************************************/

//------------------------------------------------------------------
/*N*/ Reference< XInterface > SAL_CALL
/*N*/     FmXFormController_NewInstance_Impl(const Reference< ::com::sun::star::lang::XMultiServiceFactory > & _rxORB)
/*N*/ {
/*N*/     return *(new FmXFormController(_rxORB));
/*N*/ }

//------------------------------------------------------------------
/*N*/ namespace fmctrlr
/*N*/ {
/*N*/ 	const ::rtl::OUString& getDataModeIdentifier()
/*N*/ 	{
/*N*/ 		static ::rtl::OUString s_sDataModeIdentifier = DATA_MODE;
/*N*/ 		return s_sDataModeIdentifier;
/*N*/ 	}
/*N*/ }
using namespace fmctrlr;

DBG_NAME( FmXFormController )
//------------------------------------------------------------------
/*N*/ FmXFormController::FmXFormController(const Reference< ::com::sun::star::lang::XMultiServiceFactory > & _rxORB,
/*N*/ 									 FmFormView* _pView, Window* _pWindow, const UniString& _sDispatchPrefix)
/*N*/ 				  :FmXFormController_BASE1(m_aMutex)
/*N*/ 				  ,OPropertySetHelper(FmXFormController_BASE1::rBHelper)
/*N*/ 				  ,OSQLParserClient(_rxORB)
/*N*/ 				  ,m_xORB(_rxORB)
/*N*/ 				  ,m_aActivateListeners(m_aMutex)
/*N*/ 				  ,m_aModifyListeners(m_aMutex)
/*N*/ 				  ,m_aErrorListeners(m_aMutex)
/*N*/ 				  ,m_aDeleteListeners(m_aMutex)
/*N*/ 				  ,m_aRowSetApproveListeners(m_aMutex)
/*N*/ 				  ,m_aParameterListeners(m_aMutex)
/*N*/ 				  ,m_pView(_pView)
/*N*/ 				  ,m_pWindow(_pWindow)
/*N*/ 				  ,m_bDBConnection(sal_False)
/*N*/ 				  ,m_bCycle(sal_False)
/*N*/ 				  ,m_bCanUpdate(sal_False)
/*N*/ 				  ,m_bCanInsert(sal_False)
/*N*/ 				  ,m_bModified(sal_False)
/*N*/ 				  ,m_nLoadEvent( 0 )
/*N*/ 				  ,m_bCommitLock(sal_False)
/*N*/ 				  ,m_bCurrentRecordModified(sal_False)
/*N*/ 				  ,m_bCurrentRecordNew(sal_False)
/*N*/ 				  ,m_bLocked(sal_False)
/*N*/ 				  ,m_aMode(getDataModeIdentifier())
/*N*/ 				  ,m_bFiltering(sal_False)
/*N*/ 				  ,m_bAttachEvents(sal_True)
/*N*/ 				  ,m_bDetachEvents(sal_True)
/*N*/ 				  ,m_nCurrentFilterPosition(0)
/*N*/ 				  ,m_sDispatchPrefix(_sDispatchPrefix)
/*N*/ 				  ,m_nUpdateDispatcherEvent(0)
/*N*/ 				  ,m_nToggleEvent(0)
/*N*/ {
/*N*/ 	DBG_CTOR( FmXFormController, NULL );
/*N*/ 
/*N*/ 	::comphelper::increment(m_refCount);
/*N*/ 	{
/*N*/ 		m_xAggregate = Reference< XAggregation > (m_xORB->createInstance(::rtl::OUString::createFromAscii("com.sun.star.awt.TabController")), UNO_QUERY);
/*N*/ 		DBG_ASSERT(m_xAggregate.is(), "FmXFormController::FmXFormController : could not create my aggregate !");
/*N*/ 		m_xTabController = Reference< ::com::sun::star::awt::XTabController > (m_xAggregate, UNO_QUERY);
/*N*/ 	}
/*N*/ 	if ( m_xAggregate.is() )
/*N*/ 		m_xAggregate->setDelegator(*this);
/*N*/ 
/*N*/     ::comphelper::decrement(m_refCount);
/*N*/ 
/*N*/     m_aInsertTimer.SetTimeout(500);
/*N*/     m_aInsertTimer.SetTimeoutHdl(LINK(this,FmXFormController,OnTimeout));
/*N*/ }

//------------------------------------------------------------------
/*N*/ FmXFormController::~FmXFormController()
/*N*/ {
/*N*/     if( m_nLoadEvent )
/*?*/         Application::RemoveUserEvent( m_nLoadEvent );
/*N*/ 
/*N*/     if (m_nToggleEvent)
/*?*/         Application::RemoveUserEvent( m_nToggleEvent );
/*N*/ 
/*N*/     if (m_nUpdateDispatcherEvent)
/*?*/         Application::RemoveUserEvent(m_nUpdateDispatcherEvent);
/*N*/ 
/*N*/     if (m_aInsertTimer.IsActive())
/*?*/         m_aInsertTimer.Stop();
/*N*/ 
/*N*/     // Freigeben der Aggregation
/*N*/     if (m_xAggregate.is())
/*N*/     {
/*?*/         Reference< XInterface >  xInt;
/*?*/         m_xAggregate->setDelegator(xInt);
/*N*/     }
/*N*/ 
/*N*/ 	DBG_DTOR( FmXFormController, NULL );
/*N*/ }

// -----------------------------------------------------------------------------
using namespace ::cppu;
using namespace ::osl;

/*N*/ void SAL_CALL FmXFormController::acquire() throw ()
/*N*/ {
/*N*/     FmXFormController_BASE1::acquire();
/*N*/ }
// -----------------------------------------------------------------------------
/*N*/ void SAL_CALL FmXFormController::release() throw ()
/*N*/ {
/*N*/     FmXFormController_BASE1::release();
/*N*/ }
// -----------------------------------------------------------------------------
// XUnoTunnel
/*N*/ Sequence< sal_Int8 > FmXFormController::getUnoTunnelImplementationId()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); Sequence< sal_Int8 > aSequence; return aSequence;//STRIP001 
/*N*/ }
//------------------------------------------------------------------------------
/*?*/ sal_Int64 SAL_CALL FmXFormController::getSomething(Sequence<sal_Int8> const& rId)throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001     if (rId.getLength() == 16 && 0 == rtl_compareMemory(getUnoTunnelImplementationId().getConstArray(),  rId.getConstArray(), 16 ) )
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ Sequence< Type > SAL_CALL FmXFormController::getTypes(  ) throw(RuntimeException)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); Sequence< Type > aType; return aType;//STRIP001 
/*N*/ }
//------------------------------------------------------------------
/*N*/ Any SAL_CALL FmXFormController::queryAggregation( const Type& _rType ) throw(RuntimeException)
/*N*/ {
/*N*/     Any aRet = FmXFormController_BASE1::queryAggregation(_rType);
/*N*/     if(!aRet.hasValue())
/*N*/     {
/*?*/         aRet = OPropertySetHelper::queryInterface(_rType);
/*?*/         if(!aRet.hasValue())
/*?*/         {
/*?*/             aRet = FmXFormController_BASE2::queryInterface(_rType);
/*?*/             if(!aRet.hasValue())
/*?*/                 aRet = FmXFormController_BASE3::queryInterface(_rType);
/*N*/         }
/*N*/     }
/*N*/     if(aRet.hasValue())
/*N*/         return aRet;
/*?*/     return m_xAggregate->queryAggregation(_rType);
/*N*/ }

// ::com::sun::star::lang::XServiceInfo
//------------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL FmXFormController::supportsService(const ::rtl::OUString& ServiceName) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001     Sequence< ::rtl::OUString> aSNL(static_getSupportedServiceNames());
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ ::rtl::OUString SAL_CALL FmXFormController::getImplementationName() throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); return ::rtl::OUString::createFromAscii("STRIP") ;//STRIP001     return ::rtl::OUString::createFromAscii("com.sun.star.form.FmXFormController");
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ Sequence< ::rtl::OUString> SAL_CALL FmXFormController::getSupportedServiceNames(void) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP");Sequence< ::rtl::OUString> aSequence; return aSequence;//STRIP001     return static_getSupportedServiceNames();
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL FmXFormController::approveReset(const ::com::sun::star::lang::EventObject& rEvent) throw( RuntimeException )
/*?*/ {
/*?*/     return sal_True;
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::resetted(const ::com::sun::star::lang::EventObject& rEvent) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     ::osl::MutexGuard aGuard(m_aMutex);
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ Sequence< ::rtl::OUString> FmXFormController::static_getSupportedServiceNames(void)
/*N*/ {
/*N*/     static Sequence< ::rtl::OUString> aServices;
/*N*/     if (!aServices.getLength())
/*N*/     {
/*N*/         aServices.realloc(2);
/*N*/         aServices.getArray()[0] = ::rtl::OUString::createFromAscii("com.sun.star.form.FormController");
/*N*/         aServices.getArray()[1] = ::rtl::OUString::createFromAscii("com.sun.star.awt.control.TabController");
/*N*/     }
/*N*/     return aServices;
/*N*/ }

//------------------------------------------------------------------------------

// OPropertySetHelper
//------------------------------------------------------------------------------
/*?*/ sal_Bool FmXFormController::convertFastPropertyValue( Any & rConvertedValue, Any & rOldValue,
/*?*/                                             sal_Int32 nHandle, const Any& rValue )
/*?*/                 throw( ::com::sun::star::lang::IllegalArgumentException )
/*?*/ {
/*?*/     return sal_False;
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::setFastPropertyValue_NoBroadcast( sal_Int32 nHandle, const Any& rValue )
/*?*/                          throw( ::com::sun::star::uno::Exception )
/*?*/ {
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormController::getFastPropertyValue( Any& rValue, sal_Int32 nHandle ) const
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//------------------------------------------------------------------------------
/*?*/ Reference< XPropertySetInfo >  FmXFormController::getPropertySetInfo() throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); Reference< XPropertySetInfo > aReference; return aReference;//STRIP001     static Reference< XPropertySetInfo >  xInfo( createPropertySetInfo( getInfoHelper() ) );
/*?*/ }

//------------------------------------------------------------------------------
#define DECL_PROP_CORE(varname, type) \
pDesc[nPos++] = Property(FM_PROP_##varname, FM_ATTR_##varname, ::getCppuType((const type*)0),


#define DECL_PROP1(varname, type, attrib1)  \
    DECL_PROP_CORE(varname, type) PropertyAttribute::attrib1)

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::fillProperties(
/*?*/         Sequence< Property >& /* [out] */ _rProps,
/*?*/         Sequence< Property >& /* [out] */ _rAggregateProps
/*?*/         ) const
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     _rProps.realloc(1);
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ ::cppu::IPropertyArrayHelper& FmXFormController::getInfoHelper()
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); return *getArrayHelper();//STRIP001     return *getArrayHelper();
/*?*/ }

// ::com::sun::star::container::XElementAccess
//------------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL FmXFormController::hasElements(void) throw( RuntimeException )
/*?*/ {{DBG_BF_ASSERT(0, "STRIP"); } return NULL;
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ Type SAL_CALL  FmXFormController::getElementType(void) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001     return ::getCppuType((const Reference< ::com::sun::star::form::XFormController>*)0);
/*?*/ 
/*?*/ }

// ::com::sun::star::container::XEnumerationAccess
//------------------------------------------------------------------------------
/*?*/ Reference< ::com::sun::star::container::XEnumeration > SAL_CALL  FmXFormController::createEnumeration(void) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001     ::osl::MutexGuard aGuard( m_aMutex );
/*?*/ //STRIP001     return new ::comphelper::OEnumerationByIndex(this);
/*?*/ }

// ::com::sun::star::container::XIndexAccess
//------------------------------------------------------------------------------
/*?*/ sal_Int32 SAL_CALL FmXFormController::getCount(void) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ Any SAL_CALL FmXFormController::getByIndex(sal_Int32 Index) throw( ::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::WrappedTargetException, RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); Any a; return a;
/*?*/ }

//-----------------------------------------------------------------------------

//  EventListener
//------------------------------------------------------------------------------
/*N*/ void SAL_CALL FmXFormController::disposing(const ::com::sun::star::lang::EventObject& e) throw( RuntimeException )
/*N*/ {
/*N*/     // Ist der Container disposed worden
/*N*/ 	::osl::MutexGuard aGuard( m_aMutex );
/*N*/     Reference< ::com::sun::star::awt::XControlContainer >  xContainer(e.Source, UNO_QUERY);
/*N*/     if (xContainer.is())
/*N*/     {
/*N*/         setContainer(Reference< ::com::sun::star::awt::XControlContainer > ());
/*N*/     }
/*N*/     else
/*N*/     {
/*N*/         // ist ein Control disposed worden
/*N*/         Reference< ::com::sun::star::awt::XControl >  xControl(e.Source, UNO_QUERY);
/*N*/         if (xControl.is())
/*N*/         {
/*?*/             if (getContainer().is())
/*?*/				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/                 removeControl(xControl);
/*N*/         }
/*N*/     }
/*N*/ }

// OComponentHelper
//-----------------------------------------------------------------------------
/*N*/ void FmXFormController::disposing(void)
/*N*/ {
/*N*/     ::com::sun::star::lang::EventObject aEvt(static_cast< ::com::sun::star::form::XFormController* >(this));
/*N*/     // noch aktiv ?
/*N*/     if (m_xActiveControl.is())
/*N*/     {
/*?*/         m_aActivateListeners.notifyEach(&::com::sun::star::form::XFormControllerListener::formDeactivated, aEvt);
/*N*/     }
/*N*/ 
/*N*/     m_aActivateListeners.disposeAndClear(aEvt);
/*N*/     m_aModifyListeners.disposeAndClear(aEvt);
/*N*/     m_aErrorListeners.disposeAndClear(aEvt);
/*N*/     m_aDeleteListeners.disposeAndClear(aEvt);
/*N*/     m_aRowSetApproveListeners.disposeAndClear(aEvt);
/*N*/     m_aParameterListeners.disposeAndClear(aEvt);
/*N*/ 
/*N*/ 	removeBoundFieldListener();
/*N*/ 	stopFiltering();
/*N*/ 
/*N*/     m_aFilters.clear();
/*N*/ 
/*N*/     ::osl::MutexGuard aGuard( m_aMutex );
/*N*/     m_xActiveControl  = m_xCurrentControl = NULL;
/*N*/ 
/*N*/     for (FmFormControllers::const_iterator i = m_aChilds.begin();
/*N*/         i != m_aChilds.end(); i++)
/*N*/     {
/*N*/         // search the position of the model within the form
/*?*/         Reference< ::com::sun::star::form::XFormComponent >  xForm((*i)->getModel(), UNO_QUERY);
/*?*/         sal_uInt32 nPos = m_xModelAsIndex->getCount();
/*?*/         Reference< ::com::sun::star::form::XFormComponent > xTemp;
/*?*/         for( ; nPos; )
/*?*/         {
/*?*/ 
/*?*/             m_xModelAsIndex->getByIndex(--nPos) >>= xTemp;
/*?*/             if ((::com::sun::star::form::XFormComponent*)xForm.get() == (::com::sun::star::form::XFormComponent*)xTemp.get())
/*?*/             {
/*?*/                 Reference< XInterface >  xIfc(*i, UNO_QUERY);
/*?*/                 m_xModelAsManager->detach( nPos, xIfc);
/*?*/                 break;
/*N*/             }
/*N*/         }
/*N*/ 
/*N*/         Reference< ::com::sun::star::lang::XComponent > (*i, UNO_QUERY)->dispose();
/*N*/     }
/*N*/     m_aChilds.clear();
/*N*/ 
/*N*/     if (m_bDBConnection)
/*?*/		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/         unload();
/*N*/ 
/*N*/     setContainer(Reference< ::com::sun::star::awt::XControlContainer > ());
/*N*/     setModel(Reference< ::com::sun::star::awt::XTabControllerModel > ());
/*N*/     setParent(Reference< XInterface > ());
/*N*/ 
/*N*/     ::comphelper::disposeComponent(m_xComposer);
/*N*/ 
/*N*/     // the following members shouldn't be set to NULL
/*N*/     // Freigeben der Aggregation
/*N*/     if (m_xAggregate.is())
/*N*/     {
/*N*/         Reference< XInterface >  xInt;
/*N*/         m_xAggregate->setDelegator(xInt);
/*N*/     }
/*N*/     m_xAggregate        = NULL;
/*N*/     m_xTabController    = NULL;
/*N*/     m_xORB              = NULL;
/*N*/ 
/*N*/     m_bDBConnection = sal_False;
/*N*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::propertyChange(const PropertyChangeEvent& evt) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {{DBG_BF_ASSERT(0, "STRIP");}//STRIP001 
/*?*/ }

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

// ::com::sun::star::awt::XTextListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::textChanged(const ::com::sun::star::awt::TextEvent& e) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

// ::com::sun::star::awt::XItemListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::itemStateChanged(const ::com::sun::star::awt::ItemEvent& rEvent) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

// XModificationBroadcaster
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::addModifyListener(const Reference< ::com::sun::star::util::XModifyListener > & l) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::removeModifyListener(const Reference< ::com::sun::star::util::XModifyListener > & l) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

// XModificationListener
//------------------------------------------------------------------------------
/*?*/ void FmXFormController::modified(const EventObject& rEvent) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//  FocusListener
//------------------------------------------------------------------------------
/*?*/ void FmXFormController::focusGained(const ::com::sun::star::awt::FocusEvent& e) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::focusLost(const ::com::sun::star::awt::FocusEvent& e) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormController::setModel(const Reference< ::com::sun::star::awt::XTabControllerModel > & Model) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/     ::osl::MutexGuard aGuard( m_aMutex );
/*N*/     DBG_ASSERT(m_xTabController.is(), "FmXFormController::setModel : invalid aggregate !");
/*N*/ 
/*N*/     // disconnect from the old model
/*N*/     if (m_xModelAsIndex.is())
/*N*/     {
/*N*/         if (m_bDBConnection)
/*N*/         {
/*N*/             // we are currently working on the model
/*?*/             ::com::sun::star::lang::EventObject aEvt(m_xModelAsIndex);
/*?*/             unloaded(aEvt);
/*N*/         }
/*N*/ 
/*N*/         Reference< ::com::sun::star::form::XLoadable >  xForm(m_xModelAsIndex, UNO_QUERY);
/*N*/         if (xForm.is())
/*N*/             xForm->removeLoadListener(this);
/*N*/ 
/*N*/         Reference< ::com::sun::star::sdb::XSQLErrorBroadcaster >  xBroadcaster(m_xModelAsIndex, UNO_QUERY);
/*N*/         if (xBroadcaster.is())
/*N*/             xBroadcaster->removeSQLErrorListener(this);
/*N*/ 
/*N*/         Reference< ::com::sun::star::form::XDatabaseParameterBroadcaster >  xParamBroadcaster(m_xModelAsIndex, UNO_QUERY);
/*N*/         if (xParamBroadcaster.is())
/*N*/             xParamBroadcaster->removeParameterListener(this);
/*N*/     }
/*N*/ 
/*N*/     // set the new model wait for the load event
/*N*/     if (m_xTabController.is())
/*N*/         m_xTabController->setModel(Model);
/*N*/     m_xModelAsIndex = Reference< ::com::sun::star::container::XIndexAccess > (Model, UNO_QUERY);
/*N*/     m_xModelAsManager = Reference< ::com::sun::star::script::XEventAttacherManager > (Model, UNO_QUERY);
/*N*/ 
/*N*/     // only if both ifaces exit, the controller will work successful
/*N*/     if (!m_xModelAsIndex.is() || !m_xModelAsManager.is())
/*N*/     {
/*N*/         m_xModelAsManager = NULL;
/*N*/         m_xModelAsIndex = NULL;
/*N*/     }
/*N*/ 
/*N*/     if (m_xModelAsIndex.is())
/*N*/     {
/*N*/         // adding load and ui interaction listeners
/*N*/         Reference< ::com::sun::star::form::XLoadable >  xForm(Model, UNO_QUERY);
/*N*/         if (xForm.is())
/*N*/             xForm->addLoadListener(this);
/*N*/ 
/*N*/         Reference< ::com::sun::star::sdb::XSQLErrorBroadcaster >  xBroadcaster(Model, UNO_QUERY);
/*N*/         if (xBroadcaster.is())
/*N*/             xBroadcaster->addSQLErrorListener(this);
/*N*/ 
/*N*/         Reference< ::com::sun::star::form::XDatabaseParameterBroadcaster >  xParamBroadcaster(Model, UNO_QUERY);
/*N*/         if (xParamBroadcaster.is())
/*N*/             xParamBroadcaster->addParameterListener(this);
/*N*/ 
/*N*/         // well, is the database already loaded?
/*N*/         // then we have to simulate a load event
/*N*/         Reference< ::com::sun::star::form::XLoadable >  xCursor(m_xModelAsIndex, UNO_QUERY);
/*N*/         if (xCursor.is() && xCursor->isLoaded())
/*N*/         {
/*?*/             ::com::sun::star::lang::EventObject aEvt(xCursor);
/*?*/             loaded(aEvt);
/*N*/         }
/*N*/     }
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ Reference< ::com::sun::star::awt::XTabControllerModel >  FmXFormController::getModel() throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/     DBG_ASSERT(m_xTabController.is(), "FmXFormController::getModel : invalid aggregate !");
/*N*/     if (!m_xTabController.is())
/*?*/         return Reference< ::com::sun::star::awt::XTabControllerModel > ();
/*N*/     return m_xTabController->getModel();
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormController::addToEventAttacher(const Reference< ::com::sun::star::awt::XControl > & xControl)
/*N*/ {
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/     // anmelden beim Eventattacher
/*N*/     Reference< ::com::sun::star::form::XFormComponent >  xComp(xControl->getModel(), UNO_QUERY);
/*N*/     if (xComp.is() && m_xModelAsIndex.is())
/*N*/     {
/*N*/         // Und die Position des ControlModel darin suchen
/*N*/         sal_uInt32 nPos = m_xModelAsIndex->getCount();
/*N*/         Reference< ::com::sun::star::form::XFormComponent > xTemp;
/*N*/         for( ; nPos; )
/*N*/         {
/*N*/             m_xModelAsIndex->getByIndex(--nPos) >>= xTemp;
/*N*/             if ((::com::sun::star::form::XFormComponent*)xComp.get() == (::com::sun::star::form::XFormComponent*)xTemp.get())
/*N*/             {
/*N*/                 Reference< XInterface >  xIfc(xControl, UNO_QUERY);
/*N*/                 m_xModelAsManager->attach( nPos, xIfc, makeAny(xControl) );
/*N*/                 break;
/*N*/             }
/*N*/         }
/*N*/     }
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormController::removeFromEventAttacher(const Reference< ::com::sun::star::awt::XControl > & xControl)
/*N*/ {
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/     // abmelden beim Eventattacher
/*N*/     Reference< ::com::sun::star::form::XFormComponent >  xComp(xControl->getModel(), UNO_QUERY);
/*N*/     if ( xComp.is() && m_xModelAsIndex.is() )
/*N*/     {
/*N*/         // Und die Position des ControlModel darin suchen
/*N*/         sal_uInt32 nPos = m_xModelAsIndex->getCount();
/*N*/         Reference< ::com::sun::star::form::XFormComponent > xTemp;
/*N*/         for( ; nPos; )
/*N*/         {
/*N*/             m_xModelAsIndex->getByIndex(--nPos) >>= xTemp;
/*N*/             if ((::com::sun::star::form::XFormComponent*)xComp.get() == (::com::sun::star::form::XFormComponent*)xTemp.get())
/*N*/             {
/*N*/                 Reference< XInterface >  xIfc(xControl, UNO_QUERY);
/*N*/                 m_xModelAsManager->detach( nPos, xIfc );
/*N*/                 break;
/*N*/             }
/*N*/         }
/*N*/     }
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormController::setContainer(const Reference< ::com::sun::star::awt::XControlContainer > & xContainer) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/     Reference< ::com::sun::star::awt::XTabControllerModel >  xTabModel(getModel());
/*N*/     DBG_ASSERT(xTabModel.is() || !xContainer.is(), "No Model defined");
/*N*/         // if we have a new container we need a model
/*N*/     DBG_ASSERT(m_xTabController.is(), "FmXFormController::setContainer : invalid aggregate !");
/*N*/ 
/*N*/     ::osl::MutexGuard aGuard( m_aMutex );
/*N*/     Reference< ::com::sun::star::container::XContainer >  xCurrentContainer;
/*N*/     if (m_xTabController.is())
/*N*/         xCurrentContainer = Reference< ::com::sun::star::container::XContainer > (m_xTabController->getContainer(), UNO_QUERY);
/*N*/     if (xCurrentContainer.is())
/*N*/     {
/*N*/         xCurrentContainer->removeContainerListener(this);
/*N*/ 
/*N*/         if (m_aInsertTimer.IsActive())
/*?*/             m_aInsertTimer.Stop();
/*N*/ 
/*N*/         // bei den Controls abmelden
/*N*/         sal_Int32 nCount = m_aControls.getLength();
/*N*/         const Reference< ::com::sun::star::awt::XControl > * pControls = m_aControls.getConstArray();
/*N*/ 
/*N*/         // clear the filter map
/*N*/         for (FmFilterControls::const_iterator iter = m_aFilterControls.begin();
/*N*/              iter != m_aFilterControls.end(); ++iter)
/*?*/             (*iter).first->removeTextListener(this);
/*N*/ 
/*N*/         m_aFilterControls.clear();
/*N*/ 
/*N*/         // einsammeln der Controls
/*N*/         for (sal_Int32 i = 0; i < nCount; ++i, ++pControls)
/*N*/         {
/*N*/             // bei jedem Control als FocusListener anmelden
/*N*/             Reference< ::com::sun::star::awt::XWindow >  xWindow(*pControls, UNO_QUERY);
/*N*/             if (xWindow.is())
/*N*/             {
/*N*/                 xWindow->removeFocusListener(this);
/*N*/ 
/*N*/                 // abmelden beim Eventattacher
/*N*/                 removeFromEventAttacher(*pControls);
/*N*/             }
/*N*/ 
/*N*/             Reference< ::com::sun::star::frame::XDispatchProviderInterception >  xInterception(*pControls, UNO_QUERY);
/*N*/             if (xInterception.is())
/*?*/				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/                 deleteInterceptor(xInterception);
/*N*/ 
/*N*/             if (pControls->is())
/*N*/             {
/*N*/                 Reference< ::com::sun::star::form::XReset >  xControlReset((*pControls)->getModel(), UNO_QUERY);
/*N*/                 if (xControlReset.is())
/*N*/                     xControlReset->removeResetListener((::com::sun::star::form::XResetListener*)this);
/*N*/             }
/*N*/         }
/*N*/ 
/*N*/         // Datenbank spezifische Dinge vornehmen
/*N*/         if (m_bDBConnection && isListeningForChanges())
/*?*/			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/             stopListening();
/*N*/ 
/*N*/         m_aControls = Sequence< Reference< ::com::sun::star::awt::XControl > >();
/*N*/     }
/*N*/ 
/*N*/     if (m_xTabController.is())
/*N*/         m_xTabController->setContainer(xContainer);
/*N*/ 
/*N*/     // Welche Controls gehoeren zum Container ?
/*N*/     if (xContainer.is() && xTabModel.is())
/*N*/     {
/*N*/         Sequence< Reference< ::com::sun::star::awt::XControlModel > > aModels = xTabModel->getControlModels();
/*N*/         const Reference< ::com::sun::star::awt::XControlModel > * pModels = aModels.getConstArray();
/*N*/         Sequence< Reference< ::com::sun::star::awt::XControl > > xCtrls = xContainer->getControls();
/*N*/ 
/*N*/         sal_Int32 nCount = aModels.getLength();
/*N*/         m_aControls = Sequence< Reference< ::com::sun::star::awt::XControl > >( nCount );
/*N*/         Reference< ::com::sun::star::awt::XControl > * pControls = m_aControls.getArray();
/*N*/ 
/*N*/         // einsammeln der Controls
/*N*/         sal_Int32 i, j;
/*N*/         for (i = 0, j = 0; i < nCount; ++i )
/*N*/         {
/*N*/             Reference< ::com::sun::star::awt::XControlModel >  xCtrlModel = pModels[i];
/*N*/             // Zum Model passendes Control suchen
/*N*/             Reference< ::com::sun::star::awt::XControl >  xCtrl = findControl( xCtrls, xCtrlModel,sal_False );
/*N*/             if (xCtrl.is())
/*N*/             {
/*N*/                 pControls[j++] = xCtrl;
/*N*/ 
/*N*/                 // bei jedem Control als FocusListener anmelden
/*N*/                 Reference< ::com::sun::star::awt::XWindow >  xWindow(xCtrl, UNO_QUERY);
/*N*/                 if (xWindow.is())
/*N*/                 {
/*N*/                     xWindow->addFocusListener(this);
/*N*/                     // anmelden beim Eventattacher
/*N*/                     addToEventAttacher(xCtrl);
/*N*/                 }
/*N*/ 
/*N*/                 // add a dispatch interceptor to the control (if supported)
/*N*/                 Reference< ::com::sun::star::frame::XDispatchProviderInterception >  xInterception(xCtrl, UNO_QUERY);
/*N*/                 if (xInterception.is())
/*?*/					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/                     createInterceptor(xInterception);
/*N*/ 
/*N*/                 // we want to know about the reset of the the model of our controls
/*N*/                 // (for correctly resetting m_bModified)
/*N*/                 Reference< ::com::sun::star::form::XReset >  xControlReset(xCtrl->getModel(), UNO_QUERY);
/*N*/                 if (xControlReset.is())
/*N*/                     xControlReset->addResetListener((::com::sun::star::form::XResetListener*)this);
/*N*/             }
/*N*/         }
/*N*/ 
/*N*/         // nicht fuer jedes Model ein Control
/*N*/         if (j != i)
/*N*/             m_aControls.realloc(j);
/*N*/ 
/*N*/         // am Container horchen
/*N*/         Reference< ::com::sun::star::container::XContainer >  xNewContainer(xContainer, UNO_QUERY);
/*N*/         if (xNewContainer.is())
/*N*/             xNewContainer->addContainerListener(this);
/*N*/ 
/*N*/         // Datenbank spezifische Dinge vornehmen
/*N*/         if (m_bDBConnection)
/*N*/         {
/*?*/			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/             m_bLocked = determineLockState();
/*N*/         }
/*N*/     }
/*N*/     // befinden sich die Controls in der richtigen Reihenfolge
/*N*/     m_bControlsSorted = sal_True;
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ Reference< ::com::sun::star::awt::XControlContainer >  FmXFormController::getContainer() throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	::osl::MutexGuard aGuard( m_aMutex );
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/     DBG_ASSERT(m_xTabController.is(), "FmXFormController::getContainer : invalid aggregate !");
/*N*/     if (!m_xTabController.is())
/*?*/         return Reference< ::com::sun::star::awt::XControlContainer > ();
/*N*/     return m_xTabController->getContainer();
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ Sequence< Reference< ::com::sun::star::awt::XControl > > FmXFormController::getControls(void) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/     ::osl::MutexGuard aGuard( m_aMutex );
/*N*/     if (!m_bControlsSorted)
/*N*/     {
/*?*/         Reference< ::com::sun::star::awt::XTabControllerModel >  xModel = getModel();
/*?*/         if (!xModel.is())
/*?*/             return m_aControls;
/*?*/ 
/*?*/         Sequence< Reference< ::com::sun::star::awt::XControlModel > > aControlModels = xModel->getControlModels();
/*?*/         const Reference< ::com::sun::star::awt::XControlModel > * pModels = aControlModels.getConstArray();
/*?*/         sal_Int32 nModels = aControlModels.getLength();
/*?*/ 
/*?*/         Sequence< Reference< ::com::sun::star::awt::XControl > > aNewControls(nModels);
/*?*/ 
/*?*/         Reference< ::com::sun::star::awt::XControl > * pControls = aNewControls.getArray();
/*?*/         Reference< ::com::sun::star::awt::XControlModel >  xCtrlModel;
/*?*/         Reference< ::com::sun::star::awt::XControl >  xCtrl;
/*?*/ 
/*?*/         // Umsortieren der Controls entsprechend der TabReihenfolge
/*?*/         for (sal_Int32 i = 0, j = 0; i < nModels; i++)
/*?*/         {
/*?*/             xCtrlModel = pModels[i];
/*?*/ 
/*?*/             // Zum Model passendes Control suchen
/*?*/             xCtrl = findControl(m_aControls, xCtrlModel);
/*?*/             if (xCtrl.is())
/*?*/                 pControls[j++] = xCtrl;
/*?*/         }
/*?*/         m_aControls = aNewControls;
/*?*/         m_bControlsSorted = sal_True;
/*N*/     }
/*N*/     return m_aControls;
/*N*/ }

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::autoTabOrder() throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormController::activateTabOrder() throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/     ::osl::MutexGuard aGuard( m_aMutex );
/*N*/     DBG_ASSERT(m_xTabController.is(), "FmXFormController::activateTabOrder : invalid aggregate !");
/*N*/     if (m_xTabController.is())
/*N*/         m_xTabController->activateTabOrder();
/*N*/ }

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
/*N*/ Reference< ::com::sun::star::awt::XControl >  FmXFormController::findControl(Sequence< Reference< ::com::sun::star::awt::XControl > >& rCtrls, const Reference< ::com::sun::star::awt::XControlModel > & xCtrlModel ,sal_Bool _bRemove,sal_Bool _bOverWrite) const
/*N*/ {
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/     DBG_ASSERT( xCtrlModel.is(), "findControl - welches ?!" );
/*N*/ 
/*N*/     Reference< ::com::sun::star::awt::XControl > * pCtrls = rCtrls.getArray();
/*N*/     Reference< ::com::sun::star::awt::XControlModel >  xModel;
/*N*/     for ( sal_Int32 i = 0, nCount = rCtrls.getLength(); i < nCount; ++i )
/*N*/     {
/*N*/         // #66449# Speicherueberschreiber durch folgende Zeile
/*N*/         // Reference< ::com::sun::star::awt::XControlModel >  xModel(pCtrls[i].is() ? pCtrls[i]->getModel() : Reference< ::com::sun::star::awt::XControlModel > ());
/*N*/         if (pCtrls[i].is())
/*N*/         {
/*N*/             xModel = pCtrls[i]->getModel();
/*N*/             if ((::com::sun::star::awt::XControlModel*)xModel.get() == (::com::sun::star::awt::XControlModel*)xCtrlModel.get())
/*N*/             {
/*N*/                 Reference< ::com::sun::star::awt::XControl >  xCtrl( pCtrls[i] );
/*N*/ 				if ( _bRemove )
/*N*/ 					::comphelper::removeElementAt(rCtrls, i);
/*N*/ 				else if ( _bOverWrite )
/*N*/ 					pCtrls[i] = Reference< ::com::sun::star::awt::XControl >();
/*N*/                 return xCtrl;
/*N*/             }
/*N*/         }
/*N*/     }
/*?*/     return Reference< ::com::sun::star::awt::XControl > ();
/*N*/ }

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

// ::com::sun::star::form::XLoadListener
//------------------------------------------------------------------------------
/*?*/ void FmXFormController::loaded(const ::com::sun::star::lang::EventObject& rEvent) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {{DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 
/*?*/ }

//------------------------------------------------------------------------------

/*?*/ void FmXFormController::unloaded(const ::com::sun::star::lang::EventObject& rEvent) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::reloading(const ::com::sun::star::lang::EventObject& aEvent) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormController::reloaded(const ::com::sun::star::lang::EventObject& aEvent) throw( RuntimeException )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::unloading(const ::com::sun::star::lang::EventObject& aEvent) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ //STRIP001     unload();
/*?*/ }

//------------------------------------------------------------------------------
// -----------------------------------------------------------------------------
/*?*/ void FmXFormController::removeBoundFieldListener()
/*?*/ {{DBG_BF_ASSERT(0, "STRIP");}//STRIP001 
/*?*/ }
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

// ::com::sun::star::sdbc::XRowSetListener
//------------------------------------------------------------------------------
/*?*/ void FmXFormController::cursorMoved(const ::com::sun::star::lang::EventObject& event) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::rowChanged(const ::com::sun::star::lang::EventObject& event) throw( RuntimeException )
/*?*/ {
/*?*/     // not interested in ...
/*?*/ }
//------------------------------------------------------------------------------
/*?*/ void FmXFormController::rowSetChanged(const ::com::sun::star::lang::EventObject& event) throw( RuntimeException )
/*?*/ {
/*?*/     // not interested in ...
/*?*/ }


// ::com::sun::star::container::XContainerListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::elementInserted(const ::com::sun::star::container::ContainerEvent& evt) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::elementReplaced(const ::com::sun::star::container::ContainerEvent& evt) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::elementRemoved(const ::com::sun::star::container::ContainerEvent& evt) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::activateFirst() throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void FmXFormController::activateLast() throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

// ::com::sun::star::form::XFormController
//------------------------------------------------------------------------------
/*N*/ Reference< XControl> SAL_CALL FmXFormController::getCurrentControl(void) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	::osl::MutexGuard aGuard( m_aMutex );
/*N*/ 	return m_xCurrentControl;
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void SAL_CALL FmXFormController::addActivateListener(const Reference< XFormControllerListener > & l) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	::osl::MutexGuard aGuard( m_aMutex );
/*N*/ 	OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/ 	m_aActivateListeners.addInterface(l);
/*N*/ }
//------------------------------------------------------------------------------
/*N*/ void SAL_CALL FmXFormController::removeActivateListener(const Reference< XFormControllerListener > & l) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
/*N*/ void FmXFormController::stopFiltering()
/*N*/ {
/*N*/     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*N*/ 	if ( !m_bFiltering ) // #104693# OJ
/*N*/ 	{	// nothing to do
/*N*/ 		return;
/*N*/ 	}
/*?*/ DBG_BF_ASSERT(0, "STRIP");//STRIP001 
/*N*/ }

// ::com::sun::star::util::XModeSelector
//------------------------------------------------------------------------------
/*?*/ void FmXFormController::setMode(const ::rtl::OUString& Mode) throw( ::com::sun::star::lang::NoSupportException, RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); 
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ ::rtl::OUString SAL_CALL FmXFormController::getMode(void) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); ::rtl::OUString a; return a;
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ Sequence< ::rtl::OUString > SAL_CALL FmXFormController::getSupportedModes(void) throw( RuntimeException )
/*?*/ {
/*?*/     DBG_BF_ASSERT(0, "STRIP"); Sequence< ::rtl::OUString > aModes; return aModes;//STRIP001 OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ sal_Bool SAL_CALL FmXFormController::supportsMode(const ::rtl::OUString& Mode) throw( RuntimeException )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*N*/ }

//------------------------------------------------------------------------------
// ::com::sun::star::sdb::XRowSetApproveListener
//------------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL FmXFormController::approveRowChange(const ::com::sun::star::sdb::RowChangeEvent& aEvent) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL FmXFormController::approveCursorMove(const ::com::sun::star::lang::EventObject& event) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL FmXFormController::approveRowSetChange(const ::com::sun::star::lang::EventObject& event) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;	
/*?*/ }

// ::com::sun::star::sdb::XRowSetApproveBroadcaster
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::addRowSetApproveListener(const Reference< ::com::sun::star::sdb::XRowSetApproveListener > & _rxListener) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); 
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::removeRowSetApproveListener(const Reference< ::com::sun::star::sdb::XRowSetApproveListener > & _rxListener) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); 
/*?*/ }

// ::com::sun::star::form::XErrorListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::errorOccured(const ::com::sun::star::sdb::SQLErrorEvent& aEvent) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); 
/*?*/ }

// ::com::sun::star::form::XErrorBroadcaster
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::addSQLErrorListener(const Reference< ::com::sun::star::sdb::XSQLErrorListener > & aListener) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); 
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::removeSQLErrorListener(const Reference< ::com::sun::star::sdb::XSQLErrorListener > & aListener) throw( RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); 
/*?*/ }

// ::com::sun::star::form::XDatabaseParameterBroadcaster
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::addParameterListener(const Reference< ::com::sun::star::form::XDatabaseParameterListener > & aListener) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::removeParameterListener(const Reference< ::com::sun::star::form::XDatabaseParameterListener > & aListener) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

// ::com::sun::star::form::XDatabaseParameterListener
//------------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL FmXFormController::approveParameter(const ::com::sun::star::form::DatabaseParameterEvent& aEvent) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

// ::com::sun::star::form::XConfirmDeleteBroadcaster
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::addConfirmDeleteListener(const Reference< ::com::sun::star::form::XConfirmDeleteListener > & aListener) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::removeConfirmDeleteListener(const Reference< ::com::sun::star::form::XConfirmDeleteListener > & aListener) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

// ::com::sun::star::form::XConfirmDeleteListener
//------------------------------------------------------------------------------
/*?*/ sal_Bool SAL_CALL FmXFormController::confirmDelete(const ::com::sun::star::sdb::RowChangeEvent& aEvent) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP");  return NULL;//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ Reference< ::com::sun::star::frame::XDispatch >
/*?*/ FmXFormController::interceptedQueryDispatch(sal_uInt16 _nId, const ::com::sun::star::util::URL& aURL,
/*?*/                                             const ::rtl::OUString& aTargetFrameName, sal_Int32 nSearchFlags)
/*?*/                                             throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); Reference< ::com::sun::star::frame::XDispatch >  xReturn; return xReturn;//STRIP001     OSL_ENSURE(!FmXFormController_BASE1::rBHelper.bDisposed,"FmXFormController: Object already disposed!");
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::dispatch( const URL& _rURL, const Sequence< PropertyValue >& _rArgs ) throw (RuntimeException)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	OSL_ENSURE(sal_False, "FmXFormController::dispatch: never to be called!");
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::addStatusListener( const Reference< XStatusListener >& _rxListener, const URL& _rURL ) throw (RuntimeException)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001     if (_rURL.Complete == FMURL_CONFIRM_DELETION)
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormController::removeStatusListener( const Reference< XStatusListener >& _rxListener, const URL& _rURL ) throw (RuntimeException)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	OSL_ENSURE(_rURL.Complete == FMURL_CONFIRM_DELETION, "FmXFormController::removeStatusListener: invalid (unsupported) URL!");
/*?*/ }

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------




}
