/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: starmath_view.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:58:46 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SV_DECOVIEW_HXX //autogen
#include <vcl/decoview.hxx>
#endif

#include <svtools/itemset.hxx>
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif

#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif

#ifndef _SVX_ZOOMITEM_HXX //autogen
#include <bf_svx/zoomitem.hxx>
#endif
#ifndef _MyEDITENG_HXX
#include <bf_svx/editeng.hxx>
#endif


#ifndef VIEW_HXX
#include "view.hxx"
#endif
#ifndef DOCUMENT_HXX
#include "document.hxx"
#endif
#ifndef TOOLBOX_HXX
#include "toolbox.hxx"
#endif
#ifndef _STARMATH_HRC
#include "starmath.hrc"
#endif


#define MINWIDTH		200
#define MINHEIGHT		200
#define MINSPLIT		40
#define SPLITTERWIDTH	2

#define MINZOOM 25
#define MAXZOOM 800

#define SmViewShell
namespace binfilter {
#include "smslots.hxx"

using namespace ::com::sun::star::accessibility;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;

//////////////////////////////////////////////////////////////////////

/*N*/ SmGraphicWindow::SmGraphicWindow(SmViewShell* pShell):
/*N*/ 	ScrollableWindow(&pShell->GetViewFrame()->GetWindow(), 0),
/*N*/ 	pViewShell(pShell),
/*N*/ 	nZoom(100),
/*N*/ 	bIsCursorVisible(FALSE)
/*N*/ {
/*N*/ 	Hide();
/*N*/ 	const Fraction aFraction (1,1);
/*N*/ 	SetMapMode( MapMode(MAP_100TH_MM, Point(), aFraction, aFraction));
/*N*/ 
/*N*/     ApplyColorConfigValues( SM_MOD1()->GetColorConfig() );
/*N*/ 
/*N*/     SetTotalSize();
/*N*/ 
/*N*/ 	SetHelpId(HID_SMA_WIN_DOCUMENT);
/*N*/ 	SetUniqueId(HID_SMA_WIN_DOCUMENT);
/*N*/ }

/*N*/ SmGraphicWindow::~SmGraphicWindow()
/*N*/ {
/*N*/     // Note: memory for pAccessible will be freed when the reference
/*N*/     // xAccessible is released.
/*N*/ }

/*N*/  void SmGraphicWindow::StateChanged( StateChangedType eType )
/*N*/  {
/*N*/  	if ( eType == STATE_CHANGE_INITSHOW )
/*N*/  		Show();
/*N*/  	ScrollableWindow::StateChanged( eType );
/*N*/  }


/*N*/ void SmGraphicWindow::ApplyColorConfigValues( const svtools::ColorConfig &rColorCfg )
/*N*/ {
/*N*/     // Note: SetTextColor not necessary since the nodes that
/*N*/     // get painted have the color information.
/*N*/ #if OSL_DEBUG_LEVEL > 1
/*N*/ 	ColorData nVal = rColorCfg.GetColorValue(svtools::DOCCOLOR).nColor;
/*N*/ #endif
/*N*/     SetBackground( Color( (ColorData) rColorCfg.GetColorValue(svtools::DOCCOLOR).nColor ) );
/*N*/     Invalidate();
/*N*/ }





/*N*/ void SmGraphicWindow::GetFocus()
/*N*/ {
/*N*/     ScrollableWindow::GetFocus();
/*N*/ }

/*N*/ void SmGraphicWindow::LoseFocus()
/*N*/ {
/*N*/     ScrollableWindow::LoseFocus();
/*N*/ }

/*N*/ void SmGraphicWindow::ShowCursor(BOOL bShow)
/*N*/ 	// shows or hides the formula-cursor depending on 'bShow' is TRUE or not
/*N*/ {
/*N*/ 	BOOL  bInvert = bShow != IsCursorVisible();
/*N*/ 
/*N*/ 	if (bInvert)
/*N*/ 		InvertTracking(aCursorRect, SHOWTRACK_SMALL | SHOWTRACK_WINDOW);
/*N*/ 
/*N*/ 	SetIsCursorVisible(bShow);
/*N*/ }


/*N*/ void SmGraphicWindow::SetCursor(const SmNode *pNode)
/*N*/ {
/*N*/ 	const SmNode *pTree = pViewShell->GetDoc()->GetFormulaTree();
/*N*/ 
/*N*/ 	// get appropriate rectangle
/*N*/ 	Point aOffset (pNode->GetTopLeft() - pTree->GetTopLeft()),
/*N*/ 		  aTLPos  (GetFormulaDrawPos() + aOffset);
/*N*/ 	aTLPos.X() -= pNode->GetItalicLeftSpace();
/*N*/ 	Size  aSize   (pNode->GetItalicSize());
/*N*/ 	Point aBRPos  (aTLPos.X() + aSize.Width(), aTLPos.Y() + aSize.Height());
/*N*/ 
/*N*/ 	SetCursor(Rectangle(aTLPos, aSize));
/*N*/ }

/*N*/ void SmGraphicWindow::SetCursor(const Rectangle &rRect)
/*N*/ 	// sets cursor to new position (rectangle) 'rRect'.
/*N*/ 	// The old cursor will be removed, and the new one will be shown if
/*N*/ 	// that is activated in the ConfigItem
/*N*/ {
/*N*/ 	SmModule *pp = SM_MOD1();
/*N*/ 
/*N*/ 	if (IsCursorVisible())
/*?*/ 		ShowCursor(FALSE);		// clean up remainings of old cursor
/*N*/ 	aCursorRect = rRect;
/*N*/ 	if (pp->GetConfig()->IsShowFormulaCursor())
/*N*/ 		ShowCursor(TRUE);		// draw new cursor
/*N*/ }

/*N*/ const SmNode * SmGraphicWindow::SetCursorPos(USHORT nRow, USHORT nCol)
/*N*/ 	// looks for a VISIBLE node in the formula tree with it's token at
/*N*/ 	// (or around) the position 'nRow', 'nCol' in the edit window
/*N*/ 	// (row and column numbering starts with 1 there!).
/*N*/ 	// If there is such a node the formula-cursor is set to cover that nodes
/*N*/ 	// rectangle. If not the formula-cursor will be hidden.
/*N*/ 	// In any case the search result is being returned.
/*N*/ {
/*N*/ 	// find visible node with token at nRow, nCol
/*N*/ 	const SmNode *pTree = pViewShell->GetDoc()->GetFormulaTree(),
/*N*/ 				 *pNode = 0;
/*N*/ 	if (pTree)
/*N*/ 		pNode = pTree->FindTokenAt(nRow, nCol);
/*N*/ 
/*N*/ 	if (pNode)
/*N*/ 		SetCursor(pNode);
/*N*/ 	else
/*N*/ 		ShowCursor(FALSE);
/*N*/ 
/*N*/ 	return pNode;
/*N*/ }


/*N*/ void SmGraphicWindow::Paint(const Rectangle&)
/*N*/ {
/*N*/ 	DBG_ASSERT(pViewShell, "Sm : NULL pointer");
/*N*/ 
/*N*/ 	SmDocShell &rDoc = *pViewShell->GetDoc();
/*N*/ 	Point aPoint;
/*N*/ 
/*N*/ 	rDoc.Draw(*this, aPoint);	//! modifies aPoint to be the topleft
/*N*/ 								//! corner of the formula
/*N*/ 	SetFormulaDrawPos(aPoint);
/*N*/ 
/*N*/ 	SetIsCursorVisible(FALSE);	// (old) cursor must be drawn again
/*N*/ 
/*N*/ 	const SmEditWindow *pEdit = pViewShell->GetEditWindow();
/*N*/ 	if (pEdit)
/*N*/ 	{	// get new position for formula-cursor (for possible altered formula)
/*N*/ 		USHORT	nRow, nCol;
/*N*/ 		SmGetLeftSelectionPart(pEdit->GetSelection(), nRow, nCol);
/*N*/ 		nRow++;
/*N*/ 		nCol++;
/*N*/ 		const SmNode *pFound = SetCursorPos(nRow, nCol);
/*N*/ 
/*N*/ 		SmModule  *pp = SM_MOD1();
/*N*/ 		if (pFound && pp->GetConfig()->IsShowFormulaCursor())
/*?*/ 			ShowCursor(TRUE);
/*N*/ 	}
/*N*/ }


/*N*/ void SmGraphicWindow::SetTotalSize ()
/*N*/ {
/*N*/ 	SmDocShell &rDoc = *pViewShell->GetDoc();
/*N*/ 	const Size aTmp( PixelToLogic( LogicToPixel( rDoc.GetSize() )));
/*N*/ 	if ( aTmp != ScrollableWindow::GetTotalSize() )
/*N*/ 		ScrollableWindow::SetTotalSize( aTmp );
/*N*/ }


/**************************************************************************/


/*N*/ SmGraphicController::SmGraphicController(SmGraphicWindow &rSmGraphic,
/*N*/ 						USHORT			nId,
/*N*/ 						SfxBindings 	&rBindings) :
/*N*/ 	rGraphic(rSmGraphic),
/*N*/ 	SfxControllerItem(nId, rBindings)
/*N*/ {
/*N*/ }


/*N*/ void SmGraphicController::StateChanged(USHORT nSID, SfxItemState eState, const SfxPoolItem* pState)
/*N*/ {
/*N*/ 	rGraphic.SetTotalSize();
/*N*/ 	rGraphic.Invalidate();
/*N*/ 	SfxControllerItem::StateChanged (nSID, eState, pState);
/*N*/ }


/**************************************************************************/


/*N*/ SmEditController::SmEditController(SmEditWindow &rSmEdit,
/*N*/ 					 USHORT 	  nId,
/*N*/ 					 SfxBindings  &rBindings) :
/*N*/ 	rEdit(rSmEdit),
/*N*/ 	SfxControllerItem(nId, rBindings)
/*N*/ {
/*N*/ }


/*N*/ #if OSL_DEBUG_LEVEL > 1
/*N*/ SmEditController::~SmEditController()
/*N*/ {
/*N*/ }
#endif


/*N*/ void SmEditController::StateChanged(USHORT nSID, SfxItemState eState, const SfxPoolItem* pState)
/*N*/ {
/*N*/ 	const SfxStringItem *pItem = PTR_CAST(SfxStringItem, pState);
/*N*/ 
/*N*/ 	if ((pItem != NULL) && (rEdit.GetText() != pItem->GetValue()))
/*N*/ 		rEdit.SetText(pItem->GetValue());
/*N*/ 	SfxControllerItem::StateChanged (nSID, eState, pState);
/*N*/ }


/**************************************************************************/

/*N*/ SmCmdBoxWindow::SmCmdBoxWindow(SfxBindings *pBindings, SfxChildWindow *pChildWindow,
/*N*/ 							   Window *pParent) :
/*N*/ 	SfxDockingWindow(pBindings, pChildWindow, pParent, SmResId(RID_CMDBOXWINDOW)),
/*N*/     aEdit       (*this),
/*N*/     aController (aEdit, SID_TEXT, *pBindings),
/*N*/     bExiting    (FALSE)
/*N*/ {
/*N*/ 	Hide ();
/*N*/ 	aGrabTimer.SetTimeout (1000);
/*N*/ 	aGrabTimer.SetTimeoutHdl (LINK (this, SmCmdBoxWindow, UpdateTimeoutHdl));
/*N*/ 	aGrabTimer.Start ();
/*N*/ }


/*N*/ SmCmdBoxWindow::~SmCmdBoxWindow ()
/*N*/ {
/*N*/     bExiting = TRUE;
/*N*/ 	aGrabTimer.Stop ();
/*N*/ }


/*N*/ SmViewShell * SmCmdBoxWindow::GetView()
/*N*/ {
/*N*/     SfxViewShell *pView = GetBindings().GetDispatcher()->GetFrame()->GetViewShell();
/*N*/     return PTR_CAST(SmViewShell, pView);
/*N*/ }



/*N*/ void SmCmdBoxWindow::Paint(const Rectangle& rRect)
/*N*/ {
/*N*/ 	Rectangle aRect = Rectangle(Point(0, 0), GetOutputSizePixel());
/*N*/ 	DecorationView aView(this);
/*N*/ 
/*N*/ 	if (! IsFloatingMode())
/*N*/ 	{
/*?*/ 		Point aFrom, aTo;
/*?*/ 		switch (GetAlignment())
/*?*/ 		{
/*?*/ 			case SFX_ALIGN_TOP:
/*?*/ 				aFrom = aRect.BottomLeft(); aTo = aRect.BottomRight();
/*?*/ 				aRect.Bottom()--;
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SFX_ALIGN_BOTTOM:
/*?*/ 				aFrom = aRect.TopLeft(); aTo = aRect.TopRight();
/*?*/ 				aRect.Top()++;
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SFX_ALIGN_LEFT:
/*?*/ 				aFrom = aRect.TopRight(); aTo = aRect.BottomRight();
/*?*/ 				aRect.Right()--;
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SFX_ALIGN_RIGHT:
/*?*/ 				aFrom = aRect.TopLeft(); aTo = aRect.BottomLeft();
/*?*/ 				aRect.Left()++;
/*?*/ 				break;
/*?*/ 		}
/*?*/ 		DrawLine( aFrom, aTo );
/*?*/ 		aView.DrawFrame(aRect, FRAME_DRAW_OUT);
/*N*/ 	}
/*N*/ 	aRect.Left() += 8; aRect.Top()	 += 8;
/*N*/ 	aRect.Right()-= 8; aRect.Bottom()-= 8;
/*N*/ 	aRect = aView.DrawFrame( aRect, FRAME_DRAW_DOUBLEIN );
/*N*/ }


/*
		case SFX_ALIGN_TOP:
		case SFX_ALIGN_BOTTOM:
*/


/*N*/ IMPL_LINK(SmCmdBoxWindow, UpdateTimeoutHdl, Timer *, pTimer)
/*N*/ {
/*N*/ 	aGrabTimer.Stop ();
/*N*/ 	Grab();
/*N*/ 	return 0;
/*N*/ }


/*N*/ void SmCmdBoxWindow::Grab ()
/*N*/ {
/*N*/ 	GrabFocus ();
/*N*/ 	aEdit.GrabFocus ();
/*N*/ }


/*N*/ SfxChildAlignment SmCmdBoxWindow::CheckAlignment(SfxChildAlignment eActual,
/*N*/ 											 SfxChildAlignment eWish)
/*N*/ {
/*N*/ 	switch (eWish)
/*N*/ 	{
/*N*/ 		case SFX_ALIGN_TOP:
/*N*/ 		case SFX_ALIGN_BOTTOM:
/*N*/ 		case SFX_ALIGN_NOALIGNMENT:
/*N*/ 			return eWish;
/*N*/ 	}
/*N*/ 
/*N*/ 	return eActual;
/*N*/ }


/*N*/ void SmCmdBoxWindow::StateChanged( StateChangedType nStateChange )
/*N*/ {
/*N*/ 	if (STATE_CHANGE_INITSHOW == nStateChange)
/*N*/     {
/*N*/         Resize();   // #98848# avoid SmEditWindow not being painted correctly
/*N*/ 
/*N*/         // set initial position of window in floating mode
/*N*/         if (TRUE == IsFloatingMode())
/*N*/             AdjustPosition();   //! don't change pos in docking-mode !
/*N*/     }
/*N*/ 
/*N*/     SfxDockingWindow::StateChanged( nStateChange );
/*N*/ }


/*N*/ void SmCmdBoxWindow::AdjustPosition()
/*N*/ {
/*N*/ 	Point aPt;
/*N*/ 	const Rectangle aRect( aPt, GetParent()->GetOutputSizePixel() );
/*N*/ 	Point aTopLeft( Point( aRect.Left(),
/*N*/ 						   aRect.Bottom() - GetSizePixel().Height() ) );
/*N*/ 	Point aPos( GetParent()->OutputToScreenPixel( aTopLeft ) );
/*N*/ 	if (aPos.X() < 0)
/*?*/ 		aPos.X() = 0;
/*N*/ 	if (aPos.Y() < 0)
/*?*/ 		aPos.Y() = 0;
/*N*/ 	SetPosPixel( aPos );
/*N*/ }


/*N*/ void SmCmdBoxWindow::ToggleFloatingMode()
/*N*/ {
/*N*/ 	SfxDockingWindow::ToggleFloatingMode();
/*N*/ 
/*N*/ 	if (GetFloatingWindow())
/*N*/ 		GetFloatingWindow()->SetMinOutputSizePixel(Size (200, 50));
/*N*/ }


/*N*/ void SmCmdBoxWindow::GetFocus()
/*N*/ {
/*N*/     if (!bExiting)
/*N*/         aEdit.GrabFocus();
/*N*/ }

/**************************************************************************/


/*N*/ SFX_IMPL_DOCKINGWINDOW(SmCmdBoxWrapper, SID_CMDBOXWINDOW);
/*N*/ 
/*N*/ SmCmdBoxWrapper::SmCmdBoxWrapper(Window *pParentWindow, USHORT nId,
/*N*/ 								 SfxBindings *pBindings,
/*N*/ 								 SfxChildWinInfo *pInfo) :
/*N*/ 	SfxChildWindow(pParentWindow, nId)
/*N*/ {
/*N*/ 	pWindow = new SmCmdBoxWindow(pBindings, this, pParentWindow);
/*N*/ 
/*N*/     // make window docked to the bottom initially (after first start)
/*N*/     eChildAlignment = SFX_ALIGN_BOTTOM;
/*N*/     ((SfxDockingWindow *)pWindow)->Initialize(pInfo);
/*N*/ }


#if OSL_DEBUG_LEVEL > 1
/*N*/ SmCmdBoxWrapper::~SmCmdBoxWrapper()
/*N*/ {
/*N*/ }
#endif

/**************************************************************************/


/*N*/ TYPEINIT1( SmViewShell, SfxViewShell );

/*N*/ SFX_IMPL_INTERFACE(SmViewShell, SfxViewShell, SmResId(0))
/*N*/ {
/*N*/ 	//Dummy-Objectbar, damit es bei aktivieren nicht staendig zuppelt.
/*N*/ // Wegen #58705# entfernt (RID wurde nirgends verwendet)
/*N*/ //	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_OBJECT | SFX_VISIBILITY_SERVER,
/*N*/ //								SmResId(RID_DRAW_OBJECTBAR) );
/*N*/ 
/*N*/ }


/*N*/ SFX_IMPL_VIEWFACTORY(SmViewShell, SmResId(RID_VIEWNAME))
/*N*/ {
/*N*/ 	SFX_VIEW_REGISTRATION(SmDocShell);
/*N*/ }

/*N*/ void SmViewShell::OuterResizePixel(const Point &rOfs, const Size &rSize)
/*N*/ {
/*N*/     SmGraphicWindow &rWin = GetGraphicWindow();
/*N*/     rWin.SetPosSizePixel(rOfs, rSize);
/*N*/     if (GetDoc()->IsPreview())
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/         rWin.ZoomToFitInWindow();
/*N*/     rWin.Update();
/*N*/ }

/*?*/ void SmViewShell::Impl_Print(
/*?*/         OutputDevice &rOutDev, const SmPrintSize ePrintSize,
/*?*/         Rectangle aOutRect, Point aZeroPoint )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ }

/*N*/ SfxPrinter* SmViewShell::GetPrinter(BOOL bCreate)
/*N*/ {
/*N*/ 	SmDocShell *pDoc = GetDoc();
/*N*/ 	if ( pDoc->HasPrinter() || bCreate )
/*N*/ 		return pDoc->GetPrinter();
/*N*/ 	return 0;
/*N*/ }

/*N*/ SmEditWindow *SmViewShell::GetEditWindow()
/*N*/ {
/*N*/ 	SmCmdBoxWrapper *pWrapper = (SmCmdBoxWrapper *) GetViewFrame()->
/*N*/ 			GetChildWindow( SmCmdBoxWrapper::GetChildWindowId() );
/*N*/ 
/*N*/ 	if (pWrapper != NULL)
/*N*/ 	{
/*N*/ 		SmEditWindow *pEditWin	= pWrapper->GetEditWindow();
/*N*/ 		DBG_ASSERT( pEditWin, "SmEditWindow missing" );
/*N*/ 		return pEditWin;
/*N*/ 	}
/*N*/ 
/*N*/ 	return NULL;
/*N*/ }


/*N*/ void SmViewShell::SetStatusText(const String& Text)
/*N*/ {
/*N*/ 	StatusText = Text;
/*N*/ 	GetViewFrame()->GetBindings().Invalidate(SID_TEXTSTATUS);
/*N*/ }


/*?*/ void SmViewShell::Execute(SfxRequest& rReq)
/*?*/ {
/*?*/ 		DBG_BF_ASSERT(0, "STRIP");//STRIP001 	SmEditWindow *pWin = GetEditWindow();
/*?*/ }


/*N*/ void SmViewShell::GetState(SfxItemSet &rSet)
/*N*/ {
/*N*/ 	SfxWhichIter aIter(rSet);
/*N*/ 
/*N*/     SmEditWindow *pEditWin = GetEditWindow();
/*N*/ 	for (USHORT nWh = aIter.FirstWhich(); nWh != 0; nWh = aIter.NextWhich())
/*N*/ 	{
/*N*/ 		switch (nWh)
/*N*/ 		{
/*N*/ 		case SID_CUT:
/*N*/ 		case SID_COPY:
/*N*/ 		case SID_DELETE:
/*N*/             if (! pEditWin || ! pEditWin->IsSelected())
/*N*/ 				rSet.DisableItem(nWh);
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SID_PASTE:
/*N*/             if( !xClipEvtLstnr.is()  &&  pEditWin)
/*N*/ 			{
/*N*/ 				AddRemoveClipboardListener( TRUE );
/*N*/ 				TransferableDataHelper aDataHelper(
/*N*/ 						TransferableDataHelper::CreateFromSystemClipboard(
/*N*/                                                         pEditWin) );
/*N*/ 
/*N*/ 				bPasteState = aDataHelper.GetTransferable().is() &&
/*N*/ 				 ( aDataHelper.HasFormat( FORMAT_STRING ) ||
/*N*/ 				   aDataHelper.HasFormat( SOT_FORMATSTR_ID_EMBEDDED_OBJ ) ||
/*N*/ 				   (aDataHelper.HasFormat( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR )
/*N*/ 				 	 && aDataHelper.HasFormat( SOT_FORMATSTR_ID_EMBED_SOURCE )));
/*N*/ 			}
/*N*/ 			if( !bPasteState )
/*N*/ 				rSet.DisableItem( nWh );
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SID_ATTR_ZOOM:
/*N*/ 			rSet.Put(SvxZoomItem( SVX_ZOOM_PERCENT, aGraphic.GetZoom()));
/*N*/ 			/* no break here */
/*N*/ 		case SID_VIEW050:
/*N*/ 		case SID_VIEW100:
/*N*/ 		case SID_VIEW200:
/*N*/ 		case SID_ADJUST:
/*N*/ 		case SID_ZOOMIN:
/*N*/ 		case SID_ZOOMOUT:
/*N*/ 		case SID_FITINWINDOW:
/*N*/ 			if ( GetDoc()->GetProtocol().IsInPlaceActive() )
/*?*/ 				rSet.DisableItem( nWh );
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SID_NEXTERR:
/*N*/ 		case SID_PREVERR:
/*N*/ 		case SID_NEXTMARK:
/*N*/ 		case SID_PREVMARK:
/*N*/ 		case SID_DRAW:
/*N*/ 		case SID_SELECT:
/*N*/             if (! pEditWin || pEditWin->IsEmpty())
/*N*/ 				rSet.DisableItem(nWh);
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SID_TEXTSTATUS:
/*N*/ 			{
/*N*/ 				rSet.Put(SfxStringItem(nWh, StatusText));
/*N*/ 			}
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SID_FORMULACURSOR:
/*N*/ 			{
/*N*/ 				SmModule *pp = SM_MOD1();
/*N*/ 				rSet.Put(SfxBoolItem(nWh, pp->GetConfig()->IsShowFormulaCursor()));
/*N*/ 			}
/*N*/ 			break;
/*N*/ 		}
/*N*/ 	}
/*N*/ }


/*N*/ SmViewShell::SmViewShell(SfxViewFrame *pFrame, SfxViewShell *):
/*N*/ 	SfxViewShell(pFrame, SFX_VIEW_DISABLE_ACCELS | SFX_VIEW_MAXIMIZE_FIRST | SFX_VIEW_HAS_PRINTOPTIONS | SFX_VIEW_CAN_PRINT),
/*N*/ 	aGraphic(this),
/*N*/ 	aGraphicController(aGraphic, SID_GRAPHIC, pFrame->GetBindings())
/*N*/ {
/*N*/ 	pViewFrame = &pFrame->GetWindow();
/*N*/ 
/*N*/ 	SetStatusText(String());
/*N*/ 	SetWindow(&aGraphic);
/*N*/ 	SfxShell::SetName(C2S("SmView"));
/*N*/ 	SfxShell::SetUndoManager( &GetDoc()->GetEditEngine().GetUndoManager() );
/*N*/ 	SetHelpId( HID_SMA_VIEWSHELL_DOCUMENT );
/*N*/ }


/*N*/ SmViewShell::~SmViewShell()
/*N*/ {
/*N*/ 	AddRemoveClipboardListener( FALSE );
/*N*/ 
/*N*/     //!! this view shell is not active anymore !!
/*N*/     // Thus 'SmGetActiveView' will give a 0 pointer.
/*N*/     // Thus we need to supply this view as argument
/*N*/     SmEditWindow *pEditWin = GetEditWindow();
/*N*/     if (pEditWin)
/*?*/     {DBG_BF_ASSERT(0, "STRIP");} //STRIP001     pEditWin->DeleteEditView( *this );
/*N*/ }

/*N*/ void SmViewShell::Deactivate( BOOL bIsMDIActivate )
/*N*/ {
/*N*/ 	SmEditWindow *pEdit = GetEditWindow();
/*N*/ 	if ( pEdit )
/*?*/ 		pEdit->Flush();
/*N*/ 
/*N*/ 	SfxViewShell::Deactivate( bIsMDIActivate );
/*N*/ }


/*N*/ void SmViewShell::Activate( BOOL bIsMDIActivate )
/*N*/ {
/*N*/ 	SfxViewShell::Activate( bIsMDIActivate );
/*N*/ 
/*N*/ 	SmEditWindow *pEdit = GetEditWindow();
/*N*/ 	if ( pEdit )
/*N*/ 	{
        //! Since there is no way to be informed if a "drag and drop"
        //! event has taken place, we call SetText here in order to
        //! syncronize the GraphicWindow display with the text in the
        //! EditEngine.
/*?*/          SmDocShell *pDoc = GetDoc();
/*?*/          pDoc->SetText( pDoc->GetEditEngine().GetText( LINEEND_LF ) );
/*?*/  
/*?*/  		if ( bIsMDIActivate )
/*?*/  			pEdit->GrabFocus();
/*N*/ 	}
/*N*/ }


}
