/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_topfrm.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:51:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include "topfrm.hxx"

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _TOOLKIT_UNOHLP_HXX
#include <toolkit/helper/vclunohelper.hxx>
#endif

#ifndef _SV_MENU_HXX
#include <vcl/menu.hxx>
#endif
#ifndef _SFXRECTITEM_HXX //autogen
#include <svtools/rectitem.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef   SVTOOLS_ASYNCLINK_HXX
#include <svtools/asynclink.hxx>
#endif

#include "sfx.hrc"
#include "docfile.hxx"
#include "viewsh.hxx"
#include "dispatch.hxx"
#include "request.hxx"
#include "fsetobsh.hxx"
#include "interno.hxx"
#include "objshimp.hxx"
#include "workwin.hxx"
#include "sfxhelp.hxx"
#include "fcontnr.hxx"


using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::frame;
//using namespace ::com::sun::star::util;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::beans;

//------------------------------------------------------------------------

#define SfxTopViewFrame
namespace binfilter {
#include "sfxslots.hxx"

/*N*/ DBG_NAME(SfxTopViewFrame)

class SfxTopFrame_Impl
{
public:
    Window*             pWindow;        // maybe external
    BOOL                bHidden;
    BOOL                bLockResize;
    BOOL                bMenuBarOn;
};

class SfxTopWindow_Impl : public Window
{
public:
	SfxTopFrame*   		pFrame;

    SfxTopWindow_Impl( SfxTopFrame* pF );
//        : Window( pF->pImp->pWindow, WB_CLIPCHILDREN | WB_NODIALOGCONTROL | WB_3DLOOK )
//        , pFrame( pF )
//    { SetBackground(); }
    ~SfxTopWindow_Impl( );

	virtual void		StateChanged( StateChangedType nStateChange );
	virtual long 		PreNotify( NotifyEvent& rNEvt );
	virtual long		Notify( NotifyEvent& rEvt );
	virtual void        Resize();
    virtual void        GetFocus();
	void				DoResize();
	DECL_LINK(			CloserHdl, void* );
};

/*N*/ SfxTopWindow_Impl::SfxTopWindow_Impl( SfxTopFrame* pF )
/*N*/         : Window( pF->pImp->pWindow, WB_BORDER | WB_CLIPCHILDREN | WB_NODIALOGCONTROL | WB_3DLOOK )
/*N*/         , pFrame( pF )
/*N*/ {
/*N*/     SetBackground(Wallpaper( Color( COL_WHITE ) ) );
/*N*/ }

/*N*/ SfxTopWindow_Impl::~SfxTopWindow_Impl( )
/*N*/ {
/*N*/ }


/*N*/ long SfxTopWindow_Impl::Notify( NotifyEvent& rNEvt )
/*N*/ {
/*N*/ 	if ( pFrame->IsClosing_Impl() || !pFrame->GetFrameInterface().is() )
/*N*/ 		return sal_False;
/*N*/ 
/*N*/     SfxViewFrame* pView = pFrame->GetCurrentViewFrame();
/*N*/     if ( !pView || !pView->GetObjectShell() || pView->GetObjectShell()->IsHandsOff() )
/*N*/         return Window::Notify( rNEvt );
/*N*/ 
/*N*/     if ( rNEvt.GetType() == EVENT_GETFOCUS )
/*N*/ 	{
/*N*/         SfxViewFrame* pCurrent = SfxViewFrame::Current();
/*N*/         SfxViewFrame* pContainer = pCurrent ? pCurrent->GetParentViewFrame_Impl() : NULL;
/*N*/         if ( !pContainer )
/*N*/             pContainer = pCurrent;
/*N*/         if ( pView && pView != pContainer )
/*?*/             pView->MakeActive_Impl( FALSE );
/*N*/         Window* pWindow = rNEvt.GetWindow();
/*N*/         ULONG nHelpId  = 0;
/*N*/         while ( !nHelpId && pWindow )
/*N*/         {
/*N*/             nHelpId = pWindow->GetHelpId();
/*N*/             pWindow = pWindow->GetParent();
/*N*/         }
/*N*/ 
/*N*/         if ( nHelpId )
/*N*/             SfxHelp::OpenHelpAgent( pFrame, nHelpId );
/*N*/ 	}
/*N*/     else if( rNEvt.GetType() == EVENT_KEYINPUT )
/*N*/ 	{
/*?*/         DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pView->GetViewShell()->KeyInput( *rNEvt.GetKeyEvent() ) )
/*N*/ 	}
/*N*/     else if ( rNEvt.GetType() == EVENT_EXECUTEDIALOG /*|| rNEvt.GetType() == EVENT_INPUTDISABLE*/ )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP");//STRIP001 
/*N*/ 	}
/*N*/ 	else if ( rNEvt.GetType() == EVENT_ENDEXECUTEDIALOG /*|| rNEvt.GetType() == EVENT_INPUTENABLE*/ )
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP");//STRIP001 
/*N*/ 	}
/*N*/ 
/*N*/     return Window::Notify( rNEvt );
/*N*/ }

/*N*/ long SfxTopWindow_Impl::PreNotify( NotifyEvent& rNEvt )
/*N*/ {
/*N*/ 	USHORT nType = rNEvt.GetType();
/*N*/ 	if ( nType == EVENT_KEYINPUT || nType == EVENT_KEYUP )
/*N*/     {DBG_BF_ASSERT(0, "STRIP");//STRIP001 
/*N*/ 	}
/*N*/ 	else if ( nType == EVENT_MOUSEBUTTONUP || nType == EVENT_MOUSEBUTTONDOWN )
/*N*/     {DBG_BF_ASSERT(0, "STRIP");//STRIP001 
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( nType == EVENT_MOUSEBUTTONDOWN )
/*N*/     {
/*N*/         Window* pWindow = rNEvt.GetWindow();
/*N*/         const MouseEvent* pMEvent = rNEvt.GetMouseEvent();
/*N*/         Point aPos = pWindow->OutputToScreenPixel( pMEvent->GetPosPixel() );
/*N*/         SfxWorkWindow *pWorkWin = pFrame->GetWorkWindow_Impl();
/*N*/         if ( pWorkWin )
/*N*/             pWorkWin->EndAutoShow_Impl( aPos );
/*N*/     }
/*N*/ 
/*N*/ 	return Window::PreNotify( rNEvt );
/*N*/ }

/*N*/ void SfxTopWindow_Impl::GetFocus()
/*N*/ {
/*N*/     if ( pFrame && !pFrame->IsClosing_Impl() && pFrame->GetCurrentViewFrame() && pFrame->GetFrameInterface().is() )
/*?*/         pFrame->GetCurrentViewFrame()->MakeActive_Impl( TRUE );
/*N*/ }

/*N*/ void SfxTopWindow_Impl::Resize()
/*N*/ {
/*N*/     if ( IsReallyVisible() || IsReallyShown() || GetOutputSizePixel().Width() )
/*N*/ 		DoResize();
/*N*/ }

/*N*/ void SfxTopWindow_Impl::StateChanged( StateChangedType nStateChange )
/*N*/ {
/*N*/ 	if ( nStateChange == STATE_CHANGE_INITSHOW )
/*N*/ 	{
/*N*/         SetSizePixel( GetParent()->GetOutputSizePixel() );
/*N*/ 		DoResize();
/*N*/         if ( pFrame->GetCurrentViewFrame() )
/*N*/             pFrame->GetCurrentViewFrame()->GetBindings().GetWorkWindow_Impl()->ShowChilds_Impl();
/*N*/ 	}
/*N*/ 	else
/*N*/         Window::StateChanged( nStateChange );
/*N*/ }

/*N*/ void SfxTopWindow_Impl::DoResize()
/*N*/ {
/*N*/     if ( !pFrame->pImp->bLockResize )
/*N*/         pFrame->Resize();
/*N*/ }

class StopButtonTimer_Impl : public Timer
{
	BOOL bState;
    SfxViewFrame* pFrame;
protected:
	virtual void Timeout();
public:
    StopButtonTimer_Impl( SfxViewFrame*);
	void SetButtonState( BOOL bStateP );
	BOOL GetButtonState() const { return bState; }
};

/*N*/ StopButtonTimer_Impl::StopButtonTimer_Impl( SfxViewFrame*p)
/*N*/ 	: bState( FALSE )
/*N*/     , pFrame( p )
/*N*/ {
/*N*/ 	SetTimeout( 200 );
/*N*/ }

/*N*/ void StopButtonTimer_Impl::SetButtonState( BOOL bStateP )
/*N*/ {
/*N*/ 	if( bStateP )
/*N*/ 	{
/*N*/ 		bState = TRUE;
/*N*/ 		Stop();
/*N*/ 	}
/*N*/ 	else if( bState )
/*N*/ 		Start();
/*N*/ }

/*N*/ void StopButtonTimer_Impl::Timeout()
/*N*/ {
/*N*/ 	bState = FALSE;
/*N*/     pFrame->GetBindings().Invalidate( SID_BROWSE_STOP );
/*N*/ }

class SfxTopViewWin_Impl : public Window
{
friend class SfxInternalFrame;

	BOOL				bActive;
    SfxTopViewFrame*    pFrame;

public:
                        SfxTopViewWin_Impl( SfxTopViewFrame* p,
								Window *pParent, WinBits nBits=0 ) :
							Window( pParent, nBits | WB_BORDER | WB_CLIPCHILDREN ),
							pFrame( p ),
							bActive( FALSE )
						{
                            p->GetFrame()->GetWindow().SetBorderStyle( WINDOW_BORDER_NOBORDER );
						}

	virtual void		Resize();
	virtual void		StateChanged( StateChangedType nStateChange );
};

//--------------------------------------------------------------------
/*N*/ void SfxTopViewWin_Impl::StateChanged( StateChangedType nStateChange )
/*N*/ {
/*N*/ 	if ( nStateChange == STATE_CHANGE_INITSHOW )
/*N*/         pFrame->Resize();
/*N*/ 	else
/*N*/         Window::StateChanged( nStateChange );
/*N*/ }

/*N*/ void SfxTopViewWin_Impl::Resize()
/*N*/ {
/*N*/     if ( IsReallyVisible() || IsReallyShown() || GetOutputSizePixel().Width() )
/*N*/         pFrame->Resize();
/*N*/ }

class SfxTopViewFrame_Impl
{
public:
    sal_Bool            bActive;
    Window*             pWindow;
    String          	aFactoryName;
    StopButtonTimer_Impl* pStopButtonTimer;

						SfxTopViewFrame_Impl()
							: bActive( sal_False )
                            , pWindow( 0 )
                            , pStopButtonTimer( 0 )
                        {}
};

static svtools::AsynchronLink* pPendingCloser = 0;



/*N*/ SfxTopFrame* SfxTopFrame::Create( Reference < XFrame > xFrame )
/*N*/ {
/*N*/     // create a new TopFrame to an external XFrame object ( wrap controller )
/*N*/     if ( !xFrame.is() )
/*N*/         DBG_ERROR( "Wrong parameter!" );
/*N*/ 
/*N*/     Window* pWindow = VCLUnoHelper::GetWindow( xFrame->getContainerWindow() );
/*N*/     SfxTopFrame* pFrame = new SfxTopFrame( pWindow );
/*N*/     pFrame->SetFrameInterface_Impl( xFrame );
/*N*/     return pFrame;
/*N*/ }

/*N*/ SfxTopFrame::SfxTopFrame( Window* pExternal, sal_Bool bHidden )
/*N*/ 	: SfxFrame( NULL )
/*N*/ 	, pWindow( NULL )
/*N*/ {
/*N*/     pImp = new SfxTopFrame_Impl;
/*N*/     pImp->bHidden = bHidden;
/*N*/     pImp->bLockResize = FALSE;
/*N*/     pImp->bMenuBarOn = TRUE;
/*N*/ 	InsertTopFrame_Impl( this );
/*N*/     if ( pExternal )
/*N*/     {
/*N*/         pImp->pWindow = pExternal;
/*N*/     }
/*N*/     else
/*N*/     {
/*N*/         DBG_ERROR( "TopFrame without window created!" );
/*
        pImp->pWindow = new SfxTopFrameWindow_Impl( this );
        pImp->pWindow->SetActivateMode( ACTIVATE_MODE_GRABFOCUS );
        pImp->pWindow->SetPosSizePixel( Point( 20,20 ), Size( 800,600 ) );
        if ( GetFrameInterface().is() )
            GetFrameInterface()->initialize( VCLUnoHelper::GetInterface( pImp->pWindow ) );
        pImp->pWindow->Show();
 */
/*N*/     }
/*N*/ 
/*N*/     pWindow = new SfxTopWindow_Impl( this );
/** AS:
    Hide this window till the component was realy loaded. Otherwhise it overpaint e.g. the old component hardly
    and produce repaint errors.
    pWindow->Show();
  */
/*N*/ }

/*N*/ SfxTopFrame::~SfxTopFrame()
/*N*/ {
/*N*/ 	RemoveTopFrame_Impl( this );
/*N*/     DELETEZ( pWindow );
/*N*/     delete pImp;
/*N*/ }


/*N*/ SystemWindow* SfxTopFrame::GetTopWindow_Impl() const
/*N*/ {
/*N*/     if ( pImp->pWindow->IsSystemWindow() )
/*N*/         return (SystemWindow*) pImp->pWindow;
/*N*/     else
/*N*/         return NULL;
/*N*/ }

/*N*/ Window& SfxTopFrame::GetWindow() const
/*N*/ {
/*N*/     return *pWindow;
/*N*/ }

/*N*/ sal_Bool SfxTopFrame::Close()
/*N*/ {
/*N*/ 	delete this;
/*N*/ 	return sal_True;
/*N*/ }

/*N*/ void SfxTopFrame::LockResize_Impl( BOOL bLock )
/*N*/ {
/*N*/     pImp->bLockResize = bLock;
/*N*/ }

/*N*/ void SfxTopFrame::SetMenuBar_Impl( MenuBar *pMenu )
/*N*/ {
/*N*/     if ( pMenu && !pImp->bMenuBarOn )
/*N*/         return;
/*N*/ 
/*N*/     SystemWindow *pWin = GetTopWindow_Impl();
/*N*/     if ( pWin && pWin->GetMenuBar() != pMenu )
/*N*/     {
/*N*/         pWin->SetMenuBar( pMenu );
/*N*/ 		if ( pMenu )
/*N*/ 		{
/*N*/ 			CheckMenuCloser_Impl( pMenu );
/*N*/ 			pMenu->SetCloserHdl( LINK( pWindow, SfxTopWindow_Impl, CloserHdl ) );
/*N*/ 		}
/*N*/     }
/*N*/ }

/*N*/ IMPL_LINK( SfxTopWindow_Impl, CloserHdl, void*, pVoid )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 	return 0L;
/*N*/ }



/*N*/ MenuBar* SfxTopFrame::GetMenuBar_Impl() const
/*N*/ {
/*N*/     SystemWindow *pWin = GetTopWindow_Impl();
/*N*/     return pWin ? pWin->GetMenuBar() : NULL;
/*N*/ }


/*N*/ sal_Bool SfxTopFrame::InsertDocument( SfxObjectShell* pDoc )
/* [Beschreibung]
 */
/*N*/ {
/*N*/ 	// Spezielle Bedingungen testen: nicht im ModalMode!
/*N*/ 	if ( !SfxFrame::InsertDocument( pDoc ) )
/*N*/ 		return sal_False;
/*N*/ 
/*N*/ 	SfxObjectShell *pOld = GetCurrentDocument();
/*N*/ 
/*N*/ 	// Position und Groesse testen
/*N*/ 	// Wenn diese schon gesetzt sind, soll offensichtlich nicht noch
/*N*/ 	// LoadWindows_Impl aufgerufen werden ( z.B. weil dieses ein CreateFrame()
/*N*/ 	// an einer Task aufgerufen hat! )
/*N*/ 	const SfxItemSet* pSet = GetItemSet_Impl();
/*N*/ 	if ( !pSet )
/*N*/ 		pSet = pDoc->GetMedium()->GetItemSet();
/*N*/ 	SetItemSet_Impl(0);
/*N*/ 
/*N*/     // Position und Gr"o\se
/*N*/ 	SFX_ITEMSET_ARG(
/*N*/ 		pSet, pAreaItem, SfxRectangleItem, SID_VIEW_POS_SIZE, sal_False );
/*N*/ 	// ::com::sun::star::sdbcx::View-Id
/*N*/ 	SFX_ITEMSET_ARG(
/*N*/ 		pSet, pViewIdItem, SfxUInt16Item, SID_VIEW_ID, sal_False );
/*N*/ 	// Zoom
/*N*/ 	SFX_ITEMSET_ARG(
/*N*/ 		pSet, pModeItem, SfxUInt16Item, SID_VIEW_ZOOM_MODE, sal_False );
/*N*/ 	// Hidden
/*N*/ 	SFX_ITEMSET_ARG(
/*N*/ 		pSet, pHidItem, SfxBoolItem,	SID_HIDDEN, sal_False);
/*N*/ 	// ViewDaten
/*N*/ 	SFX_ITEMSET_ARG(
/*N*/ 		pSet, pViewDataItem, SfxStringItem, SID_USER_DATA, sal_False );
/*N*/ 	// ViewOnly
/*N*/ 	SFX_ITEMSET_ARG(
/*N*/ 		pSet, pEditItem, SfxBoolItem, SID_VIEWONLY, sal_False);
/*N*/ 
/*N*/ 	if ( pEditItem  && pEditItem->GetValue() )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");}//STRIP001 SetMenuBarOn_Impl( FALSE );
/*N*/ 
/*N*/     if ( pHidItem )
/*N*/         pImp->bHidden = pHidItem->GetValue();
/*N*/ 
/*N*/     if( !pImp->bHidden )
/*N*/ 		pDoc->OwnerLock( sal_True );
/*N*/ 
/*N*/ 	// Wenn z.B. eine Fenstergr"o\se gesetzt wurde, soll keine Fensterinformation
/*N*/ 	// aus den Dokument geladen werden, z.B. weil InsertDocument seinerseits
/*N*/ 	// aus LoadWindows_Impl aufgerufen wurde!
/*N*/     if ( pDoc && !pAreaItem && !pViewIdItem && !pModeItem &&
/*N*/             !pImp->bHidden && pDoc->LoadWindows_Impl( this ) )
/*N*/ 	{
/*?*/ 		pDoc->OwnerLock( sal_False );
/*?*/ 		return sal_True;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( pDoc )
/*N*/ 	{
/*N*/ 		UpdateHistory( pDoc );
/*N*/ 		UpdateDescriptor( pDoc );
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxFrameSetObjectShell *pFDoc = PTR_CAST( SfxFrameSetObjectShell, pDoc );
/*N*/ 	if ( pFDoc )
/*?*/ 		SetFrameType_Impl( GetFrameType() | SFXFRAME_FRAMESET );
/*N*/ 	else
/*N*/ 		SetFrameType_Impl( GetFrameType() & ~SFXFRAME_FRAMESET );
/*N*/ 
/*N*/ 	sal_Bool bBrowsing = sal_True;
/*N*/     BOOL bSetFocus = GetWindow().HasChildPathFocus( TRUE );
/*N*/ 	SfxViewFrame *pFrame = GetCurrentViewFrame();
/*N*/ 	if ( pFrame )
/*N*/ 	{
/*?*/         DBG_BF_ASSERT(0, "STRIP"); //STRIP001 sal_Bool bChildActivated = sal_False;
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		bBrowsing = sal_False;
/*N*/ 		pFrame = new SfxTopViewFrame( this, pDoc, pViewIdItem ? pViewIdItem->GetValue() : 0 );
/*N*/ 	}
/*N*/ 
/*N*/     if ( pViewDataItem )
/*N*/ 	{
/*?*/ 		if ( pDoc->Get_Impl()->nLoadedFlags & SFX_LOADED_MAINDOCUMENT )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pFrame->GetViewShell()->ReadUserData( pViewDataItem->GetValue(), sal_True );
/*?*/ 		else
/*?*/ 		{
/*?*/ 			// Daten setzen, die in FinishedLoading ausgewertet werden
/*?*/ 			MarkData_Impl*& rpMark = pDoc->Get_Impl()->pMarkData;
/*?*/ 			if (!rpMark)
/*?*/ 				rpMark = new MarkData_Impl;
/*?*/ 			rpMark->pFrame = pFrame;
/*?*/ 			rpMark->aUserData = pViewDataItem->GetValue();
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	// Position und Groesse setzen
/*N*/ 	sal_uInt16 nWinMode = pModeItem ? pModeItem->GetValue() : 1;
/*N*/ 	if ( pAreaItem && !pOld )
/*N*/ 	{
/*?*/         Window *pWin = pImp->pWindow;
/*?*/ 
/*?*/ 		// Groesse setzen
/*?*/ 		const Rectangle aWinRect( pAreaItem->GetValue() );
/*?*/         const Size aAppWindow( pImp->pWindow->GetDesktopRectPixel().GetSize() );
/*?*/ 		Point aPos( aWinRect.TopLeft() );
/*?*/ 		Size aSz(aWinRect.GetSize());
/*?*/ 		if ( aSz.Width() && aSz.Height() )
/*?*/ 		{
/*?*/ 			aPos.X() = Min(aPos.X(),
/*?*/ 							long(aAppWindow.Width() - aSz.Width() + aSz.Width() / 2) );
/*?*/ 			aPos.Y() = Min(aPos.Y(),
/*?*/ 							long( aAppWindow.Height() - aSz.Height() + aSz.Height() / 2) );
/*?*/ 			if ( aPos.X() + aSz.Width() <
/*?*/ 					aAppWindow.Width() + aSz.Width() / 2 &&
/*?*/ 					aPos.Y() + aSz.Height() <
/*?*/ 					aAppWindow.Height() + aSz.Height() / 2 )
/*?*/ 			{
/*?*/ 				pWin->SetPosPixel( aPos );
/*?*/ 				pWin->SetOutputSizePixel( aSz );
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/     if ( !pImp->bHidden )
/*N*/ 	{
/*N*/ #if SUPD>638
/*N*/         if ( pDoc->IsHelpDocument() )
/*?*/             pFrame->GetDispatcher()->HideUI( TRUE );
/*N*/         else
/*N*/             pFrame->GetDispatcher()->HideUI( FALSE );
/*N*/ #endif
/*N*/ 		pFrame->Show();
/*N*/         GetWindow().Show();
/*N*/         pFrame->MakeActive_Impl( TRUE );
/*N*/ 		pDoc->OwnerLock( sal_False );
/*N*/         GetFrameInterface()->getContainerWindow()->setVisible( sal_True );
/*N*/         if( GetTopWindow_Impl()->HasFocus() )
/*?*/             pFrame->MakeActive_Impl( TRUE );
/*N*/ 	}
/*N*/ 
/*N*/     if ( bSetFocus )
/*?*/         // if the old component had the focus when it was destroyed, the focus has been transferred to
/*?*/         // the ViewFrameWindow
/*?*/         GrabFocusOnComponent_Impl();
/*N*/ 
/*N*/ 	// Jetzt UpdateTitle, hidden TopFrames haben sonst keinen Namen!
/*N*/ 	pFrame->UpdateTitle();
/*N*/ 
/*N*/ 	if ( pFrame->GetViewShell()->UseObjectSize() )
/*N*/ 	{
/*N*/ 		GetCurrentViewFrame()->UnlockAdjustPosSizePixel();
/*N*/ 		GetCurrentViewFrame()->Resize(TRUE);
/*N*/ 		GetCurrentViewFrame()->ForceInnerResize_Impl( FALSE );
/*N*/ 		GetCurrentViewFrame()->Resize(TRUE);
/*N*/ 	}
/*N*/ 
/*N*/ 	return sal_True;
/*N*/ }


//========================================================================


/*N*/ TYPEINIT1(SfxTopFrame, SfxFrame);
/*N*/ TYPEINIT1(SfxTopViewFrame, SfxViewFrame);

//--------------------------------------------------------------------
/*N*/ SFX_IMPL_INTERFACE(SfxTopViewFrame,SfxViewFrame,ResId(0,0))
/*N*/ {
/*N*/ }

//--------------------------------------------------------------------
/*N*/ String SfxTopViewFrame::UpdateTitle()

/*	[Beschreibung]

	Mit dieser Methode kann der SfxTopViewFrame gezwungen werden, sich sofort
	den neuen Titel vom der <SfxObjectShell> zu besorgen.

	[Anmerkung]

	Dies ist z.B. dann notwendig, wenn man der SfxObjectShell als SfxListener
	zuh"ort und dort auf den <SfxSimpleHint> SFX_HINT_TITLECHANGED reagieren
	m"ochte, um dann die Titel seiner Views abzufragen. Diese Views (SfxTopViewFrames)
	jedoch sind ebenfalls SfxListener und da die Reihenfolge der Benachrichtigung
	nicht feststeht, mu\s deren Titel-Update vorab erzwungen werden.


	[Beispiel]

	void SwDocShell::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
	{
		if ( rHint.IsA(TYPE(SfxSimpleHint)) )
		{
			switch( ( (SfxSimpleHint&) rHint ).GetId() )
			{
				case SFX_HINT_TITLECHANGED:
					for ( SfxTopViewFrame *pTop = (SfxTopViewFrame*)
								SfxViewFrame::GetFirst(this, TYPE(SfxTopViewFrame));
						  pTop;
						  pTop = (SfxTopViewFrame*)
								SfxViewFrame::GetNext(this, TYPE(SfxTopViewFrame));
					{
						pTop->UpdateTitle();
						... pTop->GetName() ...
					}
					break;
				...
			}
		}
	}
*/

/*N*/ {
/*N*/ 	DBG_CHKTHIS(SfxTopViewFrame, 0);
/*N*/ 
/*N*/     const SfxObjectFactory &rFact = GetObjectShell()->GetFactory();
/*N*/     if ( rFact.GetFilterContainer()->GetFilterCount() )
/*N*/ 	{
/*N*/         pImp->aFactoryName = String::CreateFromAscii( rFact.GetShortName() );
/*N*/ 		USHORT nSlotId = rFact.GetCreateNewSlotId();
/*N*/ 		if ( nSlotId )
/*N*/ 		{
/*N*/ 			pImp->aFactoryName += String::CreateFromAscii("?slot=");
/*N*/ 			pImp->aFactoryName += String::CreateFromInt32( (sal_Int32) nSlotId );
/*N*/ 		}
/*N*/ 	}
/*N*/     else
/*?*/         pImp->aFactoryName = String::CreateFromAscii( SfxObjectFactory::GetDefaultFactory().GetShortName() );
/*N*/ 
/*N*/     String aTitle = SfxViewFrame::UpdateTitle();
/*N*/ 	aTitle += String::CreateFromAscii( " - " );
/*N*/ 	aTitle += Application::GetDisplayName();
/*N*/ 
/*N*/     GetBindings().Invalidate( SID_NEWDOCDIRECT );
/*N*/ 
/*N*/     Window* pWindow = GetTopFrame_Impl()->GetTopWindow_Impl();
/*N*/     if ( pWindow && pWindow->GetText() != aTitle )
/*N*/         pWindow->SetText( aTitle );
/*N*/ 	return aTitle;
/*N*/ }

//--------------------------------------------------------------------
/*N*/ void SfxTopViewFrame::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
/*N*/ {
/*N*/ 	{DBG_CHKTHIS(SfxTopViewFrame, 0);}
/*N*/ 
/*N*/ 	if( IsDowning_Impl())
/*N*/ 		return;
/*N*/ 	// we know only SimpleHints
/*N*/ 	if ( rHint.IsA(TYPE(SfxSimpleHint)) )
/*N*/ 	{
/*N*/ 		switch( ( (SfxSimpleHint&) rHint ).GetId() )
/*N*/ 		{
/*N*/ 			case SFX_HINT_MODECHANGED:
/*N*/ 			case SFX_HINT_TITLECHANGED:
/*N*/ 				// when the document changes its title, change views too
/*N*/ 				UpdateTitle();
/*N*/ 				break;
/*N*/ 
/*N*/             case SFX_HINT_DEINITIALIZING:
/*N*/ 				// on all other changes force repaint
/*N*/ 				GetFrame()->DoClose();
/*N*/ 				return;
/*N*/ 				break;
/*N*/ 
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxViewFrame::SFX_NOTIFY( rBC, rBCType, rHint, rHintType );
/*N*/ }

//--------------------------------------------------------------------
/*N*/ sal_Bool SfxTopViewFrame::Close()
/*N*/ {
/*N*/ 	{DBG_CHKTHIS(SfxTopViewFrame, 0);}
/*N*/ 
/*N*/ 	// Modaler Dialog oben ??
/*N*/ //	if ( pImp->GetModalDialog() )
/*N*/ //		return sal_False;
/*N*/ 
/*N*/ 	// eigentliches Schlie\sen
/*N*/ 	if ( SfxViewFrame::Close() )
/*N*/ 	{
/*N*/         SfxApplication *pSfxApp = SFX_APP();
/*N*/         if (pSfxApp->GetViewFrame() == this)
/*N*/             pSfxApp->SetViewFrame(0);
/*N*/ 
/*N*/ 		// Da der Dispatcher leer ger"aumt wird, kann man ihn auch nicht mehr
/*N*/ 		// vern"unftig verwenden - also besser still legen
/*N*/ 		GetDispatcher()->Lock(sal_True);
/*N*/ 		delete this;
/*N*/ 
/*N*/ 		return sal_True;
/*N*/ 	}
/*N*/ 
/*N*/ 	return sal_False;
/*N*/ }

/*N*/ SfxTopViewFrame::SfxTopViewFrame
/*N*/ (
/*N*/ 	SfxFrame*			pFrame,
/*N*/ 	SfxObjectShell* 	pObjShell,
/*N*/ 	sal_uInt16				nViewId
/*N*/ )

/*	[Beschreibung]

	Ctor des SfxTopViewFrame f"ur eine <SfxObjectShell> aus der Ressource.
	Die 'nViewId' der zu erzeugenden <SfxViewShell> kann angegeben werden
	(default ist die zuerst registrierte SfxViewShell-Subklasse).
*/

/*N*/     : SfxViewFrame( *(new SfxBindings), pFrame, pObjShell, SFXFRAME_HASTITLE )
/*N*/ {
/*N*/ 	DBG_CTOR(SfxTopViewFrame, 0);
/*N*/ 
/*N*/ 	pCloser = 0;
/*N*/ 	pImp = new SfxTopViewFrame_Impl;
/*N*/     pImp->pStopButtonTimer = new StopButtonTimer_Impl(this);
/*N*/ 
/*N*/ //(mba)/task    if ( !pFrame->GetTask() )
/*N*/     {
/*N*/         pImp->pWindow = new SfxTopViewWin_Impl( this, &pFrame->GetWindow() );
/*N*/         pImp->pWindow->SetSizePixel( pFrame->GetWindow().GetOutputSizePixel() );
/*N*/         SetWindow_Impl( pImp->pWindow );
/*N*/ 		pFrame->SetOwnsBindings_Impl( sal_True );
/*N*/         pFrame->CreateWorkWindow_Impl();
/*N*/     }
/*N*/ 
/*N*/ 	sal_uInt32 nType = SFXFRAME_OWNSDOCUMENT | SFXFRAME_HASTITLE;
/*N*/ 	if ( pObjShell && pObjShell->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED )
/*N*/ 		nType |= SFXFRAME_EXTERNAL;
/*N*/ 	GetFrame()->SetFrameType_Impl( GetFrame()->GetFrameType() | nType );
/*N*/ 
/*N*/ 	// ViewShell erzeugen
/*N*/ 	if ( pObjShell )
/*N*/ 		SwitchToViewShell_Impl( nViewId );
/*N*/ 
/*N*/ 	// initiale Gr"o\se festlegen
/*N*/ 	if ( GetViewShell()->UseObjectSize() )
/*N*/ 	{
/*?*/ 		// Zuerst die logischen Koordinaten von IP-Objekt und EditWindow
/*?*/ 		// ber"ucksichtigen
/*N*/ 		LockAdjustPosSizePixel();
/*N*/ 		ForceInnerResize_Impl( TRUE );
/*?*/ 		SfxInPlaceObject *pIPObj = GetObjectShell()->GetInPlaceObject();
/*?*/ 		DBG_ASSERT( pIPObj, "UseObjectSize aber kein IP-Object" );
/*?*/ 		Window *pWindow = GetViewShell()->GetWindow();
/*?*/ 
/*?*/ 		// Da in den Applikationen bei der R"ucktransformation immer die
/*?*/ 		// Eckpunkte tranformiert werden und nicht die Size (um die Ecken
/*?*/ 		// alignen zu k"onnen), transformieren wir hier auch die Punkte, um
/*?*/ 		// m"oglichst wenig Rundungsfehler zu erhalten.
	/*
		Rectangle aRect = pWindow->LogicToLogic( pIPObj->GetVisArea(),
										pIPObj->GetMapUnit(),
										pWindow->GetMapMode() );
		aRect = pWindow->LogicToPixel( aRect );
	*/
/*?*/ 		Rectangle aRect = pWindow->LogicToPixel( pIPObj->GetVisArea() );
/*?*/ 		Size aSize = aRect.GetSize();
/*?*/ 		GetViewShell()->GetWindow()->SetSizePixel( aSize );
/*?*/ 		DoAdjustPosSizePixel(GetViewShell(), Point(), aSize );
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------
/*N*/ SfxTopViewFrame::~SfxTopViewFrame()
/*N*/ {
/*N*/ 	DBG_DTOR(SfxTopViewFrame, 0);
/*N*/ 
/*N*/ 	SetDowning_Impl();
/*N*/ 
/*N*/ 	SfxApplication *pApp = SFX_APP();
/*N*/ 	if ( pApp->GetViewFrame() == this )
/*?*/ 		pApp->SetViewFrame(NULL);
/*N*/ 
/*N*/ 	ReleaseObjectShell_Impl();
/*N*/ 	if ( pPendingCloser == pCloser )
/*N*/ 		pPendingCloser = 0;
/*N*/ 	delete pCloser;
/*N*/ 	if ( GetFrame()->OwnsBindings_Impl() )
/*N*/ 		// Die Bindings l"oscht der Frame!
/*N*/ 		KillDispatcher_Impl();
/*N*/ 
/*N*/     delete pImp->pWindow;
/*N*/     delete pImp->pStopButtonTimer;
/*N*/     delete pImp;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void SfxTopViewFrame::InvalidateBorderImpl
/*N*/ (
/*N*/ 	const SfxViewShell*
/*N*/ )
/*N*/ {
/*N*/ 	if ( GetViewShell() && GetWindow().IsVisible() )
/*N*/ 	{
/*?*/ 		if ( GetViewShell()->UseObjectSize() )
/*?*/ 		{
/*?*/ 			// Zun"achst die Gr"o\se des MDI-Fensters berechnen
/*?*/ 
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 DoAdjustPosSizePixel( GetViewShell(), Point(),
/*?*/ 		}
/*?*/ 
/*?*/ 		DoAdjustPosSizePixel( (SfxViewShell *) GetViewShell(), Point(),
/*?*/ 										GetWindow().GetOutputSizePixel() );
/*?*/ 		if ( GetViewShell()->UseObjectSize() )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ForceOuterResize_Impl(sal_False);
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------
/*N*/ sal_Bool SfxTopViewFrame::SetBorderPixelImpl( const SfxViewShell *pVSh, const SvBorder &rBorder )
/*N*/ {
/*N*/ 	if( SfxViewFrame::SetBorderPixelImpl( GetViewShell(), rBorder ) )
/*N*/ 	{
/*N*/ 		if ( IsResizeInToOut_Impl() )
/*N*/ 		{
/*?*/ 			Size aSize = pVSh->GetWindow()->GetOutputSizePixel();
/*?*/ 			if ( aSize.Width() && aSize.Height() )
/*?*/ 			{
/*?*/ 				aSize.Width() += rBorder.Left() + rBorder.Right();
/*?*/ 				aSize.Height() += rBorder.Top() + rBorder.Bottom();
/*?*/ 
/*?*/ 				Size aOldSize = GetWindow().GetOutputSizePixel();
/*?*/ 				GetWindow().SetOutputSizePixel( aSize );
/*?*/ 				Window* pParent = &GetWindow();
/*?*/ 				while ( pParent->GetParent() )
/*?*/ 					pParent = pParent->GetParent();
/*?*/ 				Size aOuterSize = pParent->GetOutputSizePixel();
/*?*/ 				aOuterSize.Width() += ( aSize.Width() - aOldSize.Width() );
/*?*/ 				aOuterSize.Height() += ( aSize.Height() - aOldSize.Height() );
/*?*/ 				pParent->SetOutputSizePixel( aOuterSize );
/*?*/ 			}
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			Point aPoint;
/*N*/ 			Rectangle aEditArea( aPoint, GetWindow().GetOutputSizePixel() );
/*N*/ 			aEditArea.Left() += rBorder.Left();
/*N*/ 			aEditArea.Right() -= rBorder.Right();
/*N*/ 			aEditArea.Top() += rBorder.Top();
/*N*/ 			aEditArea.Bottom() -= rBorder.Bottom();
/*N*/ 			pVSh->GetWindow()->SetPosSizePixel( aEditArea.TopLeft(), aEditArea.GetSize() );
/*N*/ 		}
/*N*/ 		return sal_True;
/*N*/ 
/*N*/ 	}
/*N*/ 	return sal_False;
/*N*/ }

/*N*/ void SfxTopViewFrame::Exec_Impl(SfxRequest &rReq )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

/*N*/ void SfxTopViewFrame::GetState_Impl( SfxItemSet &rSet )
/*N*/ {
/*N*/ 	SfxObjectShell *pDocSh = GetObjectShell();
/*N*/ 
/*N*/ 	if ( !pDocSh )
/*N*/ 		return;
/*N*/ 
/*N*/ 	const sal_uInt16 *pRanges = rSet.GetRanges();
/*N*/ 	DBG_ASSERT(pRanges, "Set ohne Bereich");
/*N*/ 	while ( *pRanges )
/*N*/ 	{
/*N*/ 		for ( sal_uInt16 nWhich = *pRanges++; nWhich <= *pRanges; ++nWhich )
/*N*/ 		{
/*N*/ 			switch(nWhich)
/*N*/ 			{
/*N*/             case SID_NEWDOCDIRECT :
/*N*/             {
/*N*/ 				if ( pImp->aFactoryName.Len() )
/*N*/ 				{
/*N*/ 	                String aFact = String::CreateFromAscii("private:factory/");
/*N*/ 		            aFact += pImp->aFactoryName;
/*N*/ 	                rSet.Put( SfxStringItem( nWhich, aFact ) );
/*N*/ 				}
/*N*/                 break;
/*N*/             }
/*N*/ 
/*N*/ 			case SID_NEWWINDOW:
/*?*/ 				rSet.DisableItem(nWhich);
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_CLOSEWIN:
/*?*/ 			{
/*?*/ 				// disable CloseWin, if frame is not a task
/*?*/                 Reference < ::com::sun::star::util::XCloseable > xTask( GetFrame()->GetFrameInterface(),  UNO_QUERY );
/*?*/ 				if ( !xTask.is() )
/*?*/ 					rSet.DisableItem(nWhich);
/*?*/ 				break;
/*?*/ 			}
/*?*/ 
/*?*/             case SID_SHOWPOPUPS :
/*?*/ 				break;
/*?*/ 
/*?*/ 			case SID_WIN_POSSIZE:
/*?*/ 			{
/*?*/ 				rSet.Put( SfxRectangleItem( nWhich, Rectangle(
/*?*/ 						GetWindow().GetPosPixel(), GetWindow().GetSizePixel() ) ) );
/*?*/ 				break;
/*?*/ 			}
/*N*/ 
/*N*/ 			default:
/*N*/ 				DBG_ERROR( "invalid message-id" );
/*N*/ 			}
/*N*/ 		}
/*N*/ 		++pRanges;
/*N*/ 	}
/*N*/ }

/*N*/ void SfxTopViewFrame::INetExecute_Impl( SfxRequest &rRequest )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

/*N*/ void SfxTopViewFrame::INetState_Impl( SfxItemSet &rItemSet )
/*N*/ {
/*N*/ 	if ( !GetFrame()->CanBrowseForward() )
/*N*/ 		rItemSet.DisableItem( SID_BROWSE_FORWARD );
/*N*/ 
/*N*/ 	if ( !GetFrame()->CanBrowseBackward() )
/*N*/ 		rItemSet.DisableItem( SID_BROWSE_BACKWARD );
/*N*/ 
/*N*/     // Add/SaveToBookmark bei BASIC-IDE, QUERY-EDITOR etc. disablen
/*N*/ 	SfxObjectShell *pDocSh = GetObjectShell();
/*N*/     sal_Bool bPseudo = pDocSh && !( pDocSh->GetFactory().GetFlags() & SFXOBJECTSHELL_HASOPENDOC );
/*N*/     sal_Bool bEmbedded = pDocSh && pDocSh->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED;
/*N*/ 	if ( !pDocSh || bPseudo || bEmbedded || !pDocSh->HasName() )
/*N*/ 		rItemSet.DisableItem( SID_CREATELINK );
/*N*/ 
/*N*/     pImp->pStopButtonTimer->SetButtonState( GetCancelManager()->CanCancel() );
/*N*/     if ( !pImp->pStopButtonTimer->GetButtonState() )
/*N*/ 		rItemSet.DisableItem( SID_BROWSE_STOP );
/*N*/ }

/*N*/ void SfxTopViewFrame::SetZoomFactor( const Fraction &rZoomX, const Fraction &rZoomY )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ }

/*N*/ void SfxTopViewFrame::Activate( sal_Bool bMDI )
/*N*/ {
/*N*/ 	DBG_ASSERT(GetViewShell(), "Keine Shell");
/*N*/ 	if ( bMDI && !pImp->bActive )
/*N*/     {
/*N*/         pImp->bActive = sal_True;
/*N*/         SfxWorkWindow *pWorkWin = GetFrame()->GetWorkWindow_Impl();
/*N*/         SfxBindings *pBind = &GetBindings();
/*N*/         while ( pBind )
/*N*/         {
/*N*/             pBind->HidePopupCtrls_Impl( FALSE );
/*N*/             pBind = pBind->GetSubBindings_Impl();
/*N*/         }
/*N*/ 
/*N*/         pWorkWin->HidePopups_Impl( FALSE, FALSE, 1 );
/*N*/     }
/*N*/ //(mba): hier evtl. wie in Beanframe NotifyEvent ?!
/*N*/ }

/*N*/ void SfxTopViewFrame::Deactivate( sal_Bool bMDI )
/*N*/ {
/*N*/ 	DBG_ASSERT(GetViewShell(), "Keine Shell");
/*N*/ 	if ( bMDI && pImp->bActive )
/*N*/     {
/*N*/ 		pImp->bActive = sal_False;
/*N*/         SfxWorkWindow *pWorkWin = GetFrame()->GetWorkWindow_Impl();
/*N*/         SfxBindings *pBind = &GetBindings();
/*N*/         while ( pBind )
/*N*/         {
/*N*/             pBind->HidePopupCtrls_Impl( TRUE );
/*N*/             pBind = pBind->GetSubBindings_Impl();
/*N*/         }
/*N*/ 
/*N*/         pWorkWin->HidePopups_Impl( TRUE, FALSE, 1 );
/*N*/     }
/*N*/ //(mba): hier evtl. wie in Beanframe NotifyEvent ?!
/*N*/ }

/*N*/ void SfxTopFrame::CheckMenuCloser_Impl( MenuBar* pMenuBar )
/*N*/ {
/*N*/ 	Reference < ::com::sun::star::frame::XFrame > xFrame = GetFrameInterface();
/*N*/ 
/*N*/ 	// checks if there is more than one "real" (not help) task window
/*N*/ 	// in this case a close button is inserted into the menubar
/*N*/ 
/*N*/ 	if ( !xFrame->getController().is() )
/*N*/ 		// dummy component
/*N*/ 		return;
/*N*/ 
/*N*/     Reference < ::com::sun::star::frame::XFramesSupplier > xDesktop( xFrame->getCreator(), UNO_QUERY );
/*N*/ 	if ( !xDesktop.is() )
/*N*/ 		// test only for task windows
/*N*/ 		return;
/*N*/ 
/*N*/ 	sal_Bool bLastTask = sal_False;
/*N*/     Reference < ::com::sun::star::container::XIndexAccess >
/*N*/ 			xList ( xDesktop->getFrames(), ::com::sun::star::uno::UNO_QUERY );
/*N*/     sal_Int32 nCount = xList->getCount();
/*N*/ 	if ( nCount<=1 )
/*N*/ 		// only one task
/*N*/ 		bLastTask = sal_True;
/*N*/ 	else if ( nCount==2 )
/*N*/ 	{
/*N*/ 		// if we have to tasks, one can be the help task, that should be ignored
/*N*/     	for( sal_Int32 i=0; i<nCount; ++i )
/*N*/     	{
/*N*/ 			Reference < ::com::sun::star::frame::XFrame > xTask;
/*N*/         	::com::sun::star::uno::Any aVal = xList->getByIndex(i);
/*N*/         	if ( (aVal>>=xTask) && xTask.is() && xTask->getName().compareToAscii("OFFICE_HELP_TASK") == COMPARE_EQUAL )
/*N*/ 			{
/*N*/ 				// one of the two open tasks was the help task -> ignored
/*N*/ 				bLastTask = sal_True;
/*N*/ 				break;
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	pMenuBar->ShowCloser(bLastTask);
/*N*/ }
}
