/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_virtmenu.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:43:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <svtools/menuoptions.hxx>
#include <svtools/imageitm.hxx>


#ifndef _TOOLKIT_HELPER_VCLUNOHELPER_HXX_
#include <toolkit/unohlp.hxx>
#endif

#pragma hdrstop

#include "virtmenu.hxx"
#include "msgpool.hxx"

#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

#include "idpool.hxx"
#include "mnumgr.hxx"
#include "dispatch.hxx"
#include "accmgr.hxx"
#include "sfxtypes.hxx"
#include "sfx.hrc"
#include "ipfrm.hxx"
#include "viewsh.hxx"
#include "imgmgr.hxx"
#include "menu.hrc"

#ifndef __FRAMEWORK_CLASSES_ADDONSOPTIONS_HXX_
#include <framework/addonsoptions.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_ADDONMENUS_HXX_
#include <framework/addonmenu.hxx>
#endif


namespace binfilter {

using namespace ::com::sun::star::container;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::uno;

//=========================================================================

/*N*/ DBG_NAME(SfxVirtualMenu)

static long nAutoDeactivateTimeout_Impl = -1;

//=========================================================================

typedef SfxMenuControl* SfxMenuControlPtr;

class SfxMenuImageControl_Impl : public SfxControllerItem
{
    SfxVirtualMenu*     pMenu;
    long                lRotation;
    BOOL                bIsMirrored;

protected:
    virtual void        StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState );
public:
                        SfxMenuImageControl_Impl( USHORT nSlotId, SfxBindings& rBindings, SfxVirtualMenu* pVMenu )
                            : SfxControllerItem( nSlotId, rBindings )
                            , pMenu( pVMenu )
                            , lRotation( 0 )
                            , bIsMirrored( FALSE )
                        {}
    void                Update();
};

/*N*/ void SfxMenuImageControl_Impl::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ {
/*N*/     const SfxImageItem* pItem = PTR_CAST( SfxImageItem, pState );
/*N*/     if ( pItem )
/*N*/     {
/*N*/         lRotation = pItem->GetRotation();
/*N*/         bIsMirrored = pItem->IsMirrored();
/*N*/         Update();
/*N*/     }
/*N*/ }

/*N*/ void SfxMenuImageControl_Impl::Update()
/*N*/ {
/*N*/     SfxViewFrame* pViewFrame = GetBindings().GetDispatcher_Impl()->GetFrame();
/*N*/     SfxModule* pModule = pViewFrame->GetObjectShell()->GetModule();
/*N*/     SfxSlotPool* pPool = pModule->GetSlotPool();
/*N*/     Menu* pSVMenu = pMenu->GetSVMenu();
/*N*/     for (USHORT nPos = 0; nPos<pSVMenu->GetItemCount(); nPos++)
/*N*/     {
/*N*/         USHORT nId = pSVMenu->GetItemId( nPos );
/*N*/         const SfxSlot* pSlot = pPool->GetSlot( nId );
/*N*/         if ( pSlot && pSlot->IsMode( SFX_SLOT_IMAGEROTATION ) )
/*N*/         {
/*N*/             pSVMenu->SetItemImageMirrorMode( nId, FALSE );
/*N*/             pSVMenu->SetItemImageAngle( nId, lRotation );
/*N*/         }
/*N*/ 
/*N*/         if ( pSlot && pSlot->IsMode( SFX_SLOT_IMAGEREFLECTION ) )
/*N*/             pSVMenu->SetItemImageMirrorMode( nId, bIsMirrored );
/*N*/     }
/*N*/ }

//=========================================================================


//=========================================================================

/*	Diese Hilfsfunktion pr"uft, ob eine Slot-Id im aktuellen Applikations-
	Status sichtbar ist oder nicht. Dabei bezieht sich der Applikations-Status
	darauf, ob die Applikation OLE-Server ist oder nicht.
*/

/*N*/ BOOL IsItemHidden_Impl( USHORT nItemId, int bOleServer, int bMac )
/*N*/ {
/*N*/ 	return ( bMac &&
/*N*/ 			 ( nItemId == SID_ARRANGEICONS || nItemId == SID_MINIMIZEWINS ) ) ||
/*N*/ 		   (  bOleServer &&
/*N*/ 			 ( nItemId == SID_QUITAPP || nItemId == SID_SAVEDOC ||
/*N*/ 			   nItemId == SID_OPENDOC || nItemId == SID_SAVEASDOC ||
/*N*/ 			   nItemId == SID_NEWDOC ) ) ||
/*N*/ 		   ( !bOleServer &&
/*N*/ 			 ( nItemId == SID_EXITANDRETURN || nItemId == SID_UPDATEDOC ) );
/*N*/ }

//====================================================================

/*N*/ void SfxVirtualMenu::Construct_Impl()
/*N*/ {
/*N*/     pWindowMenu = NULL;
/*N*/     pPickMenu = NULL;
/*N*/     pAddonsMenu = NULL;
/*N*/ 	bIsActive = FALSE;
/*N*/ 	bControllersUnBound = FALSE;
/*N*/ 	pSVMenu->SetHighlightHdl( LINK(this, SfxVirtualMenu, Highlight) );
/*N*/ 	pSVMenu->SetActivateHdl( LINK(this, SfxVirtualMenu, Activate) );
/*N*/ 	pSVMenu->SetDeactivateHdl( LINK(this, SfxVirtualMenu, Deactivate) );
/*N*/ 	pSVMenu->SetSelectHdl( LINK(this, SfxVirtualMenu, Select) );
/*N*/ 
/*N*/ 	// #107258# accelerator keys are needed for accessibility
/*N*/ 	if ( bOLE )
/*N*/ 		InvalidateKeyCodes();
/*N*/ 
/*N*/ 	if ( !pResMgr && pParent )
/*N*/ 		pResMgr = pParent->pResMgr;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxVirtualMenu::SfxVirtualMenu( USHORT nOwnId,
/*N*/ 				SfxVirtualMenu* pOwnParent, Menu& rMenu, BOOL bWithHelp,
/*N*/ 				SfxBindings &rBindings, BOOL bOLEServer, BOOL bRes, BOOL bIsAddonMenu ):
/*N*/ 	pItems(0),
/*N*/ 	pBindings(&rBindings),
/*N*/ 	pResMgr(0),
/*N*/     pImageControl(0),
/*N*/ 	nLocks(0), pAutoDeactivate(0), bHelpInitialized( bWithHelp ),
/*N*/ 	bWasHighContrast( FALSE ),
/*N*/ 	bIsAddonPopupMenu( bIsAddonMenu )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_CTOR(SfxVirtualMenu, 0);
/*N*/ 	pSVMenu = &rMenu;
/*N*/ 
/*N*/ 	bResCtor = bRes;
/*N*/ 	bOLE = bOLEServer;
/*N*/ 	nId = nOwnId;
/*N*/ 	pParent = pOwnParent;
/*N*/ 	nVisibleItems = 0;
/*N*/ 	CreateFromSVMenu();
/*N*/ 	Construct_Impl();
/*N*/ 	bHelpInitialized = FALSE;
/*N*/ }

//--------------------------------------------------------------------

// creates a virtual menu from a StarView MenuBar or PopupMenu

/*N*/ SfxVirtualMenu::SfxVirtualMenu( Menu *pStarViewMenu, BOOL bWithHelp,
/*N*/ 					SfxBindings &rBindings, BOOL bOLEServer, BOOL bRes, BOOL bIsAddonMenu ):
/*N*/ 	pItems(0),
/*N*/ 	pBindings(&rBindings),
/*N*/ 	pResMgr(0),
/*N*/     pImageControl(0),
/*N*/ 	nLocks(0), pAutoDeactivate(0),  bHelpInitialized( bWithHelp ),
/*N*/ 	bWasHighContrast( FALSE ),
/*N*/ 	bIsAddonPopupMenu( bIsAddonMenu )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_CTOR(SfxVirtualMenu, 0);
/*N*/ 
/*N*/     pSVMenu = pStarViewMenu;
/*N*/ 
/*N*/ 	bResCtor = bRes;
/*N*/ 	bOLE = bOLEServer;
/*N*/ 	nId = 0;
/*N*/ 	pParent = 0;
/*N*/ 	nVisibleItems = 0;
/*N*/ 	CreateFromSVMenu();
/*N*/ 	Construct_Impl();
/*N*/ 	bHelpInitialized = FALSE;
/*N*/ }

//--------------------------------------------------------------------

/*  Der Destruktor der Klasse SfxVirtualMenu gib die gebundenen Items frei
	und klinkt das zugeh"orige StarView-PopupMenu aus seinem Parent aus.
	Falls es sich um das Pickmenu oder das MDI-Menu handelt, wird es
	dort abgemeldet.
*/

/*N*/ SfxVirtualMenu::~SfxVirtualMenu()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_DTOR(SfxVirtualMenu, 0);
/*N*/ 
/*N*/     DELETEZ( pImageControl );
/*N*/     SvtMenuOptions().RemoveListener( LINK( this, SfxVirtualMenu, SettingsChanged ) );
/*N*/ 
/*N*/ 	if ( bIsActive )
/*N*/ 	{
/*?*/ 		pBindings->LEAVEREGISTRATIONS(); --nLocks; bIsActive = FALSE;
/*N*/ 	}
/*N*/ 
/*N*/ 	// QAP-Hack
/*N*/ 	if ( pAutoDeactivate )
/*N*/ 	{
/*N*/ 		if ( pAutoDeactivate->IsActive() )
/*N*/ 			Deactivate(0);
/*N*/ 		DELETEX(pAutoDeactivate);
/*N*/ 	}
/*N*/ 
/*N*/ 	if (pItems)
/*N*/ 	{
/*N*/ #ifdef MPW
/*N*/ 		// der MPW-Compiler ruft sonst keine Dtoren!
/*?*/ 		for ( USHORT n = 0; n < nCount; ++n )
/*?*/ 			(pItems+n)->SfxMenuControl::~SfxMenuControl();
/*?*/ 		delete (void*) pItems;
/*N*/ #else
/*N*/ 		delete [] pItems;
/*N*/ #endif
/*N*/ 	}
/*N*/ 
/*N*/ 	pBindings = 0;
/*N*/ 
/*N*/ 	// Alle Menues, die von SV erzeugt wurden, werden auch dort wieder
/*N*/ 	// gel"oscht (also die beim Laden aus der Resource erzeugten).
/*N*/ 	// Das Top-Level-Menu wird nie von SV gel"oscht, da die Allocierung
/*N*/ 	// im SFX erfolgt
/*N*/ 	if ( !bResCtor || !pParent)
/*N*/ 	{
/*N*/         if ( pParent )
/*N*/         {
/*?*/             if( pParent->pSVMenu->GetItemPos( nId ) != MENU_ITEM_NOTFOUND )
/*?*/                 pParent->pSVMenu->SetPopupMenu( nId, 0 );
/*?*/             if ( pParent->pPickMenu == pSVMenu )
/*?*/                 pParent->pPickMenu = 0;
/*?*/             if ( pParent->pWindowMenu == pSVMenu)
/*?*/                 pParent->pWindowMenu = 0;
/*N*/             if ( pParent->pAddonsMenu == pSVMenu )
/*N*/ 				pParent->pAddonsMenu = 0;
/*N*/         }
/*N*/ 
/*N*/ 		delete pSVMenu;
/*N*/ 	}
/*N*/ 
/*N*/ 	DBG_OUTF( ("SfxVirtualMenu %lx destroyed", this) );
/*N*/ 	DBG_ASSERT( !nLocks, "destroying active menu" );
/*N*/ }
//--------------------------------------------------------------------

/*N*/ BOOL SfxVirtualMenu::IsHiContrastMode() const
/*N*/ {
/*N*/ 	const StyleSettings& rSettings = Application::GetSettings().GetStyleSettings();
/*N*/ 	Color aMenuColor = rSettings.GetMenuColor();
/*N*/ 	if ( aMenuColor.IsDark() )
/*N*/ 		return TRUE;
/*N*/ 	else
/*N*/ 		return FALSE;
/*N*/ }

//--------------------------------------------------------------------
// internal: creates the virtual menu from the pSVMenu

/*N*/ void SfxVirtualMenu::CreateFromSVMenu()
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_CHKTHIS(SfxVirtualMenu, 0);
/*N*/ 
/*N*/ 	// Merge Addon popup menus into the SV Menu
/*N*/ 	Reference< ::com::sun::star::frame::XFrame > xFrame( pBindings->GetDispatcher()->GetFrame()->GetFrame()->GetFrameInterface() );
/*N*/ 	
/*N*/ 	if ( pSVMenu->IsMenuBar() )
/*N*/ 	{
/*N*/ 		USHORT nPos = pSVMenu->GetItemPos( SID_MDIWINDOWLIST );
/*N*/ 		if ( nPos != MENU_ITEM_NOTFOUND && xFrame.is() )
/*N*/ 		{
/*N*/ 			// Retrieve addon popup menus and add them to our menu bar
/*N*/ 			Reference< ::com::sun::star::frame::XModel >		xModel;
/*N*/ 			Reference< ::com::sun::star::frame::XController >	xController( xFrame->getController(), UNO_QUERY );
/*N*/ 			if ( xController.is() )
/*N*/ 				xModel = Reference< ::com::sun::star::frame::XModel >( xController->getModel(), UNO_QUERY );
/*N*/ 			framework::AddonMenuManager::MergeAddonPopupMenus( xFrame, xModel, nPos, (MenuBar *)pSVMenu );
/*N*/ 		}
/*N*/ 		
/*N*/         // Merge the Add-Ons help menu items into the Office help menu
/*N*/ 		if ( xFrame.is() )
/*N*/ 		    framework::AddonMenuManager::MergeAddonHelpMenu( xFrame, (MenuBar *)pSVMenu );
/*N*/ 		    
/*N*/         // Set addon menu pointer here to avoid problems. When accessibility is enabled, the whole menu 
/*N*/         // is created immediately!
/*N*/ 		pAddonsMenu = pSVMenu->GetPopupMenu( SID_ADDONLIST );
/*N*/ 	}
/*N*/ 	else if ( pParent )
/*N*/ 	{
/*N*/ 		if ( pSVMenu == pParent->pAddonsMenu &&
/*N*/ 			 framework::AddonsOptions().HasAddonsMenu() &&
/*N*/ 			 !pSVMenu->GetPopupMenu( SID_ADDONS ) )
/*N*/ 		{
/*N*/ 			// Create menu item at the end of the tools popup menu for the addons popup menu
/*?*/ 			DBG_BF_ASSERT(0, "STRIP");//STRIP001 InsertAddOnsMenuItem( pSVMenu );
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	// get and store the number of items
/*N*/ 	nCount = pSVMenu->GetItemCount();
/*N*/ 
/*N*/ 	// Achtung: nur zu diesem Zeitpunkt ist garantiert, da\s nCount und
/*N*/ 	// der ItemCount des SV-Menues "ubereinstimmen; sp"ater kann das SvMenue
/*N*/ 	// auch mehr Eintr"age haben (Pickliste!)
/*N*/ 	if (nCount)
/*N*/ 		pItems = new SfxMenuControl[nCount];
/*N*/ 
/*N*/ 	// remember some values
/*N*/ 	SfxApplication *pSfxApp = SFX_APP();
/*N*/ 	const int bOleServer = FALSE;
/*N*/ 	const int bMac = FALSE;
/*N*/     SfxViewFrame *pViewFrame = pBindings->GetDispatcher()->GetFrame();
/*N*/     SfxModule* pModule = pViewFrame->GetObjectShell()->GetModule();
/*N*/ 	SvtMenuOptions aOptions;
/*N*/     aOptions.AddListener( LINK( this, SfxVirtualMenu, SettingsChanged ) );
/*N*/ 
/*N*/ 	// iterate through the items
/*N*/ 	pBindings->ENTERREGISTRATIONS(); ++nLocks;
/*N*/     pImageControl = new SfxMenuImageControl_Impl( SID_IMAGE_ORIENTATION, *pBindings, this );
/*N*/ 
/*N*/ 	// Update high contrast state
/*N*/ 	bWasHighContrast = IsHiContrastMode();
/*N*/ 
/*N*/ 	USHORT nSVPos = 0;
/*N*/ 	for ( USHORT nPos=0; nPos<nCount; ++nPos, ++nSVPos )
/*N*/ 	{
/*N*/ 		USHORT nId = pSVMenu->GetItemId(nSVPos);
/*N*/ 		PopupMenu* pPopup = pSVMenu->GetPopupMenu(nId);
/*N*/ 		if( pPopup && nId >= SID_OBJECTMENU0 && nId <= SID_OBJECTMENU_LAST )
/*N*/ 		{
/*N*/ 			// artefact in XML menuconfig: every entry in root menu must have a popup!
/*?*/ 			pSVMenu->SetPopupMenu( nId, NULL );
/*?*/ 			DELETEZ( pPopup );
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( pPopup )
/*N*/ 		{
/*N*/ 			DBG_ASSERT( SfxMenuManager::IsPopupFunction(nId) ||
/*N*/ 						!SFX_SLOTPOOL().GetIdPool().IsLocked(nId),
/*N*/ 						"popupmenu with existing func-id" );
/*N*/ 			SfxMenuControl *pMnuCtrl =
/*N*/ 				SfxMenuControl::CreateControl(nId, *pPopup, *pBindings);
/*N*/ 
/*N*/ 			if ( pMnuCtrl )
/*N*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*
				if ( nId >= SID_SFX_START && !SfxMenuManager::IsPopupFunction(nId) )
				{
					// Echte Popups sollen keine SlotIds haben; leider sind
					// da noch Altlasten mit herumzuschleppen ...
					String aTitle = pSVMenu->GetItemText( nId );
					pSVMenu->SetPopupMenu( nId, NULL );
					USHORT nPos = pSVMenu->GetItemPos( nId );
					pSVMenu->RemoveItem( nPos );
					nId = 1;
					while ( pSVMenu->GetItemPos(nId) != MENU_ITEM_NOTFOUND )
						nId++;
					pSVMenu->InsertItem( nId, aTitle, 0, nPos );
					pSVMenu->SetPopupMenu( nId, pPopup );
				}
*/
/*N*/ 				pSVMenu->SetHelpId( nId, 0L );
/*N*/ 				pMnuCtrl = pItems+nPos;
/*N*/ 
/*N*/ 				// normalerweise jetzt erst im Activate-Handler
/*N*/ 				if ( bOLE )
/*N*/ 				{
/*N*/ 					pMnuCtrl->Bind( this, nId,
/*N*/ 						*new SfxVirtualMenu(nId, this, *pPopup, bHelpInitialized, *pBindings, bOLE, bResCtor),
/*N*/ 						pSVMenu->GetItemText(nId), pSVMenu->GetHelpText(nId),
/*N*/ 						*pBindings );
/*N*/ 				}
/*N*/ 			}
/*N*/ 
/*N*/ 			++nVisibleItems;
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			switch ( pSVMenu->GetItemType(nSVPos) )
/*N*/ 			{
/*N*/ 				case MENUITEM_STRING:
/*N*/ 				case MENUITEM_STRINGIMAGE:
/*N*/ 				{
/*N*/                     SfxMenuControl *pMnuCtrl=0;
/*N*/ 					String aCmd( pSVMenu->GetItemCommand( nId ) );
/*N*/ 					if ( aCmd.CompareToAscii("slot:", 5) == 0 )
/*N*/ 					{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 					}
/*N*/ 
/*N*/                     if ( aCmd.Len() && (( nId < SID_SFX_START ) || ( nId > SHRT_MAX )) )
/*N*/ 					{{DBG_BF_ASSERT(0, "STRIP");}//STRIP001 
/*N*/ 					}
/*N*/ 
/*N*/                     if ( !pMnuCtrl )
/*N*/ 					{
/*N*/                         // try to create control via Id
/*N*/                         pMnuCtrl = SfxMenuControl::CreateControl(nId, *pSVMenu, *pBindings);
/*N*/ 						if ( pMnuCtrl )
/*N*/ 						{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*N*/ 						}
/*N*/ 						else
/*N*/                             // take default control
/*N*/ 							pMnuCtrl = (pItems+nPos);
/*N*/ 
/*N*/                         pMnuCtrl->Bind( this, nId, pSVMenu->GetItemText(nId), pSVMenu->GetHelpText(nId), *pBindings);
/*N*/ 					}
/*N*/ 
/*N*/                     if ( aOptions.IsMenuIconsEnabled() )
/*N*/                     {
/*N*/                         // try to get image via URL
/*N*/ //                        Image aImage = SvFileInformationManager::GetImage( aCmd, FALSE, bWasHighContrast );
/*N*/ //                        if ( !aImage )
/*N*/                             // try to get image via Id
/*N*/ 						Image aImage;
/*N*/ 						if ( bIsAddonPopupMenu || framework::AddonMenuManager::IsAddonMenuId( nId ))
/*N*/ 						{DBG_BF_ASSERT(0, "STRIP");//STRIP001 
/*N*/ 						}
/*N*/ 						else
/*N*/ 							aImage = pBindings->GetImageManager()->GetImage( nId, pModule, FALSE, bWasHighContrast );
/*N*/ 						
/*N*/ 						if ( !!aImage )
/*N*/ 							pSVMenu->SetItemImage( nId, aImage );
/*N*/                     }
/*N*/ 
/*N*/ 					if ( !IsItemHidden_Impl(nId, bOleServer, bMac) )
/*N*/ 						++nVisibleItems;
/*N*/ 					else
/*N*/ 						pSVMenu->RemoveItem( nSVPos-- );
/*N*/ 					break;
/*N*/ 				}
/*N*/ 
/*N*/ 				case MENUITEM_IMAGE:
/*N*/ 					//! not implemented
/*N*/ 					break;
/*N*/ 
/*N*/ 				case MENUITEM_SEPARATOR:
/*N*/ 					//! not implemented
/*N*/ 					break;
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	pBindings->LEAVEREGISTRATIONS(); --nLocks;
/*N*/ }

//--------------------------------------------------------------------

// called on activation of the SV-Menu

/*?*/ IMPL_LINK( SfxVirtualMenu, Highlight, Menu *, pMenu )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

/*?*/ IMPL_LINK( SfxVirtualMenu, SettingsChanged, void*, pVoid )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

//--------------------------------------------------------------------


//--------------------------------------------------------------------


//--------------------------------------------------------------------


//--------------------------------------------------------------------





//--------------------------------------------------------------------

//--------------------------------------------------------------------

// called on activation of the SV-Menu

/*?*/ IMPL_LINK( SfxVirtualMenu, Activate, Menu *, pMenu )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

//--------------------------------------------------------------------

/*?*/ IMPL_LINK( SfxVirtualMenu, Deactivate, Menu *, pMenu )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }
//--------------------------------------------------------------------

// called on activation of the SV-Menu

/*?*/ IMPL_LINK( SfxVirtualMenu, Select, Menu *, pMenu )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

//--------------------------------------------------------------------

// returns the associated StarView-menu

/*N*/ Menu* SfxVirtualMenu::GetSVMenu() const
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_CHKTHIS(SfxVirtualMenu, 0);
/*N*/ 
/*N*/ 	return pSVMenu;
/*N*/ }

//--------------------------------------------------------------------

// return the position of the specified item

/*N*/ USHORT SfxVirtualMenu::GetItemPos( USHORT nItemId ) const
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_CHKTHIS(SfxVirtualMenu, 0);
/*N*/ 
/*N*/ 	for ( USHORT nPos = 0; nPos < nCount; ++nPos )
/*N*/ 		if ( (pItems+nPos)->GetId() == nItemId )
/*N*/ 			return nPos;
/*N*/ 	return MENU_ITEM_NOTFOUND;
/*N*/ }

//--------------------------------------------------------------------

// returns the popup-menu assigned to the item or 0 if none

/*N*/ SfxVirtualMenu* SfxVirtualMenu::GetPopupMenu( USHORT nId ) const
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_CHKTHIS(SfxVirtualMenu, 0);
/*N*/ 
/*N*/ 	USHORT nPos = GetItemPos(nId);
/*N*/ 	if ( nPos != MENU_ITEM_NOTFOUND )
/*N*/ 		return (pItems+nPos)->GetPopupMenu();
/*N*/ 	return 0;
/*N*/ }
//--------------------------------------------------------------------

// returns the text of the item as currently shown in the menu

//--------------------------------------------------------------------

// returns the text of the item as currently shown in the menu


//--------------------------------------------------------------------

/*N*/ void SfxVirtualMenu::InvalidateKeyCodes()
/*N*/ {
/*N*/ 	DBG_ASSERT( pSVMenu, "invalidating key of incomplete menu" );
/*N*/ 
/*N*/     SfxApplication* pSfxApp = SFX_APP();
/*N*/     SfxViewFrame *pViewFrame = pBindings->GetDispatcher()->GetFrame();
/*N*/     SfxAcceleratorManager* pAccMgr = pViewFrame->GetViewShell()->GetAccMgr_Impl();
/*N*/ 	SfxAcceleratorManager* pAppAccel = pSfxApp->GetAppAccel_Impl();
/*N*/ 	if ( !pAccMgr )
/*N*/ 		pAccMgr = pAppAccel;
/*N*/ 
/*N*/ 	for ( USHORT nPos = 0; nPos < pSVMenu->GetItemCount(); ++nPos )
/*N*/ 	{
/*N*/ 		USHORT nId = pSVMenu->GetItemId(nPos);
/*N*/         SfxVirtualMenu *pPopup = GetPopupMenu(nId);
/*N*/ //        if ( pPopup )
/*N*/ //            pPopup->InvalidateKeyCodes();
/*N*/ //        else if ( nId )
/*N*/         if ( nId && !pSVMenu->GetPopupMenu( nId ) )
/*N*/ 		{
/*N*/ 			KeyCode aCode = pAccMgr->GetKeyCode( nId );
/*N*/ 			if ( !aCode.GetCode() && pAccMgr != pAppAccel )
/*N*/ 				aCode = pAppAccel->GetKeyCode( nId );
/*N*/ 			pSVMenu->SetAccelKey( nId, aCode );
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

// set the checkmark of the specified item

/*N*/ void SfxVirtualMenu::CheckItem( USHORT nItemId, BOOL bCheck )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_CHKTHIS(SfxVirtualMenu, 0);
/*N*/ 	DBG_ASSERT( this != 0, "");
/*N*/ 	DBG_ASSERT( pSVMenu != 0, "" );
/*N*/ 	if (pSVMenu->GetItemPos( nItemId ) != MENU_ITEM_NOTFOUND )
/*N*/ 		pSVMenu->CheckItem( nItemId, bCheck );
/*N*/ }
//--------------------------------------------------------------------

// set the enabled-state of the specified item

/*N*/ void SfxVirtualMenu::EnableItem( USHORT nItemId, BOOL bEnable )
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 	DBG_CHKTHIS(SfxVirtualMenu, 0);
/*N*/ 	DBG_ASSERT( this != 0, "");
/*N*/ 	DBG_ASSERT( pSVMenu != 0, "" );
/*N*/ 
/*N*/ 	if (pSVMenu->GetItemPos( nItemId ) != MENU_ITEM_NOTFOUND )
/*N*/ 		pSVMenu->EnableItem( nItemId, bEnable );
/*N*/ }
//--------------------------------------------------------------------

// set the text of the specified item


//--------------------------------------------------------------------

//


//--------------------------------------------------------------------

// Erzwingt die Initialisierung, die sonst nur im Activate kommt



typedef ULONG (__LOADONCALLAPI *HelpIdFunc) ( const String& );


}
