/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_cfgimex.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:07:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SVSTDARR_ULONGS_DECL
#define _SVSTDARR_ULONGS
#endif

#pragma hdrstop

#ifndef _OSL_DIAGNOSE_H_
#include "osl/diagnose.h"
#endif

#include "cfgmgr.hxx"

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#include "tbxmgr.hxx"
#include "tbxconf.hxx"
#include "sfx.hrc"
#include "cfgimpl.hxx"
#include "accmgr.hxx"
#include "stbmgr.hxx"
#include "evntconf.hxx"
namespace binfilter {

// STATIC DATA -----------------------------------------------------------

/*N*/ static const char pHeader[] = "Star Framework Config File";
/*N*/ #define CFG_STREAM_BUFFER_SIZE  5000
/*N*/ static const USHORT nVersion = 26;
/*N*/ static const char cCtrlZ = 26;
/*N*/ 
/*N*/ static const USHORT nTypesCount = 82;
/*N*/ const char* pStreamNames[] =
/*N*/ {
/*N*/     "statusbar.xml",
/*N*/     "mathstatusbar.xml",
/*N*/     "chartstatusbar.xml",
/*N*/     "calcstatusbar.xml",
/*N*/     "drawstatusbar.xml",
/*N*/     "writerstatusbar.xml",
/*N*/     "globalkeybinding.xml",
/*N*/     "mathkeybinding.xml",
/*N*/     "chartkeybinding.xml",
/*N*/     "calckeybinding.xml",
/*N*/     "impresskeybinding.xml",
/*N*/     "drawkeybinding.xml",
/*N*/     "writerkeybinding.xml",
/*N*/     "webkeybinding.xml",
/*N*/     "defaultmenubar.xml",
/*N*/     "mathmenubar.xml",
/*N*/     "chartmenubar.xml",
/*N*/     "calcmenubar.xml",
/*N*/     "impressmenubar.xml",
/*N*/     "drawmenubar.xml",
/*N*/     "writermenubar.xml",
/*N*/     "webmenubar.xml",
/*N*/     "fullscreenbar.xml",
/*N*/     "functionbar.xml",
/*N*/     "formsnavigationbar.xml",
/*N*/     "formsfilterbar.xml",
/*N*/     "mathtoolbar.xml",
/*N*/     "chartobjectbar.xml",
/*N*/     "charttoolbar.xml",
/*N*/     "calctextobjectbar.xml",
/*N*/     "calcformsobjectbar.xml",
/*N*/     "calcdrawobjectbar.xml",
/*N*/     "calcgrapicobjectbar.xml",
/*N*/     "calcformatobjectbar.xml",
/*N*/     "calcpreviewbar.xml",
/*N*/     "calctoolbar.xml",
/*N*/     "drawbezierobjectbar.xml",
/*N*/     "drawgluepointsobjectbar.xml",
/*N*/     "impressgraphicobjectbar.xml",
/*N*/     "drawdrawingobjectbar.xml",
/*N*/     "impresstextobjectbar.xml",
/*N*/     "drawtextobjectbar.xml",
/*N*/     "impresstoolbar.xml",
/*N*/     "impressoptionsbar.xml",
/*N*/     "impresscommontaskbar.xml",
/*N*/     "drawtoolbar.xml",
/*N*/     "drawoptionsbar.xml",
/*N*/     "drawgraphicobjectbar.xml",
/*N*/     "impressoutlinetoolbar.xml",
/*N*/     "impressslideviewtoolbar.xml",
/*N*/     "impressslideviewobjectbar.xml",
/*N*/     "writerbezierobjectbar.xml",
/*N*/     "writerdrawingobjectbar.xml",
/*N*/     "writerformsobjectbar.xml",
/*N*/     "writerdrawtextobjectbar.xml",
/*N*/     "writerframeobjectbar.xml",
/*N*/     "writergraphicobjectbar.xml",
/*N*/     "writernumobjectbar.xml",
/*N*/     "writeroleobjectbar.xml",
/*N*/     "writertableobjectbar.xml",
/*N*/     "writertextobjectbar.xml",
/*N*/     "writerpreviewobjectbar.xml",
/*N*/     "websourceviewobjectbar.xml",
/*N*/     "websourceviewtoolbar.xml",
/*N*/     "webtextobjectbar.xml",
/*N*/     "writertoolbar.xml",
/*N*/     "webframeobjectbar.xml",
/*N*/     "webgraphicobjectbar.xml",
/*N*/     "weboleobjectbar.xml",
/*N*/     "webtoolbar.xml",
/*N*/     "imagelist.xml",
/*N*/     "toolboxlayout.xml",
/*N*/     "eventbindings.xml",
/*N*/     "eventbindings.xml",
/*N*/ 	"macrobar.xml",
/*N*/ 	"basicstatusbar.xml",
/*N*/ 	"writerglobalmenubar.xml",
/*N*/ 	"basicmenubar.xml",
/*N*/ 	"writerviewerbar.xml",
/*N*/ 	"calcviewerbar.xml",
/*N*/ 	"impressviewerbar.xml",
/*N*/ 	"drawviewerbar.xml"
/*N*/ };

/*N*/ const USHORT pTypes[] =
/*N*/ {
/*N*/     4,
/*N*/     20816,
/*N*/     30002,
/*N*/     26005,
/*N*/     23007,
/*N*/     20013,
/*N*/     1,
/*N*/     20815,
/*N*/     20080,
/*N*/     26006,
/*N*/     23005,
/*N*/     23008,
/*N*/     20017,
/*N*/     20020,
/*N*/     261,
/*N*/     20814,
/*N*/     20081,
/*N*/     26007,
/*N*/     23006,
/*N*/     23009,
/*N*/     20016,
/*N*/     20019,
/*N*/     558,
/*N*/     560,
/*N*/     18003,
/*N*/     18004,
/*N*/     20050,
/*N*/     30001,
/*N*/     30513,
/*N*/     25005,
/*N*/     25047,
/*N*/     25053,
/*N*/     25054,
/*N*/     25001,
/*N*/     25006,
/*N*/     25035,
/*N*/     23015,
/*N*/     23019,
/*N*/     23030,
/*N*/     23013,
/*N*/     23016,
/*N*/     23028,
/*N*/     23011,
/*N*/     23020,
/*N*/     23021,
/*N*/     23025,
/*N*/     23026,
/*N*/     23027,
/*N*/     23017,
/*N*/     23012,
/*N*/     23014,
/*N*/     23283,
/*N*/     23269,
/*N*/     23299,
/*N*/     23270,
/*N*/     23267,
/*N*/     23268,
/*N*/     23271,
/*N*/     23272,
/*N*/     23266,
/*N*/     23265,
/*N*/     20631,
/*N*/     23282,
/*N*/     20402,
/*N*/     20403,
/*N*/     23273,
/*N*/     20408,
/*N*/     20410,
/*N*/     20411,
/*N*/     20412,
/*N*/     6,
/*N*/     9,
/*N*/     10,
/*N*/     11,
/*N*/ 	14850,
/*N*/ 	30805,
/*N*/ 	20029,
/*N*/ 	14851,
/*N*/ 	23310,
/*N*/ 	25000,
/*N*/ 	23023,
/*N*/ 	23024
/*N*/ };

/*N*/ BOOL SfxConfigManagerImExport_Impl::HasConfiguration( SotStorage& rStorage )
/*N*/ {
/*N*/     return rStorage.IsStream( String::CreateFromAscii(pHeader) );
/*N*/ }

/*N*/ USHORT SfxConfigManagerImExport_Impl::Import( SotStorage* pInStorage, SotStorage* pStorage )
/*N*/ {
/*N*/ 	SotStorageStreamRef aStr =
/*N*/         pInStorage->OpenSotStream( String::CreateFromAscii(pHeader), STREAM_STD_READ );
/*N*/ 	if ( aStr->GetError() )
/*N*/ 		return SfxConfigManager::ERR_OPEN;
/*N*/ 
/*N*/ 	SvStream* pStream = aStr;
/*N*/ 	pStream->SetVersion( SOFFICE_FILEFORMAT_40 );
/*N*/ 	pStream->SetBufferSize( CFG_STREAM_BUFFER_SIZE );
/*N*/ 	pStream->Seek(0);
/*N*/ 	USHORT nRet = SfxConfigManager::ERR_NO;
/*N*/ 
/*N*/ 	// check header
/*N*/ 	const unsigned nLen = strlen( pHeader );
/*N*/ 	char *pBuf = new char[nLen+1];
/*N*/ 	pStream->Read( pBuf, nLen );
/*N*/ 	pBuf[nLen] = 0;
/*N*/ 	if( strcmp( pBuf, pHeader ) )
/*N*/ 	{
/*N*/ 		delete pBuf;
/*?*/ 		return SfxConfigManager::ERR_FILETYPE;
/*N*/ 	}
/*N*/ 
/*N*/ 	delete pBuf;
/*N*/ 
/*N*/ 	// compare version
/*N*/ 	char c;
/*N*/ 	USHORT nFileVersion;
/*N*/ 	(*pStream) >> c;					// skip ASCII 26 (CTRL-Z)
/*N*/ 	(*pStream) >> nFileVersion;
/*N*/ 	if( nFileVersion != nVersion )
/*N*/ 	{
/*?*/ 		return SfxConfigManager::ERR_VERSION;
/*N*/ 	}
/*N*/ 
/*N*/ 	// get position of directory
/*N*/ 	long lDirPos, lStart = pStream->Tell();
/*N*/ 	(*pStream) >> lDirPos;
/*N*/ 	pStream->Seek(lDirPos);
/*N*/ 
/*N*/ 	// get number of items
/*N*/ 	USHORT nCount;
/*N*/ 	(*pStream) >> nCount;
/*N*/ 
/*N*/ 	// read in directory and convert items
/*N*/ 	for( USHORT i=0; i < nCount; ++i )
/*N*/ 	{
/*N*/ 		SfxConfigItem_Impl* pItem = new SfxConfigItem_Impl;
/*N*/ 		pItemArr->Insert( pItem, pItemArr->Count() );
/*N*/ 
/*N*/ 		// retrieve type of item and human readable name
/*N*/ 		long lLength, lPos;	            // dummies
/*N*/         (*pStream) >> pItem->nType >> lPos >> lLength;
/*N*/ 		pItem->bDefault = ( lPos == -1L );
/*N*/         pStream->ReadByteString( pItem->aName );
/*N*/         if ( pStream->GetError() )
/*N*/         {
/*?*/             pItem->bDefault = TRUE;
/*?*/             return SfxConfigManager::ERR_READ;
/*N*/         }
/*N*/ 
/*N*/ 		// convert into new format
/*N*/         if ( !pItem->bDefault )
/*N*/         {
/*N*/             // stream name for new format
/*N*/             pItem->aStreamName = GetStreamName( pItem->nType );
/*N*/             if ( pItem->aStreamName.Len() )
/*N*/             {
/*N*/                 long lOldPos = pStream->Tell();
/*N*/                 pStream->Seek( lPos );
/*N*/ 
/*N*/                 // check for correct type id, inequality is allowed for userdef toolboxes
/*N*/                 USHORT nType;
/*N*/                 (*pStream) >> nType;
/*N*/                 BOOL bOk = ( nType == pItem->nType ||
/*N*/                             1294 <= nType && nType <= 1301 &&
/*N*/                             1294 <= pItem->nType && pItem->nType <= 1301 );
/*N*/ 
/*N*/                 if ( !bOk || !ImportItem( pItem, pStream, pStorage ) )
/*N*/                 {
/*?*/                     pItem->bDefault = TRUE;
/*?*/                     nRet = SfxConfigManager::ERR_IMPORT;
/*N*/                 }
/*N*/ 
/*N*/                 pStream->Seek( lOldPos );
/*N*/             }
/*N*/             else
/*N*/             {
/*N*/                 DBG_ERROR("Couldn't convert old configuration!");
/*N*/                 // force error message that saving this document would lose some configuration information
/*N*/             }
/*N*/         }
/*N*/ 
/*N*/         if ( !pItem->aStreamName.Len() )
/*N*/ 		{
/*N*/             // no real config item anymore
/*N*/ 			delete pItem;
/*N*/ 			pItemArr->Remove( pItemArr->Count() - 1 );
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	return nRet;
/*N*/ }

/*N*/ BOOL SfxConfigManagerImExport_Impl::ImportItem( SfxConfigItem_Impl* pItem, SvStream* pStream, SotStorage* pStor )
/*N*/ {
/*N*/ 	BOOL bRet = TRUE;
/*N*/ 	switch ( pItem->nType )
/*N*/ 	{
/*N*/     	// Statusbars
/*N*/     	case SFX_ITEMTYPE_STATBAR :     // Global
/*N*/     	case 20816 :        			// Math
/*N*/     	case 30002 :      				// Chart
/*N*/     	case 26005 :                    // Calc
/*N*/     	case 23007 :                    // Impress/Draw
/*N*/     	case 20013 :                    // Writer/WriterWeb
/*N*/ 		{
/*?*/ 			BOOL bOK = FALSE;
/*?*/ 			SotStorageStreamRef xStream =
/*?*/             		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
/*?*/ 			if ( !xStream->GetError() )
/*?*/ 				bOK = SfxStatusBarManager::Import( *pStream, *xStream );
/*?*/ 			if ( bRet )
/*?*/ 				bRet = bOK;
/*?*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/     	// Accels
/*N*/     	case SFX_ITEMTYPE_ACCEL :		// Global
/*N*/ 		case 20815 :        			// Math
/*N*/         case 20080 :        			// Chart
/*N*/         case 26006 :        			// Calc
/*N*/         case 20017 :        			// Impress
/*N*/         case 20020 :        			// Draw
/*N*/         case 23005 :        			// Writer
/*N*/         case 23008 :        			// WriterWeb
/*N*/         {
/*?*/             SfxAcceleratorManager aMgr( pItem->nType, NULL );
/*?*/             int nRet = aMgr.Load( *pStream );
/*?*/             if ( nRet == SfxConfigItem::ERR_OK )
/*?*/                 bRet = aMgr.Store( *pStor );
/*?*/ 			break;
/*N*/         }
/*N*/ 
/*N*/     	// Menues
/*N*/     	case 20814 :        			// Math
/*N*/     	case 20081 :       				// Chart
/*N*/         case 26007 :        			// Calc
/*N*/         case 23006 :        			// Impress
/*N*/         case 23009 :        			// Draw
/*N*/         case 20016 :        			// Writer
/*N*/         case 20019 :        			// WriterWeb
/*N*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 BOOL bOK = FALSE;
/*?*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/     	// Toolboxes
/*N*/         case 558 :                      // Fullscreenbar
/*N*/         case 560 :                    	// Functionbar
/*N*/         case 18003 :                    // FormularNavigationbar
/*N*/         case 18004 :                    // FormularFilterbar
/*N*/         case 20050 :                    // MathToolbar
/*N*/     	case 30001 :                    // ChartObjectbar
/*N*/     	case 30513 :                    // ChartToolbar
/*N*/     	case 25005 :                    // CalcTextObjectbar
/*N*/     	case 25047 :                    // CalcFormObjectbar
/*N*/     	case 25053 :                    // CalcDrawObjectbar
/*N*/     	case 25054 :                    // CalcGraphicObjectbar
/*N*/     	case 25001 :                    // CalcFormatObjectbar
/*N*/     	case 25006 :                    // CalcPreviewObjectbar
/*N*/     	case 25035 :                    // CalcToolbar
/*N*/ 		case 23015 :                    // DrawBezierObjectbar
/*N*/         case 23019 :                    // DrawGluepointsObjectbar
/*N*/         case 23030 :                    // ImpressGraphicObjectbar
/*N*/         case 23013 :                    // DrawDrawingObjectbar
/*N*/         case 23016 :                    // ImpressTextObjectbar
/*N*/         case 23028 :                    // DrawTextObjectbar
/*N*/         case 23011 :                    // ImpressToolbar
/*N*/         case 23020 :                    // ImpressOptionsbar
/*N*/         case 23021 :                    // ImpressCommontaskbar
/*N*/         case 23025 :                    // DrawToolbar
/*N*/         case 23026 :                    // DrawOptionsbar
/*N*/         case 23027 :                    // DrawGraphicObjectbar
/*N*/         case 23017 :                    // OutlineToolbar
/*N*/         case 23012 :                    // SlideViewToolbar
/*N*/         case 23014 :                    // SlideViewObjectbar
/*N*/         case 23283 :                    // WriterBezierObjectbar
/*N*/         case 23269 :                    // WriterDrawObjectbar
/*N*/         case 23299 :                    // WriterFormularObjectbar
/*N*/         case 23270 :                    // WriterDrawTextObjectbar
/*N*/         case 23267 :                    // WriterFrameObjectbar
/*N*/         case 23268 :                    // WriterGraphicObjectbar
/*N*/         case 23271 :                    // WriterNumObjectbar
/*N*/         case 23272 :                    // WriterOleObjectbar
/*N*/         case 23266 :                    // WriterTableObjectbar
/*N*/         case 23265 :                    // WriterTextObjectbar
/*N*/         case 20631 :                    // WriterPagePreviewObjectbar
/*N*/         case 23282 :                    // WriterWebSourceViewObjectbar
/*N*/         case 20402 :                    // WriterWebSourceViewToolbox
/*N*/         case 20403 :                    // WriterWebTextObjectbar
/*N*/         case 23273 :                    // WriterToolbox
/*N*/         case 20408 :                    // WriterWebFrameObjectbar
/*N*/         case 20410 :                    // WriterWebGraphicObjectbar
/*N*/         case 20411 :                    // WriterWebOleObjectbar
/*N*/         case 20412 :                    // WriterWebToolbar ????????????????????
/*N*/ 		{
/*?*/ 			BOOL bOK = FALSE;
/*?*/ 			SotStorageStreamRef xStream =
/*?*/             		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
/*?*/ 			if ( !xStream->GetError() )
/*?*/ 				bOK = SfxToolBoxManager::Import( *pStream, *xStream );
/*?*/ 			if ( bRet )
/*?*/ 				bRet = bOK;
/*?*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/     	case SFX_ITEMTYPE_IMAGELIST :
/*N*/ 		{
/*?*/ 			BOOL bOK = SfxImageManager::Import( *pStream, *pStor );
/*?*/ 			if ( bRet )
/*?*/ 				bRet = bOK;
/*?*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/     	case SFX_ITEMTYPE_TOOLBOXCONFIG :
/*N*/ 		{
/*?*/ 			BOOL bOK = FALSE;
/*?*/ 			SotStorageStreamRef xStream =
/*?*/             		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
/*?*/ 			if ( !xStream->GetError() )
/*?*/ 				bOK = SfxToolBoxConfig::Import( *pStream, *xStream );
/*?*/ 			if ( bRet )
/*?*/ 				bRet = bOK;
/*?*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/     	case SFX_ITEMTYPE_APPEVENTCONFIG :
/*N*/         {
/*?*/ 			BOOL bOK = FALSE;
/*?*/ 			SotStorageStreamRef xStream =
/*?*/             		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
/*?*/ 			if ( !xStream->GetError() )
/*?*/                 bOK = SfxEventConfiguration::Import( *pStream, xStream );
/*?*/ 			if ( bRet )
/*?*/ 				bRet = bOK;
/*N*/             break;
/*N*/         }
/*N*/ 
/*N*/     	case SFX_ITEMTYPE_DOCEVENTCONFIG :
/*N*/         {
/*N*/             BOOL bOK = SfxEventConfiguration::Import( *pStream, NULL, pObjShell );
/*N*/ 			if ( bRet )
/*N*/ 				bRet = bOK;
/*N*/ 			break;
/*N*/         }
/*N*/ 
/*N*/     	default:
/*?*/         	if ( pItem->nType >= SFX_ITEMTYPE_INTERFACE_START && pItem->nType <= SFX_ITEMTYPE_INTERFACE_END )
/*?*/         	{
/*?*/         	}
/*?*/         	else if ( pItem->nType >= RID_SFX_TOOLBOX_START + 10 && pItem->nType <= RID_SFX_TOOLBOX_START + 17 )
/*?*/         	{
/*?*/ 				// user defined toolboxes
/*?*/ 				BOOL bOK = FALSE;
/*?*/ 				SotStorageStreamRef xStream =
/*?*/             			pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
/*?*/ 				if ( !xStream->GetError() )
/*?*/ 					bOK = SfxToolBoxManager::Import( *pStream, *xStream );
/*?*/ 				if ( bRet )
/*?*/ 					bRet = bOK;
/*?*/         	}
/*?*/ #ifdef  DBG_UTIL
/*?*/ 			else
/*?*/ 			{
/*?*/ 				ByteString aMsg("SfxConfigManager: ConfigItem will not be imported : ");
/*?*/ 				aMsg += ByteString::CreateFromInt32( pItem->nType );
/*?*/ 				DBG_TRACE( aMsg.GetBuffer() );
/*?*/ 			}
/*?*/ #endif
/*?*/ 			break;
/*?*/ 	}
/*?*/ 
/*N*/ 	return bRet;
/*N*/ }

/*?*/ USHORT SfxConfigManagerImExport_Impl::Export( SotStorage* pStor, SotStorage *pOut )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
/*?*/ }

/*?*/ BOOL SfxConfigManagerImExport_Impl::ExportItem( SfxConfigItem_Impl *pItem, SotStorage* pStor, SvStream* pStream )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
/*?*/ }

/*?*/ String SfxConfigManagerImExport_Impl::GetItemName( USHORT nType )
/*?*/ {
/*?*/     return String();
/*?*/ }

/*N*/ String SfxConfigManagerImExport_Impl::GetStreamName( USHORT nType )
/*N*/ {
/*N*/     if ( nType >= SFX_ITEMTYPE_INTERFACE_START && nType <= SFX_ITEMTYPE_INTERFACE_END && nType != RID_DEFAULTMENU )
/*N*/     {
/*?*/         // accidently the old default menu interfered with the interface ID area
/*?*/         if ( nType != RID_DEFAULTMENU )
/*?*/             DBG_ERROR("Obsolete configitem!");
/*?*/         return String();
/*N*/     }
/*N*/     else if ( nType >= RID_SFX_TOOLBOX_START + 10 && nType <= RID_SFX_TOOLBOX_START + 17 )
/*N*/     {
/*?*/         ByteString aStr("userdeftoolbox");
/*?*/         aStr += ByteString::CreateFromInt32( nType - ( RID_SFX_TOOLBOX_START + 9 ) );
/*?*/         aStr += ".xml";
/*?*/         return String( aStr, RTL_TEXTENCODING_UTF8 );
/*N*/     }
/*N*/ 
/*N*/     for ( USHORT n=0; n<nTypesCount; n++ )
/*N*/     {
/*N*/         if ( pTypes[n] == nType )
/*N*/             return String::CreateFromAscii( pStreamNames[n] );
/*N*/     }
/*?*/ 
/*?*/     OSL_ENSURE(false, "Unknown configitem!");
/*?*/     return String();
/*N*/ }

/*?*/ USHORT SfxConfigManagerImExport_Impl::GetType( const String& rStreamName )
/*?*/ {
/*NBFF*/     ByteString aCmp( rStreamName, RTL_TEXTENCODING_ASCII_US );
/*NBFF*/ 
/*NBFF*/     if ( !aCmp.CompareTo( "userdeftoolbox", 14 ) )
/*NBFF*/         return (USHORT) ( RID_SFX_TOOLBOX_START + 9 + aCmp.Copy( 14 ).ToInt32() );
/*NBFF*/ 
/*NBFF*/     for ( USHORT n=0; n<nTypesCount; n++ )
/*NBFF*/         if ( !strcmp( aCmp.GetBuffer(), pStreamNames[n] ) )
/*NBFF*/             return pTypes[n];
/*NBFF*/ 
/*?*/     return 0;
/*?*/ }

}
