/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_helper.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 19:04:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "helper.hxx"

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XRESULTSET_HPP_
#include <com/sun/star/sdbc/XResultSet.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XROW_HPP_
#include <com/sun/star/sdbc/XRow.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_COMMANDABORTEDEXCEPTION_HPP_
#include <com/sun/star/ucb/CommandAbortedException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_ILLEGALIDENTIFIEREXCEPTION_HPP_
#include <com/sun/star/ucb/IllegalIdentifierException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_NAMECLASH_HPP_
#include <com/sun/star/ucb/NameClash.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_NUMBEREDSORTINGINFO_HPP_
#include <com/sun/star/ucb/NumberedSortingInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_TRANSFERINFO_HPP_
#include <com/sun/star/ucb/TransferInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XANYCOMPAREFACTORY_HPP_
#include <com/sun/star/ucb/XAnyCompareFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDINFO_HPP_
#include <com/sun/star/ucb/XCommandInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTACCESS_HPP_
#include <com/sun/star/ucb/XContentAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XDYNAMICRESULTSET_HPP_
#include <com/sun/star/ucb/XDynamicResultSet.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XSORTEDDYNAMICRESULTSETFACTORY_HPP_
#include <com/sun/star/ucb/XSortedDynamicResultSetFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_DATETIME_HPP_
#include <com/sun/star/util/DateTime.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
#include <unotools/localedatawrapper.hxx>
#endif
#ifndef _RTL_STRBUF_HXX_
#include <rtl/strbuf.hxx>
#endif

#include <tools/ref.hxx>
#include <tools/debug.hxx>
#include <tools/urlobj.hxx>
#include <tools/datetime.hxx>
#include <vcl/svapp.hxx>
#include <ucbhelper/content.hxx>
#include <ucbhelper/commandenvironment.hxx>
#include <comphelper/processfactory.hxx>
#include <osl/file.hxx>

#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {

using namespace ::ucb;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::ucb;
using namespace ::com::sun::star::task;
using namespace rtl;
using namespace comphelper;
using namespace osl;

DECLARE_LIST( StringList_Impl, OUString* )//STRIP008 ;

#define CONVERT_DATETIME( aUnoDT, aToolsDT ) \
	aToolsDT = DateTime( Date( aUnoDT.Day, aUnoDT.Month, aUnoDT.Year ), \
						 Time( aUnoDT.Hours, aUnoDT.Minutes, aUnoDT.Seconds, aUnoDT.HundredthSeconds ) );


// SfxContentHelper ------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

/*N*/ Sequence < OUString > SfxContentHelper::GetResultSet( const String& rURL )
/*N*/ {
/*N*/ 	StringList_Impl* pList = NULL;
/*N*/ 	try
/*N*/ 	{
/*N*/ 		Content aCnt( rURL, Reference< ::com::sun::star::ucb::XCommandEnvironment >() );
/*N*/ 		Reference< XResultSet > xResultSet;
/*N*/ 		Reference< ::com::sun::star::ucb::XDynamicResultSet > xDynResultSet;
/*N*/ 		Sequence< OUString > aProps(3);
/*N*/ 		OUString* pProps = aProps.getArray();
/*N*/ 		pProps[0] = OUString::createFromAscii( "Title" );
/*N*/ 		pProps[1] = OUString::createFromAscii( "ContentType" );
/*N*/ 		pProps[2] = OUString::createFromAscii( "IsFolder" );
/*N*/ 
/*N*/ 		try
/*N*/ 		{
/*N*/ 			xDynResultSet = aCnt.createDynamicCursor( aProps, INCLUDE_FOLDERS_AND_DOCUMENTS );
/*N*/ 			if ( xDynResultSet.is() )
/*N*/ 				xResultSet = xDynResultSet->getStaticResultSet();
/*N*/ 		}
/*N*/ 		catch( ::com::sun::star::ucb::CommandAbortedException& )
/*N*/ 		{
/*N*/ 			DBG_ERRORFILE( "createCursor: CommandAbortedException" );
/*N*/ 		}
/*N*/ 		catch( ::com::sun::star::uno::Exception& )
/*N*/ 		{
/*N*/ 			DBG_ERRORFILE( "createCursor: Any other exception" );
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( xResultSet.is() )
/*N*/ 		{
/*N*/ 			pList = new StringList_Impl;
/*N*/ 			Reference< ::com::sun::star::sdbc::XRow > xRow( xResultSet, UNO_QUERY );
/*N*/ 			Reference< ::com::sun::star::ucb::XContentAccess > xContentAccess( xResultSet, UNO_QUERY );
/*N*/ 
/*N*/ 			try
/*N*/ 			{
/*N*/ 				while ( xResultSet->next() )
/*N*/ 				{
/*N*/ 					String aTitle( xRow->getString(1) );
/*N*/ 					String aType( xRow->getString(2) );
/*N*/ 					sal_Bool bFolder = xRow->getBoolean(3);
/*N*/ 					String aRow = aTitle;
/*N*/ 					aRow += '\t';
/*N*/ 					aRow += aType;
/*N*/ 					aRow += '\t';
/*N*/ 					aRow += String( xContentAccess->queryContentIdentifierString() );
/*N*/ 					OUString* pRow = new OUString( aRow );
/*N*/ 					pList->Insert( pRow, LIST_APPEND );
/*N*/ 				}
/*N*/ 			}
/*N*/ 			catch( ::com::sun::star::ucb::CommandAbortedException& )
/*N*/ 			{
/*N*/ 				DBG_ERRORFILE( "XContentAccess::next(): CommandAbortedException" );
/*N*/ 			}
/*N*/ 			catch( ::com::sun::star::uno::Exception& )
/*N*/ 			{
/*N*/ 				DBG_ERRORFILE( "XContentAccess::next(): Any other exception" );
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	catch( ::com::sun::star::uno::Exception& )
/*N*/ 	{
/*N*/ 		DBG_ERRORFILE( "GetResultSet: Any other exception" );
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( pList )
/*N*/ 	{
/*N*/ 		ULONG nCount = pList->Count();
/*N*/ 		Sequence < OUString > aRet( nCount );
/*N*/ 		OUString* pRet = aRet.getArray();
/*N*/ 		for ( ULONG i = 0; i < nCount; ++i )
/*N*/ 		{
/*N*/ 			OUString* pEntry = pList->GetObject(i);
/*N*/ 			pRet[i] = *( pEntry );
/*N*/ 			delete pEntry;
/*N*/ 		}
/*N*/ 		delete pList;
/*N*/ 		return aRet;
/*N*/ 	}
/*N*/ 	else
/*N*/ 		return Sequence < OUString > ();
/*N*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------

/*N*/ String SfxContentHelper::GetActiveHelpString( const String& rURL )
/*N*/ {
/*N*/ 	String aRet;
/*N*/ 	try
/*N*/ 	{
/*N*/         Reference< XMultiServiceFactory > xFactory = ::legacy_binfilters::getLegacyProcessServiceFactory();
/*N*/         Reference< XInteractionHandler > xInteractionHandler = Reference< XInteractionHandler > (
/*N*/                     xFactory->createInstance( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.task.InteractionHandler") ) ), UNO_QUERY );
/*N*/         Content aCnt( rURL, new ::ucb::CommandEnvironment( xInteractionHandler, Reference< XProgressHandler >() ) );
/*N*/ 		// open the "active help" stream
/*N*/ 		Reference< ::com::sun::star::io::XInputStream > xStream = aCnt.openStream();
/*N*/ 		// and convert it to a String
/*N*/ 		Sequence< sal_Int8 > lData;
/*N*/ 		sal_Int32 nRead = xStream->readBytes( lData, 1024 );
/*N*/ 		while ( nRead > 0 )
/*N*/ 		{
/*N*/ 			OStringBuffer sBuffer( nRead );
/*N*/ 			for( sal_Int32 i = 0; i < nRead; ++i )
/*N*/     			sBuffer.append( (sal_Char)lData[i] );
/*N*/ 			OUString sString = OStringToOUString( sBuffer.makeStringAndClear(), RTL_TEXTENCODING_UTF8 );
/*N*/ 			aRet += String( sString );
/*N*/ 
/*N*/ 			nRead = xStream->readBytes( lData, 1024 );
/*N*/ 		}
/*N*/ 	}
/*N*/ 	catch( ::com::sun::star::uno::Exception& )
/*N*/ 	{
/*N*/ 	}
/*N*/ 
/*N*/ 	return aRet;
/*N*/ }

// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------


// -----------------------------------------------------------------------
// please don't use it (only used in appbas.cxx and appcfg.cxx)

// -----------------------------------------------------------------------



}
