/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: xmlaccelcfg.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:51:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef INCLUDED_SFX_XMLACCELCFG_HXX
#define INCLUDED_SFX_XMLACCELCFG_HXX

#include "accelcfg.hxx"

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef __COM_SUN_STAR_XML_SAX_XDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _RTL_USTRING_
#include <rtl/ustring.hxx>
#endif

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#include <hash_map>

namespace binfilter {



class OWriteAcceleratorDocumentHandler
{
	public:
		OWriteAcceleratorDocumentHandler(
            const SfxAcceleratorItemList& aWriteAcceleratorList,
			::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XDocumentHandler > );
		virtual ~OWriteAcceleratorDocumentHandler();

		void WriteAcceleratorDocument() throw ( ::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException );

	private:
        void WriteAcceleratorItem( const SfxAcceleratorConfigItem& aAcceleratorItem ) throw( ::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException );

		::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XDocumentHandler > m_xWriteDocumentHandler;
		::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList > m_xEmptyList;
		::rtl::OUString											m_aXMLAccelNS;
		::rtl::OUString											m_aXMLXlinkNS;
		::rtl::OUString											m_aAttributeType;
		::rtl::OUString											m_aAttributeURL;
		::rtl::OUString											m_aAttributeKeycode;
		::rtl::OUString											m_aAttributeModShift;
		::rtl::OUString											m_aAttributeModMod1;
		::rtl::OUString											m_aAttributeModMod2;
		::rtl::OUString											m_aAttributeModCTRL;
		::rtl::OUString											m_aAttributeBooleanTRUE;
        const SfxAcceleratorItemList&                           m_aWriteAcceleratorList;
};

}//end of namespace binfilter
#endif // INCLUDED_SVTOOLS_XMLACCELCFG_HXX
