/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_viewshel.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:48:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _SCRBAR_HXX //autogen
#include <vcl/scrbar.hxx>
#endif
#ifndef _SVX_RULER_HXX //autogen
#include <bf_svx/ruler.hxx>
#endif
#ifndef _SVXIDS_HXX
#include <bf_svx/svxids.hrc>
#endif
#ifndef _SVX_FMSHELL_HXX
#include <bf_svx/fmshell.hxx>
#endif
#ifndef SD_WINDOW_UPDATER_HXX
#include "WindowUpdater.hxx"
#endif

#include "app.hrc"
#include "helpids.h"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "sdview.hxx"
#include "sdresid.hxx"
#include "docshell.hxx"
#include "fuslshow.hxx"
#include "drawdoc.hxx"
#include "zoomlist.hxx"
#include "grviewsh.hxx"
#include "prevchld.hxx"

// #96090#

#ifndef _SD_SDWINDOW_HXX
#include "sdwindow.hxx"
#endif

namespace binfilter {

#ifndef SO2_DECL_SVINPLACEOBJECT_DEFINED
#define SO2_DECL_SVINPLACEOBJECT_DEFINED
SO2_DECL_REF(SvInPlaceObject)
#endif

#define DELTA_ZOOM  10

// Use magenta as transparency color instead of the standard gray that is
// imported from vcl/image.hxx
#undef IMAGE_STDBTN_COLOR
#undef IMAGE_STDBTN_COLOR_HC
#define IMAGE_STDBTN_COLOR Color(0xff,0x00,0xff)
#define IMAGE_STDBTN_COLOR_HC Color(0xff,0x00,0xff)

/*************************************************************************
|*
|* SFX-Slotmap und Standardinterface deklarieren
|*
\************************************************************************/
/*N*/ TYPEINIT1( SdViewShell, SfxViewShell);

/*************************************************************************
|*
|* gemeinsamer Initialiserungsanteil der beiden Konstruktoren
|*
\************************************************************************/

/*N*/ void SdViewShell::Construct(void)
/*N*/ {
/*N*/ 	pDocSh->Connect(this);
/*N*/ 
/*N*/ 	pZoomList = new ZoomList( this );
/*N*/ 
/*N*/ 	pWindow = NULL;
/*N*/ 	SetActiveWindow(new SdWindow(&GetViewFrame()->GetWindow()));
/*N*/ //    pWindow->GrabFocus();
/*N*/ 
/*N*/ 	// alle Zeiger mit NULL initialisieren
/*N*/ 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
/*N*/ 	{
/*N*/ 		pHScrlArray[nX] = NULL;
/*N*/ 		pHRulerArray[nX] = NULL;
/*N*/ 
/*N*/ 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
/*N*/ 		{
/*N*/ 			pVScrlArray[nY] = NULL;
/*N*/ 			pVRulerArray[nY] = NULL;
/*N*/ 			pWinArray[nX][nY] = NULL;
/*N*/ 		}
/*N*/ 	}
/*N*/ 	// Splitter zu Anfang aus
/*N*/ 	bIsHSplit = bIsVSplit = FALSE;
/*N*/ 	// Lineal an
/*N*/ 	bHasRuler = TRUE;
/*N*/ 
/*N*/ 	pWindow->SetCenterAllowed(bCenterAllowed);
/*N*/ 
/*N*/ 	pWinArray[0][0] = pWindow;
/*N*/ 	pWinArray[0][0]->SetViewShell(this);
/*N*/ 
/*N*/ 	pHScrlArray[0] = new ScrollBar(&GetViewFrame()->GetWindow(),
/*N*/ 									WinBits(WB_HSCROLL | WB_DRAG));
/*N*/ 	pHScrlArray[0]->EnableRTL (FALSE);
/*N*/     pHScrlArray[0]->SetRange(Range(0, 32000));
/*N*/ 	pHScrlArray[0]->SetScrollHdl(LINK(this, SdViewShell, HScrollHdl));
/*N*/ 	pHScrlArray[0]->Show();
/*N*/ 
/*N*/ 	pVScrlArray[0] = new ScrollBar(&GetViewFrame()->GetWindow(),
/*N*/ 									WinBits(WB_VSCROLL | WB_DRAG));
/*N*/ 	pVScrlArray[0]->SetRange(Range(0, 32000));
/*N*/ 	pVScrlArray[0]->SetScrollHdl(LINK(this, SdViewShell, VScrollHdl));
/*N*/ 	pVScrlArray[0]->Show();
/*N*/ 	aScrBarWH = Size(pVScrlArray[0]->GetSizePixel().Width(),
/*N*/ 					 pHScrlArray[0]->GetSizePixel().Height());
/*N*/ 
/*N*/ 	aHSplit.SetSplitHdl(LINK(this, SdViewShell, SplitHdl));
/*N*/ 	aVSplit.SetSplitHdl(LINK(this, SdViewShell, SplitHdl));
/*N*/ 	aHSplit.Show();
/*N*/ 	aVSplit.Show();
/*N*/ 
/*N*/ 	if (pScrlBox)
/*N*/ 		pScrlBox->Show();
/*N*/ 
/*N*/ 	if( !this->ISA( SdGraphicViewShell ) )
/*N*/ 	{
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 		aDrawBtn.SetImage( Image( Bitmap( SdResId( BMP_SW_DRAW ) ), IMAGE_STDBTN_COLOR ) );
/*N*/ 		aDrawBtn.SetClickHdl(LINK(this, SdViewShell, ModeBtnHdl));
/*N*/ 		aDrawBtn.SetQuickHelpText( String( SdResId( STR_DRAW_MODE ) ) );
/*N*/ 		aDrawBtn.SetHelpId( HID_SD_BTN_DRAW );
/*N*/ 		aDrawBtn.Show();
/*N*/ 
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 		aSlideBtn.SetImage( Image( Bitmap( SdResId( BMP_SW_SLIDE ) ), IMAGE_STDBTN_COLOR ) );
/*N*/ 		aSlideBtn.SetClickHdl(LINK(this, SdViewShell, ModeBtnHdl));
/*N*/ 		aSlideBtn.SetQuickHelpText( String( SdResId( STR_SLIDE_MODE ) ) );
/*N*/ 		aSlideBtn.SetHelpId( HID_SD_BTN_SLIDE );
/*N*/ 		aSlideBtn.Show();
/*N*/ 
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 		aOutlineBtn.SetImage( Image( Bitmap( SdResId( BMP_SW_OUTLINE ) ), IMAGE_STDBTN_COLOR ) );
/*N*/ 		aOutlineBtn.SetClickHdl(LINK(this, SdViewShell, ModeBtnHdl));
/*N*/ 		aOutlineBtn.SetQuickHelpText( String( SdResId( STR_OUTLINE_MODE ) ) );
/*N*/ 		aOutlineBtn.SetHelpId( HID_SD_BTN_OUTLINE );
/*N*/ 		aOutlineBtn.Show();
/*N*/ 
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 		aNotesBtn.SetImage( Image( Bitmap( SdResId( BMP_SW_NOTES ) ), IMAGE_STDBTN_COLOR ) );
/*N*/ 		aNotesBtn.SetClickHdl(LINK(this, SdViewShell, ModeBtnHdl));
/*N*/ 		aNotesBtn.SetQuickHelpText( String( SdResId( STR_NOTES_MODE ) ) );
/*N*/ 		aNotesBtn.SetHelpId( HID_SD_BTN_NOTES );
/*N*/ 		aNotesBtn.Show();
/*N*/ 
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 		aHandoutBtn.SetImage( Image( Bitmap( SdResId( BMP_SW_HANDOUT ) ), IMAGE_STDBTN_COLOR ) );
/*N*/ 		aHandoutBtn.SetClickHdl(LINK(this, SdViewShell, ModeBtnHdl));
/*N*/ 		aHandoutBtn.SetQuickHelpText( String( SdResId( STR_HANDOUT_MODE ) ) );
/*N*/ 		aHandoutBtn.SetHelpId( HID_SD_BTN_HANDOUT );
/*N*/ 		aHandoutBtn.Show();
/*N*/ 
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 		aPresentationBtn.SetImage( Image( Bitmap( SdResId( BMP_SW_PRESENTATION ) ), IMAGE_STDBTN_COLOR ) );
/*N*/ 		aPresentationBtn.SetClickHdl(LINK(this, SdViewShell, ModeBtnHdl));
/*N*/ 		aPresentationBtn.SetQuickHelpText( String( SdResId( STR_START_PRESENTATION ) ) );
/*N*/ 		aPresentationBtn.SetHelpId( HID_SD_BTN_PRESENTATION );
/*N*/ 		aPresentationBtn.Show();
/*N*/ 
/*N*/ 		if (pDocSh->IsPreview())
/*N*/ 		{
/*?*/ 			aPresentationBtn.Disable();
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			aPresentationBtn.Enable();
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	String aName( RTL_CONSTASCII_USTRINGPARAM( "ViewShell" ));
/*N*/ 	SetName (aName);

/*N*/ 	pDoc->StartOnlineSpelling(FALSE);

/*N*/     mpWindowUpdater->SetViewShell (*this);
/*N*/     mpWindowUpdater->SetDocument (pDoc);
/*N*/ }

/*************************************************************************
|*
|* Standard-Konstruktor
|*
\************************************************************************/

/*N*/ SdViewShell::SdViewShell(SfxViewFrame* pFrame, Window *pParent,
/*N*/ 						 BOOL bAllowCenter) :
/*N*/ 	SfxViewShell(pFrame, SFX_VIEW_MAXIMIZE_FIRST	  |
/*N*/ 						 SFX_VIEW_OPTIMIZE_EACH 	  |
/*N*/ 						 SFX_VIEW_DISABLE_ACCELS	  |
/*N*/ 						 SFX_VIEW_OBJECTSIZE_EMBEDDED |
/*N*/ 						 SFX_VIEW_CAN_PRINT           |
/*N*/ 						 SFX_VIEW_HAS_PRINTOPTIONS),
/*N*/     mpWindowUpdater (new ::binfilter::sd::WindowUpdater()),
/*N*/ 	aHSplit(&pFrame->GetWindow(), WB_HSCROLL),
/*N*/ 	aVSplit(&pFrame->GetWindow(), WB_VSCROLL),
/*N*/ 	aDrawBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
/*N*/ 	aSlideBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
/*N*/ 	aOutlineBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
/*N*/ 	aNotesBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
/*N*/ 	aHandoutBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
/*N*/ 	aPresentationBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
/*N*/ 	pDocSh( (SdDrawDocShell*) GetViewFrame()->GetObjectShell() ),
/*N*/ 	pDoc( pDocSh->GetDoc() ),
/*N*/ 	pFuActual(NULL),
/*N*/ 	pFuOld(NULL),
/*N*/ 	pFuSearch(NULL),
/*N*/ 	pFuSlideShow(NULL),
/*N*/ 	pZoomList(NULL),
/*N*/ 	nCurrentObjectBar(0),
/*N*/ 	bObjectBarSwitchEnabled(TRUE),
/*N*/ 	pFrameView(NULL),
/*N*/ 	bCenterAllowed(bAllowCenter),
/*N*/ 	bStartShowWithDialog( FALSE ),
/*N*/ 	pScrlBox(NULL),
/*N*/ 	pView(NULL),
/*N*/ 	nPrintedHandoutPageNum(1),
/*N*/ 	bPrintDirectSelected( FALSE )
/*N*/ {
/*N*/ 	pScrlBox = new ScrollBarBox(&pFrame->GetWindow(), WB_3DLOOK | WB_SIZEABLE );
/*N*/ 	Construct();
/*N*/ }

/*************************************************************************
|*
|* Copy-Konstruktor
|*
\************************************************************************/

SdViewShell::SdViewShell(SfxViewFrame* pFrame, const SdViewShell& rShell) :
	SfxViewShell(pFrame, SFX_VIEW_MAXIMIZE_FIRST	  |
						 SFX_VIEW_OPTIMIZE_EACH 	  |
						 SFX_VIEW_DISABLE_ACCELS	  |
						 SFX_VIEW_OBJECTSIZE_EMBEDDED |
						 SFX_VIEW_HAS_PRINTOPTIONS),
	aHSplit(&pFrame->GetWindow(), WB_HSCROLL),
	aVSplit(&pFrame->GetWindow(), WB_VSCROLL),
	aDrawBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
	aSlideBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
	aOutlineBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
	aNotesBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
	aHandoutBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
	aPresentationBtn(&pFrame->GetWindow(), WB_3DLOOK | WB_RECTSTYLE | WB_SMALLSTYLE | WB_NOPOINTERFOCUS ),
	pDocSh( (SdDrawDocShell*) GetViewFrame()->GetObjectShell() ),
	pDoc( pDocSh->GetDoc() ),
	pFuActual(NULL),
	pFuOld(NULL),
	pFuSearch(NULL),
	pFuSlideShow(NULL),
	pZoomList(NULL),
	nCurrentObjectBar(0),
	bObjectBarSwitchEnabled(TRUE),
	pFrameView(NULL),
	bCenterAllowed(rShell.bCenterAllowed),
	pScrlBox(NULL),
	pView(NULL),
	nPrintedHandoutPageNum(1),
	bPrintDirectSelected( FALSE )
{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001 	pScrlBox = new ScrollBarBox(&pFrame->GetWindow(), WB_3DLOOK | WB_SIZEABLE );
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SdViewShell::~SdViewShell()
/*N*/ {
/*N*/ 	CancelSearching();
/*N*/ 
/*N*/ 	pDocSh->Disconnect(this);
/*N*/ 
/*N*/ 	SetWindow(NULL);
/*N*/ 
/*N*/ 	delete pZoomList;
/*N*/ 
/*N*/ 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
/*N*/ 	{
/*N*/ 		// Zeiger immer gueltig oder NULL
/*N*/ 		delete pHScrlArray[nX];
/*N*/ 		delete pHRulerArray[nX];
/*N*/ 
/*N*/ 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
/*N*/ 		{
/*N*/ 			if ( pVScrlArray[nY] )
/*N*/ 			{
/*N*/ 				delete pVScrlArray[nY];
/*N*/ 				pVScrlArray[nY] = NULL;
/*N*/ 			}
/*N*/ 			if ( pVRulerArray[nY] )
/*N*/ 			{
/*N*/ 				delete pVRulerArray[nY];
/*N*/ 				pVRulerArray[nY] = NULL;
/*N*/ 			}
/*N*/ 			if ( pWinArray[nX][nY] )
/*N*/ 				delete pWinArray[nX][nY];
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	// Shells fuer Object Bars loeschen
/*N*/ 	// vorm Zerstoeren der ObjectBarShells den Dispatcher flushen
/*N*/ 	GetViewFrame()->GetDispatcher()->Flush();
/*N*/ 
/*N*/ 	SfxShell* pObjBarShell = (SfxShell*)aShellTable.First();
/*N*/ 	while (pObjBarShell)
/*N*/ 	{
/*N*/ 		delete pObjBarShell;
/*N*/ 		pObjBarShell = (SfxShell*)aShellTable.Next();
/*N*/ 	}
/*N*/ 
/*N*/ 	delete pScrlBox;
/*N*/ }

/*************************************************************************
|*
|* Diese Methode deaktiviert und loescht die aktuelle Funktion. Falls es
|* eine alte Funktion gibt, wird sie als aktuelle Funktion eingesetzt und
|* aktiviert.
|*
\************************************************************************/

/*N*/ void SdViewShell::Cancel()
/*N*/ {
/*N*/ 	if (pFuActual && pFuActual != pFuOld)
/*N*/ 	{
/*?*/ 		FuPoor* pTemp = pFuActual;
/*?*/ 		pFuActual	  = NULL;
/*?*/ 		pTemp->Deactivate();
/*?*/ 		delete pTemp;
/*?*/ 	}
/*N*/ 
/*N*/ 	if (pFuOld)
/*N*/ 	{
/*N*/ 		pFuActual = pFuOld;
/*N*/ 		pFuActual->Activate();
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Aktivierung: Arbeitsfenster den Fokus zuweisen
|*
\************************************************************************/




/*************************************************************************
|*
|* Deaktivierung
|*
\************************************************************************/

/*N*/ void SdViewShell::Deactivate(BOOL bIsMDIActivate)
/*N*/ {
/*N*/ 	// View-Attribute an der FrameView merken
/*N*/ 	WriteFrameViewData();
/*N*/ 
/*N*/ 	if (bIsMDIActivate)
/*N*/ 	{
/*N*/ 		if (pFuSlideShow)
/*N*/ 		{
/*?*/ 			pFuSlideShow->Deactivate();
/*N*/ 		}
/*N*/ 		if (pFuActual)
/*N*/ 		{
/*?*/ 			pFuActual->Deactivate();
/*N*/ 		}
/*N*/ 
/*N*/ 		// ggfs. Preview vom Kontext loesen
/*N*/ 		SfxChildWindow* pPreviewChildWindow =
/*N*/ 			GetViewFrame()->GetChildWindow(SdPreviewChildWindow::GetChildWindowId());
/*N*/ 		if (pPreviewChildWindow)
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SdPreviewWin* pPreviewWin =
/*?*/ 		}
/*N*/ 
/*N*/ 		SdView* pView = GetView();
/*N*/ 
/*N*/ 		if (pView)
/*N*/ 		{
/*N*/ 			pView->HideMarkHdl(NULL);
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
/*N*/ 		if ( pHRulerArray[nX] )
/*N*/ 			pHRulerArray[nX]->SetActive(FALSE);
/*N*/ 	for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
/*N*/ 		if ( pVRulerArray[nY] )
/*N*/ 			pVRulerArray[nY]->SetActive(FALSE);
/*N*/ 
/*N*/ 	SfxViewShell::Deactivate(bIsMDIActivate);
/*N*/ }

/*************************************************************************
|*
|* Keyboard event
|*
\************************************************************************/


/*************************************************************************
|*
|* MouseButtonDown event
|*
\************************************************************************/


/*************************************************************************
|*
|* MouseMove event
|*
\************************************************************************/


/*************************************************************************
|*
|* MouseButtonUp event
|*
\************************************************************************/



/*************************************************************************
|*
|* Command event
|*
\************************************************************************/



/*************************************************************************
|*
|* Ersatz fuer AdjustPosSizePixel ab Sfx 248a
|*
\************************************************************************/


/*************************************************************************
|*
|* Ersatz fuer AdjustPosSizePixel ab Sfx 248a
|*
\************************************************************************/



/** After a simple consistency check the given values are stored so that
    they can be accessed by the <member>ArrageGUIElements</member> method
    which is finally called and performs the actual adjustment of sizes and
    positions of the GUI elements.
*/



/*
	if ( aVBarSize.Height() < MIN_SCROLLBAR_SIZE )
	{
		aVPos.Y() = aVSplitPos.Y() - MIN_SCROLLBAR_SIZE;
		aVBarSize.Height() = MIN_SCROLLBAR_SIZE;
	}
*/

/*************************************************************************
|*
|* Splitter-Handling
|*
\************************************************************************/

IMPL_LINK( SdViewShell, SplitHdl, Splitter *, pSplit )
{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 Point	aSplitPos = pSplit->GetPosPixel();
	return 0;
}

/*************************************************************************
|*
|* Fenster und ScrollBars fuer Horizontales Splitting erzeugen
|* bzw. entfernen
|*
\************************************************************************/


/*************************************************************************
|*
|* Fenster und ScrollBars fuer Vertikales Splitting erzeugen
|* bzw. entfernen
|*
\************************************************************************/


/*************************************************************************
|*
|* Metrik setzen
|*
\************************************************************************/


/*************************************************************************
|*
|* DefTab an den horizontalen Linealen setzen
|*
\************************************************************************/

/*************************************************************************
|*
|* Der FmShell das PrepareClose mitteilen, damit diese ihre Datensaetze
|* speichern kann.
|*
\************************************************************************/
/*N*/ USHORT SdViewShell::PrepareClose( BOOL bUI, BOOL bForBrowsing )
/*N*/ {
/*N*/ 	USHORT nRet = SfxViewShell::PrepareClose( bUI, bForBrowsing );
/*N*/ 
/*N*/ 	if( nRet == TRUE )
/*N*/ 	{
/*N*/ 		FmFormShell* pShell = (FmFormShell*)aShellTable.Get( RID_FORMLAYER_TOOLBOX );
/*N*/ 		if( pShell )
/*N*/ 			nRet = pShell->PrepareClose( bUI, bForBrowsing );
/*N*/ 	}
/*N*/ 
/*N*/ 	return nRet;
/*N*/ }

/*************************************************************************
|*
|* Update preview context
|*
\************************************************************************/
/*N*/ void SdViewShell::UpdatePreview( SdPage* pPage, BOOL bInit )
/*N*/ {
/*N*/ 	SfxChildWindow* pPreviewChildWindow = GetViewFrame()->GetChildWindow( SdPreviewChildWindow::GetChildWindowId() );
/*N*/ 	if ( pPreviewChildWindow )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SdPreviewWin* pPreviewWin = (SdPreviewWin*) pPreviewChildWindow->GetWindow();
/*?*/ 	}
/*N*/ }

// -----------------------------------------------------------------------------



// -----------------------------------------------------------------------------


// -----------------------------------------------------------------------------


// -----------------------------------------------------------------------------


// -----------------------------------------------------------------------------





/** This default implemenation returns only an empty reference.  See derived
    classes for more interesting examples.
*/



}
