/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviews8.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:42:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVXIDS_HXX
#include <bf_svx/svxids.hrc>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX //autogen
#include <bf_sfx2/bindings.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX
#include <bf_sfx2/viewfrm.hxx>
#endif

#pragma hdrstop

#include "app.hrc"
#include "strings.hrc"

#include "sdresid.hxx"
#include "sdwindow.hxx"
#include "drviewsh.hxx"
namespace binfilter {



/*************************************************************************
|*
|* SfxRequests fuer temporaere Funktionen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::FuTemp01(SfxRequest& rReq)
/*N*/ {
/*N*/ 	switch(rReq.GetSlot())
/*N*/ 	{
/*?*/ 		case SID_ATTRIBUTES_LINE:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuLine( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_ATTRIBUTES_AREA:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_ASSERT(0,"STRIP!"); //STRIP001 pFuActual = new FuArea( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_ATTR_TRANSFORM:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuTransform( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_CHAR_DLG:	// BASIC
/*?*/ 		{
/*?*/ 			DBG_ASSERT(0, "STRIP!"); //STRIP001 pFuActual = new FuChar( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_PARA_DLG:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuParagraph( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OUTLINE_BULLET:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuOutlineBullet( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_BULLET:
/*?*/ 		{
/*?*/ 			DBG_ASSERT(0, "STRIP!"); //STRIP001 pFuActual = new FuBullet( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_PRESENTATION_LAYOUT:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuPresentationLayout(this, pWindow, pDrView, pDoc, rReq);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ //        case SID_MODEL:
/*?*/ //        {
/*?*/ //            pFuActual = new FuTemplate( this, pWindow, pDrView, pDoc, rReq );
/*?*/ //            Cancel();
/*?*/ //        }
/*?*/ //        break;
/*?*/ 
/*?*/ 		case SID_PASTE2:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuInsertClipboard( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_INSERT_GRAPHIC:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuInsertGraphic( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_INSERT_OBJECT:
/*?*/ 		case SID_INSERT_PLUGIN:
/*?*/ 		case SID_INSERT_SOUND:
/*?*/ 		case SID_INSERT_VIDEO:
/*?*/ 		case SID_INSERT_APPLET:
/*?*/ 		case SID_INSERT_FLOATINGFRAME:
/*?*/ #ifdef STARIMAGE_AVAILABLE
/*?*/ 		case SID_INSERT_IMAGE:
/*?*/ #endif
/*?*/ 		case SID_INSERT_MATH:
/*?*/ 		case SID_INSERT_DIAGRAM:
/*?*/ 		case SID_ATTR_TABLE:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuInsertOLE( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_COPYOBJECTS:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsPresObjSelected(FALSE, TRUE) )
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_INSERTFILE:  // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuInsertFile( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_PAGESETUP:  // BASIC ??
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuPage( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_ZOOM_OUT:
/*?*/ 		case SID_ZOOM_PANNING:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 bZoomOnPage = FALSE;
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_BEFORE_OBJ:
/*?*/ 		case SID_BEHIND_OBJ:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuDisplayOrder(this, pWindow, pDrView, pDoc, rReq);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_REVERSE_ORDER:   // BASIC
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->ReverseOrderOfMarked();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_DIA:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual =new FuSlideParameters( this, pWindow, pDrView, pDoc, rReq);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_ANIMATION_EFFECTS:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual =new FuObjectAnimationParameters( this, pWindow, pDrView, pDoc, rReq);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_LINEEND_POLYGON:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuLineEnd( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_CAPTUREPOINT:
/*?*/ 			// negative Werte um Aufruf aus Menue zu signalisieren
/*?*/ 			aMousePos = Point(-1,-1);
/*?*/ 		case SID_SET_SNAPITEM:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuSnapLine(this, pWindow, pDrView, pDoc, rReq);
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_MANAGE_LINKS:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuLink( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_THESAURUS:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuThesaurus( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_TEXTATTR_DLG:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuTextAttrDlg( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_MEASURE_DLG:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuMeasureDlg( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_CONNECTION_DLG:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuConnectionDlg( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_CONNECTION_NEW_ROUTING:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxItemSet aDefAttr( GetPool(), SDRATTR_EDGELINE1DELTA, SDRATTR_EDGELINE3DELTA );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/         case SID_TWAIN_SELECT:
/*?*/ 		{
/*?*/ 			BOOL bDone = FALSE;
/*?*/ 
/*?*/ 			if( mxScannerManager.is() )
/*?*/ 			{
/*?*/ 				try
/*?*/ 				{
/*?*/ 					const ::com::sun::star::uno::Sequence< ::com::sun::star::scanner::ScannerContext >
/*?*/ 						aContexts( mxScannerManager->getAvailableScanners() );
/*?*/ 
/*?*/ 					if( aContexts.getLength() )
/*?*/ 					{
/*?*/ 						::com::sun::star::scanner::ScannerContext aContext( aContexts.getConstArray()[ 0 ] );
/*?*/ 						bDone = mxScannerManager->configureScanner( aContext );
/*?*/ 					}
/*?*/ 				}
/*?*/ 				catch(...)
/*?*/ 				{
/*?*/                 }
/*?*/ 			}
/*?*/ 
/*?*/             Cancel();
/*?*/ 			rReq.Done();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/         case SID_TWAIN_TRANSFER:
/*?*/ 		{
/*?*/ 			BOOL bDone = FALSE;
/*?*/ 
/*?*/ 			if( mxScannerManager.is() )
/*?*/ 			{
/*?*/ 				try
/*?*/ 				{
/*?*/ 					const ::com::sun::star::uno::Sequence< ::com::sun::star::scanner::ScannerContext > aContexts( mxScannerManager->getAvailableScanners() );
/*?*/ 
/*?*/ 					if( aContexts.getLength() )
/*?*/ 					{
/*?*/ 						mxScannerManager->startScan( aContexts.getConstArray()[ 0 ], mxScannerListener );
/*?*/ 						bDone = TRUE;
/*?*/ 					}
/*?*/ 				}
/*?*/ 				catch( ... )
/*?*/ 				{
/*?*/ 				}
/*?*/ 			}
/*?*/ 
/*?*/ 			if( !bDone )
/*?*/ 			{
/*?*/ #ifndef UNX
/*?*/ 				const USHORT nId = STR_TWAIN_NO_SOURCE;
/*?*/ #else
/*?*/ 				const USHORT nId = STR_TWAIN_NO_SOURCE_UNX;
/*?*/ #endif
/*?*/ 
/*?*/ 				InfoBox( pWindow, String( SdResId( nId ) ) ).Execute();
/*?*/ 			}
/*?*/ 			else
/*?*/ 			{
/*?*/ 				SfxBindings& rBindings = GetViewFrame()->GetBindings();
/*?*/ 				rBindings.Invalidate( SID_TWAIN_SELECT );
/*?*/ 				rBindings.Invalidate( SID_TWAIN_TRANSFER );
/*?*/ 			}
/*?*/ 
/*?*/             Cancel();
/*?*/ 			rReq.Done();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_POLYGON_MORPHING:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuMorph( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_VECTORIZE:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFuActual = new FuVectorize( this, pWindow, pDrView, pDoc, rReq );
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*N*/ 		default:
/*N*/ 		{
/*N*/ 			// switch Anweisung wegen CLOOKS aufgeteilt. Alle case-Anweisungen die
/*N*/ 			// eine Fu???? -Funktion aufrufen, sind in die Methode FuTemp01 (drviews8),
/*N*/ 			// FuTemp02 (drviewsb) gewandert.
/*N*/ 			FuTemp02(rReq);
/*N*/ 		}
/*N*/ 		break;
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Scanner-Event
|*
\************************************************************************/

}
