/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviews3.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:41:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _EEITEMID_HXX
#include <bf_svx/eeitemid.hxx>
#endif

#ifndef _EEITEM_HXX //autogen
#include <bf_svx/eeitem.hxx>
#endif


#ifndef _SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif


#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _SFXRECTITEM_HXX //autogen
#include <svtools/rectitem.hxx>
#endif
#ifndef _SVDOOLE2_HXX //autogen
#include <bf_svx/svdoole2.hxx>
#endif
#ifndef _SB_SBSTAR_HXX //autogen
#include <basic/sbstar.hxx>
#endif

#include <bf_svx/f3dchild.hxx>

#include "app.hrc"
#include "glob.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"

#include "fuslshow.hxx"
#include "sdwindow.hxx"
#include "sdresid.hxx"
#include "drawview.hxx"
#include "drawdoc.hxx"
#include "drviewsh.hxx"
#include "docshell.hxx"
namespace binfilter {

#ifndef SO2_DECL_SVINPLACEOBJECT_DEFINED
#define SO2_DECL_SVINPLACEOBJECT_DEFINED
SO2_DECL_REF(SvInPlaceObject)
#endif

/*************************************************************************
|*
|* SfxRequests fuer Controller bearbeiten
|*
\************************************************************************/

/*N*/ void  SdDrawViewShell::ExecCtrl(SfxRequest& rReq)
/*N*/ {
/*N*/ 	// waehrend einer Diashow wird nichts ausser dem Seitenwechsel und dem
/*N*/ 	// Sprung zur Bookmark ausgefuehrt!
/*N*/ 	if (pFuActual &&
/*N*/ 		pFuActual->GetSlotID() == SID_PRESENTATION &&
/*N*/ 		rReq.GetSlot() != SID_SWITCHPAGE &&
/*N*/ 		rReq.GetSlot() != SID_JUMPTOMARK)
/*N*/ 		return;
/*N*/ 
/*N*/ 	CheckLineTo (rReq);
/*N*/ 
/*N*/     // End text edit mode for some requests.
/*N*/ 	USHORT nSlot = rReq.GetSlot();
/*N*/     switch (nSlot)
/*N*/     {
/*N*/ 		case SID_OUTPUT_QUALITY_COLOR:
/*N*/ 		case SID_OUTPUT_QUALITY_GRAYSCALE:
/*N*/ 		case SID_OUTPUT_QUALITY_BLACKWHITE:
/*N*/ 		case SID_OUTPUT_QUALITY_CONTRAST:
/*N*/ 		case SID_PREVIEW_QUALITY_COLOR:
/*N*/ 		case SID_PREVIEW_QUALITY_GRAYSCALE:
/*N*/ 		case SID_PREVIEW_QUALITY_BLACKWHITE:
/*N*/ 		case SID_PREVIEW_QUALITY_CONTRAST:
/*N*/             // Do nothing.
/*N*/             break;
/*N*/         default:
/*N*/             if ( pDrView->IsTextEdit() )
/*N*/             {
/*?*/                 pDrView->EndTextEdit();
/*N*/             }
/*N*/     }
/*N*/ 
/*N*/     //	USHORT nSlot = rReq.GetSlot();
/*N*/ 	switch (nSlot)
/*N*/ 	{
/*N*/ 		case SID_SWITCHPAGE:  // BASIC
/*N*/ 		{
/*N*/ 			BOOL bWasBasic = FALSE;
/*N*/ 
/*N*/ 			// Seitenwechsel in der Diashow abspielen
/*N*/ 			if (pFuSlideShow && rReq.GetArgs())
/*N*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SFX_REQUEST_ARG(rReq, pWhatPage, SfxUInt32Item, ID_VAL_WHATPAGE, FALSE);
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*N*/ 				const SfxItemSet *pArgs = rReq.GetArgs ();
/*N*/ 				USHORT nSelectedPage;
/*N*/ 
/*N*/ 				if (! pArgs)
/*N*/ 				{
/*N*/ 					nSelectedPage = aTabControl.GetCurPageId() - 1;
/*N*/ 				}
/*N*/ 				else if (pArgs->Count () == 2)
/*N*/ 				{
/*?*/ 					SFX_REQUEST_ARG (rReq, pWhatPage, SfxUInt32Item, ID_VAL_WHATPAGE, FALSE);
/*?*/ 					SFX_REQUEST_ARG (rReq, pWhatKind, SfxUInt32Item, ID_VAL_WHATKIND, FALSE);
/*?*/ 
/*?*/ 					if (! CHECK_RANGE (PK_STANDARD, pWhatKind->GetValue (), PK_HANDOUT))
/*?*/ 					{
/*?*/ 						StarBASIC::FatalError (SbERR_BAD_PROP_VALUE);
/*?*/ 						rReq.Ignore ();
/*?*/ 						break;
/*?*/ 					}
/*?*/ 					else if (eEditMode != EM_MASTERPAGE)
/*?*/ 					{
/*?*/ 						if (! CHECK_RANGE (0, pWhatPage->GetValue (),
/*?*/ 							pDoc->GetSdPageCount ((PageKind) pWhatKind->GetValue ())))
/*?*/ 						{
/*?*/ 							StarBASIC::FatalError (SbERR_BAD_PROP_VALUE);
/*?*/ 							rReq.Ignore ();
/*?*/ 							break;
/*?*/ 						}
/*?*/ 
/*?*/ 						nSelectedPage = (short) pWhatPage->GetValue ();
/*?*/ 						ePageKind	  = (PageKind) pWhatKind->GetValue ();
/*?*/ 						bWasBasic	  = TRUE;
/*?*/ 					}
/*?*/ 				}
/*N*/ 				else
/*N*/ 				{
/*N*/ 					StarBASIC::FatalError (SbERR_WRONG_ARGS);
/*N*/ 					rReq.Ignore ();
/*N*/ 					break;
/*N*/ 				}
/*N*/ 

/*N*/ 				if( GetDocSh() && (GetDocSh()->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED))
/*?*/ 					GetDocSh()->SetModified();
/*N*/ 
/*N*/ 				SwitchPage(nSelectedPage);
/*N*/ 
/*N*/ 				if (pFuActual && pFuActual->GetSlotID() == SID_BEZIER_EDIT)
/*?*/ 					GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON);

/*N*/ 				Invalidate();
/*N*/ 				InvalidateWindows();
/*N*/ 				rReq.Done ();
/*N*/ 			}
/*N*/ 			break;
/*N*/ 		}

/*N*/ 		case SID_SWITCHLAYER:  // BASIC
/*N*/ 		{
/*?*/ 			const SfxItemSet *pArgs = rReq.GetArgs ();
/*?*/ 			USHORT nCurPage = aLayerTab.GetCurPageId ();
/*?*/ 
/*?*/ 			if( pArgs && pArgs->Count () == 1)
/*?*/ 			{
/*?*/ 				SFX_REQUEST_ARG (rReq, pWhatLayer, SfxUInt32Item, ID_VAL_WHATLAYER, FALSE);
/*?*/ 				if( pWhatLayer )
/*?*/ 					nCurPage = (short) pWhatLayer->GetValue ();
/*?*/ 			}
/*?*/ 
/*?*/ 			pDrView->SetActiveLayer( aLayerTab.GetPageText(nCurPage) );
/*?*/ 			Invalidate();
/*?*/ 			rReq.Done ();
/*?*/ 
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SID_PAGEMODE:	// BASIC
/*?*/ 		{
/*?*/ 
/*?*/ 			const SfxItemSet *pArgs = rReq.GetArgs ();
/*?*/ 
/*?*/ 			if ( pArgs && pArgs->Count () == 2)
/*?*/ 			{
/*?*/ 				SFX_REQUEST_ARG (rReq, pIsActive, SfxBoolItem, ID_VAL_ISACTIVE, FALSE);
/*?*/ 				SFX_REQUEST_ARG (rReq, pWhatKind, SfxUInt32Item, ID_VAL_WHATKIND, FALSE);
/*?*/ 
/*?*/ 				if (CHECK_RANGE (PK_STANDARD, pWhatKind->GetValue (), PK_HANDOUT))
/*?*/ 				{
/*?*/ 					bLayerMode = pIsActive->GetValue ();
/*?*/ 					ePageKind = (PageKind) pWhatKind->GetValue ();
/*?*/ 				}
/*?*/ 			}
/*?*/ 
/*?*/ 			// Default-Layer der Page einschalten
/*?*/ 			pDrView->SetActiveLayer( String( SdResId(STR_LAYER_LAYOUT) ) );
/*?*/ 
/*?*/ 			ChangeEditMode(EM_PAGE, bLayerMode);
/*?*/ 
/*?*/ 			Invalidate();
/*?*/ 			rReq.Done ();
/*?*/ 
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SID_LAYERMODE:  // BASIC
/*?*/ 		{
/*?*/ 			const SfxItemSet *pArgs = rReq.GetArgs ();
/*?*/ 
/*?*/ 			if ( pArgs && pArgs->Count () == 2)
/*?*/ 			{
/*?*/ 				SFX_REQUEST_ARG (rReq, pWhatLayerMode, SfxBoolItem, ID_VAL_ISACTIVE, FALSE);
/*?*/ 				SFX_REQUEST_ARG (rReq, pWhatLayer, SfxUInt32Item, ID_VAL_WHATLAYER, FALSE);
/*?*/ 
/*?*/ 				if (CHECK_RANGE (EM_PAGE, pWhatLayer->GetValue (), EM_MASTERPAGE))
/*?*/ 				{
/*?*/ 					bLayerMode = pWhatLayerMode->GetValue ();
/*?*/ 					eEditMode = (EditMode) pWhatLayer->GetValue ();
/*?*/ 				}
/*?*/ 			}
/*?*/ 
/*?*/ 			ChangeEditMode(eEditMode, !bLayerMode);
/*?*/ 
/*?*/ 			Invalidate();
/*?*/ 			rReq.Done ();
/*?*/ 
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SID_OBJECTRESIZE:
/*?*/ 		{
			/******************************************************************
			* Der Server moechte die Clientgrosse verandern
 			******************************************************************/
/*?*/ 			SfxInPlaceClient* pIPClient = GetIPClient();
/*?*/ 
/*?*/ 			if ( pIPClient && pIPClient->IsInPlaceActive() )
/*?*/ 			{
/*?*/ 				const SfxRectangleItem& rRect =
/*?*/ 					(SfxRectangleItem&)rReq.GetArgs()->Get(SID_OBJECTRESIZE);
/*?*/ 				Rectangle aRect( pWindow->PixelToLogic( rRect.GetValue() ) );
/*?*/ 
/*?*/ 				if ( pDrView->HasMarkedObj() )
/*?*/ 				{
/*?*/ 					const SdrMarkList& rMarkList = pDrView->GetMarkList();
/*?*/ 
/*?*/ 					if (rMarkList.GetMarkCount() == 1)
/*?*/ 					{
/*?*/ 						SdrMark* pMark = rMarkList.GetMark(0);
/*?*/ 						SdrObject* pObj = pMark->GetObj();
/*?*/ 
/*?*/ 						UINT16 nSdrObjKind = pObj->GetObjIdentifier();
/*?*/ 
/*?*/ 						if (pObj->GetObjInventor() == SdrInventor &&
/*?*/ 							pObj->GetObjIdentifier() == OBJ_OLE2)
/*?*/ 						{
/*?*/ 							SvInPlaceObjectRef aIPObj =
/*?*/ 							( (SdrOle2Obj*) pObj)->GetObjRef();
/*?*/ 
/*?*/ 							if ( aIPObj.Is() )
/*?*/ 							{
/*?*/ 								pObj->SetLogicRect(aRect);
/*?*/ 							}
/*?*/ 						}
/*?*/ 					}
/*?*/ 				}
/*?*/ 			}
/*?*/ 			rReq.Ignore ();
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SID_RELOAD:
/*?*/ 		{
/*?*/ 			// #83951#
/*?*/ 			USHORT nId = Svx3DChildWindow::GetChildWindowId();
/*?*/ 			SfxChildWindow* pWindow = GetViewFrame()->GetChildWindow(nId);
/*?*/ 			if(pWindow)
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 Svx3DWin* p3DWin = (Svx3DWin*)(pWindow->GetWindow());
/*?*/ 			}
/*?*/ 
/*?*/ 			// DER SLOT KANN IN DEN SFX VERSCHOBEN WERDEN
/*?*/ 			SFX_REQUEST_ARG(rReq, pForceReloadItem, SfxBoolItem, SID_NOCACHE, FALSE);
/*?*/ 			// Normale Weiterleitung an ViewFrame zur Ausfuehrung
/*?*/ 			GetViewFrame()->ExecuteSlot(rReq);
/*?*/ 
/*?*/ 			// Muss sofort beendet werden
/*?*/ 			return;
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_JUMPTOMARK:
/*?*/ 		{
/*?*/ 			if( rReq.GetArgs() )
/*?*/ 			{
/*?*/ 				SFX_REQUEST_ARG(rReq, pBookmark, SfxStringItem, SID_JUMPTOMARK, FALSE);
/*?*/ 
/*?*/ 				UniString sBookmark( INetURLObject::decode( pBookmark->GetValue(), '%', INetURLObject::DECODE_WITH_CHARSET ) );
/*?*/ 				if( sBookmark.Search( sal_Unicode('#') ) == 0 )
/*?*/ 					sBookmark = sBookmark.Copy( 1 );
/*?*/ 
/*?*/ 				if (pBookmark)
/*?*/ 				{
/*?*/ 					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if (pFuSlideShow)
/*?*/ 				}
/*?*/ 			}
/*?*/ 			rReq.Done();
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SID_OUTPUT_QUALITY_COLOR:
/*?*/ 		case SID_OUTPUT_QUALITY_GRAYSCALE:
/*?*/ 		case SID_OUTPUT_QUALITY_BLACKWHITE:
/*?*/ 		case SID_OUTPUT_QUALITY_CONTRAST:
/*?*/ 
/*?*/ 		case SID_PREVIEW_QUALITY_COLOR:
/*?*/ 		case SID_PREVIEW_QUALITY_GRAYSCALE:
/*?*/ 		case SID_PREVIEW_QUALITY_BLACKWHITE:
/*?*/ 		case SID_PREVIEW_QUALITY_CONTRAST:
/*?*/ 		{
/*?*/             DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ExecReq( rReq );
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SID_MAIL_SCROLLBODY_PAGEDOWN:
/*?*/ 		{
/*?*/             DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ExecReq( rReq );
/*?*/ 			break;
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_ATTR_YEAR2000:
/*?*/ 		{
/*?*/ 			FmFormShell* pShell = (FmFormShell*) aShellTable.Get(RID_FORMLAYER_TOOLBOX);
/*?*/ 			if( pShell )
/*?*/ 			{
/*?*/ 				const SfxPoolItem* pItem;
/*?*/ 				if (rReq.GetArgs()->GetItemState(SID_ATTR_YEAR2000, TRUE, &pItem) == SFX_ITEM_SET)
/*?*/ 					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pShell->SetY2KState( ( (const SfxUInt16Item*) pItem )->GetValue() );
/*?*/ 			}
/*?*/ 
/*?*/ 			rReq.Done();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_OPT_LOCALE_CHANGED:
/*?*/ 		{
/*?*/ 			pWindow->Invalidate();
/*?*/ 			UpdatePreview( pActualPage );
/*?*/ 			rReq.Done();
/*?*/ 		}
/*?*/ 
/*N*/ 		default:
/*N*/ 		break;
/*N*/ 	}
/*N*/ }

}
