/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviews1.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:41:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif
#ifndef _SVDPAGV_HXX //autogen
#include <bf_svx/svdpagv.hxx>
#endif
#ifndef _SVDOOLE2_HXX //autogen
#include <bf_svx/svdoole2.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _SVX_FMSHELL_HXX //autogen
#include <bf_svx/fmshell.hxx>
#endif

#pragma hdrstop


#ifdef STARIMAGE_AVAILABLE
#endif

// #define ITEMID_SIZE             0

#include "glob.hrc"
#include "app.hrc"
#include "res_bmp.hrc"
#include "strings.hrc"
#include "helpids.h"

#include "sdpage.hxx"
#include "frmview.hxx"
#include "sdwindow.hxx"
#include "drawview.hxx"
#include "drawdoc.hxx"
#include "docshell.hxx"
#include "drviewsh.hxx"
#include "sdruler.hxx"
#include "sdclient.hxx"
#include "prevchld.hxx"
#include "fuslshow.hxx"
#include "animobjs.hxx"
#include "SdUnoDrawView.hxx"
namespace binfilter {

#ifndef SO2_DECL_SVINPLACEOBJECT_DEFINED
#define SO2_DECL_SVINPLACEOBJECT_DEFINED
SO2_DECL_REF(SvInPlaceObject)
#endif
#ifndef SO2_DECL_SVSTORAGE_DEFINED
#define SO2_DECL_SVSTORAGE_DEFINED
SO2_DECL_REF(SvStorage)
#endif

#ifdef WNT
#pragma optimize ( "", off )
#endif

/*************************************************************************
|*
|* Activate(), beim ersten Aufruf wird eine Shell fuer den Object Bar erzeugt
|*
\************************************************************************/




/*************************************************************************
|*
|* Deactivate()
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::Deactivate(BOOL bIsMDIActivate)
/*N*/ {
/*N*/ 	SdViewShell::Deactivate(bIsMDIActivate);
/*N*/ }

/*************************************************************************
|*
|* Wird gerufen, wenn sich der Selektionszustand der View aendert
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::SelectionHasChanged()
/*N*/ {
/*N*/ 	// Um die Performance zu steigern wird jetzt die komplette
/*N*/ 	// Shell invalidiert statt alle Slots einzeln
/*N*/ 	Invalidate();
/*N*/ 
/*N*/ 	// Damit das Effekte-Window auch einen aktuellen Status bekommt
/*N*/ 	UpdateEffectWindow();
/*N*/ 
/*N*/ 	//Update3DWindow(); // 3D-Controller
/*N*/ 	SfxBoolItem aItem( SID_3D_STATE, TRUE );
/*N*/ 	GetViewFrame()->GetDispatcher()->Execute(
/*N*/ 		SID_3D_STATE, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
/*N*/ 
/*N*/ 	SdrOle2Obj* pOleObj = NULL;
/*N*/ 	SdrGrafObj* pGrafObj = NULL;
/*N*/ 
/*N*/ 	if ( pDrView->HasMarkedObj() )
/*N*/ 	{
/*?*/ 		const SdrMarkList& rMarkList = pDrView->GetMarkList();
/*?*/ 
/*?*/ 		if (rMarkList.GetMarkCount() == 1)
/*?*/ 		{
/*?*/ 			SdrMark* pMark = rMarkList.GetMark(0);
/*?*/ 			SdrObject* pObj = pMark->GetObj();
/*?*/ 
/*?*/ 			UINT32 nInv = pObj->GetObjInventor();
/*?*/ 			UINT16 nSdrObjKind = pObj->GetObjIdentifier();
/*?*/ 
/*?*/ 			if (nInv = SdrInventor && nSdrObjKind == OBJ_OLE2)
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pOleObj = (SdrOle2Obj*) pObj;
/*?*/ 			}
/*?*/ 			else if (nSdrObjKind == OBJ_GRAF)
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pGrafObj = (SdrGrafObj*) pObj;
/*?*/ 			}
/*?*/ 		}
/*?*/ 	}
/*N*/ 
/*N*/ 	SdClient* pIPClient = (SdClient*) GetIPClient();
/*N*/ 
/*N*/ 	if ( pIPClient && pIPClient->IsInPlaceActive() )
/*N*/ 	{
		/**********************************************************************
		* Ggf. OLE-Objekt beruecksichtigen und deaktivieren
		**********************************************************************/
/*?*/ 
/*?*/ 		// if we have no ole object marked and have an inplace active ipc client
/*?*/ 		// this means we recently deselected an inplace active ole object so
/*?*/ 		// we need to deselect it now
/*?*/ 		if (!pOleObj)
/*?*/ 		{
/*?*/ 			pIPClient->GetProtocol().Reset2Open();
/*?*/ 
/*?*/ 			SFX_APP()->SetViewFrame( GetViewFrame() );
/*?*/ 			SetVerbs(0);
/*?*/ 			pDrView->ShowMarkHdl(NULL);
/*?*/ 		}
/*?*/ 		else
/*?*/ 		{
/*?*/ 			SvInPlaceObjectRef aIPObj = pOleObj->GetObjRef();
/*?*/ 
/*?*/ 			if ( aIPObj.Is() )
/*?*/ 			{
/*?*/ 				SetVerbs( &aIPObj->GetVerbList() );
/*?*/ 			}
/*?*/ 			else
/*?*/ 			{
/*?*/ 				SetVerbs(NULL);
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*?*/ #ifdef STARIMAGE_AVAILABLE
/*?*/ 		if ( pGrafObj && pGrafObj->GetGraphicType() == GRAPHIC_BITMAP && SFX_APP()->HasFeature(SFX_FEATURE_SIMAGE))
/*?*/ 		{
/*?*/ 			SvVerb aVerb( 0, String( SdResId(STR_EDIT_OBJ) ) );
/*?*/ 			SvVerbList aVerbList;
/*?*/ 			aVerbList.Append( aVerb );
/*?*/ 			SetVerbs( &aVerbList );
/*?*/ 		}
/*?*/ 		else
/*?*/ #endif
/*N*/ 		if ( pOleObj )
/*N*/ 		{
/*?*/ 			SvInPlaceObjectRef aIPObj = pOleObj->GetObjRef();
/*?*/ 
/*?*/ 			if ( aIPObj.Is() )
/*?*/ 			{
/*?*/ 				SetVerbs( &aIPObj->GetVerbList() );
/*?*/ 			}
/*?*/ 			else
/*?*/ 			{
/*?*/ 				SetVerbs(NULL);
/*?*/ 			}
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			SetVerbs(NULL);
/*N*/ 		}
/*N*/ 	}

/*N*/ 	if( pFuActual )
/*?*/ 	{
/*?*/ 		pFuActual->SelectionHasChanged();
/*?*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		USHORT nObjBarId;
/*N*/ 
/*N*/ 		if (pView->GetContext() == SDRCONTEXT_POINTEDIT)
/*N*/ 			nObjBarId = RID_BEZIER_TOOLBOX;
/*N*/ 		else if (pView->GetContext() == SDRCONTEXT_GRAPHIC)
/*N*/ 			nObjBarId = RID_DRAW_GRAF_TOOLBOX;
/*N*/ 		else if (pView->GetContext() == SDRCONTEXT_TEXTEDIT)
/*N*/ 			nObjBarId = RID_DRAW_TEXT_TOOLBOX;	// #96124# Keep text bar when in textedit
/*N*/ 		else
/*N*/ 			nObjBarId = RID_DRAW_OBJ_TOOLBOX;
/*N*/ 
/*N*/ 		SwitchObjectBar(nObjBarId);
/*N*/ 	}
/*N*/ 
/*N*/     // #96124# Invalidate for every subshell
/*N*/     SfxShell* pShell = (SfxShell*) aShellTable.Get( GetObjectBar() );
/*N*/     if( pShell )
/*N*/         pShell->Invalidate();
/*N*/ 
/*N*/ 	if( SFX_APP()->GetHelpPI() )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 SetHelpIdBySelection();

/*N*/     pDrView->UpdateSelectionClipboard( FALSE );

/*N*/ 	if( pController )
/*?*/ 		pController->fireSelectionChangeListener();
/*N*/ }


/*************************************************************************
|*
|* Zoomfaktor setzen
|*
\************************************************************************/


/*************************************************************************
|*
|* Zoomrechteck fuer aktives Fenster einstellen
|*
\************************************************************************/


/*************************************************************************
|*
|* Modus-Umschaltung (Draw, Slide, Outline)
|*
\************************************************************************/

IMPL_LINK( SdDrawViewShell, TabModeBtnHdl, Button *, pButton )
{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( !((ImageButton*) pButton)->IsChecked() ||
	return 0;
}

/*************************************************************************
|*
|* PrepareClose, ggfs. Texteingabe beenden, damit andere Viewshells ein
|* aktualisiertes Textobjekt vorfinden
|*
\************************************************************************/

/*N*/ USHORT SdDrawViewShell::PrepareClose( BOOL bUI, BOOL bForBrowsing )
/*N*/ {
/*N*/ 	if ( SdViewShell::PrepareClose(bUI, bForBrowsing) != TRUE )
/*N*/ 		return FALSE;
/*N*/ 
/*N*/ 	SfxChildWindow* pPreviewChild = GetViewFrame()->GetChildWindow( SdPreviewChildWindow::GetChildWindowId() );
/*N*/ 	BOOL			bRet = TRUE;
/*N*/ 
/*N*/ 	if( pFuSlideShow )
/*?*/ 	{
/*?*/ 		pFuSlideShow->Terminate();
/*?*/ 		bRet = FALSE;
/*?*/ 	}
/*N*/ 
/*N*/ 	if( pPreviewChild && pPreviewChild->GetWindow() )
/*?*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SdPreviewWin*	pPreviewWin = (SdPreviewWin*) pPreviewChild->GetWindow();
/*?*/ 	}

/*N*/ 	if( bRet && pFuActual )
/*N*/ 	{
/*N*/ 		USHORT nID = pFuActual->GetSlotID();
/*N*/ 		if (nID == SID_TEXTEDIT || nID == SID_ATTR_CHAR)
/*?*/ 		{
/*?*/ 			pDrView->EndTextEdit();
/*?*/ 		}
/*N*/ 	}
/*N*/ 	else if( !bRet )
/*?*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 aCloseTimer.SetTimeoutHdl( LINK( this, SdDrawViewShell, CloseHdl ) );
/*?*/ 	}
/*N*/ 
/*N*/ 	return bRet;
/*N*/ }

/*************************************************************************
|*
|* Status (Enabled/Disabled) von Menue-SfxSlots setzen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::ChangeEditMode(EditMode eEMode, BOOL bLMode)
/*N*/ {
/*N*/ 	if (eEditMode != eEMode || bLayerMode != bLMode)
/*N*/ 	{
/*N*/         USHORT nActualPageNum = 0;
/*N*/ 
/*N*/ 		if( pController )
/*N*/ 		{
/*N*/ 			pController->fireChangeEditMode( eEMode == EM_MASTERPAGE );
/*N*/ 			pController->fireChangeLayerMode( bLMode );
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( pDrView->IsTextEdit() )
/*N*/ 		{
/*?*/ 			pDrView->EndTextEdit();
/*?*/ 		}
/*?*/ 
/*N*/ 		aLayerTab.EndEditMode();
/*N*/ 		aTabControl.EndEditMode();
/*N*/ 
/*N*/ 		if (ePageKind == PK_HANDOUT)
/*N*/ 		{
/*N*/ 			// Bei Handzetteln nur MasterPage zulassen
/*N*/ 			eEMode = EM_MASTERPAGE;
/*N*/ 		}
/*N*/ 
/*N*/ 		eEditMode = eEMode;
/*N*/ 		bLayerMode = bLMode;
/*N*/ 
/*N*/ 		if (eEditMode == EM_PAGE)
/*N*/ 		{
			/******************************************************************
			* PAGEMODE
			******************************************************************/
            // Emulate radio button behaviour.  Order of checking buttons on
            // or off is important for accessibility.
/*N*/ 			aMasterPageBtn.Check(FALSE);
/*N*/ 			aPageBtn.Check(TRUE);
/*N*/ 
/*N*/ 			aTabControl.Clear();
/*N*/ 
/*N*/ 			SdPage* pPage;
/*N*/ 			String aPageName;
/*N*/ 			USHORT nPageCnt = pDoc->GetSdPageCount(ePageKind);
/*N*/ 
/*N*/ 			for (USHORT i = 0; i < nPageCnt; i++)
/*N*/ 			{
/*N*/ 				pPage = pDoc->GetSdPage(i, ePageKind);
/*N*/ 				aPageName = pPage->GetName();
/*N*/ 				aTabControl.InsertPage(i + 1, aPageName);
/*N*/ 
/*N*/ 				if ( pPage->IsSelected() && nActualPageNum == 0 )
/*N*/ 				{
/*N*/ 					nActualPageNum = i;
/*N*/ 				}
/*N*/ 			}
/*N*/ 
/*N*/             aTabControl.SetCurPageId(nActualPageNum + 1);
/*N*/ 
/*N*/ 			SwitchPage(nActualPageNum);
/*N*/ 
/*N*/ 			SfxBoolItem aItem(SID_PREVIEW_WIN, pFrameView->IsShowPreviewInPageMode() != 0 );
/*N*/ 			GetViewFrame()->GetDispatcher()->Execute(
/*N*/ 				SID_PREVIEW_WIN, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
			/******************************************************************
			* MASTERPAGE
			******************************************************************/
/*?*/ 			GetViewFrame()->SetChildWindow(SdAnimationChildWindow::GetChildWindowId(), FALSE );
/*?*/ 
            // Emulate radio button behaviour.  Order of checking buttons on
            // or off is important for accessibility.
/*?*/ 			aPageBtn.Check(FALSE);
/*?*/ 			aMasterPageBtn.Check(TRUE);
/*?*/ 
/*?*/ 			if (!pActualPage)
/*?*/ 			{
/*?*/ 				// Sofern es keine pActualPage gibt, wird die erste genommen
/*?*/ 				pActualPage = pDoc->GetSdPage(0, ePageKind);
/*?*/ 			}
/*?*/ 
/*?*/ 			SdPage* pPreviewPage = pActualPage;
/*?*/ 
/*?*/ 			aTabControl.Clear();
/*?*/ 			USHORT nActualMasterPageNum = 0;
/*?*/ 			USHORT nMasterPageCnt = pDoc->GetMasterSdPageCount(ePageKind);
/*?*/ 
/*?*/ 			for (USHORT i = 0; i < nMasterPageCnt; i++)
/*?*/ 			{
/*?*/ 				SdPage* pMaster = pDoc->GetMasterSdPage(i, ePageKind);
/*?*/ 				String aLayoutName(pMaster->GetLayoutName());
/*?*/ 				aLayoutName.Erase(aLayoutName.SearchAscii(SD_LT_SEPARATOR));
/*?*/ 
/*?*/ 				aTabControl.InsertPage(i + 1, aLayoutName);
/*?*/ 
/*?*/ 				if (pActualPage->GetMasterPage(0) == pMaster)
/*?*/ 				{
/*?*/ 					nActualMasterPageNum = i;
/*?*/ 				}
/*?*/ 			}
/*?*/ 
/*?*/ 			aTabControl.SetCurPageId(nActualMasterPageNum + 1);
/*?*/ 			SwitchPage(nActualMasterPageNum);
/*?*/ 
/*?*/ 			SfxBoolItem aItem(SID_PREVIEW_WIN, pFrameView->IsShowPreviewInMasterPageMode() != 0 );
/*?*/ 			GetViewFrame()->GetDispatcher()->Execute(
/*?*/ 				SID_PREVIEW_WIN, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
/*N*/  		}

/*N*/ 		if (bLayerMode)
/*N*/ 		{
			/******************************************************************
			* LAYER ein
			******************************************************************/
/*N*/  			aTabControl.Hide();
/*N*/  			aLayerTab.Show();
/*N*/  			aLayerBtn.Check(TRUE);
/*N*/  		}
/*N*/  		else
/*N*/ 		{
			/******************************************************************
			* LAYER aus
			******************************************************************/
/*N*/ 			aTabControl.Show();
/*N*/ 			aLayerTab.Hide();
/*N*/ 			aLayerBtn.Check(FALSE);
            // Set the tab control only for draw pages.  For master page
            // this has been done already above.
/*N*/             if (eEditMode == EM_PAGE)
/*N*/                 aTabControl.SetCurPageId (nActualPageNum + 1);
/*N*/ 		}
/*N*/ 
/*N*/ 		ResetActualLayer();
/*N*/ 
/*N*/ 		Invalidate( SID_PAGEMODE );
/*N*/ 		Invalidate( SID_LAYERMODE );
/*N*/ 		Invalidate( SID_MASTERPAGE );
/*N*/ 		Invalidate( SID_SLIDE_MASTERPAGE );
/*N*/ 		Invalidate( SID_TITLE_MASTERPAGE );
/*N*/ 		Invalidate( SID_NOTES_MASTERPAGE );
/*N*/ 		Invalidate( SID_HANDOUT_MASTERPAGE );
/*N*/ 		Invalidate(SID_PREVIEW_WIN);
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Groesse des TabControls und der ModeButtons zurueckgeben
|*
\************************************************************************/



/*************************************************************************
|*
|* Horizontales Lineal erzeugen
|*
\************************************************************************/


/*************************************************************************
|*
|* Vertikales Lineal erzeugen
|*
\************************************************************************/


/*************************************************************************
|*
|* Horizontales Lineal aktualisieren
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::UpdateHRuler()
/*N*/ {
/*N*/ 	Invalidate( SID_ATTR_LONG_LRSPACE );
/*N*/ 	Invalidate( SID_RULER_PAGE_POS );
/*N*/ 	Invalidate( SID_RULER_OBJECT );
/*N*/ 	Invalidate( SID_RULER_TEXT_RIGHT_TO_LEFT );
/*N*/ 
/*N*/ 	for (USHORT nIndex=0; nIndex<MAX_HSPLIT_CNT; nIndex++)
/*N*/ 	{
/*N*/ 		if (pHRulerArray[nIndex])
/*N*/ 		{
/*?*/ 			pHRulerArray[nIndex]->ForceUpdate();
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Vertikales Lineal aktualisieren
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::UpdateVRuler()
/*N*/ {
/*N*/ 	Invalidate( SID_ATTR_LONG_LRSPACE );
/*N*/ 	Invalidate( SID_RULER_PAGE_POS );
/*N*/ 	Invalidate( SID_RULER_OBJECT );
/*N*/ 
/*N*/ 	for (USHORT nIndex=0; nIndex<MAX_VSPLIT_CNT; nIndex++)
/*N*/ 	{
/*N*/ 		if (pVRulerArray[nIndex])
/*N*/ 		{
/*N*/ 			pVRulerArray[nIndex]->ForceUpdate();
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Metrik setzen
|*
\************************************************************************/


/*************************************************************************
|*
|* TabControl nach Splitteraenderung aktualisieren
|*
\************************************************************************/

IMPL_LINK( SdDrawViewShell, TabSplitHdl, TabBar *, pTab )
{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 long nMax = aHSplit.GetPosPixel().X() - aTabControl.GetPosPixel().X();
	return 0;
}

/*************************************************************************
|*
|* neue aktuelle Seite auswaehlen, falls sich die Seitenfolge geaendert
|* hat (z. B. durch Undo)
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::ResetActualPage()
/*N*/ {
/*N*/ 	USHORT nCurrentPage = aTabControl.GetCurPageId() - 1;
/*N*/ 	USHORT nPageCount	= (eEditMode == EM_PAGE)?pDoc->GetSdPageCount(ePageKind):pDoc->GetMasterSdPageCount(ePageKind);
/*N*/ 	if (nPageCount > 0)
/*N*/ 		nCurrentPage = Min((USHORT)(nPageCount - 1), nCurrentPage);
/*N*/ 	else
/*N*/ 		nCurrentPage = 0;
/*N*/ 
/*N*/ 	if (eEditMode == EM_PAGE)
/*N*/ 	{
/*N*/ 
/*N*/ 		// Update fuer TabControl
/*N*/ 		aTabControl.Clear();
/*N*/ 
/*N*/ 		SdPage* pPage = NULL;
/*N*/ 		String aPageName;
/*N*/ 
/*N*/ 		for (USHORT i = 0; i < nPageCount; i++)
/*N*/ 		{
/*N*/ 			pPage = pDoc->GetSdPage(i, ePageKind);
/*N*/ 			aPageName = pPage->GetName();
/*N*/ 			aTabControl.InsertPage(i + 1, aPageName);
/*N*/ 
/*N*/ 			// Selektionskennungen der Seiten korrigieren
/*N*/ 			pDoc->SetSelected(pPage, i == nCurrentPage);
/*N*/ 		}
/*N*/ 
/*N*/ 		aTabControl.SetCurPageId(nCurrentPage + 1);
/*N*/ 	}
/*N*/ 	else // EM_MASTERPAGE
/*N*/ 	{
/*?*/ 		SdPage* pActualPage = pDoc->GetMasterSdPage(nCurrentPage, ePageKind);
/*?*/ 		aTabControl.Clear();
/*?*/ 		USHORT nActualMasterPageNum = 0;
/*?*/ 
/*?*/ 		USHORT nMasterPageCnt = pDoc->GetMasterSdPageCount(ePageKind);
/*?*/ 		for (USHORT i = 0; i < nMasterPageCnt; i++)
/*?*/ 		{
/*?*/ 			SdPage* pMaster = pDoc->GetMasterSdPage(i, ePageKind);
/*?*/ 			String aLayoutName(pMaster->GetLayoutName());
/*?*/ 			aLayoutName.Erase(aLayoutName.SearchAscii(SD_LT_SEPARATOR));
/*?*/ 			aTabControl.InsertPage(i + 1, aLayoutName);
/*?*/ 
/*?*/ 			if (pActualPage == pMaster)
/*?*/ 				nActualMasterPageNum = i;
/*?*/ 		}
/*?*/ 
/*?*/ 		aTabControl.SetCurPageId(nActualMasterPageNum + 1);
/*?*/ 		SwitchPage(nActualMasterPageNum);
/*?*/ 	}
/*N*/ 
/*N*/ 	GetViewFrame()->GetDispatcher()->Execute(SID_SWITCHPAGE,
/*N*/ 				SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
/*N*/ }

/*************************************************************************
|*
|* Verb auf OLE-Objekt anwenden
|*
\************************************************************************/




/*************************************************************************
|*
|* OLE-Object aktivieren
|*
\************************************************************************/


/*************************************************************************
|*
|* Auf gewuenschte Seite schalten
|* Der Parameter nSelectedPage bezieht sich auf den aktuellen EditMode
|*
\************************************************************************/

/*N*/ BOOL SdDrawViewShell::SwitchPage(USHORT nSelectedPage)
/*N*/ {
/*N*/ 	BOOL bOK = FALSE;
/*N*/ 
/*N*/ 	if (IsSwitchPageAllowed())
/*N*/ 	{
/*N*/ 		bOK = TRUE;
/*N*/ 
/*N*/ 		BOOL bIsChanged = pDoc->IsChanged();
/*N*/ 
/*N*/ 		if (pActualPage)
/*N*/ 		{
/*N*/  			SdPage* pNewPage = pDoc->GetSdPage(nSelectedPage, ePageKind);
/*N*/  
/*N*/  			if (pActualPage == pNewPage)
/*N*/  			{
/*N*/  				if (eEditMode == EM_MASTERPAGE)
/*N*/  				{
/*?*/ 					pNewPage = (SdPage*) pNewPage->GetMasterPage(0);
/*?*/ 				}
/*N*/  
/*N*/  				SdrPageView* pPV = pDrView->GetPageViewPvNum(0);
/*N*/  
/*N*/  				if (pPV && pNewPage == (SdPage*) pPV->GetPage() &&
/*N*/  					pNewPage->GetName() == aTabControl.GetPageText(nSelectedPage+1))
/*N*/  				{
/*N*/  					// Die Seite wird schon angezeigt
/*N*/  					return(TRUE);
/*N*/  				}
/*N*/  			}
/*N*/ 		}
/*N*/ 
/*N*/ 		pActualPage = NULL;
/*N*/ 
/*N*/ 		if (eEditMode == EM_PAGE)
/*N*/ 		{
/*N*/ 			pActualPage = pDoc->GetSdPage(nSelectedPage, ePageKind);
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*?*/ 			SdPage* pMaster = pDoc->GetMasterSdPage(nSelectedPage, ePageKind);
/*?*/ 
/*?*/ 			// Passt die selektierte Seite zur MasterPage?
/*?*/ 			USHORT nPageCount = pDoc->GetSdPageCount(ePageKind);
/*?*/ 			for (USHORT i = 0; i < nPageCount; i++)
/*?*/ 			{
/*?*/ 				SdPage* pPage = pDoc->GetSdPage(i, ePageKind);
/*?*/ 				if(pPage && pPage->IsSelected() && pPage->GetMasterPage(0) == pMaster)
/*?*/ 				{
/*?*/ 					pActualPage = pPage;
/*?*/ 					break;
/*?*/ 				}
/*?*/ 			}
/*?*/ 
/*?*/ 			if (!pActualPage)
/*?*/ 			{
/*?*/ 				// Die erste Seite nehmen, welche zur MasterPage passt
/*?*/ 				for (USHORT i = 0; i < nPageCount; i++)
/*?*/ 				{
/*?*/ 					SdPage* pPage = pDoc->GetSdPage(i, ePageKind);
/*?*/ 					if(pPage && pPage->GetMasterPage(0) == pMaster)
/*?*/ 					{
/*?*/ 						pActualPage = pPage;
/*?*/ 						break;
/*?*/ 					}
/*?*/ 				}
/*?*/ 			}
/*?*/ 		}

/*N*/ 		for (USHORT i = 0; i < pDoc->GetSdPageCount(ePageKind); i++)
/*N*/ 		{
/*N*/ 			// Alle Seiten deselektieren
/*N*/ 			pDoc->SetSelected( pDoc->GetSdPage(i, ePageKind), FALSE);
/*N*/ 		}
/*N*/ 
/*N*/ 		if (!pActualPage)
/*N*/ 		{
			// Sofern es keine pActualPage gibt, wird die erste genommen
/*?*/ 			pActualPage = pDoc->GetSdPage(0, ePageKind);
		}

		// diese Seite auch selektieren (pActualPage zeigt immer auf Zeichenseite,
		// nie auf eine Masterpage)
/*N*/ 		pDoc->SetSelected(pActualPage, TRUE);
/*N*/ 
/*N*/         if( !pFuSlideShow || ( pFuSlideShow->GetAnimationMode() != ANIMATIONMODE_SHOW ) )
/*N*/         {
    		// VisArea zuziehen, um ggf. Objekte zu deaktivieren
            // !!! only if we are not in presentation mode (#96279) !!!
/*N*/     		DisconnectAllClients();
/*N*/     		VisAreaChanged(Rectangle(Point(), Size(1, 1)));
/*N*/         }
/*N*/ 
/*N*/ 		if( pActualPage )
/*N*/ 			pActualPage->SetAutoLayout( pActualPage->GetAutoLayout() );
/*N*/ 
/*N*/ 		if (eEditMode == EM_PAGE)
/*N*/ 		{
			/**********************************************************************
			* PAGEMODE
			**********************************************************************/
/*N*/ 			pDoc->SetSelected(pActualPage, TRUE);
/*N*/ 
/*N*/ 			SdrPageView* pPageView = pDrView->GetPageViewPvNum(0);
/*N*/ 
/*N*/ 			if (pPageView)
/*N*/ 			{
/*N*/ 				pFrameView->SetVisibleLayers( pPageView->GetVisibleLayers() );
/*N*/ 				pFrameView->SetPrintableLayers( pPageView->GetPrintableLayers() );
/*N*/ 				pFrameView->SetLockedLayers( pPageView->GetLockedLayers() );
/*N*/ 
/*N*/ 				if (ePageKind == PK_NOTES)
/*N*/ 				{
/*?*/ 					pFrameView->SetNotesHelpLines( pPageView->GetHelpLines() );
/*N*/ 				}
/*N*/ 				else if (ePageKind == PK_HANDOUT)
/*N*/ 				{
/*?*/ 					pFrameView->SetHandoutHelpLines( pPageView->GetHelpLines() );
/*N*/ 				}
/*N*/ 				else
/*N*/ 				{
/*N*/ 					pFrameView->SetStandardHelpLines( pPageView->GetHelpLines() );
/*N*/ 				}
/*N*/ 			}
/*N*/ 
/*N*/ 			pDrView->HideAllPages();
/*N*/ 			pDrView->ShowPage(pActualPage, Point(0, 0));
/*N*/ 			if( pController )
/*?*/ 				pController->fireSwitchCurrentPage( pActualPage );
/*N*/ 
/*N*/ 			SdrPageView* pNewPageView = pDrView->GetPageViewPvNum(0);
/*N*/ 
/*N*/ 			if (pNewPageView)
/*N*/ 			{
/*N*/ 				pNewPageView->SetVisibleLayers( pFrameView->GetVisibleLayers() );
/*N*/ 				pNewPageView->SetPrintableLayers( pFrameView->GetPrintableLayers() );
/*N*/ 				pNewPageView->SetLockedLayers( pFrameView->GetLockedLayers() );
/*N*/ 
/*N*/ 				if (ePageKind == PK_NOTES)
/*N*/ 				{
/*N*/ 					pNewPageView->SetHelpLines( pFrameView->GetNotesHelpLines() );
/*N*/ 				}
/*N*/ 				else if (ePageKind == PK_HANDOUT)
/*N*/ 				{
/*N*/ 					pNewPageView->SetHelpLines( pFrameView->GetHandoutHelpLines() );
/*N*/ 				}
/*N*/ 				else
/*N*/ 				{
/*N*/ 					pNewPageView->SetHelpLines( pFrameView->GetStandardHelpLines() );
/*N*/ 				}
/*N*/ 			}
/*N*/ 
/*N*/ 			aTabControl.SetCurPageId(nSelectedPage+1);
/*N*/ 			String aPageName = pActualPage->GetName();
/*N*/ 
/*N*/ 			if (aTabControl.GetPageText(nSelectedPage+1) != aPageName)
/*N*/ 			{
/*?*/ 				aTabControl.SetPageText(nSelectedPage+1, aPageName);
/*?*/ 			}
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
			/**********************************************************************
			* MASTERPAGE
			**********************************************************************/
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SdrPageView* pPageView = pDrView->GetPageViewPvNum(0);
/*N*/ 		}

/*N*/ 		Size aVisSizePixel = pWindow->GetOutputSizePixel();
/*N*/ 		Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0), aVisSizePixel) );
/*N*/ 		VisAreaChanged(aVisAreaWin);
/*N*/ 		pDrView->VisAreaChanged(pWindow);
/*N*/ 
/*N*/ 		// Damit der Navigator (und das Effekte-Window) das mitbekommt (/-men)
/*N*/ 		SfxBindings& rBindings = GetViewFrame()->GetBindings();
/*N*/ 		rBindings.Invalidate(SID_NAVIGATOR_PAGENAME, TRUE, FALSE);
/*N*/ 		rBindings.Invalidate(SID_EFFECT_STATE, TRUE, FALSE);
/*N*/ 		rBindings.Invalidate(SID_STATUS_PAGE, TRUE, FALSE);
/*N*/ 		UpdateSlideChangeWindow();
/*N*/ 		UpdatePreview( pActualPage );
/*N*/ 
/*N*/ 		if (pDrView->GetSlideShow())
/*N*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pDrView->SetAnimationMode(TRUE);
/*?*/ 		}
/*N*/ 
/*N*/ 		pDoc->SetChanged(bIsChanged);
/*N*/ 	}
/*N*/ 
/*N*/ 	return (bOK);
/*N*/ }


/*************************************************************************
|*
|* Pruefen, ob ein Seitenwechsel erlaubt ist
|*
\************************************************************************/

/*N*/ BOOL SdDrawViewShell::IsSwitchPageAllowed() const
/*N*/ {
/*N*/ 	BOOL bOK = TRUE;
/*N*/ 
/*N*/ 	FmFormShell* pShell = (FmFormShell*) aShellTable.Get(RID_FORMLAYER_TOOLBOX);
/*N*/ 
/*N*/ 	if (pShell && !pShell->PrepareClose(FALSE))
/*N*/ 	{
/*N*/ 		bOK = FALSE;
/*N*/ 	}
/*N*/ 
/*N*/ 	return( bOK && !bInEffectAssignment );
/*N*/ }

/*************************************************************************
|*
|* neue aktuelle Seite auswaehlen, falls sich die Seitenfolge geaendert
|* hat (z. B. durch Undo)
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::ResetActualLayer()
/*N*/ {
/*N*/ 	// remember old layer cound and current layer id
/*N*/ 	// this is needed when one layer is renamed to
/*N*/ 	// restore current layer
/*N*/ 	USHORT nOldLayerCnt = aLayerTab.GetPageCount();
/*N*/ 	USHORT nOldLayerId = aLayerTab.GetCurPageId();

	/*************************************************************
	* Update fuer LayerTab
	*************************************************************/
/*N*/ 	aLayerTab.Clear();
/*N*/ 
/*N*/ 	String aName;
/*N*/ 	String aActiveLayer = pDrView->GetActiveLayer();
/*N*/ 	String aBackgroundLayer( SdResId(STR_LAYER_BCKGRND) );
/*N*/ 	String aBackgroundObjLayer( SdResId(STR_LAYER_BCKGRNDOBJ) );
/*N*/ 	String aLayoutLayer( SdResId(STR_LAYER_LAYOUT) );
/*N*/ 	String aControlsLayer( SdResId(STR_LAYER_CONTROLS) );
/*N*/ 	String aMeasureLinesLayer( SdResId(STR_LAYER_MEASURELINES) );
/*N*/ 	USHORT nNewLayer = 0;
/*N*/ 	USHORT nActiveLayer = SDRLAYER_NOTFOUND;
/*N*/ 	SdrLayerAdmin& rLayerAdmin = pDoc->GetLayerAdmin();
/*N*/ 	USHORT nLayerCnt = rLayerAdmin.GetLayerCount();
/*N*/ 
/*N*/ 	for ( USHORT nLayer = 0; nLayer < nLayerCnt; nLayer++ )
/*N*/ 	{
/*N*/ 		aName = rLayerAdmin.GetLayer(nLayer)->GetName();
/*N*/ 
/*N*/ 		if ( aName == aActiveLayer )
/*N*/ 		{
/*N*/ 			nActiveLayer = nLayer;
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( aName != aBackgroundLayer )
/*N*/ 		{
/*N*/ 			if (eEditMode == EM_MASTERPAGE)
/*?*/ 			{
/*?*/ 				// Layer der Page nicht auf MasterPage anzeigen
/*?*/ 				if (aName != aLayoutLayer   &&
/*?*/ 					aName != aControlsLayer &&
/*?*/ 					aName != aMeasureLinesLayer)
/*?*/ 				{
/*?*/ 					aLayerTab.InsertPage(nLayer+1, aName);
/*?*/ 
/*?*/ 					TabBarPageBits nBits = 0;
/*?*/ 					SdrPageView* pPV = pDrView->GetPageViewPvNum(0);
/*?*/ 
/*?*/ 					if (pPV && !pPV->IsLayerVisible(aName))
/*?*/ 					{
/*?*/ 						// Unsichtbare Layer werden anders dargestellt
/*?*/ 						nBits = TPB_SPECIAL;
/*?*/ 					}
/*?*/ 
/*?*/ 					aLayerTab.SetPageBits(nLayer+1, nBits);
/*?*/ 				}
/*?*/ 			}
/*N*/ 			else
/*N*/ 			{
/*N*/ 				// Layer der MasterPage nicht auf Page anzeigen
/*N*/ 				if ( aName != aBackgroundObjLayer )
/*N*/ 				{
/*N*/ 					aLayerTab.InsertPage(nLayer+1, aName);
/*N*/ 
/*N*/ 					TabBarPageBits nBits = 0;
/*N*/ 
/*N*/ 					if (!pDrView->GetPageViewPvNum(0)->IsLayerVisible(aName))
/*N*/ 					{
/*N*/ 						// Unsichtbare Layer werden anders dargestellt
/*N*/ 						nBits = TPB_SPECIAL;
/*N*/ 					}
/*N*/ 
/*N*/ 					aLayerTab.SetPageBits(nLayer+1, nBits);
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}

/*N*/ 	if ( nActiveLayer == SDRLAYER_NOTFOUND )
/*N*/ 	{
/*N*/ 		if( nOldLayerCnt == aLayerTab.GetPageCount() )
/*N*/ 		{
/*N*/ 			nActiveLayer = nOldLayerId - 1;
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			nActiveLayer = ( eEditMode == EM_MASTERPAGE ) ? 2 : 0;
/*N*/ 		}
/*N*/ 
/*N*/ 		pDrView->SetActiveLayer( aLayerTab.GetPageText(nActiveLayer + 1) );
/*N*/ 	}
/*N*/ 
/*N*/ 	aLayerTab.SetCurPageId(nActiveLayer + 1);
/*N*/ 	GetViewFrame()->GetBindings().Invalidate( SID_MODIFYLAYER );
/*N*/ }

/*************************************************************************
|*
|* Verzoegertes Close ausfuehren
|*
\************************************************************************/


/*************************************************************************
|*
|* Setzt die HelpId in Abhaengigkeit von der Selektion
|*
\************************************************************************/


/*************************************************************************
|*
|* AcceptDrop
|*
\************************************************************************/


/*************************************************************************
|*
|* ExecuteDrop
|*
\************************************************************************/


#ifdef WNT
#pragma optimize ( "", on )
#endif
    
}
