/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: docshell.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:25:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SD_DOCSHELL_HXX
#define _SD_DOCSHELL_HXX

#ifndef _SFX_OBJFAC_HXX //autogen
#include <bf_sfx2/docfac.hxx>
#endif
#ifndef _SFX_INTERNO_HXX //autogen
#include <bf_sfx2/interno.hxx>
#endif
#ifndef _SFX_OBJSH_HXX //autogen
#include <bf_sfx2/objsh.hxx>
#endif
#ifndef _SVX_SVXIFACT_HXX //autogen
#include <bf_svx/svxifact.hxx>
#endif
#include <sot/factory.hxx>
#include <so3/factory.hxx>

#ifndef _SD_GLOB_HXX
#include "glob.hxx"
#endif
#ifndef _SDMOD_HXX
#include "sdmod.hxx"
#endif
#ifndef _PRESENTATION_HXX
#include "pres.hxx"
#endif
class SfxStyleSheetBasePool;
class FontList;
namespace binfilter {

#ifndef SO2_DECL_SVSTORAGESTREAM_DEFINED
#define SO2_DECL_SVSTORAGESTREAM_DEFINED
SO2_DECL_REF(SvStorageStream)
#endif

class SfxStatusBarManager;
class SdStyleSheetPool;
class FrameView;
class SdDrawDocument;
class SdViewShell;
class SdView;
class FuPoor;
class SvxItemFactory;
class SdPage;
class SfxPrinter;
struct SdrDocumentStreamInfo;
struct SpellCallbackInfo;
class SvxNameDialog;

// ------------------
// - SdDrawDocShell -
// ------------------

class SdDrawDocShell : public SfxObjectShell, public SfxInPlaceObject
{
protected:
	
    SfxProgress*		   	pProgress;
	SdDrawDocument* 		pDoc;
	SfxUndoManager* 		pUndoManager;
	SfxPrinter* 			pPrinter;
	SdViewShell*			pViewShell;
	FontList*				pFontList;
	FuPoor* 				pFuActual;
	DocumentType            eDocType;
	UINT16					nStyleFamily;
	const USHORT*           pFilterSIDs;    
	USHORT                  nFilterCount;   
	BOOL                    bFilterEnable;  
	BOOL					bUIActive;
	BOOL					bSdDataObj;
	BOOL                    bInDestruction;
	BOOL 					bOwnPrinter;
    BOOL                    mbNewDocument;

	static SfxProgress*		mpSpecialProgress;
	static Link*			mpSpecialProgressHdl;

    void					Construct();

public:
    void                    UpdateRefDevice();
	virtual void	        Deactivate( BOOL bMDI );
	virtual BOOL	        InitNew( SvStorage * );
	virtual BOOL	        Load( SvStorage * );
	virtual void	        HandsOff();
	virtual BOOL	        Save();
	virtual BOOL	        SaveAs( SvStorage * pNewStor );
	virtual BOOL            SaveAsOwnFormat( SfxMedium& rMedium );
	virtual BOOL	        SaveCompleted( SvStorage * pNewStor );
	virtual void	        SetVisArea(const Rectangle& rRect);
	virtual Rectangle       GetVisArea(USHORT nAspect) const;
	virtual SfxUndoManager* GetUndoManager();
	virtual Printer*        GetDocumentPrinter();
	virtual SfxStyleSheetBasePool* GetStyleSheetPool();
	virtual void            FillClass(SvGlobalName* pClassName, ULONG*  pFormat, String* pAppName, String* pFullTypeName, String* pShortTypeName, long nFileFormat = SOFFICE_FILEFORMAT_CURRENT) const;
	virtual void            SetModified( BOOL = TRUE );

public:
	
                            TYPEINFO();
                        	SFX_DECL_INTERFACE(SD_IF_SDDRAWDOCSHELL);
                        	SFX_DECL_OBJECTFACTORY_DLL(SdDrawDocShell, SD_MOD());

                        	SdDrawDocShell(SfxObjectCreateMode eMode = SFX_CREATE_MODE_EMBEDDED, BOOL bSdDataObj=FALSE, DocumentType=DOCUMENT_TYPE_IMPRESS);
                        	SdDrawDocShell(SdDrawDocument* pDoc, SfxObjectCreateMode eMode = SFX_CREATE_MODE_EMBEDDED, BOOL bSdDataObj=FALSE, DocumentType=DOCUMENT_TYPE_IMPRESS);
                        	~SdDrawDocShell();

	SdViewShell*	        GetViewShell() { return pViewShell; }
	FrameView*		        GetFrameView();
	FuPoor* 		        GetActualFunction() const { return pFuActual; }
	
    SdDrawDocument*         GetDoc();
	DocumentType            GetDocumentType() const { return eDocType; }

	SfxPrinter*             GetPrinter(BOOL bCreate);
	void			        SetPrinter(SfxPrinter *pNewPrinter);

	BOOL					IsUIActive() { return bUIActive; }
	BOOL                    IsInDestruction() const { return bInDestruction; }

                            
	void			        Execute( SfxRequest& rReq ){DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 Execute( SfxRequest& rReq );
	void		        	GetState(SfxItemSet&) {DBG_BF_ASSERT(0, "STRIP"); }//STRIP001         GetState(SfxItemSet&);
                        
	void			        Connect(SdViewShell* pViewSh);
	void			        Disconnect(SdViewShell* pViewSh);
	void			        UpdateTablePointers();
                            
                            

    /** checks, if the given name is a valid new name for a slide

        <p>If the name is invalid, an <type>SvxNameDialog</type> pops up that
        queries again for a new name until it is ok or the user chose
        Cancel.</p>

        @param pWin is necessary to pass to the <type>SvxNameDialog</type> in
                    case an invalid name was entered.
        @param rName the new name that is to be set for a slide.  This string
                     may be set to an empty string (see below).

        @return TRUE, if the new name is unique.  Note that if the user entered
                a default name of a not-yet-existing slide (e.g. 'Slide 17'),
                TRUE is returned, but rName is set to an empty string.
     */

	void                    SetSlotFilter(BOOL bEnable = FALSE, USHORT nCount = 0, const USHORT* pSIDs = NULL) { bFilterEnable = bEnable; nFilterCount = nCount; pFilterSIDs = pSIDs; }

	UINT16	                GetStyleFamily() const { return nStyleFamily; }
	void	                SetStyleFamily( UINT16 nSF ) { nStyleFamily = nSF; }

	BOOL                    HasSpecialProgress() const { return ( mpSpecialProgress != NULL && mpSpecialProgressHdl != NULL ); }
	void                    ReleaseSpecialProgress() { mpSpecialProgress = NULL; mpSpecialProgressHdl = NULL; }
	void                    SetSpecialProgress( SfxProgress* pProgress, Link* pLink ) { mpSpecialProgress = pProgress; mpSpecialProgressHdl = pLink; }
	SfxProgress*            GetSpecialProgress() { return( HasSpecialProgress() ? mpSpecialProgress : NULL ); }


    /** checks, if the given name is a valid new name for a slide

        <p>This method does not pop up any dialog (like CheckPageName).</p>

        @param rInOutPageName the new name for a slide that is to be renamed.
                    This string will be set to an empty string if
                    bResetStringIfStandardName is true and the name is of the
                    form of any, possibly not-yet existing, standard slide
                    (e.g. 'Slide 17')

        @param bResetStringIfStandardName if true allows setting rInOutPageName
                    to an empty string, which returns true and implies that the
                    slide will later on get a new standard name (with a free
                    slide number).

        @return true, if the new name is unique.  If bResetStringIfStandardName
                    is true, the return value is also true, if the slide name is
                    a standard name (see above)
     */
    bool                    IsNewPageNameValid( String & rInOutPageName, bool bResetStringIfStandardName = false );


    /** Return the reference device for the current document.  When the
        inherited implementation returns a device then this is passed to the
        caller.  Otherwise the returned value depends on the printer
        independent layout mode and will usually be either a printer or a
        virtual device used for screen rendering.
        @return
            Returns NULL when the current document has no reference device.
    */
    virtual OutputDevice* GetDocumentRefDev (void);

    DECL_LINK( RenameSlideHdl, SvxNameDialog* );

#ifndef SVX_LIGHT
                            // #91457# ExecuteSpellPopup now handled by SdDrawDocShell
#endif
};

#ifndef SV_DECL_SDDRAWDOCSHELL_DEFINED
#define SV_DECL_SDDRAWDOCSHELL_DEFINED
SV_DECL_REF(SdDrawDocShell)
#endif

SV_IMPL_REF (SdDrawDocShell)

} //namespace binfilter
#endif // _SD_DOCSHELL_HXX
