/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_fudraw.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 18:20:26 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop
#ifndef _EEITEM_HXX //autogen
#include <bf_svx/eeitem.hxx>
#endif



#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif

#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif

#ifndef _DATE_HXX
#include <tools/date.hxx>
#endif

#ifndef _TOOLS_TIME_HXX
#include <tools/time.hxx>
#endif

#define ITEMID_FIELD    EE_FEATURE_FIELD
#ifndef _BMPMASK_HXX_ //autogen
#include <bf_svx/bmpmask.hxx>
#endif
#include <bf_svx/svxids.hrc>
#ifndef _E3D_POLYSC3D_HXX //autogen
#include <bf_svx/polysc3d.hxx>
#endif

#include "app.hrc"
#include "glob.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"

#include "viewshel.hxx"
#include "sdwindow.hxx"
#include "docshell.hxx"
#include "drawview.hxx"
#include "fusel.hxx"
namespace binfilter {

using namespace ::com::sun::star;

TYPEINIT1( FuDraw, FuPoor );

/*************************************************************************
|*
|* Base-class for all drawmodul-specific functions
|*
\************************************************************************/

/*N*/ FuDraw::FuDraw(SdViewShell* pViewSh, SdWindow* pWin, SdView* pView,
/*N*/ 			   SdDrawDocument* pDoc, SfxRequest& rReq) :
/*N*/ 	FuPoor(pViewSh, pWin, pView, pDoc, rReq),
/*N*/ 	bMBDown(FALSE),
/*N*/ 	bPermanent(FALSE),
/*N*/ 	bDragHelpLine(FALSE)
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ FuDraw::~FuDraw()
/*N*/ {
/*N*/ 	pView->BrkAction();
/*N*/ }

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/


/*************************************************************************
|*
|* MouseMove-event
|*
\************************************************************************/


/*************************************************************************
|*
|* MouseButtonUp-event
|*
\************************************************************************/


/*************************************************************************
|*
|* Process keyboard-events
|*
|* When processing a KeyEvent the returnvalue is TRUE, otherwise FALSE.
|*
\************************************************************************/

				// #105336# Moved next line which was a bugfix itself into
				// the scope which really does the object selection travel
				// and thus is allowed to call SelectionHasChanged().

				// Switch to FuSelect.

/*************************************************************************
|*
|* Fade out the selection-presentation before scrolling
|*
\************************************************************************/


/*************************************************************************
|*
|* After scrolling show the selection-presentation again
|*
\************************************************************************/


/*************************************************************************
|*
|* Aktivate function
|*
\************************************************************************/

/*N*/ void FuDraw::Activate()
/*N*/ {
/*N*/ 	FuPoor::Activate();
/*N*/ 	ForcePointer();
/*N*/ }

/*************************************************************************
|*
|* Deaktivate function
|*
\************************************************************************/

/*N*/ void FuDraw::Deactivate()
/*N*/ {
/*N*/ 	FuPoor::Deactivate();
/*N*/ }


/*************************************************************************
|*
|* Toggle mouse-pointer
|*
\************************************************************************/

/*N*/ void FuDraw::ForcePointer(const MouseEvent* pMEvt)
/*N*/ {
/*N*/ 	Point aPnt;
/*N*/ 	USHORT nModifier = 0;
/*N*/ 	BOOL bLeftDown = FALSE;
/*N*/ 	BOOL bDefPointer = TRUE;

/*N*/ 	if (pMEvt)
/*?*/ 	{
/*?*/ 		aPnt = pWindow->PixelToLogic(pMEvt->GetPosPixel());
/*?*/ 		nModifier = pMEvt->GetModifier();
/*?*/ 		bLeftDown = pMEvt->IsLeft();
/*?*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		aPnt = pWindow->PixelToLogic(pWindow->GetPointerPosPixel());
/*N*/ 	}

/*N*/ 	BOOL bIsAction = pView->IsAction();

/*N*/ 	if (pView->IsDragObj())
/*?*/ 	{
/*?*/ 		if (SD_MOD()->GetWaterCan() && !pView->HitHandle(aPnt, *pWindow))
		{
			/******************************************************************
			* Giesskannenmodus
			******************************************************************/
			bDefPointer = FALSE;
			pWindow->SetPointer(Pointer(POINTER_FILL));
		}
/*?*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		SdrHdl* pHdl = pView->HitHandle(aPnt, *pWindow);

/*N*/ 		if (SD_MOD()->GetWaterCan() && !pHdl)
/*?*/ 		{
			/******************************************************************
			* Giesskannenmodus
			******************************************************************/
/*?*/ 			bDefPointer = FALSE;
/*?*/ 			pWindow->SetPointer(Pointer(POINTER_FILL));
/*?*/ 		}
/*N*/ 		else if (!pHdl &&
/*N*/ 				 pViewShell->GetViewFrame()->HasChildWindow(SvxBmpMaskChildWindow::GetChildWindowId()))
/*N*/ 		{
			/******************************************************************
			* Pipettenmodus
			******************************************************************/
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SvxBmpMask* pMask = (SvxBmpMask*) pViewShell->GetViewFrame()->GetChildWindow(SvxBmpMaskChildWindow::GetChildWindowId())->GetWindow();
/*N*/ 		}
/*N*/ 		else if (!pView->IsAction())
/*N*/ 		{
/*N*/ 			SdrObject* pObj = NULL;
/*N*/ 			SdrPageView* pPV = NULL;
/*N*/ 			SdrViewEvent aVEvt;
/*N*/ 			SdrHitKind eHit = SDRHIT_NONE;
/*N*/ 			SdrDragMode eDragMode = pView->GetDragMode();
/*N*/ 			USHORT nHitLog(USHORT (pWindow->PixelToLogic(Size(HITPIX,0)).Width()));

/*N*/ 			if (pMEvt)
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 eHit = pView->PickAnything(*pMEvt, SDRMOUSEMOVE, aVEvt);
/*?*/ 			}

/*N*/ 			if ((eDragMode == SDRDRAG_ROTATE) && (eHit == SDRHIT_MARKEDOBJECT))
/*?*/ 			{
				// The goal of this request is show always the rotation-arrow for 3D-objects at rotation-modus
				// Independent of the settings at Extras->Optionen->Grafik "Objekte immer verschieben"
				// 2D-objects acquit in an other way. Otherwise, the rotation of 3d-objects around any axises
				// wouldn't be possible per default.
/*?*/ 				const SdrMarkList& rMarkList = pView->GetMarkList();
				SdrObject* pObject = rMarkList.GetMark(0)->GetObj();
				if ((pObject->ISA(E3dObject)) && (rMarkList.GetMarkCount() == 1))
				{
					pWindow->SetPointer(Pointer(POINTER_ROTATE));
					bDefPointer = FALSE;     // Otherwise it'll be calles Joes routine and the mousepointer will reconfigurate again
				}
			}

/*N*/ 			if (eHit == SDRHIT_NONE)
/*N*/ 			{
				// found nothing -> look after at the masterpage
/*N*/ 				pView->PickObj(aPnt, pObj, pPV, SDRSEARCH_ALSOONMASTER);
/*N*/ 			}
/*N*/ 			else if (eHit == SDRHIT_UNMARKEDOBJECT)
/*N*/ 			{
/*N*/ 				pObj = aVEvt.pObj;
/*N*/ 			}
/*N*/ 			else if (eHit == SDRHIT_TEXTEDITOBJ && this->ISA(FuSelection))
/*?*/ 			{
/*?*/ 				UINT16 nSdrObjKind = aVEvt.pObj->GetObjIdentifier();

				if ( nSdrObjKind != OBJ_TEXT		&&
					 nSdrObjKind != OBJ_TITLETEXT	&&
					 nSdrObjKind != OBJ_OUTLINETEXT &&
					 aVEvt.pObj->IsEmptyPresObj() )
				{
					pObj = NULL;
					bDefPointer = FALSE;
					pWindow->SetPointer(Pointer(POINTER_ARROW));
				}
/*?*/ 			}

/*N*/ 			if (pObj && pMEvt && !pMEvt->IsMod2() && this->ISA(FuSelection))
/*?*/ 			{
				// Auf Animation oder ImageMap pruefen
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 		bDefPointer = !SetPointer(pObj, aPnt);

/*N*/ 			}
/*N*/ 		}
/*N*/ 	}

/*N*/ 	if (bDefPointer)
/*N*/ 	{
/*N*/ 		pWindow->SetPointer(pView->GetPreferedPointer(
/*N*/ 							aPnt, pWindow, nModifier, bLeftDown));
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Set cursor for animaton or imagemap
|*
\************************************************************************/




/*************************************************************************
|*
|* Response of doubleclick
|*
\************************************************************************/

					/**********************************************************
					* aktivate OLE-object
					**********************************************************/

/*************************************************************************
|*
|* Help-event
|*
\************************************************************************/




/*************************************************************************
|*
|* Command-event
|*
\************************************************************************/

		/**************************************************************
		* URL-Field
		**************************************************************/


/** is called when the currenct function should be aborted. <p>
	This is used when a function gets a KEY_ESCAPE but can also
	be called directly.

	@returns true if a active function was aborted
*/
}
