/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tabvwshf.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:18:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#include <bf_sfx2/request.hxx>
#include <svtools/stritem.hxx>
#include <svtools/whiter.hxx>

#include "tabvwsh.hxx"
#include "bf_sc.hrc"
#include "docsh.hxx"
#include "globstr.hrc"

#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif

namespace binfilter {



#define IS_AVAILABLE(WhichId,ppItem) \
    (pReqArgs->GetItemState((WhichId), TRUE, ppItem ) == SFX_ITEM_SET)

//------------------------------------------------------------------


//------------------------------------------------------------------

/*N*/ void ScTabViewShell::GetStateTable( SfxItemSet& rSet )
/*N*/ {
/*N*/ 	ScViewData* pViewData	= GetViewData();
/*N*/ 	ScDocument* pDoc		= pViewData->GetDocument();
/*N*/ 	ScMarkData& rMark		= GetViewData()->GetMarkData();
/*N*/ 	USHORT		nPosX		= pViewData->GetCurX();
/*N*/ 	USHORT		nPosY		= pViewData->GetCurY();
/*N*/ 	USHORT		nTab		= pViewData->GetTabNo();
/*N*/ 
/*N*/ 	BOOL bOle = GetViewData()->GetDocShell()->IsOle();
/*N*/ 
/*N*/ 	USHORT nTabCount = pDoc->GetTableCount();
/*N*/ 	USHORT nTabSelCount = rMark.GetSelectCount();
/*N*/ 
/*N*/ 	SfxWhichIter	aIter(rSet);
/*N*/ 	USHORT			nWhich = aIter.FirstWhich();
/*N*/ 
/*N*/ 	while ( nWhich )
/*N*/ 	{
/*N*/ 		switch ( nWhich )
/*N*/ 		{
/*N*/ 
/*?*/ 			case FID_TABLE_VISIBLE:
/*?*/ 				rSet.Put( SfxBoolItem( nWhich, pDoc->IsVisible(nTab) ));
/*?*/ 				break;
/*?*/ 
/*N*/ 			case FID_TABLE_HIDE:
/*N*/ 				{
/*N*/ 					USHORT nVis = 0;
/*N*/ 					for ( USHORT i=0; i < nTabCount && nVis<2; i++ )
/*N*/ 						if (pDoc->IsVisible(i))
/*N*/ 							++nVis;
/*N*/ 
/*N*/ 					if ( nVis<2 || !pDoc->IsDocEditable() || nTabSelCount > 1 )
/*?*/ 						rSet.DisableItem( nWhich );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*N*/ 			case FID_TABLE_SHOW:
/*N*/ 				{
/*N*/ 					BOOL bHasHidden = FALSE;
/*N*/ 					for ( USHORT i=0; i < nTabCount && !bHasHidden; i++ )
/*N*/ 						if (!pDoc->IsVisible(i))
/*N*/ 							bHasHidden = TRUE;
/*N*/ 					if ( !bHasHidden || pDoc->IsDocProtected() || nTabSelCount > 1 )
/*N*/ 						rSet.DisableItem( nWhich );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 
/*?*/ 			case FID_DELETE_TABLE:
/*?*/ 				{
/*?*/ 					if ( pDoc->GetChangeTrack() )
/*?*/ 						rSet.DisableItem( nWhich );
/*?*/ 					else
/*?*/ 					{
/*?*/ 						USHORT nVis = 0;
/*?*/ 						for ( USHORT i=0; i < nTabCount && nVis<2; i++ )
/*?*/ 							if (pDoc->IsVisible(i))
/*?*/ 								++nVis;
/*?*/ 						if (   pDoc->IsTabProtected(nTab)
/*?*/ 							|| !pDoc->IsDocEditable()
/*?*/ 							|| nVis < 2
/*?*/ 							|| nTabSelCount == nTabCount)
/*?*/ 						rSet.DisableItem( nWhich );
/*?*/ 					}
/*?*/ 				}
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_INS_TABLE:
/*?*/ 			case FID_TAB_APPEND:
/*?*/ 				if (   !pDoc->IsDocEditable()
/*?*/ 					|| nTabCount > MAXTAB)
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				break;
/*?*/ 
/*?*/ 			case FID_TAB_MOVE:
/*?*/ 				if (   !pDoc->IsDocEditable()
/*?*/ 					|| pDoc->GetChangeTrack() != NULL
/*?*/ 					|| nTabCount > MAXTAB)
/*?*/ 					rSet.DisableItem( nWhich );
/*?*/ 				break;
/*N*/ 
/*N*/ 			//	FID_TAB_MENU_RENAME - "umbenennen" im Menu
/*N*/ 			//	FID_TAB_RENAME		- "Name"-Property fuer Basic
/*N*/ 
/*N*/ 			case FID_TAB_MENU_RENAME:
/*N*/ 				if ( !pDoc->IsDocEditable() ||
/*N*/ 					 pDoc->IsTabProtected(nTab) ||nTabSelCount > 1 )
/*N*/ 					rSet.DisableItem( nWhich );
/*N*/ 				break;
/*N*/ 
/*?*/ 			case FID_TAB_RENAME:
/*?*/ 				{
/*?*/ 					String aTabName;
/*?*/ 					pDoc->GetName( nTab, aTabName );
/*?*/ 
/*?*/ 					rSet.Put( SfxStringItem( nWhich, aTabName ));
/*?*/ 
/*?*/ 				}
/*?*/ 				break;
/*N*/ 		}
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }




}
