/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_gridmerg.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:10:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

#include <vcl/outdev.hxx>

#include "gridmerg.hxx"
namespace binfilter {

//------------------------------------------------------------------

/*N*/ ScGridMerger::ScGridMerger( OutputDevice* pOutDev, long nOnePixelX, long nOnePixelY ) :
/*N*/ 	pDev( pOutDev ),
/*N*/ 	nOneX( nOnePixelX ),
/*N*/ 	nOneY( nOnePixelY ),
/*N*/ 	bVertical( FALSE ),
/*N*/ 	nCount( 0 )
/*N*/ {
/*N*/ 	//	optimize (DrawGrid) only for pixel MapMode,
/*N*/ 	//	to avoid rounding errors
/*N*/ 
/*N*/ 	bOptimize = ( pDev->GetMapMode().GetMapUnit() == MAP_PIXEL );
/*N*/ }

/*N*/ ScGridMerger::~ScGridMerger()
/*N*/ {
/*N*/ 	Flush();
/*N*/ }




/*N*/ void ScGridMerger::Flush()
/*N*/ {
/*N*/ 	if (nCount)
/*N*/ 	{
/*?*/ 		if (bVertical)
/*?*/ 		{
/*?*/ 			if ( nCount == 1 )
/*?*/ 				pDev->DrawLine( Point( nVarStart, nFixStart ), Point( nVarStart, nFixEnd ) );
/*?*/ 			else
/*?*/ 			{
/*?*/ 				long nVarEnd = nVarStart + ( nCount - 1 ) * nVarDiff;
/*?*/ 				pDev->DrawGrid( Rectangle( nVarStart, nFixStart, nVarEnd, nFixEnd ),
/*?*/ 								Size( nVarDiff, nFixEnd - nFixStart ),
/*?*/ 								GRID_VERTLINES );
/*?*/ 			}
/*?*/ 		}
/*?*/ 		else
/*?*/ 		{
/*?*/ 			if ( nCount == 1 )
/*?*/ 				pDev->DrawLine( Point( nFixStart, nVarStart ), Point( nFixEnd, nVarStart ) );
/*?*/ 			else
/*?*/ 			{
/*?*/ 				long nVarEnd = nVarStart + ( nCount - 1 ) * nVarDiff;
/*?*/ 				pDev->DrawGrid( Rectangle( nFixStart, nVarStart, nFixEnd, nVarEnd ),
/*?*/ 								Size( nFixEnd - nFixStart, nVarDiff ),
/*?*/ 								GRID_HORZLINES );
/*?*/ 			}
/*?*/ 		}
/*?*/ 		nCount = 0;
/*N*/ 	}
/*N*/ }



}
