/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_colrowba.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:08:05 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------



#include "colrowba.hxx"
#include "tabvwsh.hxx"
#include "docsh.hxx"
#include "globstr.hrc"
namespace binfilter {

// STATIC DATA -----------------------------------------------------------

//==================================================================


//==================================================================

/*N*/ ScColBar::ScColBar( Window* pParent, ScViewData* pData, ScHSplitPos eWhichPos,
/*N*/ 					ScHeaderFunctionSet* pFunc, ScHeaderSelectionEngine* pEng ) :
/*N*/ 			ScHeaderControl( pParent, pEng, MAXCOL+1, HDR_HORIZONTAL ),
/*N*/ 			pViewData( pData ),
/*N*/ 			eWhich( eWhichPos ),
/*N*/ 			pFuncSet( pFunc ),
/*N*/ 			pSelEngine( pEng )
/*N*/ {
/*N*/ 	Show();
/*N*/ }

/*N*/ ScColBar::~ScColBar()
/*N*/ {
/*N*/ }

/*N*/ USHORT ScColBar::GetPos()
/*N*/ {
/*N*/ 	return pViewData->GetPosX(eWhich);
/*N*/ }

/*N*/ USHORT ScColBar::GetEntrySize( USHORT nEntryNo )
/*N*/ {
/*N*/ 	ScDocument* pDoc = pViewData->GetDocument();
/*N*/ 	USHORT nTab = pViewData->GetTabNo();
/*N*/ 	if ( pDoc->GetColFlags( nEntryNo, nTab ) & CR_HIDDEN )
/*N*/ 		return 0;
/*N*/ 	else
/*N*/ 		return (USHORT) ScViewData::ToPixel( pDoc->GetColWidth( nEntryNo, nTab ), pViewData->GetPPTX() );
/*N*/ }




/*M*/ void ScColBar::SetMarking( BOOL bSet )
/*M*/ {
/*M*/ 	pViewData->GetMarkData().SetMarking( bSet );
/*M*/ 	if (!bSet)
/*M*/ 	{
/*M*/ 		pViewData->GetView()->UpdateAutoFillMark();
/*M*/ 	}
/*M*/ }






//==================================================================

/*N*/ ScRowBar::ScRowBar( Window* pParent, ScViewData* pData, ScVSplitPos eWhichPos,
/*N*/ 					ScHeaderFunctionSet* pFunc, ScHeaderSelectionEngine* pEng ) :
/*N*/ 			ScHeaderControl( pParent, pEng, MAXROW+1, HDR_VERTICAL ),
/*N*/ 			pViewData( pData ),
/*N*/ 			eWhich( eWhichPos ),
/*N*/ 			pFuncSet( pFunc ),
/*N*/ 			pSelEngine( pEng )
/*N*/ {
/*N*/ 	Show();
/*N*/ }

/*N*/ ScRowBar::~ScRowBar()
/*N*/ {
/*N*/ }

/*N*/ USHORT ScRowBar::GetPos()
/*N*/ {
/*N*/ 	return pViewData->GetPosY(eWhich);
/*N*/ }

/*N*/ USHORT ScRowBar::GetEntrySize( USHORT nEntryNo )
/*N*/ {
/*N*/ 	ScDocument* pDoc = pViewData->GetDocument();
/*N*/ 	USHORT nTab = pViewData->GetTabNo();
/*N*/ 	if ( pDoc->GetRowFlags( nEntryNo, nTab ) & CR_HIDDEN )
/*N*/ 		return 0;
/*N*/ 	else
/*N*/ 		return (USHORT) ScViewData::ToPixel( pDoc->GetRowHeight( nEntryNo, nTab ), pViewData->GetPPTY() );
/*N*/ }




/*M*/ void ScRowBar::SetMarking( BOOL bSet )
/*M*/ {
/*M*/ 	pViewData->GetMarkData().SetMarking( bSet );
/*M*/ 	if (!bSet)
/*M*/ 	{
/*M*/ 		pViewData->GetView()->UpdateAutoFillMark();
/*M*/ 	}
/*M*/ }






//	GetHiddenCount ist nur fuer Zeilen ueberladen




}
